/* 
 *  Utility macros
 *
 *  Copyright (C) 1998 by Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#ifndef _UTIL_H_
#define _UTIL_H_

#include "ggi2dlib.h"

#define min(a,b)      ( (a) < (b) ? (a) : (b) )
#define max(a,b)      ( (a) > (b) ? (a) : (b) )
#define swap(a,b) do { int tmp; tmp = (a); (a) = (b); (b) = (tmp); } while(0)

/* true if point lies inside the visual */    
#define INVISUAL(vis,x,y)	\
    (x >= 0 && x < GGI_FB_WIDTH(vis) && y >= 0 && y < GGI_FB_HEIGHT(vis))
     
/* true if point lies inside the clipping rectangle */    
#define CLIP(vis,x,y)	\
    (x >= GGI2D_GC_CLIP_X1(vis) && x < GGI2D_GC_CLIP_X2(vis) && \
     y >= GGI2D_GC_CLIP_Y1(vis) && y < GGI2D_GC_CLIP_Y2(vis))

#define CLIPY(vis,y1,y2,tmp)	\
  if (y1 > y2) swap(y1, y2);\
  if (y1 < GGI2D_GC_CLIP_Y1(vis)) {\
    if (y2 < GGI2D_GC_CLIP_Y1(vis)) return;\
    y1 = GGI2D_GC_CLIP_Y1(vis);\
  }\
  if (y2 >= GGI2D_GC_CLIP_Y2(vis)) {\
    if (y1 >= GGI2D_GC_CLIP_Y2(vis)) return;\
    y2 = GGI2D_GC_CLIP_Y2(vis)-1;\
  }

/* return if the hline is invisible else clip it */    
#define CLIPHLINE(vis,x1,x2,y,tmp)	\
  if (y < GGI2D_GC_CLIP_Y1(vis) || y >= GGI2D_GC_CLIP_Y2(vis)) return;\
  if (x1 > x2) swap(x1, x2);\
  if (x1 < GGI2D_GC_CLIP_X1(vis)) {\
    if (x2 < GGI2D_GC_CLIP_X1(vis)) return;\
    x1 = GGI2D_GC_CLIP_X1(vis);\
  }\
  if (x2 >= GGI2D_GC_CLIP_X2(vis)) {\
    if (x1 >= GGI2D_GC_CLIP_X2(vis)) return;\
    x2 = GGI2D_GC_CLIP_X2(vis)-1;\
  }

/* return if the vline is invisible else clip it */    
#define CLIPVLINE(vis,x,y1,y2,tmp)	\
  if (x < GGI2D_GC_CLIP_X1(vis) || x >= GGI2D_GC_CLIP_X2(vis)) return;\
  if (y1 > y2) swap(y1, y2);\
  if (y1 < GGI2D_GC_CLIP_Y1(vis)) {\
    if (y2 < GGI2D_GC_CLIP_Y1(vis)) return;\
    y1 = GGI2D_GC_CLIP_Y1(vis);\
  }\
  if (y2 >= GGI2D_GC_CLIP_Y2(vis)) {\
    if (y1 >= GGI2D_GC_CLIP_Y2(vis)) return;\
    y2 = GGI2D_GC_CLIP_Y2(vis)-1;\
  }

/* return if rect is invisible else clip it */    
#define CLIPRECT(vis,x1,y1,x2,y2,tmp)	\
  if (x1 > x2) swap(x1, x2);\
  if (x1 < GGI2D_GC_CLIP_X1(vis)) {\
    if (x2 < GGI2D_GC_CLIP_X1(vis)) return;\
    x1 = GGI2D_GC_CLIP_X1(vis);\
  }\
  if (x2 >= GGI2D_GC_CLIP_X2(vis)) {\
    if (x1 >= GGI2D_GC_CLIP_X2(vis)) return;\
    x2 = GGI2D_GC_CLIP_X2(vis)-1;\
  }\
  if (y1 > y2) swap(y1, y2);\
  if (y1 < GGI2D_GC_CLIP_Y1(vis)) {\
    if (y2 < GGI2D_GC_CLIP_Y1(vis)) return;\
    y1 = GGI2D_GC_CLIP_Y1(vis);\
  }\
  if (y2 >= GGI2D_GC_CLIP_Y2(vis)) {\
    if (y1 >= GGI2D_GC_CLIP_Y2(vis)) return;\
    y2 = GGI2D_GC_CLIP_Y2(vis)-1;\
  }

typedef struct {
	int x, d, dd, dy, xadd, xstep;
} linecontext;

#define lineNext(line)  \
{\
    line.x += line.xadd;\
    line.d -= line.dd;\
    if (line.d < 0) {\
	line.d += line.dy;\
	line.x += line.xstep;\
    }\
}

/* initialize line context */
	
#define lineInit(line, x1, deltax, deltay) \
{\
    line.dy = deltay; line.d = line.dy - 1;\
    line.xadd = 0; line.x = x1;\
    line.dd = deltax;\
    if (line.dd < 0) {\
	line.dd = -line.dd; line.xstep = -1;\
    } else line.xstep = 1;\
    if (line.dd > line.dy && line.dy != 0) {\
	line.xadd = (line.dd / line.dy) * line.xstep;\
	line.dd = line.dd % line.dy;\
    }\
    line.dd += line.dd; line.dy += line.dy;\
}
  
typedef struct {
	linecontext context;
	int y, ye, dir;
} polyline;

#define polylineInit(line) \
        {\
          if (y1 > y2) {\
             swap(x1, x2);\
             swap(y1, y2);\
             line.dir = -1;\
          } else line.dir = 1;\
          line.y = y1; line.ye = y2;\
          lineInit(line.context, x1, x2 - x1, y2 - y1);\
        }

	
#endif /* _UTIL_H_ */
