/* 
 *  Arc template
 *
 *  Copyright (C) 1998 by Teunis Peters. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*----------------------------------------------------------------------
    macros that must be defined:
    
(if !FILL)
#define PLOT(x, y)
    plots a pixel at (x,y)

(if FILL)
#define SCANLINE(x1, x2, y)
    fills a horizontal scanline from (x1,y) to (x2,y) 

(if FILL)
#define LINE(x1, y1, x2, y2)
    fills a line from (x1,y1) to (x2,y2) 

#define FILL
    filled arc

#define STIPPLE
    use stippling - currently not supported

----------------------------------------------------------------------*/

/* 
void	drawArc(ggi_visual_t vis, int x, int y, uint a, uint b,
	    	   ggi_float startangle, ggi_float endangle, int close)
void	fillArc(ggi_visual_t vis, int x, int y, uint a, uint b,
		   ggi_float startangle, ggi_float endangle)
*/
{
	/* short names are easier to work with.
	 * 	e,f	= left, right x
	 * 	g,h	= top,bottom y
	 * 	r,s,t	= coefficients for arc
	 * 	MPI180    = pi / 180	(M_PI == pi, defined in math.h)
	 * 	i	  = counter
	 * 
	 * arcTest: array of flags for each sector (8 sectors/circle + safety)
	 * 	flag:	0 = No part of arc appears here
	 * 		1 = Arc starts but does not end here
	 * 		2 = Arc extends through this entire segment
	 * 		3 = Arc ends but does not start here
	 * 		4 = Arc starts and ends in this segment
	 * All other variables should be pretty obvious
	 */
	const float MPI180 = M_PI / 180.0;
	int	i, start_sector, end_sector;
	int	x_start_test, x_end_test;
	int	arcTest[9] = {0,0,0,0,0,0,0,0,0};
	int	z, e, f, g, h;
	int	yq, dx, dy, r, s, t;

#ifndef FILL
#define plotArc1(ax,ay,sector)\
   {									\
        if ( arcTest[sector]==0) {}					\
   else if ( arcTest[sector]==2)			PLOT(ax,ay);	\
   else if ((arcTest[sector]==1) && (ax>=x_start_test))	PLOT(ax,ay);	\
   else if ((arcTest[sector]==3) && (ax<=x_end_test))	PLOT(ax,ay);	\
   else if ((arcTest[sector]==4) &&					\
	    (ax>=x_start_test)   && (ax<=x_end_test))	PLOT(ax,ay);	\
   }
#define plotArc2(ax,ay,sector)						\
   {									\
        if ( arcTest[sector]==0) {}					\
   else if ( arcTest[sector]==2)			PLOT(ax,ay);	\
   else if ((arcTest[sector]==1) && (ax<=x_start_test))	PLOT(ax,ay);	\
   else if ((arcTest[sector]==3) && (ax>=x_end_test))	PLOT(ax,ay);	\
   else if ((arcTest[sector]==4) &&					\
	    (ax<=x_start_test)   && (ax>=x_end_test))	PLOT(ax,ay);	\
   }
#else /* FILL */
#define plotArc1(ax,ay,sector)						 \
   {									 \
        if ( arcTest[sector]==0) {}					 \
   else if ( arcTest[sector]==2)		    SCANLINE(x,ax,ay);	 \
   else if ((arcTest[sector]==1) && (ax>=x_start_test))	LINE(x,y,ax,ay); \
   else if ((arcTest[sector]==3) && (ax<=x_end_test))	LINE(x,y,ax,ay); \
   else if ((arcTest[sector]==4) &&					 \
	    (ax>=x_start_test)   && (ax<=x_end_test))	LINE(x,y,ax,ay); \
   }
#define plotArc2(ax,ay,sector)						 \
   {									 \
        if ( arcTest[sector]==0) {}					 \
   else if ( arcTest[sector]==2)		    SCANLINE(x,ax,ay);	 \
   else if ((arcTest[sector]==1) && (ax<=x_start_test))	LINE(x,y,ax,ay); \
   else if ((arcTest[sector]==3) && (ax>=x_end_test))	LINE(x,y,ax,ay); \
   else if ((arcTest[sector]==4) &&					 \
	    (ax<=x_start_test)   && (ax>=x_end_test))	LINE(x,y,ax,ay); \
   }
#endif

#ifndef	STIPPLE
	e = x - a; g = y;
	f = x + a; h = y;
	while (startangle<0) startangle += 360.0;
	while (  endangle<0)   endangle += 360.0;
	yq   = b*b;
	dx   = a*a*2;	dy = yq*2;
	r    = a*yq;	s  = r*2;	t = 0;
	z    = a;
	start_sector  = ((int)(startangle/45.0)) & 0x7; /* restrict 0-7 */
	end_sector    = ((int)(  endangle/45.0)) & 0x7;	/* restrict 0-7 */
	     if ((startangle==  0.0) || (startangle==180.0))
	     x_start_test = x + fabs(a);
	else if ((startangle== 90.0) || (startangle==270.0))
	     x_start_test = x;
  	else x_start_test = x + fabs(a)*cos(startangle*MPI180);
	     if ((  endangle==  0.0) || (  endangle==180.0))
	     x_end_test   = x + fabs(a);
	else if ((  endangle== 90.0) || (  endangle==270.0))
	     x_end_test   = x;
  	else x_end_test   = x + fabs(a)*cos(  endangle*MPI180);
	if (start_sector == end_sector)
  	   arcTest[start_sector] = 4;
	else
	   {
	   arcTest[start_sector] = 1;
	   arcTest[  end_sector] = 3;
	   for (i=start_sector+1; i!=end_sector; i++)
	      {
	      arcTest[i]=2;
	      if (i==8) i=-1;
	      };
	   };

	while (z > 0)
   	   {
	   if (r > 0)	{ g++; h--; t += dx; r -= t; }
	   if (r <= 0)	{ e++; f--; s -= dy; r += s; z--; }
	   plotArc1(f, h, 6);
	   plotArc2(f, g, 1);
	   plotArc1(e, h, 5);
	   plotArc2(e, g, 2);
	   }
#else	/* STIPPLE */
#endif

#undef plotArc1
#undef plotArc2
}

#undef PLOT
#undef SCANLINE
#undef FILL
#undef STIPPLE
