/* $Id: test1.c,v 1.8 1998/10/29 21:37:01 becka Exp $
***************************************************************************

   Test extension test1.c

   Copyright (C) 1997 Uwe Maurer - uwe_maurer@t-online.de
   Copyright (C) 1998 Andreas Beck - becka@ggi-project.org
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <string.h>

#include <ggi/internal/internal.h>

#include "test1.h"

/*
 * The API of Extension #1 looks a bit like this :
 */

/* Extension ID. Defaulting to -1 should make segfault on abuse more likely ... */
ggi_extid ggiTest1ID=-1;

static int changed(ggi_visual_t vis,int whatchanged)
{
	printf("changed called for extension 1 - vis=%p, %i \n",
		vis,whatchanged);

	switch(whatchanged) {
		case GGI_CHG_APILIST:
			{	int temp;
				char api[256],args[256];
				for(temp=0;0==ggiGetAPI(vis,temp,api,args);temp++) {
					strcat(api,"-test1");
                	                printf("Would now load #%d: %s(%s)\n",temp,api,args);
				}
			}
			break;
	}
                                
	return 0;
}

int ggiTest1Init(void)
{
	ggiTest1ID=ggiExtensionRegister("Ext1",123,changed);
	printf("Initialized Test1 extension. ID: %i\n",ggiTest1ID);

	return ggiTest1ID >= 0 ? 0 : -1;
}

int ggiTest1Exit(void)
{
	int rc;
	rc=ggiExtensionUnregister(ggiTest1ID);
	printf("DeInitailized Test1 extension. rc=%i\n", rc);

	return rc;
}

int ggiTest1Attach(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionAttach(vis,ggiTest1ID);
	printf("Attached Test1 extension to %p. rc=%i\n", vis, rc);

	if (rc==0) {	/* We are actually creating the primary instance. */
		strcpy(LIBGGI_EXT(vis,ggiTest1ID),"Test 1 private Data !");
		/* Now fake an "API change" so the right libs get loaded */
		changed(vis,GGI_CHG_APILIST);
	}

	return rc;
}

int ggiTest1Detach(ggi_visual_t vis)
{
	int rc;
	rc=ggiExtensionDetach(vis,ggiTest1ID);
	printf("Detached Test1 extension from %p. rc=%i\n", vis, rc);

	return rc;
}

void ggiTest1PrintLocaldata(ggi_visual_t vis)
{
	printf("%s\n",(char *)LIBGGI_EXT(vis,ggiTest1ID));
}

void ggiTest1SetLocaldata  (ggi_visual_t vis,char *content)
{
	strcpy(LIBGGI_EXT(vis,ggiTest1ID),content);
}
