/* $Id: box.c,v 1.8 1998/09/25 21:33:13 becka Exp $
***************************************************************************

   SVGAlib target vgagl helper: box stubs

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck      [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "vgaglvis.h"


/**********************/
/* draw/get/put a box */
/**********************/
int GGI_vgagl_drawbox(ggi_visual *vis,int x,int y,int width,int height)
{
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x     +=diff;
		width-=diff;
	}
	if (x+width>(LIBGGI_GC(vis)->clipbr.x)) {
		width=(LIBGGI_GC(vis)->clipbr.x)-x;
	}

	if (height<=0 || width<=0 ) 
		return 0;

	gl_fillbox(x,y,width,height,LIBGGI_GC_FGCOLOR(vis));
	return 0;
}

int GGI_vgagl_putbox(ggi_visual *vis,int x,int y,int width,int height,void *buffer)
{ 
	int rowadd = LIBGGI_FB_W_STRIDE(vis);
	ggi_coord  tl=LIBGGI_GC(vis)->cliptl, br=LIBGGI_GC(vis)->clipbr;

	/* Pre-Clipping, so we don't call PutHline without need. */
	if (y< tl.y) {
		int diff=tl.y-y;
		y     +=diff;
		height-=diff;
		buffer = (uint8 *)(buffer)+rowadd*diff; 
	}
	if (y+height>=br.y) {
		height=br.y-y;
	}
	if (x< tl.x) {
		int diff=tl.x-x;
		x     +=diff;
		width -=diff;
		buffer = (uint8 *)(buffer)+diff;
		}
	if (x+width>=br.x) {
		width=br.x-x;
	}
	if (height>0&&width>0)
		gl_putbox(x,y,width,height,buffer);
	return 0;
}

int GGI_vgagl_getbox(ggi_visual *vis,int x,int y,int width,int height,void *buffer)
{ 
	/* Unclipped - get */
	gl_getbox(x,y,width,height,buffer);
	return 0;
}
