/* $Id: visual.c,v 1.2 1998/10/28 01:55:17 ajapted Exp $
***************************************************************************

   Display-VCSA: visual management

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/mman.h>

#include <ggi/internal/ggi-dl.h>

#include "vcsahook.h"


int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	VcsaHook *vv;

	char *filename = "/dev/vcsa";

	unsigned char buf[4];


	DPRINT("display-vcsa: GGIdlinit start.\n");

	vv = LIBGGI_PRIVATE(vis) = _ggi_malloc(sizeof(VcsaHook));
	
	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	LIBGGI_FD(vis) = LIBGGI_SELECT_FD(vis) = -1;

	
	/* handle args */

	while (args && *args && isspace(*args)) {
		args++;
	}

	if (args && *args) {
		filename = (char *) args;
	}

	
	/* now open the vcsa device */

	LIBGGI_FD(vis) = open(filename, O_RDWR);

	if (LIBGGI_FD(vis) < 0) {
		perror("display-vcsa: Couldn't open vcsa device");
		free(vv);
		return GGI_DL_ERROR;
	}

	/* read vcsa dimensions */

	if (read(LIBGGI_FD(vis), buf, 4) < 4) {
		perror("display-vcsa: Couldn't read vcsa device");
		close(LIBGGI_FD(vis));
		free(vv);
		return GGI_DL_ERROR;
	}

	vv->width  = buf[1];
	vv->height = buf[0];


	/* open keyboard input */

	vis->input = giiOpen("input-linux-kbd", NULL);

	if (vis->input == NULL) {
		fprintf(stderr, "display-vcsa: Couldn't open kbd.\n");
		close(LIBGGI_FD(vis));
		free(vv);
		return GGI_DL_ERROR;
	}
	

	/* mode management */

	vis->opdisplay->getmode   = GGI_vcsa_getmode;
	vis->opdisplay->setmode   = GGI_vcsa_setmode;
	vis->opdisplay->checkmode = GGI_vcsa_checkmode;
	vis->opdisplay->getapi    = GGI_vcsa_getapi;
	vis->opdisplay->flush     = GGI_vcsa_flush;
	vis->opdisplay->setflags  = GGI_vcsa_setflags;
		
	DPRINT("display-vcsa: GGIdlinit success.\n");

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	VcsaHook *vv = VCSA_HOOK(vis);

	DPRINT("display-vcsa: GGIdlcleanup start.\n");

	if (LIBGGI_FD(vis) >= 0) {

		GGI_vcsa_resetmode(vis);
		
		giiClose(vis->input);
		vis->input = NULL;

		close(LIBGGI_FD(vis));
		LIBGGI_FD(vis) = -1;
	}

	free(LIBGGI_GC(vis));
	free(vv);

	DPRINT("display-vcsa: GGIdlcleanup done.\n");

	return 0;
}

int GGI_vcsa_flush(ggi_visual *vis, int tryflag)
{
	return 0;
}


#include <ggi/internal/ggidlinit.h>
