/* $Id: draw.c,v 1.1 1998/10/27 11:58:02 ajapted Exp $
***************************************************************************

   Display-VCSA: drawing primitives

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

#include "vcsahook.h"


/* Note: completely and utterly unoptimized !!! */


#define VCSA_SEEK(vis, vv, x, y)  \
	lseek(LIBGGI_FD(vis), 4 + (y)*(vv)->width*2 + (x)*2, SEEK_SET)


int GGI_vcsa_putpixel_nc(ggi_visual *vis, int x, int y, ggi_pixel p)
{
	VcsaHook *vv = VCSA_HOOK(vis);

	unsigned short buf[4];
	
	if (VCSA_SEEK(vis, vv, x, y) < 0) {
		DPRINT_DRAW("display-vcsa: seek failed.\n");
		return -1;
	}

	buf[0] = (unsigned short) p;

	if (write(LIBGGI_FD(vis), buf, 2) != 2) {
		DPRINT_DRAW("display-vcsa: write failed.\n");
		return -1;
	}

	return 0;
}


/* ---------------------------------------------------------------------- */


int GGI_vcsa_getpixel(ggi_visual *vis, int x, int y, ggi_pixel *p)
{
	VcsaHook *vv = VCSA_HOOK(vis);

	unsigned short buf[4];
	
	if (VCSA_SEEK(vis, vv, x, y) < 0) {
		DPRINT_DRAW("display-vcsa: seek failed.\n");
		return -1;
	}

	if (read(LIBGGI_FD(vis), buf, 2) != 2) {
		DPRINT_DRAW("display-vcsa: read failed.\n");
		return -1;
	}

	*p = buf[0];

	return 0;
}


/* ---------------------------------------------------------------------- */


int GGI_vcsa_getcharsize(ggi_visual *vis, int *width, int *height)
{
	*width = *height = 1;
	
	return 0;
}

int GGI_vcsa_putc(ggi_visual *vis, int x, int y, char c)
{
	return ggiPutPixel(vis, x, y, (c & 0xff) |
		((LIBGGI_GC_BGCOLOR(vis) & 0x0f00) << 4) |
		 (LIBGGI_GC_FGCOLOR(vis) & 0x0f00));
}
