/* $Id: stubs.c,v 1.11 1998/10/13 07:54:29 marcus Exp $
***************************************************************************

   Code stolen from the graphics library for GGI.

   Seriously, these functions split the *Box, *HLine and *VLine operations
   into the component operations to the underlying "tile" visuals.  However,
   if using DirectBuffer, operations are done to the linear framebuffer by
   generic-linear-*, instead of using these functions.

   Copyright (C) 1998 Steve Cheng    [steve@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include "tilevisual.h"

int GGI_tile_flush(ggi_visual *vis, int tryflag)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int i;
	
	for(i=0; i<tilehook->numvis; i++)
		ggiFlush(tilehook->vislist[i]);
	
	return 0;
}


/* Hack: Copy GC changes to each child visual. */

void GGI_tile_gcchanged(ggi_visual *vis, int mask)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int i;
	ggi_visual *currvis;
	
	/* Irrelevant. */
	if(mask & GGI_GCCHANGED_CLIP)
		mask &= ~GGI_GCCHANGED_CLIP;

	for(i=0; i<tilehook->numvis; i++) {
		currvis = tilehook->vislist[i];

#if 0	/* Don't blindly copy the GC. */
		memcpy(LIBGGI_GC(currvis), LIBGGI_GC(vis), sizeof(ggi_gc));
#else
		if(mask & GGI_GCCHANGED_FG)
			LIBGGI_GC(currvis)->fg_color=LIBGGI_GC(vis)->fg_color;

		if(mask & GGI_GCCHANGED_BG)
			LIBGGI_GC(currvis)->bg_color=LIBGGI_GC(vis)->bg_color;

		LIBGGI_GC(currvis)->version++;
#endif

		if(currvis->opgc->gcchanged)
			currvis->opgc->gcchanged(currvis, mask);
	}
}


/**********************/
/* draw/get/put a box */
/**********************/

int GGI_tile_drawbox(ggi_visual *vis, int _x, int _y, int _width, int _length)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	ggi_coord cliptl, clipbr;
	int i, x, y, width, length, diff;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];
		x = _x;
		y = _y;
		width = _width;
		length = _length;

		if (y < cliptl.y) {
			diff = cliptl.y - y;
			y     +=diff;
			length-=diff;
		}

		if (y + length > clipbr.y)
			length = clipbr.y - y;

		if (x < cliptl.x) {
			diff = cliptl.x - x;
			x     +=diff;
			width-=diff;
		}

		if (x + width > clipbr.x)
			width = clipbr.x - x;

		if (length <= 0 || width <= 0 )
			continue;

		ggiDrawBox(tilehook->vislist[i],
			x - cliptl.x, y - cliptl.y, width, length);
	}

	return 0;
}

int GGI_tile_putbox(ggi_visual *vis, int _x, int _y, int _width, int _length, void *buffer)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int rowadd = (LIBGGI_PIXFMT(vis)->size+7)/8;
	ggi_coord cliptl, clipbr;
	int i, x, y, width, length, diff;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];
		x = _x;
		y = _y;
		width = _width;
		length = _length;

		if (y < cliptl.y) {
			diff = cliptl.y - y;
			y     +=diff;
			length-=diff;
		}

		if (y + length > clipbr.y)
			length = clipbr.y - y;

		if (x < cliptl.x) {
			diff = cliptl.x - x;
			x     +=diff;
			width-=diff;
		}

		if (x + width > clipbr.x)
			width = clipbr.x - x;

		if (length <= 0 || width <= 0 )
			continue;

		while(length--) {
			ggiPutHLine(tilehook->vislist[i],
				x - cliptl.x, y - cliptl.y + length, width,
				((uint8*)buffer + rowadd*_width*(y-_y+length) + rowadd*(x-_x)));
		}
	}

	return 0;
}

int GGI_tile_getbox(ggi_visual *vis, int _x, int _y, int _width, int _length, void *buffer)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int rowadd = (LIBGGI_PIXFMT(vis)->size+7)/8;
	ggi_coord cliptl, clipbr;
	int i, x, y, width, length, diff;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];
		x = _x;
		y = _y;
		width = _width;
		length = _length;

		if (y < cliptl.y) {
			diff = cliptl.y - y;
			y     +=diff;
			length-=diff;
		}

		if (y + length > clipbr.y)
			length = clipbr.y - y;

		if (x < cliptl.x) {
			diff = cliptl.x - x;
			x     +=diff;
			width-=diff;
		}

		if (x + width > clipbr.x)
			width = clipbr.x - x;

		if (length <= 0 || width <= 0 )
			continue;

		while(length--) {
			ggiGetHLine(tilehook->vislist[i],
				x - cliptl.x, y - cliptl.y + length, width,
				((uint8*)buffer + rowadd*_width*(y-_y+length) + rowadd*(x-_x)));
		}
	}

	return 0;
}

int GGI_tile_copybox(ggi_visual *vis,int x,int y,int width,int height,int nx,int ny)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	ggi_coord cliptl, clipbr;
	int i;

	/* We check if both the source and destination of the copy are wholely
	   contained in one of the tile visuals.
	*/

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];

		if (	x < cliptl.x || y < cliptl.y ||
			x + width > clipbr.x || y + height > clipbr.y ||
			nx < cliptl.x || ny < cliptl.y ||
			nx + width > clipbr.x || ny + height > clipbr.y)
			continue;

		return ggiCopyBox(tilehook->vislist[i],
			x - cliptl.x, y - cliptl.y, width, height,
			nx - cliptl.x, ny - cliptl.y);
	}


	/* ARGGH!!! */
	if(!tilehook->buf)
		tilehook->buf = _ggi_malloc(
			(LIBGGI_PIXFMT(vis)->size+7)/8*width*height);
	ggiGetBox(vis, x, y, width, height, tilehook->buf);
	ggiPutBox(vis, nx, ny, width, height, tilehook->buf);


	/* Or leave buffer allocated for later copybox? */
	free(tilehook->buf);
	tilehook->buf=NULL;
	
	return 0;
}

int GGI_tile_fillscreen(ggi_visual *vis)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int i;
	
	for(i = 0; i<tilehook->numvis; i++) 
		ggiFillscreen(tilehook->vislist[i]);

	return 0;
}

#if 0
int GGI_tile_putc(ggi_visual *vis,int x,int y,char c)
{
	int err=EOK;
	ggi_visual_t *vislist=TILE_PRIV(vis);
	while(*vislist) err=ggiPutc(*vislist++,x,y,c);

	return err;
}


int GGI_tile_puts(ggi_visual *vis,int x,int y,const char *str)
{
	int err=EOK;
	ggi_visual_t *vislist=TILE_PRIV(vis);
	while(*vislist) err=ggiPuts(*vislist++,x,y,str);

	return err;
}

int GGI_tile_drawline(ggi_visual *vis,int x1,int y1,int x2,int y2)
{ 
	int err=EOK;
	ggi_visual_t *vislist=TILE_PRIV(vis);
	while(*vislist) err=ggiDrawLine(*vislist++,x1,y1,x2,y2);

	return err;
}
#endif

int GGI_tile_drawhline_nc(ggi_visual *vis,int _x,int y,int _width)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	ggi_coord cliptl, clipbr;
	int i, x, width, diff;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];
		x = _x;
		width = _width;

		if (y < cliptl.y || y >= clipbr.y)
			continue;

		if (x < cliptl.x) {
			diff = cliptl.x - x;
			x     +=diff;
			width-=diff;
		}

		if (x + width > clipbr.x)
			width = clipbr.x - x;

		if (width <= 0)
			continue;

		_ggiDrawHLineNC(tilehook->vislist[i],
			x - cliptl.x, y - cliptl.y, width);
	}

	return 0;
}

int GGI_tile_drawhline(ggi_visual *vis,int x,int y,int w)
{
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0)
		return GGI_tile_drawhline_nc(vis,x,y,w);
	else
		return 0;	/* ??? Shouldn't this be an error? */
}

int GGI_tile_puthline(ggi_visual *vis,int _x,int y,int _width,void *buffer)
{ 
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int rowadd = (LIBGGI_PIXFMT(vis)->size+7)/8;
	ggi_coord cliptl, clipbr;
	int i, x, width, diff;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];
		x = _x;
		width = _width;

		if (y < cliptl.y || y >= clipbr.y)
			continue;

		if (x < cliptl.x) {
			diff = cliptl.x - x;
			x     +=diff;
			width-=diff;
		} else {
			diff = 0;
		}

		if (x + width > clipbr.x)
			width = clipbr.x - x;

		if (width <= 0)
			continue;

		ggiPutHLine(tilehook->vislist[i],
			x - cliptl.x, y - cliptl.y, width,
			((uint8*)buffer + diff*rowadd));
	}

	return 0;
}

int GGI_tile_gethline(ggi_visual *vis,int _x,int y,int _width,void *buffer)
{ 
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int rowadd = (LIBGGI_PIXFMT(vis)->size+7)/8;
	ggi_coord cliptl, clipbr;
	int i, x, width, diff;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];
		x = _x;
		width = _width;

		if (y < cliptl.y || y >= clipbr.y)
			continue;

		if (x < cliptl.x) {
			diff = cliptl.x - x;
			x     +=diff;
			width-=diff;
		} else {
			diff = 0;
		}

		if (x + width > clipbr.x)
			width = clipbr.x - x;

		if (width <= 0)
			continue;

		ggiGetHLine(tilehook->vislist[i],
			x - cliptl.x, y - cliptl.y, width,
			((uint8*)buffer + diff*rowadd));
	}

	return 0;
}

int GGI_tile_drawvline_nc(ggi_visual *vis,int x,int _y,int _height)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	ggi_coord cliptl, clipbr;
	int i, y, length, diff;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];
		y = _y;
		length = _height;

		if (x < cliptl.x || x >= clipbr.x)
			continue;

		if (y < cliptl.y) {
			diff = cliptl.y - y;
			y     +=diff;
			length-=diff;
		}

		if (y + length > clipbr.y)
			length = clipbr.y - y;

		if (length <= 0)
			continue;

		_ggiDrawVLineNC(tilehook->vislist[i], 
			x - cliptl.x, y - cliptl.y, length);
 	}

	return 0;
}

int GGI_tile_drawvline(ggi_visual *vis,int x,int y,int height)
{
	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	if (height>0)
		return GGI_tile_drawvline_nc(vis,x,y,height);
	else
		return 0;	/* ??? Shouldn't this be an error? */
}

int GGI_tile_putvline(ggi_visual *vis,int x,int _y,int _height,void *buffer)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int rowadd = (LIBGGI_PIXFMT(vis)->size+7)/8;
	ggi_coord cliptl, clipbr;
	int i, y, length, diff;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];
		y = _y;
		length = _height;

		if (x < cliptl.x || x >= clipbr.x)
			continue;

		if (y < cliptl.y) {
			diff = cliptl.y - y;
			y     +=diff;
			length-=diff;
		} else {
			diff = 0;
		}

		if (y + length > clipbr.y)
			length = clipbr.y - y;

		if (length <= 0)
			continue;

		ggiPutVLine(tilehook->vislist[i], 
			x - cliptl.x, y - cliptl.y, length,
			((uint8*)buffer + diff*rowadd));
 	}

	return 0;
}

int GGI_tile_getvline(ggi_visual *vis,int x,int _y,int _height,void *buffer)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int rowadd = (LIBGGI_PIXFMT(vis)->size+7)/8;
	ggi_coord cliptl, clipbr;
	int i, y, length, diff;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];
		y = _y;
		length = _height;

		if (x < cliptl.x || x >= clipbr.x)
			continue;

		if (y < cliptl.y) {
			diff = cliptl.y - y;
			y     +=diff;
			length-=diff;
		} else {
			diff = 0;
		}

		if (y + length > clipbr.y)
			length = clipbr.y - y;

		if (length <= 0)
			continue;

		ggiGetVLine(tilehook->vislist[i], 
			x - cliptl.x, y - cliptl.y, length,
			((uint8*)buffer + diff*rowadd));
 	}

	return 0;
}

int GGI_tile_drawpixel_nc(ggi_visual *vis,int x,int y)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	ggi_coord cliptl, clipbr;
	int i;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];

		if (x < cliptl.x || y < cliptl.y ||
			x >= clipbr.x || y >= clipbr.y)
			continue;

		/* Do we disallow overlapping tiles? */
		_ggiDrawPixelNC(tilehook->vislist[i], 
			x - cliptl.x, y - cliptl.y);
	}
	
	return 0;
}

int GGI_tile_drawpixel(ggi_visual *vis,int x,int y)
{
	CHECKXY(vis,x,y);
	return GGI_tile_drawpixel_nc(vis, x, y);
}

int GGI_tile_putpixel_nc(ggi_visual *vis,int x,int y,ggi_uint col)
{ 
	struct TileHooks *tilehook = TILE_PRIV(vis);
	ggi_coord cliptl, clipbr;
	int i;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];

		if (x < cliptl.x || y < cliptl.y ||
			x >= clipbr.x || y >= clipbr.y)
			continue;

		/* Do we disallow overlapping tiles? */
		ggiPutPixel(tilehook->vislist[i], 
			x - cliptl.x, y - cliptl.y, col);
	}
	
	return 0;
}

int GGI_tile_putpixel(ggi_visual *vis,int x,int y,ggi_uint col)
{
	CHECKXY(vis,x,y);
	return GGI_tile_putpixel_nc(vis, x, y, col);
}

int GGI_tile_getpixel(ggi_visual *vis,int x,int y,ggi_uint *col)
{ 
	struct TileHooks *tilehook = TILE_PRIV(vis);
	ggi_coord cliptl, clipbr;
	int i;

	for(i=0; i<tilehook->numvis; i++) {
		cliptl = tilehook->vis_origins[i];
		clipbr = tilehook->vis_clipbr[i];

		if (x < cliptl.x || y < cliptl.y ||
			x >= clipbr.x || y >= clipbr.y)
			continue;

		return ggiGetPixel(tilehook->vislist[i], 
			x - cliptl.x, y - cliptl.y, col);
	}
	
	return -1;
}
