/* $Id: frames.c,v 1.4 1998/09/23 21:35:07 marcus Exp $
***************************************************************************

   Tile target: frame handling functions

   Copyright (C) 1998 Steve Cheng    [steve@ggi-project.org]
   Copyright (C) 1998 Andrew Apted   [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "tilevisual.h"


int GGI_tile_setdisplayframe_db(ggi_visual *vis, int num)
{
	ggi_directbuffer *db = _ggi_db_find_frame(vis, num);

	if (db == NULL) {
		return -1;
	}

	vis->d_frame_num = num;
	TILE_PRIV(vis)->d_frame = db;

	ggiFlush(vis);

	return 0;
}

int GGI_tile_setdisplayframe(ggi_visual *vis, int num)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int i;
	for(i = 0; i<tilehook->numvis; i++)
		if(ggiSetDisplayFrame(tilehook->vislist[i], num))
			return -1;

	return 0;
}

int GGI_tile_setreadframe(ggi_visual *vis, int num)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int i;
	for(i = 0; i<tilehook->numvis; i++)
		if(ggiSetReadFrame(tilehook->vislist[i], num))
			return -1;

	return 0;
}

int GGI_tile_setwriteframe(ggi_visual *vis, int num)
{
	struct TileHooks *tilehook = TILE_PRIV(vis);
	int i;
	for(i = 0; i<tilehook->numvis; i++)
		if(ggiSetWriteFrame(tilehook->vislist[i], num))
			return -1;

	return 0;
}

