/* $Id: visual.c,v 1.15 1998/10/18 15:53:06 becka Exp $
***************************************************************************

   Terminfo target

   Copyright (C) 1998 MenTaLboY         [mentalboy@geocities.com]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "TIvisual.h"

#ifdef USE_THREADS
	#include <pthread.h>
	pthread_mutex_t _tivisual_ncurses_mutex = PTHREAD_MUTEX_INITIALIZER;
#endif

void _GGI_terminfo_freedbs(ggi_visual *vis) {
	int i;

	for (i=LIBGGI_APPLIST(vis)->num-1; i >= 0; i--) {
		free(LIBGGI_APPBUFS(vis)[i]->write);
		_ggi_db_free(LIBGGI_APPBUFS(vis)[i]);
		_ggi_db_del_buffer(LIBGGI_APPLIST(vis), i);
	}
}


int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	struct TIhooks *tiinfo;
	int i;

	char *term_type;
	char *term_path;
	char *finger;

	term_type = NULL;
	if ( args == NULL ) {
		term_path = alloca(1);
		*term_path = '\000';
	} else {
		term_path = alloca(strlen(args) + 1);
		if ( term_path == NULL ) return GGI_DL_ERROR;
	}

	for ( finger = term_path ; *finger != '\000' ; finger++ ) {
		if ( *finger == ',' ) {
			*finger = '\000';
			term_type = finger + 1;
			break;
		}
	}

	if ( term_type == NULL ) {
		term_type = getenv("TERM");
		if ( term_type == NULL ) {
			term_type = alloca(6);
			strcpy(term_type, "vt100"); 
		}
	}

	DPRINT("display-terminfo: initializing %s on %s.\n", term_type, ( ( *term_path == '\000' ) ? "stdin/stdout" : term_path ));

	tiinfo = (struct TIhooks *)_ggi_malloc(sizeof(struct TIhooks));

	tiinfo->splitline = 0;

	tiinfo->virgin = 1;

	if ( *term_path == '\000' ) {
		tiinfo->f_private = 0;
		tiinfo->f_in = stdin;
		tiinfo->f_out = stdout;
	} else {
		tiinfo->f_private = 1;
		tiinfo->f_in = tiinfo->f_out = fopen(term_path, "rw");
	}

	lock_ncurses();

	tiinfo->scr = newterm(term_type, tiinfo->f_out, tiinfo->f_in);
	if ( tiinfo->scr == NULL ) {
		fprintf(stderr, "display-terminfo: error creating ncurses"
				" SCREEN\n");
		unlock_ncurses();
		if ( tiinfo->f_private ) {
			fclose(tiinfo->f_in);
			fclose(tiinfo->f_out);
		}
		free(tiinfo);
		return GGI_DL_ERROR;
	}

	LIBGGI_SELECT_FD(vis) = fileno(tiinfo->f_in);
	LIBGGI_FD(vis) = fileno(tiinfo->f_out);

	set_term(tiinfo->scr);
	start_color();
	if ( has_colors() ) {
		static const int vga_color[8] = {
			COLOR_BLACK,
			COLOR_BLUE,
			COLOR_GREEN,
			COLOR_CYAN,
			COLOR_RED,
			COLOR_MAGENTA,
			COLOR_YELLOW,
			COLOR_WHITE
		};
		int j;
		DPRINT("display-terminfo: terminal supports %d colors\n", COLORS);
		DPRINT("display-terminfo: initializing %d - 1 color pairs\n", COLOR_PAIRS);
		for ( i = 1 ; i < COLOR_PAIRS ; i++ ) {
			if ( init_pair(i, COLORS - ( i % COLORS ) - 1, i / COLORS) == ERR ) {
				DPRINT("display-terminfo: error initializing color pair %d to %d,%d\n", i, COLORS - ( i % COLORS ) - 1, i / COLORS);
				fprintf(stderr, "display-terminfo: error initializing colors\n");
				break;
			}
		}
		for ( i = 0 ; i < 16 ; i++ ) {
			for ( j = 0 ; j < 16 ; j++ ) {
				tiinfo->color16_table[i+(j<<4)] =
					COLOR_PAIR(((COLORS-vga_color[i&0x07]%COLORS-1)
					 +(vga_color[j&0x07]%COLORS*COLORS))%COLOR_PAIRS)
					| ( ( i > 7 ) ? A_BOLD : A_NORMAL )
					| ( ( j > 7 ) ? A_BLINK : A_NORMAL );
			}
		}

	} else {
		DPRINT("display-terminfo: terminal lacks color support\n");
	}
	for ( i = 0 ; i < 256 ; i++ ) tiinfo->charmap[i] = i;
	/* FIXME mapping needs to be more complete; i.e. 'fake'
	   double-line versions of ACS_??CORNER and friends with the
	   single-line version we know through terminfo */
	/* mapping is IBM-ASCII; really only applicable for text16 */
	tiinfo->charmap[219] = ACS_BLOCK;
	tiinfo->charmap[218] = ACS_ULCORNER;
	tiinfo->charmap[192] = ACS_LLCORNER;
	tiinfo->charmap[191] = ACS_URCORNER;
	tiinfo->charmap[217] = ACS_LRCORNER;
	tiinfo->charmap[180] = ACS_RTEE;
	tiinfo->charmap[195] = ACS_LTEE;
	tiinfo->charmap[193] = ACS_BTEE;
	tiinfo->charmap[194] = ACS_TTEE;
	tiinfo->charmap[196] = ACS_HLINE;
	tiinfo->charmap[179] = ACS_VLINE;
	tiinfo->charmap[197] = ACS_PLUS;
	tiinfo->charmap[177] = ACS_CKBOARD;
	tiinfo->charmap[248] = ACS_DEGREE;
	tiinfo->charmap[241] = ACS_PLMINUS;
	tiinfo->charmap[254] = tiinfo->charmap[249] = tiinfo->charmap[250] = ACS_BULLET;
	/* we need arrows, diamond and such ... they're all below
	   ascii 26 in IBM-ASCII, though, so looking them up on the
	   console doesn't work too well. Someone who has time, please
	   find them out and add them */
	tiinfo->charmap[243] = ACS_LEQUAL;
	tiinfo->charmap[242] = ACS_GEQUAL;
	tiinfo->charmap[227] = ACS_PI;
	tiinfo->charmap[155] = ACS_NEQUAL; /* is this right? */
	tiinfo->charmap[156] = ACS_STERLING;
	cbreak();
	noecho();
	nonl();
	timeout(0);
	meta(stdscr, TRUE);
	keypad(stdscr, TRUE);
#if ( NCURSES_MOUSE_VERSION == 1 ) 
	DPRINT("display-terminfo: mouse support is enabled\n");
	mousemask(REPORT_MOUSE_POSITION | BUTTON1_PRESSED | BUTTON1_RELEASED |
			BUTTON2_PRESSED | BUTTON2_RELEASED | BUTTON3_PRESSED |
			BUTTON3_RELEASED | BUTTON4_PRESSED | BUTTON4_RELEASED,
			NULL);
#else
	DPRINT("display-terminfo: mouse support is disabled\n");
#endif
	unlock_ncurses();
 
	LIBGGI_PRIVATE(vis) = tiinfo;
	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	/* mode management */
	vis->opdisplay->flush     = GGI_terminfo_flush;
	vis->opdisplay->getmode   = GGI_terminfo_getmode;
	vis->opdisplay->setmode   = GGI_terminfo_setmode;
	vis->opdisplay->checkmode = GGI_terminfo_checkmode;
	vis->opdisplay->getapi    = GGI_terminfo_getapi;
	vis->opdisplay->setflags  = GGI_terminfo_setflags;

	/* event management */
	vis->opdisplay->eventpoll = GGI_terminfo_eventpoll;
	vis->opdisplay->eventread = GGI_terminfo_eventread;
	vis->opdisplay->seteventmask = GGIseteventmask;

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis) {
	struct TIhooks *tiinfo;

	tiinfo = LIBGGI_PRIVATE(vis);
	if ( tiinfo != NULL ) {
		if ( tiinfo->scr != NULL ) {
			lock_ncurses();
			set_term(tiinfo->scr);
			if ( !tiinfo->virgin ) {
				wclear(stdscr);
				refresh();
			}
			endwin();
			delscreen(tiinfo->scr);
			unlock_ncurses();
		}
		if ( tiinfo->f_private ) {
			if ( tiinfo->f_in != NULL ) {
				fclose(tiinfo->f_in);
			}
			if ( ( tiinfo->f_out != NULL ) && ( tiinfo->f_out != tiinfo->f_in ) ) {
				fclose(tiinfo->f_out);
			}
		}

		_GGI_terminfo_freedbs(vis);

		free(tiinfo);
	}	

	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
