/* $Id: mode.c,v 1.20 1998/10/18 15:53:05 becka Exp $
***************************************************************************

   Terminfo target

   Copyright (C) 1998 MenTaLboY         [mentalboy@geocities.com]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <limits.h>
#include <errno.h>

#include "TIvisual.h"
#include <ggi/internal/ggi-dl.h>

#include "../common/pixfmt-setup.inc"

extern void _GGI_terminfo_freedbs(ggi_visual *);

int GGI_terminfo_setorigin(ggi_visual *vis, int x, int y)
{
	struct TIhooks *tiinfo;
	ggi_mode *mode;

	tiinfo = LIBGGI_PRIVATE(vis);
	mode = LIBGGI_MODE(vis);

	x /= mode->dpp.x; y /= mode->dpp.y; /* terminfo can only set origin
                                               with pixel granularity, so
                                               internally, terminfo setorigin
                                               works in pixels */

	if ( ( x < 0 ) || ( x > ( mode->virt.x - mode->visible.x ) ) )
		return -EINVAL;
	if ( ( y < 0 ) || ( y > ( mode->virt.y - mode->visible.y ) ) )
		return -EINVAL;

	vis->origin_x=x;
	vis->origin_y=y;
	
	ggiFlush(vis);
	
	return 0;
}

#if 0
int GGI_terminfo_setsplitline(ggi_visual *vis, int line)
{
	struct TIhooks *tiinfo;
	ggi_mode *mode;

	tiinfo = LIBGGI_PRIVATE(vis);
	mode = LIBGGI_MODE(vis);
	
	line /= mode->dpp.y; /* terminfo can only set splitline with pixel
                                granularity, so internally, terminfo splitline
                                works in pixels */ 

	if ( ( line < 0 ) || ( line > mode->visible.y ) )
		return -EINVAL;

	tiinfo->splitline = line;

	ggiFlush(vis);

	return 0;
}
#endif

int GGI_terminfo_flush(ggi_visual *vis, int tryflag)
{
	struct TIhooks *tiinfo;
	ggi_mode *mode;

	tiinfo = LIBGGI_PRIVATE(vis);
	mode = LIBGGI_MODE(vis);

	lock_ncurses();
	set_term(tiinfo->scr);
	paint_ncurses_window(vis, stdscr, COLS, LINES);
	refresh();
	unlock_ncurses();
	
	return 0;
}

int GGI_terminfo_getapi(ggi_visual *vis, int num, char *apiname, char *arguments)
{
	switch(num) {
		case 0:
			strcpy(apiname, "display-terminfo");
			strcpy(arguments, "");
			return 0;
		case 1:
			strcpy(apiname, "generic-stubs");
			strcpy(arguments, "");
			return 0;
		case 2:
			switch (LIBGGI_MODE(vis)->graphtype) {
				case GT_TEXT16: strcpy(apiname, "generic-text-16"); break;
				case GT_TEXT32: strcpy(apiname, "generic-text-32"); break;
				default: return -1;
			}

			strcpy(arguments, "");
			return 0;
	}

	return -1;
}

static int _GGI_terminfo_loadstubs(ggi_visual *vis)
{
	int i, status;
	char sugname[256];
	char args[256];

	for(i = 1; GGI_terminfo_getapi(vis, i, sugname, args)==0; i++) {
		status = ( _ggiOpenDL(vis, sugname, args, NULL) == NULL );
		if ( status ) {
			fprintf(stderr, "display-terminfo: Unable to load an "
					"appropriate library for %s (%s)\n", sugname,
					args);
			return status;
		} else {
			DPRINT("display-terminfo: Loaded %s (%s)\n", sugname, args);
		}
	}

	ggiIndicateChange(vis, GGI_CHG_APILIST);

	return 0;
}

static int _GGI_terminfo_domode(ggi_visual *vis)
{
	struct TIhooks *tiinfo = LIBGGI_PRIVATE(vis);

	_ggiZapMode(vis, ~GGI_DL_OPDISPLAY);

	_GGI_terminfo_loadstubs(vis);

	vis->opdraw->setorigin = GGI_terminfo_setorigin;
#if 0
	vis->opdraw->setsplitline = GGI_terminfo_setsplitline;
#endif

#if 0   /* ++Andrew: The generic-text-* libraries supply versions of
	 * these functions which do the job.
	 */
	 
	vis->opcolor->mapcolor = GGI_terminfo_mapcolor;
	vis->opcolor->unmappixel = GGI_terminfo_unmappixel;
#endif

	tiinfo->virgin = 0;
	vis->origin_x = vis->origin_y = 0;
	tiinfo->splitline = LIBGGI_MODE(vis)->visible.y;

	lock_ncurses();
	set_term(tiinfo->scr);
	wclear(stdscr);
	refresh();
	unlock_ncurses();
	return 0;
} 

int GGI_terminfo_setmode(ggi_visual *vis, ggi_mode *tm)
{
	struct TIhooks *tiinfo;
	int status;

	tiinfo = LIBGGI_PRIVATE(vis);

	DPRINT("display-terminfo: setmode mode %8x %dx%d (%dx%d dots, %dx%d font)\n",
		tm->graphtype,
		tm->visible.x, tm->visible.y,
		tm->visible.x * tm->dpp.x, tm->visible.y * tm->dpp.y,
		tm->dpp.x, tm->dpp.y);

	status = GGI_terminfo_checkmode(vis, tm);
	if ( status ) return status;

	DPRINT("display-terminfo: approved mode %8x %dx%d (%dx%d dots, %dx%d font)\n",
		tm->graphtype,
		tm->visible.x, tm->visible.y,
		tm->visible.x * tm->dpp.x, tm->visible.y * tm->dpp.y,
		tm->dpp.x, tm->dpp.y);

	_GGI_terminfo_freedbs(vis);

	setup_pixfmt(LIBGGI_PIXFMT(vis), tm->graphtype);

	/* These are private or public buffers ? (-steve) */

	_ggi_db_add_buffer(LIBGGI_PRIVLIST(vis), _ggi_db_get_new());
	LIBGGI_PRIVBUFS(vis)[0]->type  = GGI_DB_NORMAL | GGI_DB_SIMPLE_PLB;
	LIBGGI_PRIVBUFS(vis)[0]->frame = 0;
	LIBGGI_PRIVBUFS(vis)[0]->read  =
	LIBGGI_PRIVBUFS(vis)[0]->write = _ggi_malloc(LIBGGI_FB_SIZE(tm));
	LIBGGI_PRIVBUFS(vis)[0]->layout = blPixelLinearBuffer;
	LIBGGI_PRIVBUFS(vis)[0]->buffer.plb.stride = tm->virt.x * GT_SIZE(tm->graphtype) / 8;
	LIBGGI_PRIVBUFS(vis)[0]->buffer.plb.pixelformat = LIBGGI_PIXFMT(vis);

	memcpy(LIBGGI_MODE(vis), tm, sizeof(ggi_mode));

	return _GGI_terminfo_domode(vis);
}

int GGI_terminfo_checkmode(ggi_visual *vis, ggi_mode *tm)
{
	int status=0;
	struct TIhooks *tiinfo;

	tiinfo = LIBGGI_PRIVATE(vis);

	lock_ncurses();
	set_term(tiinfo->scr);
	if ( tm->dpp.x == GGI_AUTO ) tm->dpp.x = 8;
	if ( tm->dpp.y == GGI_AUTO ) tm->dpp.y = 8;
	if ( ( tm->visible.x > COLS  )
		|| ( tm->visible.y > LINES ) )
			status = GGI_DL_ERROR;
	/* FIXME we should also take into account the number of pages desired */
	tm->visible.x = COLS;
	tm->visible.y = LINES;
	unlock_ncurses();
	if ( tm->virt.x < tm->visible.x ) tm->virt.x = tm->visible.x;
	if ( tm->virt.y < tm->visible.y ) tm->virt.y = tm->visible.y;
	tm->frames = ( tm->virt.x / tm->visible.x ) * ( tm->virt.y / tm->visible.y );
	if ( ( tm->graphtype != GT_TEXT16 ) && ( tm->graphtype != GT_TEXT32 ) ) {
		tm->graphtype = GT_TEXT16;
		status = GGI_DL_ERROR;
	}
	return status;
}

int GGI_terminfo_getmode(ggi_visual *vis, ggi_mode *tm)
{
	if ( vis == NULL ) return -1;
	memcpy(tm, LIBGGI_MODE(vis), sizeof(ggi_mode));
	DPRINT("display-terminfo: getmode mode %8x %dx%d (%dx%d dots, %dx%d font)\n",
		tm->graphtype,
		tm->visible.x, tm->visible.y,
		tm->visible.x * tm->dpp.x, tm->visible.y * tm->dpp.y,
		tm->dpp.x, tm->dpp.y);
	return 0;
}

int GGI_terminfo_setflags(ggi_visual *vis, ggi_flags flags)
{
	/* Doesn't support sync mode */
	LIBGGI_FLAGS(vis) = flags;
	return 0;
}
