/* $Id: color.c,v 1.5 1998/09/25 21:32:55 becka Exp $
***************************************************************************

   TELE target.

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#include <ggi/internal/ggi-dl.h>

#include "libtele.h"
#include "telehook.h"


#define MAX_COLORS  TELE_MAXIMUM_TLONG(TeleCmdSetPaletteData)


int GGI_tele_setpalvec(ggi_visual *vis, int start, int len, ggi_color *cols)
{
	TeleHook *th = TELE_PRIV(vis);
	TeleCmdSetPaletteData *c;
	TeleEvent ev;

	int no_cols, err;


	DPRINT("display-tele: setpalette(start=%d, len=%d)\n", start, len);

	if (GT_SCHEME(LIBGGI_GT(vis)) != GT_PALETTE) {
		return -1;
	}

	if (start == GGI_PALETTE_DONTCARE) {
		start = 0;
	}

	no_cols = 1 << GT_DEPTH(LIBGGI_GT(vis));

	if (cols==NULL || (start+len) > no_cols) {
		return -1;
	}

	memcpy(vis->palette+start, cols, len*sizeof(ggi_color)); 


	/* send palette to the server */

	for (; len > 0; ) {

		int i;
		int num = len;

		if (num > MAX_COLORS) {
			num = MAX_COLORS;
		}

		c = tclient_new_event(th->client, &ev, TELE_CMD_SETPALETTE,
				sizeof(TeleCmdSetPaletteData) + num*4, 0);
				
		c->start = start;
		c->len   = num;

		for (i=0; i < num; i++) {
			c->colors[i] = ((cols->r & 0xff00) << 8) |
				       ((cols->g & 0xff00)     ) |
				       ((cols->b & 0xff00) >> 8);
			cols++; start++; len--;
		}

		err = tclient_write(th->client, &ev);

		if (err == TELE_ERROR_SHUTDOWN) {
			TELE_HANDLE_SHUTDOWN;
		} else if (err < 0) {
			return err;
		}
	}
	
	return 0;
}
