/* $Id: color.c,v 1.16 1998/09/26 03:24:02 marcus Exp $
***************************************************************************

   Display-monotext: color management

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "monotext.h"


int GGI_monotext_setpalvec(ggi_visual *vis, int start, int len, ggi_color *colormap)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);

	DPRINT("display-monotext: SetPalVec(%d,%d)\n", start, len);
	
	if (start == GGI_PALETTE_DONTCARE) {
		start = 0;
	}

	if ((start < 0) || (len < 0) || (start+len > 256)) {
		return -1;
	}

	memcpy(vis->palette+start, colormap, len*sizeof(ggi_color));
	
	if (len > 0) {
		UPDATE_MOD(mt, 0, 0, mt->size.x, mt->size.y);
	}

	for (; len > 0; len--, start++, colormap++) {

		int r = (colormap->r >> 11) & 0x1f;
		int g = (colormap->g >> 11) & 0x1f;
		int b = (colormap->b >> 11) & 0x1f;

		mt->colormap[start] = *colormap;

		mt->greymap[start] = 
			mt->rgb_to_grey[(r << 10) | (g << 5) | b];
	}
	
	UPDATE_SYNC;
	return 0;
}



