/* $Id: fb.c,v 1.3 1998/09/24 01:24:36 marcus Exp $
***************************************************************************

   LibGGI GLIDE target - Framebuffer handling

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>
#include "glidevisual.h"


int
GGI_glide_setdisplayframe(ggi_visual *vis, int num)
{
	if (num < 0 || num >= LIBGGI_MODE(vis)->frames) {
		return -1;
	}
	if (num != vis->d_frame_num) {
		vis->d_frame_num = num;
		grBufferSwap(1);
	}
	if (num == vis->r_frame_num) {
		GLIDE_PRIV(vis)->readbuf = GR_BUFFER_FRONTBUFFER;
	} else {
		GLIDE_PRIV(vis)->readbuf = GR_BUFFER_BACKBUFFER;
	}
	if (num == vis->w_frame_num) {
		GLIDE_PRIV(vis)->writebuf = GR_BUFFER_FRONTBUFFER;
		grRenderBuffer(GR_BUFFER_FRONTBUFFER);
	} else {
		GLIDE_PRIV(vis)->writebuf = GR_BUFFER_BACKBUFFER;
		grRenderBuffer(GR_BUFFER_BACKBUFFER);
	}
	
	return 0;
}

int
GGI_glide_setreadframe(ggi_visual *vis, int num)
{
	if (num < 0 || num >= LIBGGI_MODE(vis)->frames) {
		return -1;
	}
	if (num == vis->d_frame_num) {
		GLIDE_PRIV(vis)->readbuf = GR_BUFFER_FRONTBUFFER;
	} else {
		GLIDE_PRIV(vis)->readbuf = GR_BUFFER_BACKBUFFER;
	}
	vis->r_frame_num = num;
	
	return 0;
}

int
GGI_glide_setwriteframe(ggi_visual *vis, int num)
{
	if (num < 0 || num >= LIBGGI_MODE(vis)->frames) {
		return -1;
	}
	if (num == vis->d_frame_num) {
		GLIDE_PRIV(vis)->writebuf = GR_BUFFER_FRONTBUFFER;
		grRenderBuffer(GR_BUFFER_FRONTBUFFER);
	} else {
		GLIDE_PRIV(vis)->writebuf = GR_BUFFER_BACKBUFFER;
		grRenderBuffer(GR_BUFFER_BACKBUFFER);
	}
	vis->w_frame_num = num;
	
	return 0;
}
