/* $Id: box.c,v 1.4 1998/09/24 01:24:34 marcus Exp $
***************************************************************************

   LibGGI GLIDE target - Box functions

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include <ggi/internal/ggi-dl.h>
#include "glidevisual.h"

int
GGI_glide_fillscreen(ggi_visual *vis)
{
	grBufferClear(LIBGGI_GC(vis)->fg_color, 0, GR_WDEPTHVALUE_FARTHEST);
	
	return 0;
}

int GGI_glide_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	GrVertex br = GLIDE_PRIV(vis)->fgvertex;
	GrVertex var = GLIDE_PRIV(vis)->fgvertex;
	
	GLIDE_PRIV(vis)->fgvertex.x = x;
	GLIDE_PRIV(vis)->fgvertex.y = y;
	br.x = x+w;
	br.y = y+h;

	var.x = x;
	var.y = y+h;
	guDrawTriangleWithClip(&GLIDE_PRIV(vis)->fgvertex, &br, &var);
	var.x = x+w;
	var.y = y;
	guDrawTriangleWithClip(&GLIDE_PRIV(vis)->fgvertex, &br, &var);

	return 0;

}

int GGI_glide_putbox(ggi_visual *vis, int x, int y, int w, int h, void *data)
{
	int rowadd = GLIDE_PRIV(vis)->bytes_per_pixel*w;

	if (y< LIBGGI_GC(vis)->cliptl.y) {
		int diff=LIBGGI_GC(vis)->cliptl.y-y;
		y+=diff;
		h-=diff;
		data = ((uint8 *)data)+rowadd*diff; 
	}
	if (y+h>LIBGGI_GC(vis)->clipbr.y) {
		h=LIBGGI_GC(vis)->clipbr.y-y;
	}
	if (h<1) return 0;

	if (x< LIBGGI_GC(vis)->cliptl.x) {
		int diff=LIBGGI_GC(vis)->cliptl.x-x;
		x+=diff;
		w-=diff;
		data = ((uint8 *)data)+diff;
		}
	if (x+w>LIBGGI_GC(vis)->clipbr.x) {
		w=LIBGGI_GC(vis)->clipbr.x-x;
	}
	if (w<1) return 0;

	grLfbWriteRegion(GLIDE_PRIV(vis)->writebuf, x-1, y-1,
			 GLIDE_PRIV(vis)->src_format,
			 w, h, GLIDE_PRIV(vis)->bytes_per_pixel*w, data);

	return 0;
}

int GGI_glide_getbox(ggi_visual *vis, int x, int y, int w, int h, void *data)
{
	grLfbReadRegion(GLIDE_PRIV(vis)->readbuf, x-1, y-1,
			w, h, GLIDE_PRIV(vis)->bytes_per_pixel*w, data);
	return 0;
}

#if 0 /* Doesn't seem to make any difference... */
int GGI_glide_copybox(ggi_visual *vis, int x, int y, int w, int h, int nx, int ny)
{
	void *chunkbuf;

	/* Clipping */

	if (nx < LIBGGI_GC(vis)->cliptl.x) {
		int diff = LIBGGI_GC(vis)->cliptl.x - nx;
		x  += diff;
		nx += diff;
		w  -= diff;
	}
	if (ny < LIBGGI_GC(vis)->cliptl.y) {
		int diff = LIBGGI_GC(vis)->cliptl.y - ny;
		y  += diff;
		ny += diff;
		h  -= diff;
	}
	if (nx+w > LIBGGI_GC(vis)->clipbr.x) {
		w = LIBGGI_GC(vis)->clipbr.x - nx;
	}
	if (ny+h > LIBGGI_GC(vis)->clipbr.y) {
		h = LIBGGI_GC(vis)->clipbr.y - ny;
	}

     	if ((h <= 0) || (w <= 0)) {
		return 0;
	}
	
	chunkbuf = _ggi_malloc(w*h*GLIDE_PRIV(vis)->bytes_per_pixel);
	
	grLfbReadRegion(GLIDE_PRIV(vis)->readbuf, x-1, y-1,
			w, h, GLIDE_PRIV(vis)->bytes_per_pixel*w,
			chunkbuf);
	grLfbWriteRegion(GLIDE_PRIV(vis)->writebuf, nx-1, ny-1,
			 GLIDE_PRIV(vis)->src_format,
			 w, h, GLIDE_PRIV(vis)->bytes_per_pixel*w,
			 chunkbuf);

	free(chunkbuf);
	
	return 0;
}
#endif
