/* $Id: visual.c,v 1.6 1998/10/18 15:52:46 becka Exp $
***************************************************************************

   Display-file: initialization

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <ggi/internal/ggi-dl.h>

#include "filehook.h"


#if 0  /* This may come in handy later on */
static ggi_option file_options[1] =
{
};
#endif

int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	FileHook *ff;
	
	LIBGGI_FD(vis) = -1;


	/* initialize */

	if (!args || !args[0]) {
		fprintf(stderr, "display-file: Missing filename.\n");
		return GGI_DL_ERROR;
	}

	DPRINT("display-file: coming up (filename='%s').\n", args);
	
	LIBGGI_PRIVATE(vis) = ff = _ggi_malloc(sizeof(FileHook));
	LIBGGI_GC(vis) = _ggi_malloc(sizeof(ggi_gc));

	ff->flags = 0;
	ff->writer = (file_writer_func *) NULL;
	ff->fb_ptr = ff->file_mmap = NULL;


	/* handle arguments */
#if 0
	if (getenv("GGI_FILE_OPTIONS") != NULL) {
		if (_GGIparseoptions(getenv("GGI_FILE_OPTIONS"),
			file_options, 2) == NULL) {
			
			fprintf(stderr, "display-file: error in "
				"$GGI_FILE_OPTIONS.\n");
			free(ff);
			return GGI_DL_ERROR;
		}
	}
	
	args = _GGIparseoptions((char *) args, file_options, 2);
			
	if (args == NULL) {
		fprintf(stderr, "display-file: error in "
			"arguments.\n");
		free(ff);
		return GGI_DL_ERROR;
	}
#endif


	ff->filename = strdup(args);
	
	if (_ggi_file_ppm_detect(ff->filename)) {
		ff->writer = &_ggi_file_ppm_write;
	} else {
		ff->flags |= FILEFLAG_RAW;
	}


	vis->opdisplay->getmode=GGI_file_getmode;
	vis->opdisplay->setmode=GGI_file_setmode;
	vis->opdisplay->getapi=GGI_file_getapi;
	vis->opdisplay->checkmode=GGI_file_checkmode;
	vis->opdisplay->setflags=GGI_file_setflags;
	
	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	FileHook *ff = FILE_PRIV(vis);

	DPRINT("display-file: going down.\n");
	
	if (ff->fb_ptr != NULL) {
		GGI_file_resetmode(vis);
	}

	free(ff->filename);

	free(FILE_PRIV(vis));
	free(LIBGGI_GC(vis));

	LIBGGI_PRIVATE(vis) = LIBGGI_GC(vis) = NULL;

	return 0;
}

#include <ggi/internal/ggidlinit.h>
