/* $Id: events.c,v 1.13 1998/10/29 11:58:55 ajapted Exp $
***************************************************************************

   Display-FBDEV

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <termios.h>
#include <fcntl.h>

#include <sys/ioctl.h>

#include <linux/kd.h>
#include <linux/vt.h>

#include <ggi/internal/ggi-dl.h>

#include "fbdev.h"

#include "../common/evqueue.inc"


#define VTSWITCH_PRIV(vis)	(FBDEV_PRIV(vis)->vtswitch_priv)
#define KEYBOARD_PRIV(vis)	(FBDEV_PRIV(vis)->kbd_priv)
#define MOUSE_FD(vis)		(FBDEV_PRIV(vis)->mouse_fd)
#define MOUSE_PRIV(vis)		(FBDEV_PRIV(vis)->mouse_priv)
#define JOYSTICK_FD(vis)	(FBDEV_PRIV(vis)->joy_fd)
#define JOYSTICK_PRIV(vis)	(FBDEV_PRIV(vis)->joy_priv)
#define SPACEORB_FD(vis)	(FBDEV_PRIV(vis)->orb_fd)
#define SPACEORB_PRIV(vis)	(FBDEV_PRIV(vis)->orb_priv)

#define WANT_TRANSLATE_SHIFT  1

#include "../Linux_common/vtswitch.inc"
#include "../Linux_common/key_trans.inc"
#include "../Linux_common/keyboard.inc"
#include "../Linux_common/mouse.inc"

/* #include "../Linux_common/joystick.inc" */
/* #include "../Linux_common/spaceorb.inc" */


/* ---------------------------------------------------------------------- */


static void fbdev_send_expose_event(ggi_visual *vis)
{
	ggi_event ev;

	ev.any.size   = sizeof(ggi_expose_event);
	ev.any.type   = evExpose;
	ev.any.origin = EV_ORIGIN_NONE;
	ev.any.target = EV_TARGET_NONE;

	EV_TIMESTAMP(& ev);

	ev.expose.x = ev.expose.y = 0;
	ev.expose.w = LIBGGI_VIRTX(vis);
	ev.expose.h = LIBGGI_VIRTY(vis);

	_ggiEvQueueAdd(vis, &ev);

	DPRINT_EVENTS("display-fbdev: EXPOSE sent.\n");
}


ggi_event_mask GGI_fbdev_eventpoll(ggi_visual_t vis, ggi_event_mask mask,
			    struct timeval *t)
{
	fbdev_hook *ff = LIBGGI_PRIVATE(vis);

	ggi_event_mask evmask;

	int err;
	

	DPRINT_EVENTS("display-fbdev: eventpoll mask=0x%08x ", mask);

	if (t == NULL) {
		DPRINT_EVENTS("timeout=NULL\n");
	} else {
		DPRINT_EVENTS("timeout=(%d,%d)\n", t->tv_sec, t->tv_usec);
	}


	for (evmask = _ggiEvQueueSeen(vis, mask);
	     evmask == 0;
	     evmask = _ggiEvQueueSeen(vis, mask)) {

		fd_set fds;
		int fdmax;

		FD_ZERO(&fds);
		
		FD_SET(LIBGGI_SELECT_FD(vis), &fds);
		fdmax = LIBGGI_SELECT_FD(vis);

		if (ff->mouse_fd >= 0) {
			FD_SET(ff->mouse_fd, &fds);
			if (ff->mouse_fd > fdmax) {
				fdmax = ff->mouse_fd;
			}
		}


		/* check for VT switch-back */

		if (ff->need_redraw) {
			fbdev_send_expose_event(vis);
			ff->need_redraw = 0;
		}


		/* NB: The following EINTR handling assumes the Linux
		 * behaviour of select(), which modifies the timeout to
		 * indicate the time not slept.
		 */

		err = select(fdmax+1, &fds, NULL, NULL, t);

		if ((err < 0) && (errno == EINTR)) {
			continue;
		
		} else if (err < 0) {
			DPRINT_EVENTS("display-fbdev: select error.\n");
			return 0;

		} if (err == 0) {   /* select timed-out */
			DPRINT_EVENTS("display-fbdev: eventpoll timed out.\n");
			return 0;
		}


		if (FD_ISSET(LIBGGI_SELECT_FD(vis), &fds)) {
			keyboard_handle_data(vis);

		} else if ((ff->mouse_fd >= 0) &&
		           FD_ISSET(ff->mouse_fd, &fds)) {
			mouse_handle_data(vis);
		}
	}

	return evmask;
}


int GGI_fbdev_eventread(ggi_visual_t vis, ggi_event *ev, ggi_event_mask mask)
{
	/* Block if we don't have anything queued... */
	
	GGI_fbdev_eventpoll(vis, mask, NULL);

	return _ggiEvQueueRelease(vis, ev, mask);
}
