/* $Id: modelist.inc,v 1.5 1998/10/02 07:37:06 ajapted Exp $
***************************************************************************

   Functions to handle GGI_AUTO for targets with a list of modes.

   Copyright (C) 1998 Marcus Sundberg - marcus@ggi-project.org

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifdef WANT_MODELIST
#define WANT_CHECKONEBPP
#define WANT_GETHIGHBPP
#define WANT_CHECKAUTOBPP
#endif

#ifdef WANT_CHECKONEBPP
static int _GGIcheckonebpp(ggi_visual *vis,ggi_mode *tm, ggi_modelistmode *gm)
{
	int i=0, bestw=0, besth=0;
	int wantw=tm->visible.x, wanth=tm->visible.y;
	for (i=0; gm[i].bpp != 0; i++) {
		if (gm[i].gt != tm->graphtype) {
			DPRINT("_GGIcheckonebpp, wanted: 0x%x, skipping 0x%x\n",
			       tm->graphtype,  gm[i].gt); 
			continue;
		}
		if ((gm[i].x == wantw || wantw == GGI_AUTO) &&
		    (gm[i].y == wanth || wanth == GGI_AUTO)) {
			tm->visible.x=gm[i].x;
			tm->visible.y=gm[i].y;
			return 0;
		}
		if (((gm[i].x >= bestw &&
		      bestw <= wantw)
		     || wantw == GGI_AUTO
		     || (bestw >= wantw && gm[i].x >= wantw)) &&
		    ((gm[i].y >= besth &&
		      besth <= wanth)
		     || wanth == GGI_AUTO
		     || (besth >= wanth && gm[i].y >= wanth))) {
			DPRINT("_GGIcheckonebpp, best: %dx%d\n",
			       gm[i].x, gm[i].y);
			bestw = gm[i].x;
			besth = gm[i].y;
		}
	}
	if (bestw == 0)
		return 1;
	tm->visible.x=bestw;
	tm->visible.y=besth;
	return -1;
}
#endif

#ifdef WANT_GETHIGHBPP
static int _GGIgethighbpp(ggi_visual *vis,ggi_mode *tm, ggi_modelistmode *gm)
{
	int i=0, bestw=0, besth=0, bestbpp=0, bestgt=GT_AUTO;
	int wantw=tm->visible.x, wanth=tm->visible.y,
		wantbpp=GT_DEPTH(tm->graphtype);
	for (i=0; gm[i].bpp != 0; i++) {
		if (((gm[i].x >= bestw &&
		      bestw <= wantw) || wantw == GGI_AUTO) &&
		    ((gm[i].y >= besth &&
		      besth <= wanth) || wanth == GGI_AUTO) &&
		     (gm[i].bpp >= bestbpp && bestbpp <= wantbpp)) {
			bestw = gm[i].x;
			besth = gm[i].y;
			bestbpp = gm[i].bpp;
			bestgt = gm[i].gt;
			continue;
		}
	}
	tm->visible.x=bestw;
	tm->visible.y=besth;
	tm->graphtype=bestgt;
	
	return 0;

}
#endif

#ifdef WANT_CHECKAUTOBPP
static int _GGIcheckautobpp(ggi_visual *vis,ggi_mode *tm, ggi_modelistmode *gm)
{
	int i=0, ret=0, bestw=0, besth=0, bestbpp=0, bestgt=GT_AUTO, gotmode=0;
	int wantw=tm->visible.x, wanth=tm->visible.y;
	for (i=0; gm[i].bpp != 0; i++) {
		if ((gm[i].x == wantw || wantw == GGI_AUTO) &&
		    (gm[i].y == wanth || wanth == GGI_AUTO)) {
			if (gm[i].bpp >= bestbpp) {
				bestw = gm[i].x;
				besth = gm[i].y;
				bestbpp = gm[i].bpp;
				bestgt = gm[i].gt;
				gotmode=1;
			}
		}
		if (gotmode)
			continue;
		if (((gm[i].x >= bestw &&
		     bestw <= wantw) || wantw == GGI_AUTO) &&
		    ((gm[i].y >= besth &&
		      besth <= wanth) || wanth == GGI_AUTO) &&
		    gm[i].bpp >= bestbpp) {
			bestw = gm[i].x;
			besth = gm[i].y;
			bestbpp = gm[i].bpp;
			bestgt = gm[i].gt;
		}
	}
	if (gotmode) {
		ret = 0;
	} else {
		ret = -1;
	}
	tm->visible.x=bestw;
	tm->visible.y=besth;
	tm->graphtype=bestgt;
	
	return ret;
}
#endif
