/* $Id: color.c,v 1.10 1998/09/20 21:23:26 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted     [andrew@ggi-project.org]

   If you do any modifications, I would like you to send diffs to me
   to allow for collecting a more and more complete set of drivers and
   to improve existing ones.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

/* Standard 16 colors */

static ggi_color ansi_16_colors[16] =
{
	{ 0x0000, 0x0000, 0x0000 },
	{ 0x0000, 0x0000, 0xaaaa },
	{ 0x0000, 0xaaaa, 0x0000 },
	{ 0x0000, 0xaaaa, 0xaaaa },
	{ 0xaaaa, 0x0000, 0x0000 },
	{ 0xaaaa, 0x0000, 0xaaaa },
	{ 0xaaaa, 0xaaaa, 0x0000 },
	{ 0xaaaa, 0xaaaa, 0xaaaa },

	{ 0x5555, 0x5555, 0x5555 },
	{ 0x5555, 0x5555, 0xffff },
	{ 0x5555, 0xffff, 0x5555 },
	{ 0x5555, 0xffff, 0xffff },
	{ 0xffff, 0x5555, 0x5555 },
	{ 0xffff, 0x5555, 0xffff },
	{ 0xffff, 0xffff, 0x5555 },
	{ 0xffff, 0xffff, 0xffff }
};

extern int _ggi_match_palette(ggi_color *pal, int len, ggi_color *col);

ggi_pixel GGImapcolor(ggi_visual *vis, ggi_color *col)
{
	int index;

	index = _ggi_match_palette(ansi_16_colors, 16, col);

	/* Now put this color into the *foreground* part of the text
	 * pixel, and choose a character that is as solid as possible.
	 */

	return (index == 0) ? 0x20 /* space */ :
		((index << 8) | 0xdb /* block */ );
}

/* Map pixel to color
 */

int GGIunmappixel(ggi_visual *vis, ggi_pixel pixel, ggi_color *col)
{
	*col = ansi_16_colors[(pixel & 0x0f00) >> 8];

	return 0;
}
