/* $Id: hline.c,v 1.8 1998/09/20 21:23:08 marcus Exp $
***************************************************************************

   Generic 8, 16, 32 Banked Graphics library for GGI. Horizontal lines.

   Copyright (C) 1998 Brian S. Julin   [bri@forcade.calyx.com]
   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>
#include "linmm_banked.h"

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGIdrawhline(ggi_visual *vis,int x,int y,int w)
{
	ggi_pixel color;
	unsigned int align;
	uint8 *pixpt;

	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) 
	        return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	CHECKXYW(vis,x,y,w);

	color = LIBGGI_GC_FGCOLOR(vis);

	switch(LOGBYTPP) {
	case 0: 
	  color &= 0xff;
	  color |= color << 8;
	case 1: 
	  color &= 0xffff;
	  color |= color << 16;
	}

	/* Bank shadowing or ASM may speed this up --
           cannot memcpy() strips because memcpy() aligns with the 
           write buffer, not the mmap region (ick.) */
	align = ((y * LIBGGI_FB_WIDTH(vis) + x) << LOGBYTPP);
	pixpt = BANKFB + align;
	if (!(align &= 0x3)) align = 4;

	w = w << LOGBYTPP;

	switch (align) {
	case 3:
	  memset(pixpt++, (int) color, 1);
	  break;
	case 1:
	  memset(pixpt++, (int) color, 1);
	  if (w == 2) { memset(pixpt, (int) color, 1) ; return 0; };
	  if (w == 1) return 0;
	case 2:
	  if (w == 1) { memset(pixpt, (int) color, 1) ; return 0; };
	  memcpy(pixpt, &color, 2);
	  pixpt += 2;
	}	  
	while (w > 7 - align) {
	  memcpy(pixpt, &color, 4);
	  w -= 4;
	  pixpt += 4;
	}
	if ( w > 5 - align) {
	  memcpy(pixpt, &color, 2);
	  w -= 2;
	  pixpt += 2;
	}
	if (w > 4 - align) memset(pixpt, (int)color, 1);
	return 0;
}

int GGIdrawhline_nc(ggi_visual *vis,int x,int y,int w)
{
	ggi_pixel color;
	unsigned int align;
	uint8 *pixpt;

	color = LIBGGI_GC_FGCOLOR(vis);

	switch(LOGBYTPP) {
	case 0: 
	  color &= 0xff;
	  color |= color << 8;
	case 1: 
	  color &= 0xffff;
	  color |= color << 16;
	}

	/* Bank shadowing or ASM may speed this up --
           cannot memcpy() strips because memcpy() aligns with the 
           write buffer, not the mmap region (ick.) */
	align = ((y * LIBGGI_FB_WIDTH(vis) + x) << LOGBYTPP);
	pixpt = BANKFB + align;
	if (!(align &= 0x3)) align = 4;

	w = w << LOGBYTPP;

	switch (align) {
	case 3:
	  memset(pixpt++, (int) color, 1);
	  break;
	case 1:
	  memset(pixpt++, (int) color, 1);
	  if (w == 2) { memset(pixpt, (int) color, 1) ; return 0; };
	  if (w == 1) return 0;
	case 2:
	  if (w == 1) { memset(pixpt, (int) color, 1) ; return 0; };
	  memcpy(pixpt, &color, 2);
	  pixpt += 2;
	}	  
	while (w > 7 - align) {
	  memcpy(pixpt, &color, 4);
	  w -= 4;
	  pixpt += 4;
	}
	if ( w > 5 - align) {
	  memcpy(pixpt, &color, 2);
	  w -= 2;
	  pixpt += 2;
	}
	if (w > 4 - align) memset(pixpt, (int)color, 1);
	return 0;
}

int GGIputhline(ggi_visual *vis,int x,int y,int w,void *buff)
{ 
	uint8 *pixpt,*buffer=(uint8 *)buff;
	unsigned int align;

	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) 
                return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
		buffer=((uint8 *)buffer)+diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	CHECKXYW(vis,x,y,w);

	/* Hitting mapped banks first is silly for hline since banks
           are usually bigger than one line ==> single segv */

	align = ((y * LIBGGI_FB_WIDTH(vis) + x) << LOGBYTPP);
	pixpt = BANKFB + align;
	if (!(align &= 0x3)) align = 4;

	w = w << LOGBYTPP;

	switch (align) {
	case 3:
	  memcpy(pixpt++, buffer++, 1);
	  break;
	case 1:
	  memcpy(pixpt++, buffer++, 1);
	  if (w == 2) { memcpy(pixpt, buffer, 1) ; return 0; };
	  if (w == 1) return 0;
	case 2:
	  if (w == 1) { memcpy(pixpt, buffer, 1) ; return 0; };
	  memcpy(pixpt, buffer, 2);
	  pixpt += 2;
	  buffer += 2;
	}	  
	if (w > 4 - align) memcpy(pixpt, buffer, w - 4 + align);

	return 0;
}

int GGIgethline(ggi_visual *vis,int x,int y,int w,void *buff)
{ 
	uint8 *pixpt,*buffer=(uint8 *)buff;
	unsigned int align;

	CHECKXYW(vis,x,y,w);

	/* Bank shadowing or ASM may speed this up --
           cannot memcpy() strips because memcpy() aligns with the 
           write buffer, not the mmap region (ick.) */

	align = ((y * LIBGGI_FB_WIDTH(vis) + x) << LOGBYTPP);
	pixpt = RBANKFB + align;
	if (!(align &= 0x3)) align = 4;

	w = w << LOGBYTPP;

	switch (align) {
	case 3:
	  memcpy(buffer++, pixpt++, 1);
	  break;
	case 1:
	  memcpy(buffer++, pixpt++, 1);
	  if (w == 2) { memcpy(buffer, pixpt, 1) ; return 0; };
	  if (w == 1) return 0;
	case 2:
	  if (w == 1) { memcpy(buffer, pixpt, 1) ; return 0; };
	  memcpy(buffer, pixpt, 2);
	  pixpt += 2;
	  buffer += 2;
	}	  
	while (w > 7 - align) {
	  memcpy(buffer, pixpt, 4);
	  w -= 4;
	  buffer += 4;
	  pixpt += 4;
	}
	if ( w > 5 - align) {
	  memcpy(buffer, pixpt, 2);
	  w -= 2;
	  buffer += 2;
	  pixpt += 2;
	}
	if (w > 4 - align) memcpy(buffer, pixpt, 1);

	return 0;
}
