/* $Id: hline.c,v 1.9 1998/09/26 03:20:51 marcus Exp $
***************************************************************************

   Graphics library for GGI. Horizontal lines.

   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include "lin8lib.h"

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGI_lin8_drawhline(ggi_visual *vis,int x,int y,int w)
{
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		memset((char *)LIBGGI_CURWRITE(vis)
		       + y*LIBGGI_FB_W_STRIDE(vis)+x,
		       LIBGGI_GC_FGCOLOR(vis),w);
	}
	return 0;
}

int GGI_lin8_drawhline_nc(ggi_visual *vis,int x,int y,int w)
{
        memset((char *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+x,
	       LIBGGI_GC_FGCOLOR(vis),w);
	return 0;
}

int GGI_lin8_puthline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	char *mem;

	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
		buffer=((char *)buffer)+diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		mem=(char *)LIBGGI_CURWRITE(vis)+y*LIBGGI_FB_W_STRIDE(vis)+x;
		memcpy(mem,buffer,w);
	}
	return 0;
}

int GGI_lin8_gethline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	memcpy(buffer,(char *)LIBGGI_CURREAD(vis)+y*LIBGGI_FB_R_STRIDE(vis)+x,w);

	return 0;
}

