/* $Id: vline.c,v 1.8 1998/09/20 21:22:45 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

/********************************/
/* draw/get/put a vertical line */
/********************************/
int GGIdrawvline(ggi_visual *vis,int x,int y,int height)
{
	uint8 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 color0=((LIBGGI_GC_FGCOLOR(vis)    ) & 0xff);
	uint8 color1=((LIBGGI_GC_FGCOLOR(vis)>>8 ) & 0xff);
	uint8 color2=((LIBGGI_GC_FGCOLOR(vis)>>16) & 0xff);

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*w+x*3;

	for(;height>0;height--,ptr+=w)
	{
		ptr[0]=color0;
		ptr[1]=color1;
		ptr[2]=color2;
	}
	
	return 0;
}

int GGIdrawvline_nc(ggi_visual *vis,int x,int y,int height)
{
	uint8 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	uint8 color0=((LIBGGI_GC_FGCOLOR(vis)    ) & 0xff);
	uint8 color1=((LIBGGI_GC_FGCOLOR(vis)>>8 ) & 0xff);
	uint8 color2=((LIBGGI_GC_FGCOLOR(vis)>>16) & 0xff);

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*w+x*3;

	for(;height>0;height--,ptr+=w)
	{
		ptr[0]=color0;
		ptr[1]=color1;
		ptr[2]=color2;
	}
	
	return 0;
}

int GGIputvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint8 *ptr,*pixels=(uint8 *)buffer;
	int w=LIBGGI_FB_W_STRIDE(vis);

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
		buffer =((char *)buffer)+3*diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr=(uint8 *)LIBGGI_CURWRITE(vis)+y*w+x*3;

	for(;height>0;height--,ptr+=w) 
	{
		
		ptr[0]=pixels[0]; 
		ptr[1]=pixels[1]; 
		ptr[2]=pixels[2];
		pixels+=3;
	}
	
	return 0;
}

int GGIgetvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint8 *ptr,*pixels=(uint8 *)buffer;
	int w=LIBGGI_FB_R_STRIDE(vis);

	ptr=(uint8 *)LIBGGI_CURREAD(vis)+y*w+x*3;

	for(;height>0;height--,ptr+=w)
	{ 
		pixels[0]=ptr[0];
		pixels[1]=ptr[1];
		pixels[2]=ptr[2];
		pixels+=3;
	}
	
	return 0;
}

