/* $Id: copybox.c,v 1.7 1998/09/20 21:22:29 marcus Exp $
***************************************************************************

   Graphics library for GGI. Pixels.

   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>

/*******************************/
/* draw/get/put a single pixel */
/*******************************/

int GGIcopybox(ggi_visual *vis,int x,int y,int w,int h,int nx,int ny)
{
	uint16 *obox,*nbox;
	int linew=LIBGGI_FB_W_STRIDE(vis)/sizeof(uint16);
	int line;

	/* Clipping */
	if (nx< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-nx;
		nx+=diff;
		x +=diff;
		w -=diff;
	}
	if (nx+w>=(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-nx;
	}
	if (ny< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-ny;
		ny+=diff;
		y +=diff;
		h -=diff;
	}
	if (ny+h>(LIBGGI_GC(vis)->clipbr.y)) {
		h=(LIBGGI_GC(vis)->clipbr.y)-ny;
	}

	/* If nothing to copy or the source leaves the virtual screen, bail out. */
	if (w<=0||h<=0||x<0||y<0||x+w>LIBGGI_VIRTX(vis)||y+h>LIBGGI_VIRTY(vis)) return 0;

	if (ny < y) {
		obox=(uint16 *)(LIBGGI_CURWRITE(vis))+y*linew+x;
		nbox=(uint16 *)(LIBGGI_CURWRITE(vis))+ny*linew+nx;
		for (line=0;line<h;line++,obox+=linew,nbox+=linew)
			memmove(nbox,obox,w*2);
	} else {
		obox=(uint16 *)(LIBGGI_CURWRITE(vis))+(y+h-1)*linew+x;
		nbox=(uint16 *)(LIBGGI_CURWRITE(vis))+(ny+h-1)*linew+nx;
		for (line=0;line<h;line++,obox-=linew,nbox-=linew)
			memmove(nbox,obox,w*2);
	}
	return 0;
}
