/* 
   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck - becka@ggi-project.org
   Copyright (C) 1997 Jason McMullan - jmcc@ggi-project.org

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>

/*************************************/
/* fill (erase) the (virtual) screen */
/*************************************/

int GGIfillscreen(ggi_visual *vis)
{
	if (LIBGGI_GC(vis)->cliptl.x==0 &&
	    LIBGGI_GC(vis)->cliptl.y==0 &&
	    LIBGGI_GC(vis)->clipbr.x==LIBGGI_VIRTX(vis) &&
	    LIBGGI_GC(vis)->clipbr.y==LIBGGI_VIRTY(vis))
		memset((uint8 *)(LIBGGI_CURWRITE(vis)),
		       -(LIBGGI_GC_FGCOLOR(vis)&1)+0x100,
		       LIBGGI_FB_W_STRIDE(vis)*LIBGGI_VIRTY(vis));
 	else
		ggiDrawBox(vis, LIBGGI_GC(vis)->cliptl.x,LIBGGI_GC(vis)->cliptl.y,
				LIBGGI_GC(vis)->clipbr.x,LIBGGI_GC(vis)->clipbr.y);
	return 0;
}
