/* 
   Linear 1 pixel handling

   Copyright (C) 1997 Jason McMullan  [jmcc@ggi-project.org]
   Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ggi/internal/ggi-dl.h>


/* Pack the colors into an array
 */
int GGIpackcolors(ggi_visual *vis,void *outbuf,ggi_color *cols,int len)
{
	uint8 tmp=0,*obuf=(uint8 *)outbuf;
	int mask,i;

	mask=7;
	for (i=0;i<len;i++) {
		tmp |= ggiMapColor(vis,(cols++)) << mask--;
		if (mask<0) {
			*(obuf++)=tmp;
			tmp=0;
			mask=7;
		}
	}

	return 0;
}	
	
/* Unpack into the ggi_color array the values of the pixels
 */
int GGIunpackpixels(ggi_visual *vis,void *inbuf,ggi_color *cols,int len)
{
	uint8 *ibuf=(uint8 *)inbuf;
	int i,mask;
	ggi_pixel tmp;

	mask=7;
	for (i=0;i<len;i++) {
		tmp=((*ibuf) >> mask--)&1;
		ggiUnmapPixel(vis,tmp,(cols++));
		if (mask<0) {
			ibuf++;
			mask=7;
		}
	}
	return 0;
}	
