/* $Id: visual.c,v 1.8 1998/10/18 15:52:20 becka Exp $
***************************************************************************

  Graphics library for GGI.

  Copyright (C) 1995 Andreas Beck   [becka@ggi-project.org]
  Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/mman.h>

#include <ggi/internal/ggi-dl.h>
#include <kgi/ioctl.h>

int GGIdlinit(ggi_visual *visual,const char *version,void *argptr)
{
	ggi_gc *mygc;
	
	/* map the HW GC ! */
	mygc=(ggi_gc *)mmap(NULL,/*PAGE_SIZE*/4096,PROT_READ|PROT_WRITE,
			MAP_SHARED,LIBGGI_FD(visual),MMAP_TYPE_GC);

	if (mygc==(void *)-1) mygc=NULL;
	else LIBGGI_GC(visual)=mygc;
	DPRINT("Signature: %x\n",*(int *)LIBGGI_GC(visual));

	/* This is only an "override library". It will try to override
	 * functions which it thinks the Accelerator can do better.
	 */

	/* Color mapping 
	 */

	/**** 2D ops ****/

	/* Save away the old operations. We might need to use them. */
	fallback_opdraw=*visual->opdraw;

	/* Positioning is not supported...
	 */

	/* Sprites aren't supported...
	 */

	/* Generic drawing
	 */

	if (mygc) /* These functions need the Gc and thus only work,
		     when mapping it worked. */
	{
		visual->opdraw->drawline=GGIdrawline;
		visual->opdraw->drawbox=GGIdrawbox;
		visual->opdraw->fillscreen=GGIfillscreen;
	}
	
	visual->opdraw->copybox=GGIcopybox;

	return GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *visual)
{
	/* FIXME unmap GC. */
	munmap((void*)LIBGGI_GC(visual), 4096);
	LIBGGI_GC(visual) = NULL;
                
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
