/* 
   Generic color library defines

   Copyright (C) 1998 Andrew Apted  <andrew@ggi-project.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _LIBGGI_DEFAULT_COLOR_H
#define _LIBGGI_DEFAULT_COLOR_H

#include <ggi/internal/ggi-dl.h>

ggifunc_mapcolor	GGI_color_PAL_mapcolor;
ggifunc_mapcolor	GGI_color_TRUE_mapcolor;
ggifunc_mapcolor	GGI_color_GREY_mapcolor;

ggifunc_unmappixel	GGI_color_PAL_unmappixel;
ggifunc_unmappixel	GGI_color_TRUE_unmappixel;
ggifunc_unmappixel	GGI_color_GREY_unmappixel;

ggifunc_packcolors	GGI_color_L1_packcolors;
ggifunc_packcolors	GGI_color_L2_packcolors;
ggifunc_packcolors	GGI_color_L3_packcolors;
ggifunc_packcolors	GGI_color_L4_packcolors;

ggifunc_unpackpixels	GGI_color_L1_unpackpixels;
ggifunc_unpackpixels	GGI_color_L2_unpackpixels;
ggifunc_unpackpixels	GGI_color_L3_unpackpixels;
ggifunc_unpackpixels	GGI_color_L4_unpackpixels;

ggifunc_getpalvec	GGI_color_getpalvec;
ggifunc_getgamma	GGI_color_getgamma;	
ggifunc_setgamma	GGI_color_setgamma;	

typedef struct color_hook
{
	/* total = length(mask) + shift(mask)
	 */
	
	int red_total;
	int green_total;
	int blue_total;

} color_hook;


#endif /* _LIBGGI_DEFAULT_COLOR_H */
