// fl_set_font.C

// Add a font to the internal table.
// Also see fl_set_fonts.C which adds all possible fonts.

#include <config.h>
#include <FL/Fl.H>
#include <FL/x.H>
#include "Fl_Font.H"
#include <stdlib.h>
#include <string.h>

static int table_size;

int Fl::set_font(int fnum, const char *name) {
  if (fnum >= table_size) {
    int i = table_size;
    if (!i) {	// don't realloc the built-in table
      table_size = 2*FL_FREE_FONT;
      i = FL_FREE_FONT;
      Fl_Font *t = (Fl_Font*)malloc(table_size*sizeof(Fl_Font));
      memcpy(t, fl_fonts, FL_FREE_FONT*sizeof(Fl_Font));
      fl_fonts = t;
    } else {
      table_size = 2*table_size;
      fl_fonts = (Fl_Font*)realloc(fl_fonts, table_size*sizeof(Fl_Font));
    }
    for (; i < table_size; i++) fl_fonts[i].name = 0;
  }
  Fl_Font *s = fl_fonts+fnum;
  if (s->name) {
    if (!strcmp(s->name, name)) {s->name = name; return fnum;}
#ifndef WIN32
    if (s->xlist && s->n >= 0) XFreeFontNames(s->xlist);
#endif
    for (Fl_XFont *f = s->first; f;) {
#ifndef WIN32
      if (f == fl_fixed_xfont) break;
#endif
      Fl_XFont *n = f->next; delete f; f = n;
    }
    s->first = 0;
  }
  s->name = name;
#ifndef WIN32
  s->xlist = 0;
#endif
  s->first = 0;
  return fnum;
}

const char *Fl::get_font(int fnum) {return fl_fonts[fnum].name;}
