// x.H

// These are internal fltk symbols that are necessary or useful for
// calling Xlib.  You should include this file if (and ONLY if) you
// need to call Xlib directly.  These symbols may not exist on non-X
// systems.

#ifdef WIN32

#include "win32.H"

#else

#ifndef Fl_X_H
#define Fl_X_H

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "Fl_Window.H"

void fl_open_display();
void fl_close_display();

extern Display *fl_display;
extern int fl_screen;
extern XVisualInfo *fl_visual;
extern Colormap fl_colormap;
extern GC fl_gc;
extern Window fl_window;
extern XEvent fl_xevent;
extern ulong fl_event_time;

unsigned long fl_xpixel(unsigned char i);
unsigned long fl_xpixel(unsigned char r, unsigned char g, unsigned char b);

// off-screen pixmaps: create, destroy, draw into, copy to window:
#define Fl_Offscreen ulong
#define fl_create_offscreen(w,h) \
XCreatePixmap(fl_display, fl_window, w, h, fl_visual->depth)
#define fl_begin_offscreen(pixmap) Window _sw=fl_window; fl_window=pixmap
#define fl_switch_offscreen(pixmap) fl_window=pixmap
#define fl_end_offscreen() fl_window = _sw
#define fl_copy_offscreen(x,y,w,h,pixmap,srcx,srcy) \
  XCopyArea(fl_display, pixmap, fl_window, fl_gc, srcx, srcy, w, h, x, y)
#define fl_delete_offscreen(pixmap) XFreePixmap(fl_display, pixmap)

// this object contains all X-specific stuff about a window:
// Warning: this object is highly subject to change!
class Fl_X {
public:
  ulong xid;
  ulong other_xid;
  Fl_Window *w;
  Colormap colormap;
  Region region;
  Fl_X *next;
  static Fl_X* first;
  static Fl_X* i(const Fl_Window* w) {return w->i;}
  void setwindow(Fl_Window* wi) {w=wi; wi->i=this;}
  void sendxjunk();
  void flush() {w->flush();}
  static void make_xid(Fl_Window*,XVisualInfo* =fl_visual, Colormap=fl_colormap);
  static Fl_X* set_xid(Fl_Window*, ulong, Colormap=fl_colormap);
};
inline ulong fl_xid(const Fl_Window*w) {return Fl_X::i(w)->xid;}
Fl_Window* fl_find(ulong xid);
void fl_clip_region(Region);

// mapping from fltk colormap to x pixel numbers:
struct Fl_XMap {
  char mapped;	// true when XAllocColor done
  unsigned char r,g,b;	// actual color used by X
  unsigned long pixel;	// the X pixel to use
};
extern Fl_XMap fl_xmap[256];

// mask & shifts to produce xcolor for truecolor visuals:
extern unsigned char fl_redmask, fl_greenmask, fl_bluemask;
extern int fl_redshift, fl_greenshift, fl_blueshift, fl_extrashift;

unsigned long fl_alloc_color(Colormap, unsigned char); // XAlloc an fl_color

// atoms created when display opened:
extern Atom fl_wm_delete_window;
extern Atom fl__wm_quit_app;
extern Atom fl_wm_protocols;
extern Atom fl__motif_wm_hints;

extern char fl_override_redirect; // hack into Fl_Window::make_xid()
extern int fl_background_pixel;  // hack into Fl_Window::make_xid()

#endif
#endif
