// Fl_Menu_.H

// This is a base class for all items that have a menu:
// Fl_Menu_Bar, Fl_Menu_Button, Fl_Choice
// This provides storage for a menu item, functions to add/modify/delete
// items, and a call for when the user picks a menu item.

#ifndef Fl_Menu__H
#define Fl_Menu__H

#ifndef Fl_Widget_H
#include "Fl_Widget.H"
#endif
#include "Fl_Menu.H"

class Fl_Menu_ : public Fl_Widget {

  Fl_Menu *menu_;
  const Fl_Menu *value_;

protected:

  uchar textfont_;
  uchar textsize_;
  uchar textcolor_;
  char alloc;
  void picked(const Fl_Menu *);

public:

  Fl_Menu_(int,int,int,int,const char * =0);
  ~Fl_Menu_();

  const Fl_Menu* popup(int X, int Y, int W=0, int H=0);

  const Fl_Menu *menu() const {return menu_;}
  void menu(const Fl_Menu *m);
  int add(const char*, int shortcut, Fl_Callback*, void* = 0, int = 0);
  int add(const char* a, const char* b, Fl_Callback* c,
	  void* d = 0, int e = 0) {
    return add(a,fl_old_shortcut(b),c,d,e);}
  int size() const ;
  void clear();
  int add(const char *);
  void replace(int,const char *);
  void remove(int);
  void shortcut(int i, int s) {menu_[i].shortcut(s);}
  void mode(int i,int x) {menu_[i].flags = x;}
  int mode(int i) const {return menu_[i].flags;}

  const Fl_Menu *mvalue() const {return value_;}
  int value() const {return value_-menu_;}
  int value(const Fl_Menu *);
  int value(int i) {return value(menu_+i);}
  const char *text() const {return value_ ? value_->text : 0;}
  const char *text(int i) const {return menu_[i].text;}

  uchar textfont() const {return textfont_;}
  void textfont(uchar c) {textfont_=c;}
  uchar textsize() const {return textsize_;}
  void textsize(uchar c) {textsize_=c;}
  uchar textcolor() const {return textcolor_;}
  void textcolor(uchar c) {textcolor_=c;}
};

#endif
