#ifndef Fl_Enumerations_H
#define Fl_Enumerations_H

const double FL_VERSION = 0.99;

typedef unsigned char uchar;
typedef unsigned long ulong;
typedef unsigned int u32; // you must fix if not 32 bits on your machine!

enum {	// events
  FL_PUSH		= 1,
  FL_RELEASE		= 2,
  FL_ENTER		= 3,
  FL_LEAVE		= 4,
  FL_DRAG		= 5,
  FL_FOCUS		= 6,
  FL_UNFOCUS		= 7,
  FL_KEYBOARD		= 8,
  FL_MOVE		= 10,
  FL_SHORTCUT		= 11,
  FL_DEACTIVATE		= 13,
  FL_ACTIVATE		= 14,
  FL_HIDE		= 15,
  FL_SHOW		= 16,
  FL_PASTE		= 17,
  FL_SELECTIONCLEAR	= 18
};

enum { // Fl_Widget::when():
  FL_WHEN_CHANGED	= 1,
  FL_WHEN_RELEASE	= 4,
  FL_WHEN_ENTER_KEY	= 8,
  FL_WHEN_NOT_CHANGED	= 2 // modifier bit to disable changed() test
};

// Fl::event_key() and Fl::get_key(n) (use ascii letters for all other keys):
#define FL_Button	0xfee8 // use Fl_Button+n for mouse button n
#define FL_BackSpace	0xff08
#define FL_Tab		0xff09
#define FL_Enter	0xff0d
#define FL_Pause	0xff13
#define FL_Scroll_Lock	0xff14
#define FL_Escape	0xff1b
#define FL_Home		0xff50
#define FL_Left		0xff51
#define FL_Up		0xff52
#define FL_Right	0xff53
#define FL_Down		0xff54
#define FL_Page_Up	0xff55
#define FL_Page_Down	0xff56
#define FL_End		0xff57
#define FL_Print	0xff61
#define FL_Insert	0xff63
#define FL_Menu		0xff67 // the "menu/apps" key on XFree86
#define FL_Num_Lock	0xff7f
#define FL_KP		0xff80 // use FL_KP+'x' for 'x' on numeric keypad
#define FL_KP_Enter	0xff8d // same as Fl_KP+'\r'
#define FL_KP_Last	0xffbd // use to range-check keypad
#define FL_F		0xffbd // use FL_F+n for function key n
#define FL_F_Last	0xffe0 // use to range-check function keys
#define FL_Shift_L	0xffe1
#define FL_Shift_R	0xffe2
#define FL_Control_L	0xffe3
#define FL_Control_R	0xffe4
#define FL_Caps_Lock	0xffe5
#define FL_Meta_L	0xffe7 // the left windoze key on XFree86
#define FL_Meta_R	0xffe8 // the right windoze key on XFree86
#define FL_Alt_L	0xffe9
#define FL_Alt_R	0xffea
#define FL_Delete	0xffff

// Fl::event_state():
#define FL_SHIFT	0x00010000
#define FL_CAPS_LOCK	0x00020000
#define FL_CTRL		0x00040000
#define FL_ALT		0x00080000
#define FL_NUM_LOCK	0x00100000 // most X servers do this?
#define FL_META		0x00400000 // correct for XFree86
#define FL_SCROLL_LOCK	0x00800000 // correct for XFree86
#define FL_BUTTON1	0x01000000
#define FL_BUTTON2	0x02000000
#define FL_BUTTON3	0x04000000

enum {	// boxtypes (if you change these you must fix fl_boxtype.C):
  FL_NO_BOX = 0,	FL_FLAT_BOX,

  FL_UP_BOX,		FL_DOWN_BOX,
  FL_UP_FRAME,		FL_DOWN_FRAME,
  FL_THIN_UP_BOX,	FL_THIN_DOWN_BOX,
  FL_THIN_UP_FRAME,	FL_THIN_DOWN_FRAME,
  FL_ENGRAVED_BOX,	FL_EMBOSSED_BOX,
  FL_ENGRAVED_FRAME,	FL_EMBOSSED_FRAME,
  FL_BORDER_BOX,	_FL_SHADOW_BOX,
  FL_BORDER_FRAME,	_FL_SHADOW_FRAME,
  _FL_ROUNDED_BOX,	_FL_RSHADOW_BOX,
  _FL_ROUNDED_FRAME,	_FL_RFLAT_BOX,
  _FL_ROUND_UP_BOX,	_FL_ROUND_DOWN_BOX,
  _FL_DIAMOND_UP_BOX,	_FL_DIAMOND_DOWN_BOX,
  _FL_OVAL_BOX,		_FL_OSHADOW_BOX,
  _FL_OVAL_FRAME,	_FL_OFLAT_BOX,

  FL_FREE_BOXTYPE
};
extern uchar define_FL_ROUND_UP_BOX();
#define FL_ROUND_UP_BOX define_FL_ROUND_UP_BOX()
#define FL_ROUND_DOWN_BOX (define_FL_ROUND_UP_BOX()+1)
extern uchar define_FL_SHADOW_BOX();
#define FL_SHADOW_BOX define_FL_SHADOW_BOX()
#define FL_SHADOW_FRAME (define_FL_SHADOW_BOX()+2)
extern uchar define_FL_ROUNDED_BOX();
#define FL_ROUNDED_BOX define_FL_ROUNDED_BOX()
#define FL_ROUNDED_FRAME (define_FL_ROUNDED_BOX()+2)
extern uchar define_FL_RFLAT_BOX();
#define FL_RFLAT_BOX define_FL_RFLAT_BOX()
extern uchar define_FL_RSHADOW_BOX();
#define FL_RSHADOW_BOX define_FL_RSHADOW_BOX()
extern uchar define_FL_DIAMOND_BOX();
#define FL_DIAMOND_UP_BOX define_FL_DIAMOND_BOX()
#define FL_DIAMOND_DOWN_BOX (define_FL_DIAMOND_BOX()+1)
extern uchar define_FL_OVAL_BOX();
#define FL_OVAL_BOX define_FL_OVAL_BOX()
#define FL_OSHADOW_BOX (define_FL_OVAL_BOX()+1)
#define FL_OVAL_FRAME (define_FL_OVAL_BOX()+2)
#define FL_OFLAT_BOX (define_FL_OVAL_BOX()+3)

// back-compatability box types:
#define FL_FRAME FL_ENGRAVED_FRAME
#define FL_FRAME_BOX FL_ENGRAVED_BOX
#define FL_CIRCLE_BOX FL_ROUND_DOWN_BOX
#define FL_DIAMOND_BOX FL_DIAMOND_DOWN_BOX

enum {	// labeltypes:
  FL_NORMAL_LABEL	= 0,
  FL_NO_LABEL,
  _FL_SYMBOL_LABEL,
  _FL_SHADOW_LABEL,
  _FL_ENGRAVED_LABEL,
  _FL_EMBOSSED_LABEL,
  _FL_BITMAP_LABEL,
  _FL_PIXMAP_LABEL,
  _FL_IMAGE_LABEL,
  FL_FREE_LABELTYPE
};
extern uchar define_FL_SYMBOL_LABEL();
#define FL_SYMBOL_LABEL define_FL_SYMBOL_LABEL()
extern uchar define_FL_SHADOW_LABEL();
#define FL_SHADOW_LABEL define_FL_SHADOW_LABEL()
extern uchar define_FL_ENGRAVED_LABEL();
#define FL_ENGRAVED_LABEL define_FL_ENGRAVED_LABEL()
extern uchar define_FL_EMBOSSED_LABEL();
#define FL_EMBOSSED_LABEL define_FL_EMBOSSED_LABEL()

enum {	// align() values
  FL_ALIGN_CENTER	= 0,
  FL_ALIGN_TOP		= 1,
  FL_ALIGN_BOTTOM	= 2,
  FL_ALIGN_LEFT		= 4,
  FL_ALIGN_RIGHT	= 8,
  FL_ALIGN_INSIDE	= 16,
  FL_ALIGN_CLIP		= 64,
  FL_ALIGN_NOWRAP	= 128
};

enum {	// standard fonts
  FL_HELVETICA		= 0,
  FL_BOLD		= 1,	// add this to helvetica, courier, or times
  FL_ITALIC		= 2,	// add this to helvetica, courier, or times
  FL_COURIER		= 4,
  FL_TIMES		= 8,
  FL_SYMBOL		= 12,
  FL_SCREEN		= 13,
  FL_ZAPF_DINGBATS	= 15,
  FL_FREE_FONT		= 16
};

#define FL_NORMAL_SIZE	14	// default size of all labels & text

enum {	// standard colors
  FL_BLACK		= 0,
  FL_RED		= 1,
  FL_GREEN		= 2,
  FL_YELLOW		= 3,
  FL_BLUE		= 4,
  FL_MAGENTA		= 5,
  FL_CYAN		= 6,
  FL_WHITE		= 7,
  FL_INACTIVE_COLOR	= 8,
  FL_SELECTION_COLOR	= 15,

  FL_FREE_COLOR		= 16,
  FL_NUM_FREE_COLOR	= 16,

  FL_GRAY_RAMP		= 32,
  FL_NUM_GRAY		= 24,

  // boxtypes limit themselves to these colors so whole ramp is not allocated:
  FL_GRAY0		= 32,	// "black" lines
  FL_DARK3		= 40,	// dark edges
  FL_DARK2		= 42,
  FL_DARK1		= 45,
  FL_GRAY		= 47,	// default color
  FL_LIGHT1		= 49,
  FL_LIGHT2		= 51,
  FL_LIGHT3		= 54,	// light edges

  FL_COLOR_CUBE		= 56,
  FL_NUM_RED		= 5,
  FL_NUM_GREEN		= 8,
  FL_NUM_BLUE		= 5,
  // multiply indexes by these & add FL_COLOR_CUBE to get color index:
  FL_GREEN_MULTIPLY	= 1,
  FL_RED_MULTIPLY	= FL_NUM_GREEN,
  FL_BLUE_MULTIPLY	= FL_NUM_GREEN*FL_NUM_RED

};

enum {	// standard cursors
  FL_CURSOR_DEFAULT	= 0,
  FL_CURSOR_ARROW	= 35,
  FL_CURSOR_CROSS	= 66,
  FL_CURSOR_WAIT	= 76,
  FL_CURSOR_INSERT	= 77,
  FL_CURSOR_HAND	= 31,
  FL_CURSOR_HELP	= 47,
  FL_CURSOR_MOVE	= 27,
  FL_CURSOR_N		= 70,
  FL_CURSOR_NE		= 69,
  FL_CURSOR_E		= 49,
  FL_CURSOR_SE		= 8,
  FL_CURSOR_S		= 9,
  FL_CURSOR_SW		= 7,
  FL_CURSOR_W		= 36,
  FL_CURSOR_NW		= 68,
  FL_CURSOR_NS		= 22,
  FL_CURSOR_WE		= 55,
  FL_CURSOR_NONE	= 255
};

enum { // values for "when" passed to Fl::add_fd()
  // these must match values used by Fl_Poll in <poll.h>!!
  FL_READ = 1,
  FL_WRITE = 4,
  FL_EXCEPT = 8
};

enum { // visual types and Fl_Gl_Window::mode() (values match Glut)
  FL_RGB	= 0,
  FL_RGB_NOT_NECESSARY = 1,
  FL_INDEX	= 1, // back-compatability
  FL_SINGLE	= 0,
  FL_DOUBLE	= 2,
  FL_ACCUM	= 4,
  FL_ALPHA	= 8,
  FL_DEPTH	= 16,
  FL_STENCIL	= 32,
  FL_RGB8	= 64,
  FL_MULTISAMPLE= 128
};

#endif
