# Based on iwidgets2.2.0/tests/dialog.test code.   

import Tkinter
import Test
import Pmw

Test.initialise()

c = Pmw.Dialog

def _addListbox():
    global _lb
    w = Test.currentWidget()
    _lb = Tkinter.Listbox(w.interior(), relief = 'sunken')
    _lb.pack(fill = 'both', expand = 'yes')

def _addListEntry(text):
    _lb.insert('end', text)

def _test_deactivate(result):
    w = Test.currentWidget()
    w.after(Test.delay() + 4000,
        lambda widget=w, r=result: widget.deactivate(r))

def _createOtherToplevel():
    global tempToplevel
    tempToplevel = Tkinter.Toplevel()
    tempToplevel.geometry('+0+0')
    label = Tkinter.Label(tempToplevel, text =
        'The cursor should turn to a\n' +
        'clock over this window if the\n' +
	'blt busy command is available.\n' +
	'In any case, the button will be inactive\n' +
	'while the modal dialog is active.')
    label.pack(padx=100, pady=100)
    button = Tkinter.Button(tempToplevel, text = 'Try to press me')
    button.pack(pady=100, expand=1)

def _hideOtherToplevel():
    global tempToplevel
    tempToplevel.withdraw()

def _bogus():
    w = Test.currentWidget()
    w.bogus()

kw_1 = {
  'buttons' : (),
  'buttonbox_padx': 30,
}
tests_1 = (
  ('buttons', ('OK',)),
  ('buttons', ('OK', 'Cancel',)),
  ('defaultbutton', 'OK'),
  (_addListbox, ()),
  (Test.num_options, (), 8),
  ('hull_background', '#d9d9d9'),
  ('buttons', ('A', 'B', 'C', 'D')),
  ('hull_cursor', 'gumby'),
  (c.title, 'Dialog Shell', ''),
  (c.interior, (), Tkinter.Frame),
  ('buttons', ()),
  ('buttons', ('OK',)),
  ('buttons', ('OK', 'Cancel')),
  ('buttons', ('OK', 'Cancel', 'Help')),
  ('defaultbutton', 'OK'),
  ('buttons', ('Apply', 'OK', 'Cancel', 'Help')),
  ('buttons', ('Apply', 'OK', 'Cancel')),
  ('defaultbutton', 'Cancel'),
  (c.invoke, 'OK', 'None'),
  ('buttonbox_OK_text', 'OK'),
  (c.withdraw, (), ''),
  ('buttons', ('Apply', 'OK', 'Cancel', 'Foo')),
  ('buttons', ('Apply', 'OK', 'Cancel')),
  (c.show, ()),
  (c.withdraw, (), ''),
  (_createOtherToplevel, ()),
  (_addListEntry, 'Testing application activate/deactivate'),
  (_addListEntry, 'Please wait'),
  (_test_deactivate, 'Hello World'),
  (c.activate, (), 'Hello World'),
  ('defaultbutton', ''),
  (_addListEntry, 'Now testing global activate/deactivate'),
  (_addListEntry, 'Please wait a bit more'),
  (_test_deactivate, 'Hello World'),
  (c.activate, (1), 'Hello World'),
  (_hideOtherToplevel, ()),
  ('buttons', ('Apply', 'OK', 'Cancel', 'Foo', '1')),
  (c.show, (), {}),
  (_bogus, (), 'AttributeError: bogus'),
)

kw_2 = {'buttonboxpos' : 'e', 'separatorwidth' : 5}
tests_2 = (
  ('buttons', ('OK',)),
  ('buttons', ('OK', 'Cancel',)),
  ('defaultbutton', 'OK'),
)

alltests = (
  (tests_1, kw_1),
  (tests_2, kw_2),
)

testData = ((c, alltests),)

if __name__ == '__main__':
    Test.runTests(testData)
