.TH PSTOEDIT 1 971204 "Revision 2.6.0"
.SH NAME 
pstoedit \- a converter from PostScript and PDF to editable objects \
or vector graphic formats
.\" DO NOT INSERT COMMENTS ABOVE THIS LINE:
.\" Some mkwhatis and ptx utilities fail if you insert real comments before
.\" the contents of the .SH NAME field.  A comment of the form ,\" in the
.\" FIRST line tells (g)troff to preprocess according to the instruction...
.\" Set the third field of the .TH macro to the release date of the 
.\" software revision level documented in this manpage, and set the
.\" fourth field to the revision level.  NOTE: Not all man macro 
.\" packages recognize a third or fourth field to the .TH macro.
.SH SYNOPSIS
.PP
.\" Turn off right margin justification.  ".na" = no adjustment
.na
.\" Turn off hyphenation.  ".nh" = no hyphenation
.nh
.B pstoedit
.RB [ \-help ]
.PP
.B pstoedit
.RB [ \-dt ] 
.RB [ \-dis ]
.RB [ \-merge ] 
.RB [ \-df 
.IR fontname ]
.RB [ \-flat 
.IR number ]
.RB [ \-nomaptoisolatin1 ]
.RB [ \-nq ]
.RB [ \-s 
.IR factor ]
.RB [ \-psargs 
.IR string]
.RB [ \-include 
.IR includefile ]
\fB\-f\ \fIformat\fR[:\fIoptions\fR]
.RI [ inputfile
.RI [ outputfile ]]
.\" Turn on hyphenation.  ".hy" = hyphenate, restores default hyphenation.
.hy
.\" Turn on right margin justification.  ".ad" = adjust
.ad
.PP
.na
.nh
.B pstoedit
[\fB\-s\fR \fIfactor\fR]
\fB\-f \fIformat\fR[:\fIoptions\fR]
.BI "\-bo\ " inputfile
.RI [ outputfile ]
.hy
.ad
.PP
.SH DESCRIPTION
.SS "RELEASE LEVEL"
This manpage documents release 2.5.1 of 
.BR pstoedit .
.SS USE
.PP
.nh
.\" Turned off hyphenation; in default nroff manpage display,
.\" first paragraph looked really awful. -lar
.B pstoedit 
converts PostScript\*t and PDF files to a simple vector graphic
format that can be edited or imported into various drawing packages. 
Type
.hy
.RS
.BR pstoedit\ -help
.RE
to get a list of supported output formats.
.PP
.B pstoedit 
works by redefining the two basic painting operators of
PostScript,\*t 
.B stroke 
and 
.BR show .
Other drawing operators
.RI ( e.g.
.BR image )
are not supported.
After redefining these operators, the PostScript or PDF file that needs to
be converted is processed by a PostScript interpreter, 
.IR e.g. ,
Ghostscript 
.RB ( gs ). 
You normally need to have a PostScript interpreter installed in order to use 
this program.  However, you can perform some "back end" processing of prepared 
files by specifying the 
.B \-bo
option for debugging or limited filtering.  See "BACK END-SPECIFIC OPTIONS" 
below.
.PP
The output that is written by the interpreter due to the redefinition of
the drawing operators is a sort of 'flat' PostScript file that contains only
simple operations like 
.BR moveto , 
.BR lineto , 
.BR show ,
.I etc.
You can look at this file using the 
.B \-f\ debug
option.
.PP
This output is read by end-processing functions of 
.B pstoedit 
and triggers the drawing functions in the selected back end driver, or 
.IR backend .
.PP
.SS NOTES
.PP
If you want to process PDF files directly, your PostScript interpreter
must provide this feature, as does Ghostscript. Aladdin Ghostscript 4.03
or later is recommended for processing PDF (and PostScript Level 2) files.
.PP
.SH OPTIONS
.TP 0.6i
\fB\-dt\fR
Text is drawn as polygons. This might produce a large output file.
You might want to use this options for example if the PostScript file 
contains text and the backend does not support this, 
.I e.g.
.BR gnuplot .
.TP 0.6i
.B \-dis
Open a display during processing by Ghostscript. Some files only work 
correctly this way.
.TP 0.6i
\fB\-psargs\fR \fIstring\fR
The string given with this option is passed directly to Ghostscript
when Ghostscript is called to process the PostScript file for 
.B pstoedit.
For example:
.in +0.5i 
.\" .RS
\fB\-psargs "\-r72x72"\fR
.\" .RE
.in -0.5i
This causes 
the resolution to be changed to 72x72 dpi.
(Changing the resolution this way has an effect only if 
.BR \-dis play 
is set.
Otherwise the default resolution of 1 point (72 dots per inch) is used.)
.PP
You can switch Ghostscript into PostScript Level 1 only mode by
.in +0.5i 
\fB\-psargs "level1.ps".\fR
.in -0.5i 
This can be useful for example if the PostScript file to be
converted uses some Level 2 specific custom color models that are not 
supported by pstoedit. 
However, this requires that the PostScript program checks for the 
PostScript level supported by the interpreter and "acts" accordingly.
.PP
If you want to pass multiple options to Ghostscript you
must enclose all options with quotes, e.g.
.in +0.5i
\fB\-psargs "opt1 opt2 opt2".\fR
.in -0.5i
See the
.BR gs (1)
manpage for other possible options.
.TP 0.6i
\fB\-merge\fR
Some output formats permit the representation of filled polygons with edges 
that are in a different color than the fill color. Since PostScript does not
support this, drawing programs typically generate two objects (the outline and
the filled polygon) into the PostScript output. 
.B pstoedit 
is able to recombine these,
if they follow each other directly and you specify
.BR \-merge .
.TP 0.6i
\fB\-df\fR \fIfontname\fR
Sometimes fonts embedded in a PostScript programs do not have a fontname. This 
for example happens in PostScript files generated by 
.BR dvips . 
In such a case 
.B pstoedit
uses a replacement font. The default for this is Courier. Another font can
be specified using the
.BR \-df 
option.
.in +0.5i 
.\" .RS
\fB\-df Helvetica\fR
.\" .RE
.in -0.5i
.\" bug in SunOS tmac.an macros--didn't hold relative indent when .RE hit.
causes all unnamed fonts to be replaced by Helvetica.
.TP 0.6i
\fB\-include\fR \fIname of a PostScript file to be included\fR
This options allows to specify an additional PostScript file that will
be executed just before the normal input is read. This is helpful for
including specific page settings or for disabling potentially unsafe 
PostScript operators, e.g., file, renamefile, or deletefile.
.TP 0.6i
\fB\-f\fR \fIformat\fR
target output format recognized by 
.BR pstoedit . 
Currently 
.I format 
may be one of:
.BR debug , 
.B fig
(Xfig), 
.BR cgm ,
.BR pdf , 
.BR gnuplot , 
.BR dxf, 
.BR lwo , 
.B mif 
(Framemaker MIF, not MapInfo MIF),
.BR rib ,
.BR rpl , 
.BR java , 
.BR ps ,
.B met 
(OS/2 only), 
.B wmf 
(Windows and Borland C++ only), 
.BR tgif , 
.BR idraw , 
and
.BR dump .
See "BACK END-SPECIFIC OPTIONS" below for an explanation of the
.RI [: options ]
to 
\fB\-f\ \fIformat\fR.
.TP 0.6i
\fB\-s\fR \fIfactor\fR
scale by the 
specified bitmap display
.IR factor . 
(Use with \fB\-f\ tgif\fR option only.)
.TP 0.6i
\fB\-bo\fR
You can run backend processing only (without the PostScript 
interpreter frontend) by first running
.\" .RS
.in +0.5i
\fBpstoedit \-f dump\fR \fIinfile dumpfile\fR
.in -0.5i
.\" .RE
and then running
.\" .RS
.in +0.5i
.BI "pstoedit \-f\ " "format\ " "\-bo\ " "dumpfile outfile".
.in -0.5i
.\" .RE
.TP 0.6i
\fB\-flat\fR \fInumber\fR
If the backend does not support curves in the way PostScript does, all
curves are approximated by lines. Using the
.B \-flat 
option one can
control this approximation. This parameter is directly converted to a
PostScript 
.B setflat 
command.
.TP 0.6i
\fB\-nq\fR
No exit from the PostScript interpreter.
Normally Ghostscript exits after processing the 
.B pstoedit 
.IR inputfile . 
For debugging
it can be useful to avoid this. If you do, you will have to type 
.BR quit 
at the 
.BR GS> 
prompt to exit from Ghostscript.
.TP 0.6i
\fB\-nomaptoisolatin1\fR
Normally 
.B pstoedit 
maps all character codes to the ones defined by the ISO-Latin1 encoding. 
If you specify 
.B \-nomaptoisolatin1 
then the encoding from the input PostScript is passed unchanged to the output. 
.TP 0.6i
.I inputfile
input file. 
.TP 0.6i
.I outputfile
output file. If no output file is given as argument, 
.B pstoedit 
writes the result to standard output.
.PP
If neither an input nor an output file is given as argument, 
.B pstoedit 
works as filter reading from standard input and writing to standard output.
.PP
.SS "BACK END-SPECIFIC OPTIONS"
.B pstoedit 
allows you to pass individual options to a backend. This is 
done by appending all options to the 
.I format 
specified after the 
.B \-f 
option. The format specifier and its options must be separated by a 
colon 
.RB ( : ). 
If more than
one option needs to be passed to the backend, the whole argument to 
.B \-f
must be enclosed within double-quote characters, thus:
.RS
\fB\-f\ "\fIformat\fB:\fIoption option ..."\fR
.RE
.PP
Currently
.B met
,
.B java 
,
.B dxf 
, and
.B wmf 
are the only drivers accepting specific options.  Other options may be 
asserted through environment variables.  See "ENVIRONMENT
VARIABLES" below.
.PP
The wmf driver supports two backend specific options, 'v' and 'e'.
.RS
\fB\-f wmf:v\fR
.RE
turns on a verbose mode; 
.RS
\fB-f wmf:e\fR
.RE
tells \fBpstoedit\fR to generate an enhanced metafile instead of a 
normal metafile.
.RS
\fB\-f "wmf:ve"\fR
.RE
specifies both verbose mode and enhanced metafile output.
.PP
The java backend allows to specify the class name of the class that is
generated by pstoedit. The default is PSJava. You can change this using
.RS
\fB\-f java:\fIanothername\fR
.RE
.PP 
The dxf backend accepts the option -lines which forces all polygons
and lines to be represented as LINEs in the generated DXF file. The
default is to use POLYLINEs. Example:
.RS
\fB\-f "dxf:-lines"\fR
.RE
.PP
The met backend allows the following single character options (without a leading \-)
.RS
w \- Draw into an opened window instead of a metafile
.RE
.RS
p \- Draw no geometric linewidths, all lines have a width of zero
.RE
.RS
l \- No filling of polygon interiors
.RE
.RS
c \- No colors, just greyscales
.RE
.RS
t \- Omit all text
.RE
.RS
g \- Omit all graphics
.RE
.RS
v \- Put verbose output to drvMET.out
.RE
.PP
Example:
.RS
\fB\-f "met:wlc"\fR
.RE
.SS NOTES
.PP
To implement a new backend you can start from 
.B drvsampl.cpp 
and 
.BR drvsampl.h .
See also comments in
.B drvbase.h 
and 
.B drvfuncs.h 
for an explanation of methods that should be implemented for a new backend.
.PP
.B pstoedit
can be configured at compile time to include support for CGM. In this case
the cd-library from the CGM Draw package
created by G. Edward Johnson of the United States National Institute
for Standards and Technology (NIST) is needed.  
The cd-library and related documentation can be found at:
.RS
<URL:http://speckle.ncsl.nist.gov/~lorax/>
.RE
.PP
.SH ENVIRONMENT VARIABLES
.PP
A default PostScript interpreter to be called by 
.B pstoedit 
is specified at 
.I compile 
time. You can overwrite the default by setting
the GS environment variable to the name of a suitable PostScript 
interpreter.
.PP
You can check which name of a PostScript interpreter was compiled into pstoedit
using:
.BR pstoedit\ -help .
.PP
See the
.BR gs (1)
manpage for descriptions of environment variables used by Ghostscript
most importantly GS_FONTPATH and GS_LIB;
other environment variables also affect output to display, print,
and additional filtering and processing.  See the related documentation.
.PP
You can set the environment variable PSTOEDITVERBOSE to 1 to generate
verbose output from
.BR pstoedit .
Otherwise the default is 0, nonverbose.
.PP
.B pstoedit
allocates temporary files using the function 
.BR tempnam (3). 
Thus the location for
temporary files might be controllable by other environment variables used
by this function. See the
.BR tempnam (3)
manpage for descriptions of environment variables used. On UNIX like system 
this is probably the TMPDIR variable, on DOS/WINDOWS either TMP or TEMP.
.PP
.SH SYSTEM SPECIFIC NOTES
.PP
.SS "DOS/WINDOWS"
.B pstoedit
compiled with MS-Visual C++ or Borland C++ runs under 32-bit only. 
It might run under WIN32s, but certainly does not run under plain 16-bit DOS. 
.PP 
The WMF driver backend is available only if 
.B pstoedit
was compiled using Borland C++. A graphical user interface for pstoedit
is available under 
.B winp2eex. 
The compilation of the GUI is only possible under Borland C++. 
The GUI relies on 
.B pstoedit
to be installed correctly somewhere in a directory where your PATH variable
points to, since it calls
.B pstoedit
as a subprocess. When the GUI is run, it creates a file named makeedit.err
which contains error and trace messages from the GUI.
.SS "OS/2"
When running 
.B pstoedit
on OS/2 you need to call it using the script 
.BR ps2edit.cmd .
.PP
.SH TROUBLE SHOOTING
.PP
If you have problems with 
.B pstoedit 
first try whether Ghostscript successfully displays your file. If yes
try 
.\" .RS
.in +0.5i
\fBpstoedit \-f ps\fR \fIinfile.ps testfile.ps\fR
.in -0.5i
.\" .RE
and check whether \fItestfile.ps\fR
still displays correctly using Ghostscript. If this file doesn't look
correctly then there seems to be a problem with 
.B pstoedit's
PostScript frontend. If this file looks good but the output for a specific
format is wrong, the problem is probably in the backend for the specific format.
In either case send bug fixes and reports to the author.
.SH RESTRICTIONS
.PP
Non-standard fonts
.RI ( e.g.
TeX bitmap fonts)
are mapped to a default font which can be changed using the \-df option.
.B pstoedit 
chooses the size of the replacement font such that the width of the
string in the original font is the same as in the replacement font. This
is done for each text fragment displayed.
Special character encoding support is limited in this case.
If a character cannot be mapped into the target format, pstoedit displays
a '#' instead.
.PP
.B pstoedit
does not support bitmap graphics, which are left as an exercise for the
user.  (Ghostscript can be used to generate bitmap output; there are a 
number of useful filters that convert various vector graphic formats into 
bitmaps.)
.PP
The Gnuplot backend and the 3D backends (rpl, lwo, rib) do not support text.
.PP
The OS/2 met backend sometimes causes the viewer to fail, although drawing
directly to screen works. This problem is solved with OS/2 FixPak 22.
.PP
\fBpstoedit\fR does not yet generate placeable 
metafiles. This feature is planned for a future release.
.PP
.B Special note about the Java backend
.PP
The java backend generates a java source file that needs other files
in order to be compiled and usable. These files are not part of pstoedit
but can be obtained from the author.
.PP
These other files are Java classes (one applet and support classes) that 
allow to step through the individual pages of a converted PostScript
document. This applet can easily be activated from a html-document.
.PP
.SH NOTICES
.SS AUTHOR
Wolfgang Glunz, Wolfgang.Glunz@mchp.siemens.de
.PP
.SS CANONICAL ARCHIVE SITE
ftp://ftp.x.org/contrib/applications/pstoedit/pstoedit.html
.PP
.SS ACKNOWLEDGEMENTS
.TP 0.2i
.B *
.na
.nh
Klaus Steinberger
<Klaus.Steinberger@physik.uni-muenchen.de>
wrote the initial version of this manpage.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Lar Kaufman 
<lark@walden.com>
revised the increasingly complex command syntax diagrams and
updated the structure and content of this manpage following release 2.5.
.\" Activating this homepage around March 16, 1997. -lar
<URL:http://www.walden.com/~lark/>
.hy
.ad
.TP 0.2i
.B *
.na
.nh
David B. Rosen
<rosen@unr.edu>
provided ideas and some PostScript code from his 
.B ps2aplot
program.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Ian MacPhedran 
<Ian_MacPhedran@engr.USask.CA>
provided the 
.B xfig
backend.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Carsten Hammer 
<chammer@hermes.hrz.uni-bielefeld.de>
provided the 
.B gnuplot
backend and the initial 
DXF 
backend.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Christoph Jaeschke 
<jaeschke@imbe05.imbe.uni\-bremen.de>
provided the OS/2 metafile (MET) backend.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Jens Weber
<rz47b7@PostAG.DE>
provided the Windows metafile (WMF) backend, 
and a graphical user interface (GUI).
.hy
.ad
.TP 0.2i
.B *
.na
.nh
G. Edward Johnson
<lorax@nist.gov>
provided the CGM Draw 
library used in the CGM backend.
<URL:http://speckle.ncsl.nist.gov/~lorax/>
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Gerhard Kircher 
<kircher@edvz.tuwien.ac.at> 
provided some bug fixes. 
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Bill Cheng 
<william@cs.columbia.edu>
provided help with the tgif format and some changes to 
.B tgif 
to make the backend easier to implement.
.br  
<URL:http://www.cs.columbia.edu/~william>
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Reini Urban
<rurban@sbox.tu-graz.ac.at>
provided input for the extended DXF backend.
.br
<URL:http://xarch.tu-graz.ac.at/autocad/> 
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Glenn M. Lewis 
<glewis@c2.net>
provided RenderMan (RIB), Real3D (RPL), and LightWave 3D (LWO) 
backends.
<URL:http://www.c2.net/~glewis/>
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Piet van Oostrum 
<piet@cs.ruu.nl> 
made several bug fixes.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Lutz Vieweg <lkv@mania.robin.de> provided several bug fixes and suggestions 
for improvements.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Derek B. Noonburg <derekn@vw.ece.cmu.edu> and 
.br
Rainer Dorsch <rd@berlepsch.wohnheim.uni-ulm.de> isolated and resolved a 
Linux-specific core dump problem.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Rob Warner <rcw2@ukc.ac.uk> made 
.B pstoedit
compile under RiscOS.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Patrick Gosling <jpmg@eng.cam.ac.uk> made some suggestions regarding the
usage of 
.B pstoedit
in Ghostscript's SAFER mode.
.hy
.ad
.TP 0.2i
.B *
.na
.nh
Scott Pakin <pakin@cs.uiuc.edu> for the Idraw backend.
.hy
.ad
.PP
.SS "LEGAL NOTICES"
.PP
Trademarks mentioned are the property of their respective owners.  
.PP
Some code incorporated
in the
.BR pstoedit
package is subject to copyright or other intellectual property rights or
restrictions including attribution rights.  See the notes in individual 
files.
.PP
.BR pstoedit
is controlled under the Free Software Foundation GNU Public License (GPL).
.PP
Aladdin Ghostscript is a redistributable software package with copyright
restrictions controlled by Aladdin Software. 
.PP
.BR pstoedit
has no other relation to Ghostscript besides calling it in a subprocess.
.PP
The authors, contributors, and distributors of
.B pstoedit
are not responsible for its use for any purpose, or for the results 
generated thereby.  The CGM cd-library is distributed under the following
notice:
.RS
[CD] software produced by NIST, an agency of the U.S. government, is by
statute not subject to copyright in the United States.  Recipients of this
software assume all responsibilities associated with its operation, 
modification, and maintenance.
.RE
.PP
Restrictions such as the foregoing may apply in other countries according
to international conventions and agreements.
.PP
.SH "SEE ALSO"
.PP
.BR dvips (1),
.BR gs (1),
.BR ghostview (1),
.BR gnuplot (1),
.BR tgif (1),
.BR Xfig (1)
.BR idraw (1),
.PP
