/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Verwendet: GTK, Imlib                                                     *
 * Modul:     menufactory.c                                                  *
 *            menus for GTK interface paul                                   *
 *            This was extracted from the GTK tutorial and modified to       *
 *            minimize use of global variables.                              *
 * Autor:     Andreas Tille                                                  *
 * Datum:     14.06.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <strings.h>
#include "paul.h"

static void menus_remove_accel(GtkWidget * widget, gchar * signal_name, gchar * path);
static gint menus_install_accel(GtkWidget * widget, gchar * signal_name, gchar key, gchar modifiers, gchar * path);

/* this is the GtkMenuEntry structure used to create new menus.  The
 * first member is the menu definition string.  The second, the
 * default accelerator key used to access this menu function with
 * the keyboard.  The third is the callback function to call when
 * this menu item is selected (by the accelerator key, or with the
 * mouse.) The last member is the data to pass to your callback function.
 */

/* calculate the number of menu_item's */
static int             initialize  = TRUE;
static GtkMenuFactory *factory = NULL, *subfactory[1];
static GHashTable     *entry_ht = NULL;

static void menus_create(GtkMenuEntry *entries, int nmenu_entries);

static void menus_init(GtkMenuEntry *menu_items, int nmenu_items)
{
   if ( initialize ) {
      initialize = FALSE;
	
      factory       = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
      subfactory[0] = gtk_menu_factory_new(GTK_MENU_FACTORY_MENU_BAR);
	
      gtk_menu_factory_add_subfactory(factory, subfactory[0], "<Main>");
      menus_create(menu_items, nmenu_items);

      /*  siehe FAQ 4.9:
      menu_path = gtk_menu_factory_find (factory,  "<Main>/Stop");
      gtk_menu_item_right_justify(menu_path->widget);
      */
   }
}

static void menus_create(GtkMenuEntry *entries, int nmenu_entries)
{
   char *accelerator;
   int   i;
    
   if ( initialize ) menus_init(entries, nmenu_entries);
    
   if (entry_ht)
      for (i = 0; i < nmenu_entries; i++) {
         accelerator = g_hash_table_lookup(entry_ht, entries[i].path);
         if ( accelerator ) {
            if (accelerator[0] == '\0') entries[i].accelerator = NULL;
            else                        entries[i].accelerator = accelerator;
	 }
      }
   gtk_menu_factory_add_entries(factory, entries, nmenu_entries);
    
   for (i = 0; i < nmenu_entries; i++)
      if (entries[i].widget) {
         gtk_signal_connect(GTK_OBJECT(entries[i].widget), "install_accelerator",
                            (GtkSignalFunc)menus_install_accel, entries[i].path);
         gtk_signal_connect(GTK_OBJECT(entries[i].widget), "remove_accelerator",
	                    (GtkSignalFunc)menus_remove_accel, entries[i].path);
      }
}

static gint menus_install_accel(GtkWidget *widget, gchar *signal_name, gchar key, gchar modifiers, 
                                gchar *path)
{
   char accel[64], *t1, t2[2];
    
   accel[0] = '\0';
   if (modifiers & GDK_CONTROL_MASK) strcat(accel, "<control>");
   if (modifiers & GDK_SHIFT_MASK)   strcat(accel, "<shift>");
   if (modifiers & GDK_MOD1_MASK)    strcat(accel, "<alt>");
    
   t2[0] = key;
   t2[1] = '\0';
   strcat(accel, t2);
    
   if (entry_ht) {
      t1 = g_hash_table_lookup(entry_ht, path);
      g_free(t1);
   } else
      entry_ht = g_hash_table_new(g_str_hash, g_str_equal);
    
   g_hash_table_insert(entry_ht, path, g_strdup(accel));
    
   return TRUE;
}

static void menus_remove_accel(GtkWidget * widget, gchar * signal_name, gchar * path)
{
   char *t;
    
   if (entry_ht) {
      t = g_hash_table_lookup(entry_ht, path);
      g_free(t);
	
      g_hash_table_insert(entry_ht, path, g_strdup(""));
   }
}

void menus_set_sensitive(char *path, int sensitive, GtkMenuEntry *menu, int nmenu)
{
   GtkMenuPath *menu_path;
    
   if (initialize) menus_init(menu, nmenu);
    
   menu_path = gtk_menu_factory_find(factory, path);
   if (menu_path) gtk_widget_set_sensitive(menu_path->widget, sensitive);
   else           g_warning("Unable to set sensitivity for menu which doesn't exist: %s", path);
}


void get_main_menu(GtkWidget **menubar, GtkAcceleratorTable **table, 
                   GtkMenuEntry *menu, int nmenu)
/* Initialize menu with accelerator keys
 * --- Parameter: ---
 * GtkWidget           **menubar: widget, to create menu in
 * GtkAcceleratorTable **table  : Table of accelerator keys 
 * GtkMenuEntry          *menu  : all menu items
 * int                    nmenu : number of menu_items
 */
{
   if ( initialize ) menus_init(menu, nmenu);
    
   if ( menubar )   *menubar = subfactory[0]->widget;
   if ( table )     *table   = subfactory[0]->table;
}

