/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Verwendet: GTK, Imlib, libpng, libtiff                                    *
 * Modul:     callback.h                                                     *
 *            GTK callback functions for paul                                *
 * Autor:     Andreas Tille                                                  *
 * Datum:     03.09.1998                                                     *
 *                                                                           *
 *****************************************************************************/

extern const gchar *PICTURE_DataKey;
extern int   FileListSelectionStatus;
extern int   UPDATE_IMAGE;

#define FAST_TIME  0.4

extern const char ANIMATE[],
                  STOP[],
                  ACCEPT[];

typedef struct {
   char          *name;   /* Name of parameter                                 */
   int            typ;    /* type of value                                     */
   void          *val;    /* Pointer to value of parameter                     */
   gfloat         upper;  /* upper boundary                                    */
   gfloat         lower;  /* lower boundary                                    */
   GtkSignalFunc  valchg; /* Function called if value was changed              */
   GtkAdjustment *adj;    /* Adjustment to edit value                          */
} ITEM;

typedef struct {
   char    *title,  /* Title of parameter input window                         */
           *frame;  /* Title of frame                                          */
   int      np;     /* Number of parameters in param                           */
   ITEM    *para;   /* Parameters                                              */
} PARA_IN;

typedef struct {
   char          *name;   /* Name of possibilty for value                      */
   unsigned char  val;    /* Pointer to value according to this name           */
} RADIO;

typedef struct {
   char          *title,  /* Title of parameter input window                   */
                 *frame;  /* Title of frame                                    */
   int            np;     /* Number of parameters in param                     */
   int            def;    /* Number of default parameter                       */
   unsigned char *val;    /* Pointer to value of parameter                     */
   RADIO         *radio;  /* Parameters                                        */
} RADIO_PARA_IN;

typedef (*PAUL_FUNC)(PAUL *p);
typedef (*PICLIST_FUNC)(GList *pl);
#define PAUL_FUNC_TYPE     0
#define PICLIST_FUNC_TYPE  1
#define ALL                0
#define MARK               1
#define THIS               2

/* obtain picture (list) from list item widget containing file names */
#define LI2PL(fl)    (GList *)gtk_object_get_data(GTK_OBJECT(fl), PICTURE_DataKey)
/* obtain image from list item widget containing file names */
#define LI2BILD(fl)  BILD(LI2PL(fl))

/* from animate.c */
void       AnimationTimeParameterCallback(GtkWidget *widget, PAUL *p);
void       PictureAnimate(GtkWidget *button, PAUL *p);
void       StopPictureAnimate(GtkWidget *button, PAUL *p);

/* from callback.c */
void       PaulExit(GtkWidget *widget, PAUL *p);
void       PictureKeyPressed(GtkWidget *show, GdkEvent *event, PAUL *p);

void       AllDelBorderCallback(GtkWidget *widget, PAUL *p);
void       AllDelScanBorderCallback(GtkWidget *widget, PAUL *p);
void       AllDifferenceCallback(GtkWidget *widget, PAUL *p);
void       AllFFTCallback(GtkWidget *widget, PAUL *p);
void       AllFilterCallback(GtkWidget *widget, PAUL *p);
void       AllScaleCallback(GtkWidget *widget, PAUL *p);
void       AllMoveImagesCallback(GtkWidget *widget, PAUL *p);
void       EndMatchPictures(GtkWidget *widget, PAUL *p);
void       AllMirrorHorizontalCallback(GtkWidget *widget, PAUL *p);
void       AllMirrorVerticalCallback(GtkWidget *widget, PAUL *p);
void       AllMonochromeCallback(GtkWidget *widget, PAUL *p);
void       AllNegativCallback(GtkWidget *widget, PAUL *p);
void       AllRotate90Callback(GtkWidget *widget, PAUL *p);
void       AllRotate180Callback(GtkWidget *widget, PAUL *p);
void	   AllRotate270Callback(GtkWidget *widget, PAUL *p);

void       MarkDelBorderCallback(GtkWidget *widget, PAUL *p);
void       MarkDelScanBorderCallback(GtkWidget *widget, PAUL *p);
void       MarkFFTCallback(GtkWidget *widget, PAUL *p);
void       MarkFilterCallback(GtkWidget *widget, PAUL *p);
void       MarkScaleCallback(GtkWidget *widget, PAUL *p);
void       MarkMirrorHorizontalCallback(GtkWidget *widget, PAUL *p);
void       MarkMirrorVerticalCallback(GtkWidget *widget, PAUL *p);
void       MarkMonochromeCallback(GtkWidget *widget, PAUL *p);
void       MarkNegativCallback(GtkWidget *widget, PAUL *p);
void       MarkRotate90Callback(GtkWidget *widget, PAUL *p);
void       MarkRotate180Callback(GtkWidget *widget, PAUL *p);
void	   MarkRotate270Callback(GtkWidget *widget, PAUL *p);

void       ThisCutCallback(GtkWidget *widget, PAUL *p);
void       ThisDelBorderCallback(GtkWidget *widget, PAUL *p);
void       ThisDelScanBorderCallback(GtkWidget *widget, PAUL *p);
void       ThisFFTCallback(GtkWidget *widget, PAUL *p);
void       ThisFilterCallback(GtkWidget *widget, PAUL *p);
void       ThisScaleCallback(GtkWidget *widget, PAUL *p);
void       ThisHistogramCallback(GtkWidget *widget, PAUL *p);
void       ThisMirrorHorizontalCallback(GtkWidget *widget, PAUL *p);
void       ThisMirrorVerticalCallback(GtkWidget *widget, PAUL *p);
void       ThisMonochromeCallback(GtkWidget *widget, PAUL *p);
void       ThisNegativCallback(GtkWidget *widget, PAUL *p);
void       ThisRotate90Callback(GtkWidget *widget, PAUL *p);
void       ThisRotate180Callback(GtkWidget *widget, PAUL *p);
void	   ThisRotate270Callback(GtkWidget *widget, PAUL *p);

/* from file.c */
void       FileDelete(GtkWidget *widget, PAUL *p);
void       FileLoad(GtkWidget *widget, PAUL *p);
void       FileSave(GtkWidget *widget, PAUL *p);
void       FileSaveAs(GtkWidget *widget, PAUL *p);
void       LoadFirstPicture(PAUL *p);

/* from filesel.c */
void       FileListButtonPressed(GtkWidget *gtklist, GdkEventButton *event, gpointer data);
void       FileListSelectChild(GtkList *gtklist, GtkWidget *data);
void       SelectSingleListItem(GtkList *gtklist, GtkWidget *data);

/* from ginfo.c */
void       FileInfo(GtkWidget *widget, PAUL *p);

/* from gtkpaul.c */
int        CreatePicture(PAUL *p);

/* from gtkuti.c */
void       AreYouSure(void *data, GtkSignalFunc func, char *question);
void       ApplyPaulFunc(PAUL *p, void *func, int func_type, int which);
GtkWidget *BuildParameterTable(GtkWidget *box, ITEM *para, int np);
void       BuildParameterInput(PARA_IN *para_in, PAUL *p, GtkSignalFunc add_func);
void       RadioButtonParameter(RADIO_PARA_IN *para_in);
void       RefreshImage(PICTURE *bild);
GtkWidget *CreateCancelButton(GtkWidget *window, GtkWidget *box);
GtkWidget *CreateOkButton(GtkWidget *window, GtkWidget *box, void *userdata, 
                          GtkSignalFunc f1, void *d1, GtkSignalFunc f2, void *d2);
void       AddImageToFilelist(PAUL *p, PICTURE *bild);
void       RemoveImageFromFilelist(PAUL *p, GtkWidget *list_item);
void       CreateOperationFrame(PAUL *p);
void       CreateOperationImageWindow(PAUL *p);
void       OperationToList(gpointer *realdata, gpointer *flagdata);
GtkWidget *CreateListItem(GList *pl);
void       CreateGtkListOfImages(PAUL *p);
void       MakeNewFileList(PAUL *p);
GtkWidget *SearchListItem(GList *filelist, GList *search);
void       ButtonSensitive(PAUL *p);
void       SetAnimateButton(PAUL *p, GtkSignalFunc func, const char *label);

/* from parameter.c */
void       DelBorderParameterCallback(GtkWidget *widget, PAUL *p);
void       DifferenceParameterCallback(GtkWidget *widget, PAUL *p);
void       FilterParameterCallback(GtkWidget *widget, PAUL *p);
void       GrayParameterCallback(GtkWidget *widget, PAUL *p);
void       MoveParameterCallback(GtkWidget *widget, PAUL *p);
void       ScaleParameterCallback(GtkWidget *widget, PAUL *p);






