/*
 * This file is an extension to NCSA HDF to enable the use of the
 * Pablo trace library.
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1995
 * The University of Illinois Board of Trustees.
 *      All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author: George Xin Zhou (xzhou@cs.uiuc.edu)
 * Contributing Author: Jonathan M. Reid (jreid@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Aeronautics and Space Administration under NASA
 * Contracts NAG-1-613 and USRA 5555-22 and by the Advanced Research
 * Projects Agency under ARPA contracts DAVT63-91-C-0029 and
 * DABT63-93-C-0040.
 *
 */

/*--------------------------------------------------------------------------
 * File:  PabloHDFc
 * Purpose: support use of Pablo trace library to analyze HDF performance
 * Contents:
 *  HDFinitIOtrace  : initialize trace
 *  HDFendIOtrace   : complete trace
 *-------------------------------------------------------------------------*/

#ifdef HAVE_PABLO

#include "hdf.h"
#include "ProcIDs.h"


/* This global variable is used to specify which families of
   procedures should be traced. */
uint16 procTrace = 0;

/* The procEntries and procExits arrays specify the event IDs of
   procedure entry and exit events, respectively.  In order to work
   with the TRACE_ON and TRACE_OFF macros defined in ProcIDs.h, the
   values in procExits must be the negated values of each entry in
   procEntries. */
int procEntries[] = {
	ID_DFANaddfds,
	ID_DFANaddfid,
	ID_DFANgetdesc,
	ID_DFANgetdesclen,
	ID_DFANgetfds,
	ID_DFANgetfdslen,
	ID_DFANgetfid,
	ID_DFANgetfidlen,
	ID_DFANgetlabel,
	ID_DFANgetlablen,
	ID_DFANlablist,
	ID_DFANlastref,
	ID_DFANputdesc,
	ID_DFANputlabel,
	ID_DFANclear,
	ID_DFPaddpal,
	ID_DFPgetpal,
	ID_DFPlastref,
	ID_DFPnpals,
	ID_DFPputpal,
	ID_DFPreadref,
	ID_DFPrestart,
	ID_DFPwriteref,
	ID_DFR8addimage,
	ID_DFR8getdims,
	ID_DFR8getimage,
	ID_DFR8lastref,
	ID_DFR8nimages,
	ID_DFR8putimage,
	ID_DFR8readref,
	ID_DFR8restart,
	ID_DFR8setcompress,
	ID_DFR8setpalette,
	ID_DFR8writeref,
    ID_DFR8Istart,
	ID_DFSDadddata,
	ID_DFSDclear,
	ID_DFSDendslab,
	ID_DFSDendslice,
	ID_DFSDgetcal,
	ID_DFSDgetdata,
	ID_DFSDgetdatalen,
	ID_DFSDgetdatastrs,
	ID_DFSDgetdimlen,
	ID_DFSDgetdims,
	ID_DFSDgetdimscale,
	ID_DFSDgetdimstrs,
	ID_DFSDgetfillvalue,
	ID_DFSDgetNT,
	ID_DFSDgetrange,
	ID_DFSDgetslice,
	ID_DFSDlastref,
	ID_DFSDndatasets,
	ID_DFSDpre32sdg,
	ID_DFSDputdata,
	ID_DFSDputslice,
	ID_DFSDreadref,
	ID_DFSDreadslab,
	ID_DFSDrestart,
	ID_DFSDsetcal,
	ID_DFSDsetdatastrs,
	ID_DFSDsetdims,
	ID_DFSDsetdimscale,
	ID_DFSDsetdimstrs,
	ID_DFSDsetfillvalue,
	ID_DFSDsetlengths,
	ID_DFSDsetNT,
	ID_DFSDsetrange,
	ID_DFSDstartslab,
	ID_DFSDstartslice,
	ID_DFSDwriteref,
	ID_DFSDwriteslab,
	ID_DF24addimage,
	ID_DF24getdims,
	ID_DF24getimage,
	ID_DF24lastref,
	ID_DF24nimages,
	ID_DF24putimage,
	ID_DF24readref,
	ID_DF24reqil,
	ID_DF24restart,
	ID_DF24setcompress,
	ID_DF24setdims,
	ID_DF24setil,
	ID_Happendable,
	ID_Hclose,
	ID_Hdeldd,
	ID_Hdupdd,
	ID_Hendaccess,
	ID_Hfind,
	ID_Hgetelement,
	ID_Hgetfileversion,
	ID_Hgetlibversion,
	ID_Hinquire,
	ID_Hishdf,
	ID_HLcreate,
	ID_Hlength,
	ID_Hnewref,
	ID_Hnextread,
	ID_Hnumber,
	ID_Hoffset,
	ID_Hopen,
	ID_Hputelement,
	ID_Hread,
	ID_Hseek,
	ID_Hstartread,
	ID_Hstartwrite,
	ID_Hsync,
	ID_Htrunc,
	ID_Hwrite,
	ID_HXcreate,
    ID_HXsetcreatedir,
    ID_HXsetdir,
    ID_HLconvert,
    ID_Hstartaccess,
    ID_Hisappendable,
    ID_Htell,
    ID_Htagnewref,
    ID_Hcache,
    ID_Hsetaccesstype,
    ID_Hexist,
    ID_Hsetlength,
    ID_Hfidinquire,
    ID_HDreuse_tagref,
	ID_HEclear,
	ID_HEprint,
	ID_HEpush,
	ID_HEreport,
	ID_HEstring,
	ID_SDattrinfo,
	ID_SDcreate,
	ID_SDdiminfo,
	ID_SDend,
	ID_SDendaccess,
	ID_SDfileinfo,
	ID_SDfindattr,
	ID_SDgetcal,
	ID_SDgetdatastrs,
	ID_SDgetdimid,
	ID_SDgetdimscale,
	ID_SDgetdimstrs,
	ID_SDgetfillvalue,
	ID_SDgetinfo,
	ID_SDgetrange,
	ID_SDidtoref,
	ID_SDiscoordvar,
	ID_SDnametoindex,
	ID_SDreadattr,
	ID_SDreaddata,
	ID_SDreftoindex,
	ID_SDselect,
	ID_SDsetattr,
	ID_SDsetcal,
	ID_SDsetdatastrs,
	ID_SDsetdimname,
	ID_SDsetdimscale,
	ID_SDsetdimstrs,
	ID_SDsetexternalfile,
	ID_SDsetfillvalue,
	ID_SDsetrange,
	ID_SDstart,
	ID_SDwritedata,
	ID_VFfieldesize,
	ID_VFfieldisize,
	ID_VFfieldname,
	ID_VFfieldorder,
	ID_VFfieldtype,
	ID_VFnfields,
	ID_Vaddtagref,
	ID_Vattach,
	ID_Vdetach,
	ID_Vgetclass,
	ID_Vgetid,
	ID_Vgetname,
	ID_Vgettagref,
	ID_Vgettagrefs,
	ID_Vinqtagref,
	ID_Vinquire,
	ID_Vinsert,
	ID_Vlone,
	ID_Vntagrefs,
	ID_Vsetclass,
	ID_Vsetname,
    ID_Vinitialize,
    ID_Vfinish,
    ID_Vfind,
    ID_Vfindclass,
    ID_vpackvs,
    ID_vunpackvs,
    ID_vpackvg,
    ID_vunpackvg,
    ID_Vsetattr,
    ID_Vgetversion,
    ID_Vnattrs,
    ID_Vfindattr,
    ID_Vattrinfo,
    ID_Vgetattr,
    ID_Vdeletetagref,
	ID_VHmakegroup,
	ID_VHstoredata,
	ID_VHstoredatam,
	ID_VSattach,
	ID_VSdetach,
	ID_VSelts,
	ID_VSfdefine,
	ID_VSfexist,
	ID_VSfind,
	ID_VSgetclass,
	ID_VSgetfields,
	ID_VSgetid,
	ID_VSgetinterlace,
	ID_VSgetname,
	ID_VSinquire,
	ID_VSlone,
	ID_VSread,
	ID_VSseek,
	ID_VSsetclass,
	ID_VSsetfields,
	ID_VSsetinterlace,
	ID_VSsetname,
	ID_VSsizeof,
	ID_VSwrite,
    ID_VSappendable,
    ID_VSdelete,
    ID_VSfindclass,
    ID_VSfpack,
    ID_VSfindex,
    ID_VSsetattr,
    ID_VSnattrs,
    ID_VSfnattrs,
    ID_VSfindattr,
    ID_VSattrinfo,
    ID_VSgetattr,
    ID_VSisattr,
    ID_ANstart,
    ID_ANfileinfo,
    ID_ANend,
    ID_ANcreate,
    ID_ANcreatef,
    ID_ANselect,
    ID_ANnumann,
    ID_ANannlist,
    ID_ANannlen,
    ID_ANreadann,
    ID_ANwriteann,
    ID_ANendaccess,
    ID_GRstart,
    ID_GRfileinfo,
    ID_GRend,
    ID_GRcreate,
    ID_GRselect,
    ID_GRnametoindex,
    ID_GRgetiminfo,
    ID_GRwriteimage,
    ID_GRreadimage,
    ID_GRendaccess,
    ID_GRgetdimid,
    ID_GRsetdimname,
    ID_GRdiminfo,
    ID_GRidtoref,
    ID_GRreftoindex,
    ID_GRreqlutil,
    ID_GRreqimageil,
    ID_GRgetlutid,
    ID_GRgetlutinfo,
    ID_GRwritelut,
    ID_GRreadlut,
    ID_GRsetexternalfile,
    ID_GRsetaccesstype,
    ID_GRsetcompress,
    ID_GRsetattr,
    ID_GRattrinfo,
    ID_GRgetattr,
    ID_GRfindattr,
    ID_GRluttoref,
    ID_GRsetchunk,
    ID_GRgetchunkinfo,
    ID_GRsetchunkcache
};

int procExits[] = {
	-ID_DFANaddfds,
	-ID_DFANaddfid,
	-ID_DFANgetdesc,
	-ID_DFANgetdesclen,
	-ID_DFANgetfds,
	-ID_DFANgetfdslen,
	-ID_DFANgetfid,
	-ID_DFANgetfidlen,
	-ID_DFANgetlabel,
	-ID_DFANgetlablen,
	-ID_DFANlablist,
	-ID_DFANlastref,
	-ID_DFANputdesc,
	-ID_DFANputlabel,
	-ID_DFANclear,
	-ID_DFPaddpal,
	-ID_DFPgetpal,
	-ID_DFPlastref,
	-ID_DFPnpals,
	-ID_DFPputpal,
	-ID_DFPreadref,
	-ID_DFPrestart,
	-ID_DFPwriteref,
	-ID_DFR8addimage,
	-ID_DFR8getdims,
	-ID_DFR8getimage,
	-ID_DFR8lastref,
	-ID_DFR8nimages,
	-ID_DFR8putimage,
	-ID_DFR8readref,
	-ID_DFR8restart,
	-ID_DFR8setcompress,
	-ID_DFR8setpalette,
	-ID_DFR8writeref,
    -ID_DFR8Istart,
	-ID_DFSDadddata,
	-ID_DFSDclear,
	-ID_DFSDendslab,
	-ID_DFSDendslice,
	-ID_DFSDgetcal,
	-ID_DFSDgetdata,
	-ID_DFSDgetdatalen,
	-ID_DFSDgetdatastrs,
	-ID_DFSDgetdimlen,
	-ID_DFSDgetdims,
	-ID_DFSDgetdimscale,
	-ID_DFSDgetdimstrs,
	-ID_DFSDgetfillvalue,
	-ID_DFSDgetNT,
	-ID_DFSDgetrange,
	-ID_DFSDgetslice,
	-ID_DFSDlastref,
	-ID_DFSDndatasets,
	-ID_DFSDpre32sdg,
	-ID_DFSDputdata,
	-ID_DFSDputslice,
	-ID_DFSDreadref,
	-ID_DFSDreadslab,
	-ID_DFSDrestart,
	-ID_DFSDsetcal,
	-ID_DFSDsetdatastrs,
	-ID_DFSDsetdims,
	-ID_DFSDsetdimscale,
	-ID_DFSDsetdimstrs,
	-ID_DFSDsetfillvalue,
	-ID_DFSDsetlengths,
	-ID_DFSDsetNT,
	-ID_DFSDsetrange,
	-ID_DFSDstartslab,
	-ID_DFSDstartslice,
	-ID_DFSDwriteref,
	-ID_DFSDwriteslab,
	-ID_DF24addimage,
	-ID_DF24getdims,
	-ID_DF24getimage,
	-ID_DF24lastref,
	-ID_DF24nimages,
	-ID_DF24putimage,
	-ID_DF24readref,
	-ID_DF24reqil,
	-ID_DF24restart,
	-ID_DF24setcompress,
	-ID_DF24setdims,
	-ID_DF24setil,
	-ID_Happendable,
	-ID_Hclose,
	-ID_Hdeldd,
	-ID_Hdupdd,
	-ID_Hendaccess,
	-ID_Hfind,
	-ID_Hgetelement,
	-ID_Hgetfileversion,
	-ID_Hgetlibversion,
	-ID_Hinquire,
	-ID_Hishdf,
	-ID_HLcreate,
	-ID_Hlength,
	-ID_Hnewref,
	-ID_Hnextread,
	-ID_Hnumber,
	-ID_Hoffset,
	-ID_Hopen,
	-ID_Hputelement,
	-ID_Hread,
	-ID_Hseek,
	-ID_Hstartread,
	-ID_Hstartwrite,
	-ID_Hsync,
	-ID_Htrunc,
	-ID_Hwrite,
	-ID_HXcreate,
    -ID_HXsetcreatedir,
    -ID_HXsetdir,
    -ID_HLconvert,
    -ID_Hstartaccess,
    -ID_Hisappendable,
    -ID_Htell,
    -ID_Htagnewref,
    -ID_Hcache,
    -ID_Hsetaccesstype,
    -ID_Hexist,
    -ID_Hsetlength,
    -ID_Hfidinquire,
    -ID_HDreuse_tagref,
	-ID_HEclear,
	-ID_HEprint,
	-ID_HEpush,
	-ID_HEreport,
	-ID_HEstring,
	-ID_SDattrinfo,
	-ID_SDcreate,
	-ID_SDdiminfo,
	-ID_SDend,
	-ID_SDendaccess,
	-ID_SDfileinfo,
	-ID_SDfindattr,
	-ID_SDgetcal,
	-ID_SDgetdatastrs,
	-ID_SDgetdimid,
	-ID_SDgetdimscale,
	-ID_SDgetdimstrs,
	-ID_SDgetfillvalue,
	-ID_SDgetinfo,
	-ID_SDgetrange,
	-ID_SDidtoref,
	-ID_SDiscoordvar,
	-ID_SDnametoindex,
	-ID_SDreadattr,
	-ID_SDreaddata,
	-ID_SDreftoindex,
	-ID_SDselect,
	-ID_SDsetattr,
	-ID_SDsetcal,
	-ID_SDsetdatastrs,
	-ID_SDsetdimname,
	-ID_SDsetdimscale,
	-ID_SDsetdimstrs,
	-ID_SDsetexternalfile,
	-ID_SDsetfillvalue,
	-ID_SDsetrange,
	-ID_SDstart,
	-ID_SDwritedata,
	-ID_VFfieldesize,
	-ID_VFfieldisize,
	-ID_VFfieldname,
	-ID_VFfieldorder,
	-ID_VFfieldtype,
	-ID_VFnfields,
	-ID_Vaddtagref,
	-ID_Vattach,
	-ID_Vdetach,
	-ID_Vgetclass,
	-ID_Vgetid,
	-ID_Vgetname,
	-ID_Vgettagref,
	-ID_Vgettagrefs,
	-ID_Vinqtagref,
	-ID_Vinquire,
	-ID_Vinsert,
	-ID_Vlone,
	-ID_Vntagrefs,
	-ID_Vsetclass,
	-ID_Vsetname,
    -ID_Vinitialize,
    -ID_Vfinish,
    -ID_Vfind,
    -ID_Vfindclass,
    -ID_vpackvs,
    -ID_vunpackvs,
    -ID_vpackvg,
    -ID_vunpackvg,
    -ID_Vsetattr,
    -ID_Vgetversion,
    -ID_Vnattrs,
    -ID_Vfindattr,
    -ID_Vattrinfo,
    -ID_Vgetattr,
    -ID_Vdeletetagref,
	-ID_VHmakegroup,
	-ID_VHstoredata,
	-ID_VHstoredatam,
	-ID_VSattach,
	-ID_VSdetach,
	-ID_VSelts,
	-ID_VSfdefine,
	-ID_VSfexist,
	-ID_VSfind,
	-ID_VSgetclass,
	-ID_VSgetfields,
	-ID_VSgetid,
	-ID_VSgetinterlace,
	-ID_VSgetname,
	-ID_VSinquire,
	-ID_VSlone,
	-ID_VSread,
	-ID_VSseek,
	-ID_VSsetclass,
	-ID_VSsetfields,
	-ID_VSsetinterlace,
	-ID_VSsetname,
	-ID_VSsizeof,
	-ID_VSwrite,
    -ID_VSappendable,
    -ID_VSdelete,
    -ID_VSfindclass,
    -ID_VSfpack,
    -ID_VSfindex,
    -ID_VSsetattr,
    -ID_VSnattrs,
    -ID_VSfnattrs,
    -ID_VSfindattr,
    -ID_VSattrinfo,
    -ID_VSgetattr,
    -ID_VSisattr,
    -ID_ANstart,
    -ID_ANfileinfo,
    -ID_ANend,
    -ID_ANcreate,
    -ID_ANcreatef,
    -ID_ANselect,
    -ID_ANnumann,
    -ID_ANannlist,
    -ID_ANannlen,
    -ID_ANreadann,
    -ID_ANwriteann,
    -ID_ANendaccess,
    -ID_GRstart,
    -ID_GRfileinfo,
    -ID_GRend,
    -ID_GRcreate,
    -ID_GRselect,
    -ID_GRnametoindex,
    -ID_GRgetiminfo,
    -ID_GRwriteimage,
    -ID_GRreadimage,
    -ID_GRendaccess,
    -ID_GRgetdimid,
    -ID_GRsetdimname,
    -ID_GRdiminfo,
    -ID_GRidtoref,
    -ID_GRreftoindex,
    -ID_GRreqlutil,
    -ID_GRreqimageil,
    -ID_GRgetlutid,
    -ID_GRgetlutinfo,
    -ID_GRwritelut,
    -ID_GRreadlut,
    -ID_GRsetexternalfile,
    -ID_GRsetaccesstype,
    -ID_GRsetcompress,
    -ID_GRsetattr,
    -ID_GRattrinfo,
    -ID_GRgetattr,
    -ID_GRfindattr,
    -ID_GRluttoref,
    -ID_GRsetchunk,
    -ID_GRgetchunkinfo,
    -ID_GRsetchunkcache
};


/* ------------------------------------------------------------------
NAME
       HDFinitIOTrace -- initialize I/O tracing
USAGE
       VOID HDFinitIOTrace(traceFileName, detail, lifetime, timeWindow,
			   timeWindowSize, regionTrace, regionSize,
			   procTraceMask)
       char    *traceFileName;	IN: name of the generated trace output file
       intn    detail;		IN: if non-zero, do detailed trace
       intn    lifetime;	IN: if non-zero, do lifetime summaries
       intn    timeWindow;	IN: if non-zero, do time window summaries
       float64 timeWindowSize;	IN: size of time window in seconds
       intn    regionTrace;	IN: if non-zero, do file region summaries
       intn    regionSize;	IN: size of file region in bytes
       uint16  procTraceMask;	IN: families of procedures to trace
RETURNS
       None.
--------------------------------------------------------------------- */
int HDFinitIOTrace(char *traceFileName, intn detail, intn lifetime,
			   intn timeWindow, float64 timeWindowSize,
			   intn regionTrace, intn regionSize,
			   uint16 procTraceMask )
{
  int ret_value = 0;

    setTraceFileName(traceFileName);

    preInitProcTrace();
    initProcTrace(sizeof(procEntries)/sizeof(int), procEntries, procExits);

    initIOTrace();

    if (detail)
      enableIOdetail();
    else
      disableIOdetail();

    if (lifetime)
      enableLifetimeSummaries();
    else
      disableLifetimeSummaries();

    if (timeWindow) {
      if ( timeWindowSize <= 0 )
	timeWindowSize = 30.0;
      enableTimeWindowSummaries(timeWindowSize);
    } else
      disableTimeWindowSummaries();

    if (regionTrace) {
      if ( regionSize <= 0 )
	regionSize = 1000;
      enableFileRegionSummaries(regionSize);
    } else 
      disableFileRegionSummaries();

    procTrace = procTraceMask;

  return ret_value;
}


/* ------------------------------------------------------------------
NAME
       HDFendIOTrace -- end I/O tracing
USAGE
       VOID HDFendIOTrace(VOID)
RETURNS
       None.
--------------------------------------------------------------------- */
int HDFendIOTrace(VOID)
{
  int ret_value = 0;

    endIOTrace();
    endTracing();

  return ret_value;
}

#endif /* HAVE_PABLO */
