/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"
#include "gdk/gdkkeysyms.h" /* for key values */

static void update_thumb_widgets();

void set_zoom_label(gint z,gfloat f)
{
	gint zl = 1;
	gint zr = 1;
	gchar txtbuf[16];
	gchar approx[4] = " ";
	if (z > 1) zl = z;
	if (z < -1) zr = -z;
	if (z == 0 && f != 0)
		{
		if (f < 1) zr = 1 / f + 0.5;
		strcpy(approx," ~");
		}
	sprintf(txtbuf,"%d :%s%d", zl, approx, zr);
	gtk_label_set(GTK_LABEL(zoomfactorlabel),txtbuf);
}

void zoom_image_in()
{
	if (ZOOM >= 3) return;
	if (ZOOM == 0) ZOOM = 1;
	if (ZOOM == -2) ZOOM = 0;
	ZOOM++;
	image_redraw(ZOOM);
}

void zoom_image_out()
{
	if (ZOOM <= -8) return;
	if (ZOOM == 1 || ZOOM == 0) ZOOM = -1;
	ZOOM--;
	image_redraw(ZOOM);
}

void zoom_image_norm()
{
	if (ZOOM == 1) return;
	ZOOM = 1;
	image_redraw(ZOOM);
}

void zoom_image_fit()
{
	if (ZOOM == 0) return;
	ZOOM = 0;
	image_redraw(ZOOM);
}

static void update_thumb_widgets()
{
	gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(thumb_menu_item),thumbnail_mode);
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(thumb_button),thumbnail_mode);
}

void thumb_button_clicked(GtkWidget *w)
{
	if (thumbnail_mode == GTK_TOGGLE_BUTTON(w)->active) return;
	thumbnail_mode = GTK_TOGGLE_BUTTON(w)->active;
	update_thumb_widgets();
	refresh_dir();
}

void thumb_menu_item_clicked(GtkWidget *w)
{
	if (thumbnail_mode == GTK_CHECK_MENU_ITEM(w)->active) return;
	thumbnail_mode = GTK_CHECK_MENU_ITEM(w)->active;
	update_thumb_widgets();
	refresh_dir();
}

void select_next_image()
{
	gint old = filelist_pos;
	if (filelist_pos >= filelist_count - 1) return;
	filelist_pos++;
	update_list_highlight(old, filelist_pos, TRUE);
	load_from_filelist(filelist_pos);
}

void select_prev_image()
{
	gint old = filelist_pos;
	if (filelist_pos == -1) return;
	if (filelist_pos < 1) return;
	filelist_pos--;
	update_list_highlight(old, filelist_pos, TRUE);
	load_from_filelist(filelist_pos);
}

static void select_first_image()
{
	gint old = filelist_pos;
	if (filelist_count < 1 || filelist_pos == 0) return;
	filelist_pos = 0;
	update_list_highlight(old, filelist_pos, TRUE);
	load_from_filelist(filelist_pos);
}

static void select_last_image()
{
	gint old = filelist_pos;
	if (filelist_count < 1 || filelist_pos == filelist_count - 1) return;
	filelist_pos = filelist_count -1;
	update_list_highlight(old, filelist_pos, TRUE);
	load_from_filelist(filelist_pos);
}

void change_image_to_logo()
{
	image=gdk_imlib_create_image_from_data(logodata,NULL,202,76);
	gtk_window_set_title(GTK_WINDOW(mainwindow),"GQview");
	gtk_label_set(GTK_LABEL(fileinfolabel)," ");
	strcpy(image_file_name,"");
	strcpy(image_dir_name,"");
	filelist_pos = -1;
	image_redraw(ZOOM);
}

void load_from_filelist(gint row)
{
	gchar sbuf[24];
	if (row < 0 || row > filelist_count) return;
	strcpy(current_file,filelist_get_item(row));
	strcpy(image_file_name,current_file);
	strcpy(image_dir_name,current_dir);
	if (ZOOM_MODE == 1) ZOOM = 1;
	if (ZOOM_MODE == 2) ZOOM = 0;

	gtk_label_set(GTK_LABEL(statuslabel),"loading image...");
	if (popwindow)
		gtk_widget_draw_children(popwindow);
	else
		gtk_widget_draw_children(mainwindow);
	update_image();

	if (filelist_count == 1)
		sprintf(sbuf,"1 file");
	else
		sprintf(sbuf,"%d files",filelist_count);
	gtk_label_set(GTK_LABEL(statuslabel),sbuf);
}

void change_image_to_nearest()
{
	if (!strcmp(current_dir,image_dir_name) && filelist_count > 0)
		{
		if (filelist_pos > filelist_count -1)
			filelist_pos = filelist_count -1;
		load_from_filelist(filelist_pos);
		return;
		}

	/* no more images in current dir */
	change_image_to_logo();
}

void start_editor_from_list(GtkWidget *w,gchar *cmd_line)
{
	gchar editor_command[512];
	if (!current_file[0]) return;
	sprintf(editor_command,"%s \"%s/%s\" &",cmd_line,current_dir,current_file);
	printf("GQview running: %s\n",editor_command);
	system (editor_command);
}

void start_editor_from_image(GtkWidget *w,gchar *cmd_line)
{
	gchar editor_command[512];
	if (!image_file_name[0]) return;
	sprintf(editor_command,"%s \"%s/%s\" &",cmd_line,image_dir_name,image_file_name);
	printf("GQview running: %s\n",editor_command);
	system (editor_command);
}

void key_pressed(GtkWidget *widget, GdkEventKey *event)
{
	gint stop_signal = FALSE;
	gint x = 0;
	gint y = 0;

	switch (event->keyval)
		{
		case GDK_Left:
			x -= 8;
			stop_signal = TRUE;
			break;
		case GDK_Right:
			x += 8;
			stop_signal = TRUE;
			break;
		case GDK_Up:
			y -= 8;
			stop_signal = TRUE;
			break;
		case GDK_Down:
			y += 8;
			stop_signal = TRUE;
			break;
		case GDK_Page_Up: case GDK_BackSpace:
			select_prev_image();
			stop_signal = TRUE;
			break;
		case GDK_Page_Down: case GDK_space:
			select_next_image();
			stop_signal = TRUE;
			break;
		case GDK_Home:
			select_first_image();
			stop_signal = TRUE;
			break;
		case GDK_End:
			select_last_image();
			stop_signal = TRUE;
			break;
		case GDK_Delete:
			delete_file_from_image();
			stop_signal = TRUE;
			break;
		case GDK_Escape:
			interrupt_thumbs();
			stop_signal = TRUE;
			break;
		}

	if (event->state & GDK_CONTROL_MASK)
		{
		x *= 3;
		y *= 3;
		}

	if (x != 0)
		{
		GtkAdjustment *h = gtk_viewport_get_hadjustment(GTK_VIEWPORT(viewwindow));
		gfloat val = h->value + x;
		if (val < h->lower) val = h->lower;
		if (val > h->upper - h->page_size) val = h->upper - h->page_size;
		gtk_adjustment_set_value(GTK_ADJUSTMENT(h), val);
		}

	if (y != 0)
		{
		GtkAdjustment *v = gtk_viewport_get_vadjustment(GTK_VIEWPORT(viewwindow));
		gfloat val = v->value + y;
		if (val < v->lower) val = v->lower;
		if (val > v->upper - v->page_size) val = v->upper - v->page_size;
		gtk_adjustment_set_value(GTK_ADJUSTMENT(v), val);
		}

	if (stop_signal) gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
}

void destroy(GtkWidget *widget, gpointer *data)
{
	if (save_on_exit)
		{
		save_options();
		}
	gtk_main_quit();
}

int main (int argc, char *argv[])
{
	gchar command_line_path[2048];
	gchar command_line_dir[255];
	gchar command_line_with_dir[2048];
	gchar *rcfile;
	gchar *hmdir;
	gint i;

	gtk_init (&argc, &argv);
	gdk_imlib_init();
	
	/* check that we can find a valid home directory, if not exit semi-gracefully */
	hmdir = homedir();
	if (!hmdir)
		{
		printf("Unable to determine the home directory\n");
		return 0;
		}
	else if (!isdir(hmdir))
		{
		printf("Could not find home directory: %s\n", hmdir);
		return 0;
		}

	rcfile = g_strconcat(homedir(), "/gtkrc", NULL);
	gtk_rc_parse(rcfile);
	g_free(rcfile);

	for (i=0; i<8; i++)
		{
		strcpy(editor_name + (i*33),"");
		strcpy(editor_command + (i*256),"");
		}

	/* add some defaults */
	/* (these are overwritten by .gqviewrc if it exists) */
	strcpy(editor_name,"The Gimp");
	strcpy(editor_command,"gimp");
	strcpy(editor_name + 33,"Electric Eyes");
	strcpy(editor_command + 256,"ee");
	strcpy(editor_name + (2*33),"XV");
	strcpy(editor_command + (2*256),"xv");
	strcpy(editor_name + (3*33),"Xpaint");
	strcpy(editor_command + (3*256),"xpaint");

	load_options();

	create_main_window();

	/* load logo pixmap */
	image=gdk_imlib_create_image_from_data(logodata,NULL,202,76);
	gdk_imlib_render(image,image->rgb_width,image->rgb_height);
	logo_pixmap=gdk_imlib_copy_image(image);

	update_edit_menu();

	get_current_dir();
	strcpy(command_line_dir,current_dir);

	if (STARTUP_PATH_ENABLE)
		{
		if (isdir(STARTUP_PATH))
			{
			set_current_dir(STARTUP_PATH);
			}
		else
			{
			get_current_dir();
			printf("config file contains invalid startup path:\n%s\n",STARTUP_PATH);
			}
		}

	if (argc > 1)
		{
		i = 1;
		while (i < argc)
			{
			strcpy(command_line_path,argv[i]);
			sprintf(command_line_with_dir,"%s/%s",command_line_dir,command_line_path);
			i++;
			if (isdir(command_line_path) || isdir(command_line_with_dir))
				{
				/* is a directory */
				if (isdir(command_line_with_dir))
					strcpy(command_line_path,command_line_with_dir);
				i = argc;
				set_current_dir(command_line_path);
				}
			else
				{
				if (isfile(command_line_path) || isfile(command_line_with_dir))
					{
					/* is a file */
					gchar *fn_ptr;
					if (isfile(command_line_with_dir))
						strcpy(command_line_path,command_line_with_dir);
					i = argc;
					fn_ptr = command_line_path + strlen(command_line_path) -1;
					while (fn_ptr[0] != '/' && fn_ptr > command_line_path) fn_ptr--;
					fn_ptr[0] = '\0';
					fn_ptr++;
					strcpy(current_file,fn_ptr);
					strcpy(image_file_name,current_file);
					strcpy(image_dir_name,command_line_path);
					set_current_dir(command_line_path);

					if (ZOOM_MODE == 1) ZOOM = 1;
					if (ZOOM_MODE == 2) ZOOM = 0;
					update_image();

					printf("starting with file: %s\n",current_file);
					}
				else
					{
					/* is neither */
					if (!strcmp(command_line_path,"-debug"))
						{
						debug_mode = TRUE;
						printf("debug enabled\n");
						}
					else
						{
						printf("invalid or ignored: %s\n",command_line_path);
						}
					}
				}
			}
		}
	else
		{
		}

	printf("starting with directory: %s\n",current_dir);

	filelist_init();
	rebuild_filter();
	update_thumb_widgets();
	refresh_dir();

	gtk_signal_connect(GTK_OBJECT(imagewindow),"size_allocate",GTK_SIGNAL_FUNC(draw_img),NULL);

	gtk_drawing_area_size(GTK_DRAWING_AREA(imagewindow),image->rgb_width,image->rgb_height);
	
	gtk_signal_connect(GTK_OBJECT (viewwindow), "size_allocate", GTK_SIGNAL_FUNC(window_resized), NULL);

	gtk_main ();
	return 0;
}

