/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

void save_options()
{
	FILE *f;
	gchar rc_path[280];
	int i;
	sprintf(rc_path,"%s/.gqviewrc",homedir());

	f = fopen(rc_path,"w");
	if (!f)
		{
		printf("error opening config file\n");
		return;
		}

	fprintf(f,"######################################################################\n");
	fprintf(f,"#                         GQview config file           version %d.%d.%d #\n",
		GQVIEW_VERSION_MAJOR, GQVIEW_VERSION_MINOR, GQVIEW_VERSION_REV);
	fprintf(f,"#                                                                    #\n");
	fprintf(f,"#  Everything in this file can be changed in the option dialogs.     #\n");
	fprintf(f,"#      (so there should be no need to edit this file by hand)        #\n");
	fprintf(f,"#                                                                    #\n");
	fprintf(f,"######################################################################\n");
	fprintf(f,"\n");
	fprintf(f,"##### General Options #####\n");
	fprintf(f,"\n");

	fprintf(f,"enable_startup_path: ");
	if (STARTUP_PATH_ENABLE) fprintf(f,"true\n"); else fprintf(f,"false\n");

	fprintf(f,"startup_path: ");
	fprintf(f,"%s\n",STARTUP_PATH);
	fprintf(f,"\n");

	fprintf(f,"zoom_mode: ");
	switch (ZOOM_MODE)
		{
		case 1:
			fprintf(f,"original\n");
			break;
		case 2:
			fprintf(f,"fit\n");
			break;
		default:
			fprintf(f,"dont_change\n");
			break;
		}
	fprintf(f,"\n");

	fprintf(f,"fit_window_to_image: ");
	if (fit_window) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"limit_window_size: ");
	if (limit_window_size) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"max_window_size: ");
	fprintf(f,"%d\n",max_window_size);
	fprintf(f,"\n");

	fprintf(f,"thumbnail_width: ");
	fprintf(f,"%d\n",thumb_max_width);
	fprintf(f,"thumbnail_height: ");
	fprintf(f,"%d\n",thumb_max_height);
	fprintf(f,"\n");

	fprintf(f,"cache_thumbnails: ");
	if (ENABLE_THUMB_CACHING) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"confirm_delete: ");
	if (confirm_delete) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"save_settings_on_exit: ");
	if (save_on_exit) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"tools_float: ");
	if (tool_floats) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"tools_hidden: ");
	if (tool_hidden) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"restore_tool_state: ");
	if (restore_tool) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"##### Filtering Options #####\n");
	fprintf(f,"\n");

	fprintf(f,"show_dotfiles: ");
	if (DOT_FILES) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"disable_filtering: ");
	if (FILTERING_DISABLE) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"filter_ppm: ");
	if (FILTER_INCLUDE_PPM) fprintf(f,"true\n"); else fprintf(f,"false\n");

	fprintf(f,"filter_png: ");
	if (FILTER_INCLUDE_PNG) fprintf(f,"true\n"); else fprintf(f,"false\n");

	fprintf(f,"filter_jpg: ");
	if (FILTER_INCLUDE_JPG) fprintf(f,"true\n"); else fprintf(f,"false\n");

	fprintf(f,"filter_tif: ");
	if (FILTER_INCLUDE_TIF) fprintf(f,"true\n"); else fprintf(f,"false\n");

	fprintf(f,"filter_pgm: ");
	if (FILTER_INCLUDE_PGM) fprintf(f,"true\n"); else fprintf(f,"false\n");

	fprintf(f,"filter_xpm: ");
	if (FILTER_INCLUDE_XPM) fprintf(f,"true\n"); else fprintf(f,"false\n");

	fprintf(f,"filter_gif: ");
	if (FILTER_INCLUDE_GIF) fprintf(f,"true\n"); else fprintf(f,"false\n");

	fprintf(f,"filter_pcx: ");
	if (FILTER_INCLUDE_PCX) fprintf(f,"true\n"); else fprintf(f,"false\n");

	fprintf(f,"filter_bmp: ");
	if (FILTER_INCLUDE_BMP) fprintf(f,"true\n"); else fprintf(f,"false\n");
	fprintf(f,"\n");

	fprintf(f,"custom_filter: ");
		fprintf(f,"%s\n",CUSTOM_FILTER);
	fprintf(f,"\n");

	fprintf(f,"##### External Programs #####\n");
	fprintf(f,"# Maximum of 8 programs (external_1 through external 8)\n");
	fprintf(f,"# format: external_n: \"menu name\" \"command line\"\n");
	fprintf(f,"\n");

	for (i=0; i<8; i++)
		{
		fprintf(f,"external_%d: \"%s\" \"%s\"\n",i+1,editor_name + (i*33),editor_command + (i*256));
		}
	fprintf(f,"\n");

	fprintf(f,"######################################################################\n");
	fprintf(f,"#                      end of GQview config file                     #\n");
	fprintf(f,"######################################################################\n");

	fclose(f);
}

void load_options()
{
	FILE *f;
	gchar rc_path[280];
	gchar s_buf[1024];
	gchar *s_buf_ptr;
	gchar option[1024];
	gchar value[1024];
	gchar value_all[1024];
	gint c,l;
	int i;
	sprintf(rc_path,"%s/.gqviewrc",homedir());

	f = fopen(rc_path,"r");
	if (!f)
		{
		/* no file has been created yet */
		return;
		}

	while (fgets(s_buf,1024,f))
		{
		if (s_buf[0]=='#') continue;
		if (s_buf[0]=='\n') continue;
		c = 0;
		l = strlen(s_buf);
		while (s_buf[c] != ':' && c < l) c++;
		if (c >= l) continue;
		s_buf[c] = '\0';
		c++;
		while (s_buf[c] == ' ' && c < l) c++;
		while (s_buf[c] == 8 && c < l) c++;
		while (s_buf[c] == ' ' && c < l) c++;
		s_buf_ptr = s_buf + c;
		strcpy(value_all,s_buf_ptr);
		while (s_buf[c] != 8 && s_buf[c] != ' ' && s_buf[c] != '\n' && c < l) c++;
		s_buf[c] = '\0';
		strcpy(option,s_buf);
		strcpy(value,s_buf_ptr);

		/* general options */
		if (!strcasecmp(option,"enable_startup_path"))
			{
			if (!strcasecmp(value,"true")) STARTUP_PATH_ENABLE = TRUE;
			else STARTUP_PATH_ENABLE = FALSE;
			}
		if (!strcasecmp(option,"startup_path"))
			{
			strcpy(STARTUP_PATH,value);
			}
		if (!strcasecmp(option,"zoom_mode"))
			{
			if (!strcasecmp(value,"original")) ZOOM_MODE = 1;
			if (!strcasecmp(value,"fit")) ZOOM_MODE = 2;
			if (!strcasecmp(value,"dont_change")) ZOOM_MODE = 3;
			}
		if (!strcasecmp(option,"fit_window_to_image"))
			{
			if (!strcasecmp(value,"true")) fit_window = TRUE;
			else fit_window = FALSE;
			}
		if (!strcasecmp(option,"limit_window_size"))
			{
			if (!strcasecmp(value,"true")) limit_window_size = TRUE;
			else limit_window_size = FALSE;
			}
		if (!strcasecmp(option,"max_window_size"))
			{
			max_window_size = strtol(value,NULL,0);
			}
		if (!strcasecmp(option,"thumbnail_width"))
			{
			thumb_max_width = strtol(value,NULL,0);
			if (thumb_max_width < 16) thumb_max_width = 16;
			if (thumb_max_width > 100) thumb_max_width = 100;
			}
		if (!strcasecmp(option,"thumbnail_height"))
			{
			thumb_max_height = strtol(value,NULL,0);
			if (thumb_max_height < 16) thumb_max_height = 16;
			if (thumb_max_height > 100) thumb_max_height = 100;
			}
		if (!strcasecmp(option,"cache_thumbnails"))
			{
			if (!strcasecmp(value,"true")) ENABLE_THUMB_CACHING = TRUE;
			else ENABLE_THUMB_CACHING = FALSE;
			}
		if (!strcasecmp(option,"confirm_delete"))
			{
			if (!strcasecmp(value,"true")) confirm_delete = TRUE;
			else confirm_delete = FALSE;
			}
		if (!strcasecmp(option,"save_settings_on_exit"))
			{
			if (!strcasecmp(value,"true")) save_on_exit = TRUE;
			else save_on_exit = FALSE;
			}
		if (!strcasecmp(option,"tools_float"))
			{
			if (!strcasecmp(value,"true")) tool_floats = TRUE;
			else tool_floats = FALSE;
			}
		if (!strcasecmp(option,"tools_hidden"))
			{
			if (!strcasecmp(value,"true")) tool_hidden = TRUE;
			else tool_hidden = FALSE;
			}
		if (!strcasecmp(option,"restore_tool_state"))
			{
			if (!strcasecmp(value,"true")) restore_tool = TRUE;
			else restore_tool = FALSE;
			}

		/* filter options */
		if (!strcasecmp(option,"show_dotfiles"))
			{
			if (!strcasecmp(value,"true")) DOT_FILES = TRUE;
			else DOT_FILES = FALSE;
			}
		if (!strcasecmp(option,"disable_filtering"))
			{
			if (!strcasecmp(value,"true")) FILTERING_DISABLE = TRUE;
			else FILTERING_DISABLE = FALSE;
			}
		if (!strcasecmp(option,"filter_ppm"))
			{
			if (!strcasecmp(value,"true")) FILTER_INCLUDE_PPM = TRUE;
			else FILTER_INCLUDE_PPM = FALSE;
			}
		if (!strcasecmp(option,"filter_png"))
			{
			if (!strcasecmp(value,"true")) FILTER_INCLUDE_PNG = TRUE;
			else FILTER_INCLUDE_PNG = FALSE;
			}
		if (!strcasecmp(option,"filter_jpg"))
			{
			if (!strcasecmp(value,"true")) FILTER_INCLUDE_JPG = TRUE;
			else FILTER_INCLUDE_JPG = FALSE;
			}
		if (!strcasecmp(option,"filter_tif"))
			{
			if (!strcasecmp(value,"true")) FILTER_INCLUDE_TIF = TRUE;
			else FILTER_INCLUDE_TIF = FALSE;
			}
		if (!strcasecmp(option,"filter_pgm"))
			{
			if (!strcasecmp(value,"true")) FILTER_INCLUDE_PGM = TRUE;
			else FILTER_INCLUDE_PGM = FALSE;
			}
		if (!strcasecmp(option,"filter_xpm"))
			{
			if (!strcasecmp(value,"true")) FILTER_INCLUDE_XPM = TRUE;
			else FILTER_INCLUDE_XPM = FALSE;
			}
		if (!strcasecmp(option,"filter_gif"))
			{
			if (!strcasecmp(value,"true")) FILTER_INCLUDE_GIF = TRUE;
			else FILTER_INCLUDE_GIF = FALSE;
			}
		if (!strcasecmp(option,"filter_pcx"))
			{
			if (!strcasecmp(value,"true")) FILTER_INCLUDE_PCX = TRUE;
			else FILTER_INCLUDE_PCX = FALSE;
			}
		if (!strcasecmp(option,"filter_bmp"))
			{
			if (!strcasecmp(value,"true")) FILTER_INCLUDE_BMP = TRUE;
			else FILTER_INCLUDE_BMP = FALSE;
			}
		if (!strcasecmp(option,"custom_filter"))
			{
			strcpy(CUSTOM_FILTER,value);
			}
		if (!strncasecmp(option,"external_",9))
			{
			i = strtol(option + 9, NULL, 0);
			if (i>0 && i<9)
				{
				gchar *ptr1, *ptr2;
				i--;
				c = 0;
				l = strlen(value_all);
				ptr1 = value_all;
				while (c<l && value_all[c] !='"') c++;
				if (ptr1[c] == '"')
					{
					c++;
					ptr2 = ptr1 + c;
					while (c<l && value_all[c] !='"') c++;
					if (ptr1[c] == '"')
						{
						ptr1[c] = '\0';
						strncpy(editor_name + (i*33),ptr2,32);
						editor_name[(i*33) + 32] = '\0';
						c++;
						while (c<l && value_all[c] !='"') c++;
						if (ptr1[c] == '"')
							{
							c++;
							ptr2 = ptr1 + c;
							while (c<l && value_all[c] !='"') c++;
							if (ptr1[c] == '"')
								{
								ptr1[c] = '\0';
								strncpy(editor_command + (i*256),ptr2,32);
								editor_command[(i*256) + 255] = '\0';
								}
							}
						}
					}
				}
			}
		}

	fclose(f);
}


