/*###################################################################*/
/*##                          GQview 0.4.3                         ##*/
/*##       This software is Copyright (C) 1998 by John Ellis.      ##*/
/*## This software falls under the GNU Public License. Please read ##*/
/*##              the COPYING file for more information            ##*/
/*###################################################################*/

#include "gqview.h"

gchar *homedir()
{
	struct passwd *pw = getpwuid(getuid());

	if (pw)
		return pw->pw_dir;
	else
		{
		gchar *home = getenv("HOME");
		if(home)
			return home;
		else
			/* now we've got a problem */
			return NULL ;
		}
}

int isfile(char *s)
{
   struct stat st;
   
   if ((!s)||(!*s)) return 0;
   if (stat(s,&st)<0) return 0;
   if (S_ISREG(st.st_mode)) return 1;
   return 0;
}

int isdir(char *s)
{
   struct stat st;
   
   if ((!s)||(!*s)) return 0;
   if (stat(s,&st)<0) return 0;
   if (S_ISDIR(st.st_mode)) return 1;
   return 0;
}

void get_current_dir()
{
	getcwd(current_dir,255);

}

int filesize(char *s)
{
   struct stat st;
   
   if ((!s)||(!*s)) return 0;
   if (stat(s,&st)<0) return 0;
   return (int)st.st_size;
}

time_t filetime(gchar *s)
{
	struct stat st;

	if ((!s)||(!*s)) return 0;
	if (stat(s,&st)<0) return 0;
	return st.st_mtime;
}

void set_current_dir(char *s)
{
	chdir(s);
	get_current_dir();
}

void read_dir()
{
	DIR		*dp; 
	struct dirent	*dir;
	struct stat ent_sbuf;

	if((dp = opendir(current_dir))==NULL) 
	{ 
		/* dir not found */ 
		return; 
	} 

	dirlist_clear();
	filelist_clear();

	while ((dir = readdir(dp)) != NULL) 
	{ 
		/* skips removed files */ 
		if (dir->d_ino > 0)
			{
			gchar *name;
			gchar *path;

			name = dir->d_name;
			path = g_strconcat(current_dir, "/", name, NULL);

			if (stat(path,&ent_sbuf) >= 0 && S_ISDIR(ent_sbuf.st_mode))
				{
				if (dot_file_check(name) || (DOT_FILES))
					{
					dirlist_add_item(name);
					}
				}
			else
				{
				if (dot_file_check(name) || (DOT_FILES))
					{
					if (filter_file_check(name) || (FILTERING_DISABLE))
						{
						filelist_add_item(name);
						}
					}
				}
			g_free(path);
			}
	} 
 
	closedir(dp);
}

int copy_file(char *s, char *t)
{
	FILE *fi, *fo;
	char buf[4096];
	int b;

	fi = fopen(s, "rb");
	if (!fi)
		{
		return FALSE;
		}

	fo = fopen(t, "wb");
	if (!fo)
		{
		fclose(fi);
		return FALSE;
		}

	while((b = fread(buf, sizeof(char), 4096, fi)) && b != 0)
		{
		if (fwrite(buf, sizeof(char), b, fo) != b)
			{
			fclose(fi);
			fclose(fo);
			return FALSE;
			}
		}

	fclose(fi);
	fclose(fo);
	return TRUE;
}

int move_file(char *s, char *t)
{
	if (rename (s, t) < 0)
		{
		/* this may have failed because moving a file across filesystems
		was attempted, so try copy and delete instead */
		if (copy_file(s, t))
			{
			if (unlink (s) < 0)
				{
				/* err, now we can't delete the source file so return FALSE */
				return FALSE;
				}
			}
		else
			return FALSE;
		}

	return TRUE;
}

