/* gtk_type1_preview.h: Type1 font display box widget using t1lib.
   
   (c) 1998 David Huggins-Daines <bn711@freenet.carleton.ca>
   You may modify and distribute this file under the terms of the GNU
   General Public License, version 2, or any later version, at your
   convenience. See the file COPYING for details. */

#ifndef GTK_TYPE1_PREVIEW_H
#define GTK_TYPE1_PREVIEW_H

#include <gtk/gtk.h>
#include "gdk_t1lib.h"

typedef struct _GtkType1Preview GtkType1Preview;
typedef struct _GtkType1PreviewClass GtkType1PreviewClass;
typedef struct _GtkType1FontSpec GtkType1FontSpec;

typedef enum {
  GTK_TYPE1_FILE,
  GTK_TYPE1_FONTID,
} FontSpecType;

#define GTK_TYPE1_PREVIEW(obj) GTK_CHECK_CAST(obj, gtk_type1_preview_get_type(), GtkType1Preview)
#define GTK_TYPE1_PREVIEW_CLASS(klass) GTK_CHECK_CLASS_CAST(klass, gtk_type1_preview_get_type(), GtkType1Preview)
#define GTK_IS_TYPE1_PREVIEW(obj)      GTK_CHECK_TYPE(obj, gtk_type1_preview_get_type())

struct _GtkType1Preview
{
  GtkWidget widget;

  GdkPixmap *pixmap;
  gint clean;

  /* values for t1lib */
  gint font_id;
  gfloat size;
  gfloat slant;
  gfloat extend;
  gint aa;
};

struct _GtkType1PreviewClass
{
  GtkWidgetClass widget_class;
};

struct _GtkType1FontSpec
{
  FontSpecType type;
  union
  {
    gchar *filename;
    gint t1_fontid;
  } font;
};

guint gtk_type1_preview_get_type (void);
GtkWidget *gtk_type1_preview_new (void);

gint gtk_type1_preview_set_font (GtkType1Preview *preview,
				 GtkType1FontSpec spec, gfloat size,
				 gfloat slant, gfloat extend);
gint gtk_type1_preview_set_size (GtkType1Preview *preview, gfloat
				 size);
gint gtk_type1_preview_set_extend (GtkType1Preview *preview, gfloat
				   extend);
gint gtk_type1_preview_set_slant (GtkType1Preview *preview, gfloat
				  slant);
gint gtk_type1_preview_set_aa (GtkType1Preview *preview, gint aa);

#endif /* GTK_TYPE1_PREVIEW_H */
