/* GGlyph - a graphical utility for managing one's collection of Type
   1 fonts (and eventually, other sorts of fonts) under X11.

   Copyright (c) 1998 David Huggins-Daines
   <bn711@freenet.carleton.ca>.

   You are permitted to copy, distribute, and modify this file under the
   terms of the GNU General Public License, version 2, or any later
   version.  See the file COPYING for more details. */

/* gglyph.h - contains global methods and data that are common to the
   various GUI components */

#ifndef GGLYPH_H
#define GGLYPH_H

#include <gtk/gtk.h>
#include "fonts.h"

#define DEFAULT_SIZE 36
#define ALWAYS_RESCAN 0

FontFileRec *find_font (gchar *pathname);
void add_font_to_db (gchar *key, FontFileRec *value, gpointer
			    use_basename);
void question_box (gchar *question, GtkSignalFunc cb_yes,
		   GtkSignalFunc cb_no, gpointer yes_data, gpointer
		   no_data, gchar *help_text);

#endif /* GGLYPH_H */
