/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    Load an video into a pix block

    Copyright (c) 1997-1998 Mark Danks. mdanks@cybermed.ucsd.edu
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_PIX_VIDEO_H_
#define INCLUDE_PIX_VIDEO_H_

#include "Base/GemBase.h"

#ifdef __sgi
#include <vl/vl.h>
#elif _WINDOWS
#include <vfw.h>
#else
#error No video defined for OS
#endif

#include "Base/GemPixUtil.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    video
    
    Loads in an video
    
KEYWORDS
    pix
    
DESCRIPTION

    "dimen" (int, int) - set the x,y dimensions
    "zoom" (int, int) - the zoom factor (1.0 is nominal) (num / denom)
    "bright" (int) - the brightnes
    "contrast" (int) - the contrast
    "hue" (int) - the hue
    "sat" (int) - the saturation
    
-----------------------------------------------------------------*/
class GEM_EXTERN pix_video : public GemBase
{
    CPPEXTERN_HEADER(pix_video, GemBase)

    public:

        //////////
        // Constructor
    	pix_video();
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~pix_video();

    	//////////
    	// Do the rendering
    	virtual void 	render(GemState *state);

    	//////////
    	// Clear the dirty flag on the pixBlock
    	virtual void 	postrender(GemState *state);

    	//////////
    	virtual void	startRendering();

    	//////////
    	// If you care about the stop of rendering
    	virtual void	stopRendering();
    	
    	//////////
    	// Clean up the pixBlock
    	void	    	cleanPixBlock();
    
    	//////////
    	// Set the video dimensions
    	void	    	dimenMess(int x, int y);
    
    	//////////
    	// Set the video offset
    	void	    	offsetMess(int x, int y);
    
    	//////////
    	// Start up the video device
    	// [out] int - returns 0 if bad
    	int	    		startTransfer();
    
    	//////////
    	// Stop the video device
    	// [out] int - returns 0 if bad
    	int	    		stopTransfer();
    
    	////////// 
    	// Stop the video device
    	// [out] int - returns 0 if bad
    	void	    	swapMess(int state);
    
	    //-----------------------------------
	    // GROUP:	Video data
	    //-----------------------------------
    
     	//////////
    	// If video is connected
    	int 	    	m_haveVideo;
    	
    	//////////
    	// The pixBlock with the current image
    	pixBlock    	m_pixBlock;
    	
    	//////////
    	// Should swap the pixels?
    	int 	    	m_swap;
    	 
    	//////////
    	// Do we have to color swap?
    	int 	    	m_colorSwap;
    	
#ifdef __sgi
		VLServer    	m_svr;
		VLPath      	m_path;
		VLNode      	m_src;
		VLNode	    	m_drn;
		VLBuffer    	m_buffer;
#elif _WINDOWS
		HWND			m_hWndC;
		void			videoFrame(LPVIDEOHDR lpVHdr);
#else
#error Define pix_video for this OS
#endif

    private:
    	
    	//////////
    	// static member functions
    	static void dimenMessCallback(void *data, t_floatarg x, t_floatarg y);
    	static void offsetMessCallback(void *data, t_floatarg x, t_floatarg y);
    	static void swapMessCallback(void *data, t_floatarg state);

#ifdef _WINDOWS
		static LRESULT PASCAL videoFrameCallback(HWND hWnd, LPVIDEOHDR lpVHdr);
#endif

};

#endif	// for header file
