/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    A particle system

    Copyright (c) 1997-1998 Mark Danks. mark@danks.org
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_PARTATOM_H_
#define INCLUDE_PARTATOM_H_

#include "Base/Matrix.h"

#include "Base/GemBase.h"

/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS

	partatom
    
	A particle system

DESCRIPTION
    

-----------------------------------------------------------------*/
class GEM_EXTERN partatom : public GemBase
{
    CPPEXTERN_HEADER(partatom, GemBase)

    public:

	    //////////
	    // Constructor
    	partatom();
    	
    	//////////
    	virtual void 	render(GemState *state);

    protected:
    	
    	//////////
    	// Destructor
    	virtual ~partatom();

		//////////
		// The particle group
		int				m_particle;

		//////////
		// The display list
		int				m_dList;

		//////////
		Matrix			m_rotMatrix;

		//////////
		// The rotation callback
		void			rotationMess(float x, float y, float z);

		//////////
		// The button callback
		void			motionMess(int but1, int but2, int but3, int but4, int but5, int but6);

		//////////
		void			reset();

		//////////
		int				m_gravity;

		//////////
		int				m_but[6];

		//////////
		float			m_orbit;

	private:
		
		//////////
		// Static callbacks
		static void		rotationMessCallback(void *data, t_floatarg x, t_floatarg y, t_floatarg z);
		static void		motionMessCallback(void *data, t_floatarg but1, t_floatarg but2, t_floatarg but3, t_floatarg but4, t_floatarg but5, t_floatarg but6);
        static void     resetCallback(void *data);
};

#endif	// for header file
