/*
 * XSOLDIER, a video-oriented game
 * Copyright (C) 1997, Yuusuke HASHIMOTO
 *                     s945750@educ.info.kanagawa-u.ac.jp
 *
 * ܥץˤ copyleft ŬѤƤޤCONDITION ե򻲾Ȥ
 * Ƥ
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/xpm.h>

#include "image.h"
#include "xsoldier.h"
#include "manage.h"
#include "player.h"
#include "common.h"
#include "callback.h"
#include "extern.h"
#include "key.h"
#include "sin.h"

/*** Player Object ***/
void NewPlayer(int x, int y)
{
    manage->player[0]->Data.hitAtt = MPlayer;
    manage->player[0]->Data.hitMask = MEnemy | MEShot | MItem;
    /*** ° ***/

    manage->player[0]->Data.used = True;
    manage->player[0]->Data.kill = False;
    manage->player[0]->Data.X = x;
    manage->player[0]->Data.Y = y;
    manage->player[0]->Data.Speed = 15;
    manage->player[0]->Data.Attack = 0;
    manage->player[0]->Data.Width = 16;
    manage->player[0]->Data.Height = 16;
    manage->player[0]->Data.HarfW = manage->player[0]->Data.Width/2;
    manage->player[0]->Data.HarfH = manage->player[0]->Data.Height/2;
    manage->player[0]->Data.image = 0;

    manage->player[0]->Data.Cnt[0] = 0; /*** auto shot counter ***/
    manage->player[0]->Data.Cnt[1] = 0; /*** image counter ***/
    manage->player[0]->Data.Cnt[2] = 100; /*** ̵Ũ ***/
    manage->player[0]->Data.Cnt[3] = 0; /***  ***/
    manage->player[0]->Data.Cnt[4] = False; /*** ȾƩ ***/
    manage->player[0]->Data.Cnt[5] = 1; /*** 參 ***/
    manage->player[0]->Data.Cnt[6] = 0; /***  pow  ***/
    
    manage->player[0]->Grp.image = PlayerImage;
    manage->player[0]->Grp.Width = manage->player[0]->Grp.image[0]->width;
    manage->player[0]->Grp.Height = manage->player[0]->Grp.image[0]->height;
    manage->player[0]->Grp.HarfW = manage->player[0]->Grp.Width/2;
    manage->player[0]->Grp.HarfH = manage->player[0]->Grp.Height/2;
    
    manage->player[0]->Action = PlayerAction;
    manage->player[0]->Hit = PlayerHit;
    manage->player[0]->Realize = DrawImage;

    manage->PlayerNum++;
}

void RestartPlayer(int x, int y)
{
    manage->player[0]->Data.hitAtt = MPlayer;
    manage->player[0]->Data.hitMask = MEnemy | MEShot | MItem;
    manage->player[0]->Data.used = True;
    manage->player[0]->Data.kill = False;
    manage->player[0]->Data.X = x;
    manage->player[0]->Data.Y = y;

    manage->player[0]->Data.Cnt[0] = 0; /*** auto shot counter ***/
    manage->player[0]->Data.Cnt[1] = 0; /*** image counter ***/
    manage->player[0]->Data.Cnt[2] = 50; /*** ̵Ũ ***/
    manage->player[0]->Data.Cnt[3] = 0; /*** ȤΥ ***/
    manage->player[0]->Data.Cnt[4] = False; /*** ȾƩ ***/

    manage->PlayerNum++;
}

DelAtt PlayerAction(ObjData *my)
{
    /*** ԡѹϤĤǤ OK ***/
    if (keymask & SpeedUP)
    {
	if (my->Speed < 25)
	    my->Speed += 5;
	keymask -= SpeedUP;
    }
    if (keymask & SpeedDOWN)
    {
	if (my->Speed > 5)
	    my->Speed -= 5;
	keymask -= SpeedDOWN;
    }

    if (joymask & SpeedUP)
    {
	if (my->Speed < 25)
	    my->Speed += 5;
	else
	    my->Speed = 5;
    }

    /*** ˴ Act ޤ ***/
    if (my->kill == True)
    {
	my->Cnt[3]++;
	if (my->Cnt[3] == 30)
	    return NullDel;

	NewLargeBomb(my->X+random()%20-10,my->Y+random()%20-10);
	return NoneDel;
    }

    /*** ư ***/
    if (keymask & Up || joymask & Up)
	my->Y -= my->Speed;
    if (keymask & Down || joymask & Down)
	my->Y += my->Speed;
    if (keymask & Left || joymask & Left)
    {
	my->X -= my->Speed;
	my->Cnt[1] -= 2;
    }
    if (keymask & Right || joymask & Right)
    {
	my->X += my->Speed;
	my->Cnt[1] += 2;
    }

    /*** ᡼ ***/
    if (my->Cnt[1] > 0)
	my->Cnt[1]--;
    else if (my->Cnt[1] < 0)
	my->Cnt[1]++;

    if (my->Cnt[1] > 10)
	my->image = 4;
    else if (my->Cnt[1] > 0)
	my->image = 3;
    else if (my->Cnt[1] < -10)
	my->image = 2;
    else if (my->Cnt[1] < 0)
	my->image = 1;
    else
	my->image = 0;

    if (my->Cnt[2] != 0)
    {
	if (my->Cnt[4] == False)
	{
	    my->image = 5;
	    my->Cnt[4] = True;
	}
	else
	    my->Cnt[4] = False;
    }

    /*** ưϰϸ ***/
    if (my->X - 16 < 0)
	my->X = 0 + 16;
    else if (my->X + 16 > FieldW)
	my->X = FieldW - 16;
    if (my->Y - 16 < 0)
	my->Y = 0 + 16;
    else if (my->Y + 16 > FieldH)
	my->Y = FieldH - 16;

    if (my->Cnt[2] > 0)
	my->Cnt[2]--;

    if (keymask & Shot || joymask & Shot)
    {
	if (my->Cnt[0] == 0)
	{
	    switch (my->Cnt[5])
	    {
	      case 1:
		if (my->Cnt[6] >= 30)
		    my->Cnt[0] = 2;
		else
		    my->Cnt[0] = 3;/*** Ϣʹֳ ***/

		if (my->Cnt[6] >= 20)
		{
		    PlayerShot1(my->X-10,my->Y,25,90);
		    PlayerShot1(my->X+10,my->Y,25,90);
		}
		if (my->Cnt[6] >= 10)
		{
		    PlayerShot1(my->X-40,my->Y+10,25,270);
		    PlayerShot1(my->X+40,my->Y+10,25,270);
		}
		PlayerShot1(my->X-10,my->Y,25,270);
		PlayerShot1(my->X+10,my->Y,25,270);

		break;
	      case 2:
		if (my->Cnt[6] >= 30)
		    my->Cnt[0] = 2;
		else
		    my->Cnt[0] = 3;/*** Ϣʹֳ ***/

		if (my->Cnt[6] >= 20)
		{
		    PlayerShot2(my->X,my->Y,30,225);
		    PlayerShot2(my->X,my->Y,30,315);
		}
		if (my->Cnt[6] >= 14)
		{
		    PlayerShot2(my->X,my->Y,30,60);
		    PlayerShot2(my->X,my->Y,30,120);
		}
		if (my->Cnt[6] >= 7)
		{
		    PlayerShot2(my->X,my->Y,30,240);
		    PlayerShot2(my->X,my->Y,30,300);
		}
		PlayerShot2(my->X,my->Y,30,255);
		PlayerShot2(my->X,my->Y,30,270);
		PlayerShot2(my->X,my->Y,30,285);

		break;
	      case 3:
		if (my->Cnt[6] >= 30)
		    my->Cnt[0] = 3;
		else
		    my->Cnt[0] = 4;/*** Ϣʹֳ ***/

		if (my->Cnt[6] >= 20)
		{
		    PlayerShot3(my->X,my->Y-10,0);
		    PlayerShot3(my->X-10,my->Y-10,-1);
		    PlayerShot3(my->X+10,my->Y-10,1);
		}
		else if (my->Cnt[6] >= 10)
		{
		    PlayerShot3(my->X-10,my->Y-10,0);
		    PlayerShot3(my->X+10,my->Y-10,0);
		}
		else
		    PlayerShot3(my->X,my->Y-10,0);

		break;
	    }
	}
	else
	    my->Cnt[0]--;
    }
    else
	my->Cnt[0] = 0;

    return NoneDel;
}

DelAtt PlayerHit(ObjData *my, ObjData *your)
{
    if (your->hitAtt == MItem)
    {
	if (your->Cnt[0] == 0)
	    my->Cnt[6] += 2;
	else if (your->Cnt[0] == my->Cnt[5])
	    my->Cnt[6]++;
	else
	    my->Cnt[5] = your->Cnt[0];

	if (my->Cnt[6] > 30)
	    my->Cnt[6] = 30;

	return NoneDel;
    }

    if (my->Cnt[2] == 0)
    {
	my->Cnt[6] -= 5;
	if (my->Cnt[6] < 0)
	    my->Cnt[6] = 0;
	my->kill = True;
	my->image = 5;
    }
    return NoneDel;
}

/*** Player Shot ***/
void PlayerShot1(int x, int y, int speed, int angle)
{
    manage->New.Data.hitAtt = MPShot;
    manage->New.Data.hitMask = MEnemy;

    manage->New.Data.X = x;
    manage->New.Data.Y = y;
    manage->New.Data.Attack = 2;
    manage->New.Data.Speed = speed;
    manage->New.Data.Angle = angle;
    manage->New.Data.EnemyAtt = NullDel;
    manage->New.Data.Width = 10;
    manage->New.Data.Height = 26;

    manage->New.Data.Cnt[0] = x << 8;
    manage->New.Data.Cnt[1] = y << 8;
    manage->New.Data.Cnt[2] = icos(angle);
    manage->New.Data.Cnt[3] = isin(angle);

    manage->New.Data.Cnt[4] = 0;

    manage->New.Grp.image = PShot1Image;

    NewObj(MPShot,PlayerShotAct1,PlayerShotHit1,DrawImage);
}

void PlayerShot2(int x, int y, int speed, int angle)
{
    manage->New.Data.hitAtt = MPShot;
    manage->New.Data.hitMask = MEnemy;

    manage->New.Data.X = x;
    manage->New.Data.Y = y;
    manage->New.Data.Attack = 1;
    manage->New.Data.Speed = speed;
    manage->New.Data.Angle = angle;
    manage->New.Data.EnemyAtt = NullDel;
    manage->New.Data.Width = 12;
    manage->New.Data.Height = 16;

    manage->New.Data.Cnt[0] = x << 8;
    manage->New.Data.Cnt[1] = y << 8;
    manage->New.Data.Cnt[2] = icos(angle);
    manage->New.Data.Cnt[3] = isin(angle);

    manage->New.Data.Cnt[4] = 0;

    manage->New.Grp.image = PShot2Image;

    NewObj(MPShot,PlayerShotAct1,PlayerShotHit1,DrawImage);
}

DelAtt PlayerShotAct1(ObjData *my)
{
    if (my->Cnt[4] >= 1)
	return NullDel;

    my->Cnt[0] += my->Cnt[2]*my->Speed;
    my->X = my->Cnt[0] >> 8;
    my->Cnt[1] += my->Cnt[3]*my->Speed;
    my->Y = my->Cnt[1] >> 8;

    if ((my->X<0) || (my->X>FieldW))
	return NullDel;
    if ((my->Y<0) || (my->Y>FieldH))
	return NullDel;

    return NoneDel;
}

DelAtt PlayerShotHit1(ObjData *my, ObjData *your)
{
    if (my->Cnt[4] >= 1)
	return NullDel;

    my->Cnt[4]++;
    my->hitMask = 0;
    my->image = 1;
    return NoneDel;
}

void PlayerShot3(int x, int y, int inertX)
{
    manage->New.Data.hitAtt = MPShot;
    manage->New.Data.hitMask = MEnemy;

    manage->New.Data.X = x;
    manage->New.Data.Y = y;
    manage->New.Data.Attack = 5;
    manage->New.Data.EnemyAtt = NullDel;
    manage->New.Data.Width = 8;
    manage->New.Data.Height = 16;

    manage->New.Data.inertX = inertX;
    manage->New.Data.inertY = 0;
    manage->New.Data.Cnt[4] = 0;

    manage->New.Grp.image = PShot3Image;

    NewObj(MPShot,PlayerShotAct3,PlayerShotHit3,DrawImage);
}

DelAtt PlayerShotAct3(ObjData *my)
{
    if (my->Cnt[4] != 0)
    {
	if (my->Cnt[4] == 4) /*** ȯ õ ***/
	    return NullDel;
	if (my->Cnt[4] == 3) /*** ȯ ̵꤬ʤ ***/
	    my->Attack = 0;
	if (my->Cnt[4] == 1)
	    my->image = 2;
	my->Cnt[4]++;
    }

    if (my->Cnt[4] == 0) /*** ޤȯƤʤ ***/
    {
	my->inertY++;
	my->X += my->inertX;
	my->Y -= my->inertY;
    }

    if ((my->X<0) || (my->X>FieldW))
	return NullDel;
    if ((my->Y<0) || (my->Y>FieldH))
	return NullDel;

    return NoneDel;
}

DelAtt PlayerShotHit3(ObjData *my, ObjData *your)
{
    if (my->Cnt[4] == 4)
	return NullDel;
    else if (my->Cnt[4] == 0)
    {/*** ޤȯƤʤä! ȯ!! ***/
	my->Attack = 1; /***  ***/

	my->Width = 80;
	my->HarfW = my->Width>>1;
	
	my->Height = 80;
	my->HarfH = my->Height>>1;
	
	my->Cnt[4]++;
	my->image = 1;
	return NoneDel;
    }
}
