/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __QSTAT_H__
#define __QSTAT_H__

#include <unistd.h>	/* pid_t */

#include <gtk/gtk.h>

#include "xqf.h"
#include "dns.h"


#define QSTAT_DELIM	'\t'

#define BUFFER_MINSIZE	1024
#define BUFFER_MAXSIZE	(128*1024)
#define BUFFER_TRESHOLD	64


struct progress {
  int	tasks_total;
  int 	tasks_done;
  int	subtasks_total;
  int   subtasks_done;
};

struct statconn {
  pid_t	pid;
  int	fd;
  int	tag;

  char	*buf;
  int	bufsize;
  int	pos;
  int 	lastnl;

  GSList *strings;
  GSList *servers;
  struct master *master;

  char *tmpfile;
};

struct stat_job;

enum stat_state { STAT_SOURCE, STAT_SERVER, STAT_RESOLVE };

typedef void (*master_func) (struct stat_job *job, struct master *m, 
                                                                 int servers);
typedef void (*server_func) (struct stat_job *job, struct server *s);
typedef void (*host_func)   (struct stat_job *job, struct host *h, char *id);

typedef void (*state_func)  (struct stat_job *job, enum stat_state state);
typedef void (*close_func)  (struct stat_job *job, int killed);

struct stat_job {
  GSList *masters;
  GSList *servers;
  GSList *hosts;
  GSList *names;

  struct statconn *conn;

  GSList *master_handlers;
  GSList *server_handlers;
  GSList *host_handlers;

  GSList *state_handlers;
  GSList *close_handlers;

  int single;
  int redraw;

  struct progress progress;
  gpointer data;		/* arbitrary data */
};

extern	int qsort_players (const void *a, const void *b);
extern	int qsort_servers (const void *a, const void *b);
extern	int qsort_serverinfo (const void *a, const void *b);

extern	void stat_start (struct stat_job *job);
extern	void stat_stop (struct stat_job *job);

extern	struct stat_job *stat_job_create (GSList *masters, GSList *servers,
                                                GSList *hosts, GSList *names);
extern	void stat_job_free (struct stat_job *job);
extern	float stat_job_progress (struct stat_job *job);


#endif /* __QSTAT_H__ */

