/* XQF - Quake server browser and launcher
 * Copyright (C) 1998 Roman Pozlevich <roma@botik.ru>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __PREF_H__
#define __PREF_H__


#include <gtk/gtk.h>


#ifndef PATH_MAX
# ifdef MAXPATHLEN
#  define PATH_MAX MAXPATHLEN
# else
#  define PATH_MAX 8192
# endif
#endif

enum {
  PREF_PAGE_PLAYER,
  PREF_PAGE_GAMEPLAY,
  PREF_PAGE_FILTER,
  PREF_PAGE_GENERAL
};

extern  struct user_info user;

extern  int 	default_rate;
extern  int 	default_cl_nodelta;
extern  int 	default_cl_predict;
extern  int 	default_noaim;
extern  int 	default_pushlatency;
extern  int 	default_windowed_mouse;
extern  int 	default_nosound;
extern  int 	default_nocdaudio;
extern  char 	*default_name;
extern  char 	*default_team;
extern  char 	*default_qw_skin;
extern  char 	*default_q2_skin;
extern	char 	*default_qw_cfg;
extern  char 	*default_q2_cfg;
extern  int 	default_top_color;
extern  int 	default_bottom_color;
extern  int 	default_noskins;
extern  char 	*default_quake_dir;
extern  char	*default_qw_cmd;
extern	char 	*default_q2_dir;
extern	char	*default_q2_cmd;
extern	int	default_terminate;
extern	int	default_iconify;
extern  int 	default_b_switch;
extern  int 	default_w_switch;
extern  int 	default_save_lists;
extern	int	default_auto_favorites;
extern	int	default_always_resolve;

extern	int	filter_retries;
extern	int	filter_ping;
extern	int 	filter_not_full;
extern  int 	filter_not_empty;
extern  int	filter_no_cheats;
extern  int	filter_no_password;

extern	int	maxretries;
extern	int	maxsimultaneous;

extern	int	filter_prefs_changed;

extern  char 	*real_quake_dir;
extern  char 	*real_q2_dir;

extern	int set_working_dir (char *dir);
extern	void user_fix_defaults (void);
extern  void preferences_dialog (int page_num);
extern	int fix_qw_player_color (int color);


#endif /* __PREF_H__ */


