# include "stdio.h"
# define U(x) ((x)&0377)
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern unsigned char yytext[];
int yymorfg;
extern unsigned char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
 * parser.l -- lex parser of algebraic chess moves for XBoard
 * $Id: parser.l,v 1.37 1998/06/13 03:27:14 mann Exp $
 *
 * Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
 * Enhancements Copyright 1992-95 Free Software Foundation, Inc.
 *
 * The following terms apply to Digital Equipment Corporation's copyright
 * interest in XBoard:
 * ------------------------------------------------------------------------
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Digital not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * ------------------------------------------------------------------------
 *
 * The following terms apply to the enhanced version of XBoard distributed
 * by the Free Software Foundation:
 * ------------------------------------------------------------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * ------------------------------------------------------------------------
 */

/* This parser handles all forms of promotion.
 * The parser resolves ambiguous moves by searching and check-testing.
 * It also parses comments of the form [anything] or (anything).
 */

#include "config.h"

#define NO_CONSTRAINT	-1
#undef YYLMAX
#define YYLMAX			4096
#define UNPUT_BUF_SIZE		YYLMAX

#ifdef FLEX_SCANNER
/* yytext is probably a char*, but could be a char[].  yy_text is set
   in YY_DECL below, because if yytext is a char*, its value is not
   constant. */
char *yy_text;
#else /*!FLEX_SCANNER*/
/* yytext is definitely a char[], so yy_text can be set here, statically. */
char *yy_text = (char *) yytext;
#endif

#ifdef FLEX_SCANNER
/* This is flex */
#undef YY_INPUT
#define YY_INPUT(buf, result, max_size) my_yy_input(buf, &result, max_size)
#undef YY_DECL
#define YY_DECL                     \
    int _yylex YY_PROTO((void));    \
    int yylex YY_PROTO((void))      \
    {                               \
	int result = _yylex();      \
	yy_text = (char *) yytext;  \
	return(result);             \
    }                               \
    int _yylex YY_PROTO((void))
#else
/* This is lex */
#undef input
#undef output
#undef unput
#endif

/* The includes must be here, below the #undef input */

#include <ctype.h>

#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#else /* not STDC_HEADERS */
# if HAVE_STRING_H
#  include <string.h>
# else /* not HAVE_STRING_H */
#  include <strings.h>
# endif /* not HAVE_STRING_H */
#endif /* not STDC_HEADERS */

#if HAVE_UNISTD_H
# include <unistd.h>
#endif

#if defined(_amigados)
# include <errno.h>
# if HAVE_FCNTL_H
#  include <fcntl.h>    /*  isatty() prototype  */
# endif /*  HAVE_FCNTL_H        */
#endif  /*  defined(_amigados)  */

#include "common.h"
#include "backend.h"
#include "frontend.h"
#include "parser.h"
#include "moves.h"

extern int PosFlags P((int));

extern Board	boards[MAX_MOVES];
int		yyboardindex;
int             yyskipmoves = FALSE;
char		currentMoveString[YYLMAX];
#ifndef FLEX_SCANNER
char		unputBuffer[UNPUT_BUF_SIZE];
int		unputCount = 0;
#endif

#ifdef FLEX_SCANNER
void my_yy_input P((char *buf, int *result, int max_size));
#else /*!FLEX_SCANNER*/
static int input P((void));
static void output P((int ch));
static void unput P((int ch));
int yylook P((void));
int yyback P((int *, int));
#endif
#undef yywrap
int yywrap P((void));
extern void CopyBoard P((Board to, Board from));

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{
    /*
     * Fully-qualified algebraic move, possibly with promotion
     */
    int skip1 = 0, skip2 = 0;
    ChessSquare piece;
    ChessMove result;
    
    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the / */
    if (yytext[1] == '/') skip1 = 1;
    
    /* remove the [xX:-] */
    if ((yytext[3+skip1] == 'x') || (yytext[3+skip1] == 'X') ||
	(yytext[3+skip1] == '-') || (yytext[3+skip1] == ':')) skip2 = 1;
    
    currentMoveString[0] = yytext[1+skip1];
    currentMoveString[1] = yytext[2+skip1];
    currentMoveString[2] = yytext[3+skip1+skip2];
    currentMoveString[3] = yytext[4+skip1+skip2];
    currentMoveString[4] = NULLCHAR;
    
    if (yyleng-skip1-skip2 > 5) {
	if (yytext[yyleng-1] == ')') {
	    currentMoveString[4] = ToLower(yytext[yyleng-2]);
	} else {
	    currentMoveString[4] = ToLower(yytext[yyleng-1]);
	}
	currentMoveString[5] = NULLCHAR;
    }

    piece = boards[yyboardindex]
      [currentMoveString[1] - '1'][currentMoveString[0] - 'a'];
    if (ToLower(yytext[0]) != ToLower(PieceToChar(piece)))
      return (int) IllegalMove;

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 2:
{
    /*
     * Simple algebraic move, possibly with promotion
     */
    int skip = 0;
    ChessMove result;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[2] == 'x') || (yytext[2] == 'X') ||
	(yytext[2] == '-') || (yytext[2] == ':')) skip = 1;

    currentMoveString[0] = yytext[0];
    currentMoveString[1] = yytext[1];
    currentMoveString[2] = yytext[2+skip];
    currentMoveString[3] = yytext[3+skip];
    currentMoveString[4] = NULLCHAR;

    if (yyleng-skip > 4) {
	if (yytext[yyleng-1] == ')') {
	    currentMoveString[4] = ToLower(yytext[yyleng-2]);
	} else {
	    currentMoveString[4] = ToLower(yytext[yyleng-1]);
	}
	currentMoveString[5] = NULLCHAR;
    }

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 3:
{
    /*
     * Pawn move, possibly with promotion
     */
    DisambiguateClosure cl;
    int skip = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the =() */
    if (yytext[2] == '=') skip++;
    if (yytext[2+skip] == '(') skip++;

    cl.pieceIn = WhiteOnMove(yyboardindex) ? WhitePawn : BlackPawn;
    cl.rfIn = -1;
    cl.ffIn = yytext[0] - 'a';
    cl.rtIn = yytext[1] - '1';
    cl.ftIn = yytext[0] - 'a';
    cl.promoCharIn = yytext[2+skip];
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 4:
{
    /*
     * Pawn capture, possibly with promotion, possibly ambiguous
     */
    DisambiguateClosure cl;
    int skip1 = 0, skip2 = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] and =() */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip1 = 1;
    if (yytext[2+skip1] == '=') skip2++;
    if (yytext[2+skip1+skip2] == '(') skip2++;

    cl.pieceIn = WhiteOnMove(yyboardindex) ? WhitePawn : BlackPawn;
    cl.rfIn = -1;
    cl.ffIn = yytext[0] - 'a';
    cl.rtIn = -1;
    cl.ftIn = yytext[1+skip1] - 'a';
    cl.promoCharIn = yytext[2+skip1+skip2];
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 5:
{
    /*
     * unambiguously abbreviated Pawn capture, possibly with promotion
     */
    int skip = 0;
    ChessMove result;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip = 1;

    currentMoveString[0] = yytext[0];
    currentMoveString[2] = yytext[1+skip];
    currentMoveString[3] = yytext[2+skip];
    if (WhiteOnMove(yyboardindex)) {
	if (yytext[2+skip] == '1') return (int) ImpossibleMove;
	currentMoveString[1] = yytext[2+skip] - 1;
    } else {
	if (yytext[2+skip] == '8') return (int) ImpossibleMove;
	currentMoveString[1] = yytext[2+skip] + 1;
    }
    if (yyleng-skip > 3) {
	if (yytext[yyleng-1] == ')')
	  currentMoveString[4] = ToLower(yytext[yyleng-2]);
	else
	  currentMoveString[4] = ToLower(yytext[yyleng-1]);
	currentMoveString[5] = NULLCHAR;
    } else {
	currentMoveString[4] = NULLCHAR;
    }

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    if (result != IllegalMove) return (int) result;

    /* Special case: improperly written en passant capture */
    if (WhiteOnMove(yyboardindex)) {
	if (currentMoveString[3] == '5') {
	    currentMoveString[1] = '5';
	    currentMoveString[3] = '6';
	} else {
	    return (int) IllegalMove;
	}
    } else {
	if (currentMoveString[3] == '4') {
	    currentMoveString[1] = '4';
	    currentMoveString[3] = '3';
	} else {
	    return (int) IllegalMove;
	}
    }

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (result == WhiteCapturesEnPassant || result == BlackCapturesEnPassant)
      return (int) result;
    else
      return (int) IllegalMove;
}
break;
case 6:
 {
    /*
     * piece move, possibly ambiguous
     */
    DisambiguateClosure cl;
    int skip = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip = 1;

    if (WhiteOnMove(yyboardindex)) {
	cl.pieceIn = CharToPiece(ToUpper(yytext[0]));
    } else {
	cl.pieceIn = CharToPiece(ToLower(yytext[0]));
    }
    cl.rfIn = -1;
    cl.ffIn = -1;
    cl.rtIn = yytext[2+skip] - '1';
    cl.ftIn = yytext[1+skip] - 'a';
    cl.promoCharIn = NULLCHAR;
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 7:
{
    /*
     * piece move with rank or file disambiguator
     */
    DisambiguateClosure cl;
    int skip = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[2] == 'x') || (yytext[2] == 'X')
	|| (yytext[2] == ':') || (yytext[2] == '-')) skip = 1;

    if (WhiteOnMove(yyboardindex)) {
	cl.pieceIn = CharToPiece(ToUpper(yytext[0]));
    } else {
	cl.pieceIn = CharToPiece(ToLower(yytext[0]));
    }
    if (isalpha(yytext[1])) {
	cl.rfIn = -1;
	cl.ffIn = yytext[1] - 'a';
    } else {
	cl.rfIn = yytext[1] - '1';
	cl.ffIn = -1;
    }
    cl.rtIn = yytext[3+skip] - '1';
    cl.ftIn = yytext[2+skip] - 'a';
    cl.promoCharIn = NULLCHAR;
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 8:
{
    int rf, ff, rt, ft;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    if (WhiteOnMove(yyboardindex)) {
	if (boards[yyboardindex][0][3] == WhiteKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d1f1");
	    rf = 0;
	    ff = 3;
	    rt = 0;
	    ft = 5;
	} else {
	    strcpy(currentMoveString, "e1c1");
	    rf = 0;
	    ff = 4;
	    rt = 0;
	    ft = 2;
	}
    } else{ 
	if (boards[yyboardindex][7][3] == BlackKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d8f8");
	    rf = 7;
	    ff = 3;
	    rt = 7;
	    ft = 5;
	} else {
	    strcpy(currentMoveString, "e8c8");
	    rf = 7;
	    ff = 4;
	    rt = 7;
	    ft = 2;
	}
    }
    return (int) LegalityTest(boards[yyboardindex],
			      PosFlags(yyboardindex), EP_UNKNOWN,
			      rf, ff, rt, ft, NULLCHAR);
}
break;
case 9:
{
    int rf, ff, rt, ft;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    if (WhiteOnMove(yyboardindex)) {
	if (boards[yyboardindex][0][3] == WhiteKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d1b1");
	    rf = 0;
	    ff = 3;
	    rt = 0;
	    ft = 1;
	} else {
	    strcpy(currentMoveString, "e1g1");
	    rf = 0;
	    ff = 4;
	    rt = 0;
	    ft = 6;
	}
    } else {
	if (boards[yyboardindex][7][3] == BlackKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d8b8");
	    rf = 7;
	    ff = 3;
	    rt = 7;
	    ft = 1;
	} else {
	    strcpy(currentMoveString, "e8g8");
	    rf = 7;
	    ff = 4;
	    rt = 7;
	    ft = 6;
	}
    }
    return (int) LegalityTest(boards[yyboardindex],
			      PosFlags(yyboardindex), EP_UNKNOWN,
			      rf, ff, rt, ft, NULLCHAR);
}
break;
case 10:
{
    /* Bughouse piece drop.  No legality checking for now. */
    currentMoveString[1] = '@';
    currentMoveString[2] = yytext[2];
    currentMoveString[3] = yytext[3];
    currentMoveString[4] = NULLCHAR;
    if (WhiteOnMove(yyboardindex)) {
	currentMoveString[0] = ToUpper(yytext[0]);
	return (int) WhiteDrop;
    } else {
	currentMoveString[0] = ToLower(yytext[0]);
	return (int) BlackDrop;
    }
}
break;
case 11:
 {
    if (WhiteOnMove(yyboardindex))
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 12:
 {
    return (int) (ToUpper(yytext[0]) == 'W' ? BlackWins : WhiteWins);
}
break;
case 13:
 {
    return (int) GameUnfinished;
}
break;
case 14:
 {
    return (int) GameIsDrawn;
}
break;
case 15:
 {
    return (int) GameIsDrawn;
}
break;
case 16:
{
    if (WhiteOnMove(yyboardindex))
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 17:
 {
    if (WhiteOnMove(yyboardindex))
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 18:
 {
    return (int) GameIsDrawn;
}
break;
case 19:
 {
    return (int) GameIsDrawn;
}
break;
case 20:
 {
    return (int) (ToUpper(yytext[0]) == 'W' ? WhiteWins : BlackWins);
}
break;
case 21:
 {
    return (int) (ToUpper(yytext[0]) == 'W' ? BlackWins : WhiteWins);
}
break;
case 22:
{ 
    return (int) WhiteWins;
}
break;
case 23:
{ 
    return (int) BlackWins;
}
break;
case 24:
{
    return (int) GameIsDrawn;
}
break;
case 25:
{
    return (int) GameUnfinished;
}
break;
case 26:
   {
    /* move numbers */
    if ((yyleng == 1) && (yytext[0] == '1'))
      return (int) MoveNumberOne;
}
break;
case 27:
{
    /* elapsed time indication, e.g. (0:12) */ 
    return (int) ElapsedTime;
}
break;
case 28:
{
    /* position diagram enclosed in [-- --] */
    return (int) PositionDiagram;
}
break;
case 29:
{
    /* position diagram enclosed in {-- --} */
    return (int) PositionDiagram;
}
break;
case 30:
{
    return (int) PGNTag;
}
break;
case 31:
{
    return (int) GNUChessGame;
}
break;
case 32:
{
    return (int) XBoardGame;
}
break;
case 33:
{				/* numeric annotation glyph */
    return (int) NAG;
}
break;
case 34:
{        			/* anything in {} */
    return (int) Comment; 
}
break;
case 35:
{                                          /* ; to end of line */
    return (int) Comment;
}
break;
case 36:
{        			/* anything in [] */
    return (int) Comment; 
}
break;
case 37:
 { 	  	/* nested () */
    return (int) Comment; 
}
break;
case 38:
  { 				/* >=2 chars in () */
    return (int) Comment; 
}
break;
case 39:
 {
        /* Skip mail headers */
}
break;
case 40:
		{
        /* Skip random words */
}
break;
case 41:
			{
        /* Skip everything else */
}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */


static char *StringToLex;

#ifndef FLEX_SCANNER
static FILE *lexFP;

static int input()
{
    int ret;
    
    if (StringToLex != NULL) {
	ret = *StringToLex;
	if (ret == NULLCHAR)
	  ret = EOF;
	else
	  StringToLex++;
    } else if (unputCount > 0) {
	ret = unputBuffer[--unputCount];
    } else {
	ret = fgetc(lexFP);
    }    

    if (ret == EOF) 
      return 0;
    else
      return ret;
}

/*
 * Return offset of next pattern within current file
 */
int yyoffset()
{
    int offset = ftell(lexFP) - unputCount;

    if (offset < 0) {
	offset = 0;
    }
    return(offset);
}
 
static void output(ch)
     int ch;
{
    fprintf(stderr, "PARSER BUG: unmatched character '%c' (0%o)\n",
	    ch, ch);
}

static void unput(ch)
     int ch;
{
    if (ch == 0) return;
    if (StringToLex != NULL) {
	StringToLex--;
    } else {
	if (unputCount >= UNPUT_BUF_SIZE)
	  fprintf(stderr, "PARSER BUG: unput buffer overflow '%c' (0%o)\n",
		  ch, ch);
	unputBuffer[unputCount++] = ch;
    }
}

/* Get ready to lex from a new file.  Kludge below sticks
   an artificial newline at the front of the file, which the
   above grammar ignores, but which makes ^ at start of pattern
   match at the real start of the file.
*/
void yynewfile(f)
     FILE *f;
{
    lexFP = f;
    StringToLex = NULL;
    unputCount = 0;
    unput('\n'); /* kludge */
}

/* Get ready to lex from a string.  ^ at start of pattern WON'T
   match at the start of the string!
*/
void yynewstr(s)
     char *s;
{
    lexFP = NULL;
    StringToLex = s;
    unputCount = 0;
}
#endif /*!FLEX_SCANNER*/

#ifdef FLEX_SCANNER
void my_yy_input(buf, result, max_size)
     char *buf;
     int *result;
     int max_size;
{
    int count;

    if (StringToLex != NULL) {
	count = 0;
	while (*StringToLex != NULLCHAR) {
	    *buf++ = *StringToLex++;
	    count++;
	}
	*result = count;
	return;
    } else {
	count = fread(buf, 1, max_size, yyin);
	if (count == 0) {
	    *result = YY_NULL;
	} else {
	    *result = count;
	}
	return;
    }    
}

static YY_BUFFER_STATE my_file_buffer = NULL;

/*
    Return offset of next pattern in the current file.
*/
int yyoffset()
{
    int pos = yy_c_buf_p - yy_current_buffer->yy_ch_buf;

    return(ftell(yy_current_buffer->yy_input_file) -
         yy_n_chars + pos);
}


void yynewstr(s)
     char *s;
{
    if (my_file_buffer != NULL)
      yy_delete_buffer(my_file_buffer);
    StringToLex = s;
    my_file_buffer = yy_create_buffer(stdin, YY_BUF_SIZE);
    yy_switch_to_buffer(my_file_buffer);
}

void yynewfile(f)
     FILE *f;
{
    if (my_file_buffer != NULL)
      yy_delete_buffer(my_file_buffer);
    StringToLex = NULL;
    my_file_buffer = yy_create_buffer(f, YY_BUF_SIZE);
    yy_switch_to_buffer(my_file_buffer);
}
#endif /*FLEX_SCANNER*/

int yywrap()
{
    return TRUE;
}

/* Parse a move from the given string s */
/* ^ at start of pattern WON'T work here unless using flex */
ChessMove yylexstr(boardIndex, s)
     int boardIndex;
     char *s;
{
    ChessMove ret;
    char *oldStringToLex;
#ifdef FLEX_SCANNER
    YY_BUFFER_STATE buffer, oldBuffer;
#endif
    
    yyboardindex = boardIndex;
    oldStringToLex = StringToLex;
    StringToLex = s;
#ifdef FLEX_SCANNER
    buffer = yy_create_buffer(stdin, YY_BUF_SIZE);
    oldBuffer = YY_CURRENT_BUFFER;
    yy_switch_to_buffer(buffer);
#endif /*FLEX_SCANNER*/

    ret = (ChessMove) yylex();

#ifdef FLEX_SCANNER
    if (oldBuffer != NULL) 
      yy_switch_to_buffer(oldBuffer);
    yy_delete_buffer(buffer);
#endif /*FLEX_SCANNER*/
    StringToLex = oldStringToLex;

    return ret;
}
int yyvstop[] = {
0,

41,
0,

41,
0,

41,
0,

40,
41,
0,

41,
0,

25,
41,
0,

41,
0,

40,
41,
0,

40,
41,
-26,
0,

40,
41,
-26,
0,

41,
-35,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

41,
0,

41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
-26,
0,

40,
41,
-26,
0,

41,
-35,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

40,
41,
0,

41,
0,

33,
0,

40,
0,

17,
0,

40,
0,

9,
40,
0,

40,
0,

40,
-26,
0,

26,
40,
0,

-35,
0,

35,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

36,
0,

40,
0,

3,
40,
0,

40,
0,

40,
0,

4,
40,
0,

40,
0,

3,
40,
0,

40,
0,

4,
40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

34,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
-26,
0,

26,
40,
0,

-35,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

3,
40,
0,

40,
0,

40,
0,

4,
40,
0,

40,
0,

3,
40,
0,

40,
0,

4,
40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

15,
0,

9,
40,
0,

23,
40,
0,

23,
0,

8,
40,
0,

26,
0,

22,
40,
0,

22,
0,

24,
0,

40,
0,

40,
0,

40,
0,

6,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

20,
40,
0,

4,
40,
0,

40,
0,

3,
40,
0,

40,
0,

3,
40,
0,

4,
0,

5,
40,
0,

4,
40,
0,

4,
40,
0,

40,
0,

40,
0,

3,
40,
0,

4,
0,

4,
40,
0,

5,
6,
40,
0,

4,
40,
0,

9,
40,
0,

34,
0,

39,
0,

9,
40,
0,

23,
40,
0,

8,
40,
0,

22,
40,
0,

35,
0,

-35,
0,

40,
0,

40,
0,

40,
0,

6,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

9,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

20,
40,
0,

4,
40,
0,

40,
0,

3,
40,
0,

40,
0,

3,
40,
0,

5,
40,
0,

4,
40,
0,

4,
40,
0,

40,
0,

40,
0,

3,
40,
0,

4,
40,
0,

5,
6,
40,
0,

4,
40,
0,

9,
40,
0,

38,
0,

38,
0,

37,
0,

25,
0,

25,
0,

40,
0,

6,
40,
0,

7,
40,
0,

6,
0,

10,
0,

40,
0,

40,
0,

40,
0,

40,
0,

19,
40,
0,

40,
0,

21,
40,
0,

16,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

20,
0,

20,
40,
0,

36,
0,

3,
0,

3,
0,

2,
40,
0,

5,
0,

4,
0,

5,
40,
0,

4,
0,

2,
7,
40,
0,

5,
6,
0,

5,
6,
40,
0,

5,
40,
0,

40,
0,

25,
0,

40,
0,

-35,
0,

-35,
0,

6,
40,
0,

7,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

19,
40,
0,

40,
0,

21,
40,
0,

16,
40,
0,

40,
0,

40,
0,

40,
0,

40,
0,

20,
40,
0,

20,
0,

2,
40,
0,

5,
40,
0,

2,
7,
40,
0,

5,
6,
40,
0,

5,
40,
0,

40,
0,

7,
0,

1,
40,
0,

40,
0,

40,
0,

19,
40,
0,

40,
0,

40,
0,

21,
0,

21,
40,
0,

40,
0,

40,
0,

30,
36,
0,

2,
0,

2,
40,
0,

5,
0,

5,
0,

2,
7,
0,

39,
0,

-35,
0,

-35,
0,

1,
40,
0,

40,
0,

40,
0,

19,
40,
0,

40,
0,

40,
0,

21,
40,
0,

21,
0,

40,
0,

40,
0,

20,
39,
0,

2,
40,
0,

27,
38,
0,

23,
0,

23,
0,

22,
0,

22,
0,

24,
0,

24,
0,

20,
21,
0,

1,
0,

1,
40,
0,

40,
0,

40,
0,

40,
0,

11,
40,
0,

40,
0,

28,
36,
0,

30,
0,

2,
0,

2,
0,

27,
34,
0,

39,
0,

-35,
0,

-35,
0,

1,
40,
0,

40,
0,

40,
0,

40,
0,

21,
39,
0,

11,
40,
0,

40,
0,

18,
0,

24,
0,

20,
21,
0,

1,
0,

1,
0,

19,
0,

40,
0,

40,
0,

40,
0,

11,
40,
0,

40,
0,

-35,
0,

-35,
0,

40,
0,

40,
0,

40,
0,

11,
40,
0,

40,
0,

12,
0,

40,
0,

40,
0,

-35,
0,

-35,
0,

40,
0,

40,
0,

12,
0,

40,
0,

14,
40,
0,

-35,
0,

-35,
0,

40,
0,

14,
40,
0,

40,
0,

40,
0,

-35,
0,

-35,
0,

39,
0,

40,
0,

40,
0,

40,
0,

40,
0,

-35,
0,

-35,
0,

39,
0,

40,
0,

40,
0,

31,
40,
0,

-32,
0,

-32,
-35,
0,

-35,
0,

39,
0,

39,
0,

31,
40,
0,

13,
0,

31,
0,

32,
0,

32,
35,
0,

-35,
0,

39,
0,

39,
0,

-35,
0,

31,
39,
0,

-35,
0,

34,
-29,
0,

29,
0,
0};
# define YYTYPE unsigned short
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,3,	1,3,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,4,	0,0,	1,3,	
1,3,	1,5,	1,3,	0,0,	
1,6,	1,7,	1,3,	1,8,	
1,9,	0,0,	1,6,	1,3,	
1,3,	1,10,	1,11,	1,12,	
1,12,	1,12,	1,12,	1,12,	
1,12,	1,12,	1,12,	1,3,	
1,13,	8,73,	1,3,	9,74,	
38,135,	9,75,	1,6,	1,14,	
1,15,	1,16,	1,6,	1,6,	
1,17,	43,145,	66,179,	4,67,	
1,18,	1,19,	1,20,	1,21,	
1,22,	1,23,	75,189,	1,24,	
1,25,	78,195,	73,187,	79,196,	
1,26,	1,6,	36,129,	83,201,	
1,27,	86,202,	1,3,	10,76,	
1,3,	104,222,	1,28,	1,29,	
1,30,	1,31,	1,32,	1,33,	
1,34,	1,35,	1,6,	4,67,	
10,77,	17,100,	10,78,	10,79,	
1,36,	20,103,	50,156,	47,153,	
1,25,	1,6,	2,38,	2,5,	
2,38,	10,80,	15,98,	22,104,	
1,37,	2,8,	1,3,	19,102,	
2,39,	16,99,	25,108,	2,40,	
2,41,	2,42,	2,42,	2,42,	
2,42,	2,42,	2,42,	2,42,	
2,42,	17,101,	2,43,	45,151,	
2,3,	46,152,	26,90,	47,154,	
2,39,	2,44,	2,45,	2,46,	
2,39,	2,39,	2,47,	49,155,	
36,130,	22,105,	2,48,	2,49,	
2,50,	2,51,	2,52,	2,53,	
55,161,	2,54,	2,55,	52,157,	
67,180,	73,188,	2,56,	2,39,	
65,177,	84,202,	2,27,	84,203,	
40,76,	76,190,	2,3,	76,191,	
2,57,	2,58,	2,59,	2,60,	
2,61,	2,62,	2,63,	2,64,	
2,39,	40,138,	76,192,	40,78,	
40,139,	97,216,	2,65,	77,193,	
77,194,	98,217,	2,55,	2,39,	
99,218,	52,158,	40,140,	100,219,	
101,219,	102,220,	2,66,	5,68,	
5,68,	5,68,	5,68,	5,68,	
5,68,	5,68,	5,68,	5,68,	
5,68,	6,69,	26,109,	26,110,	
103,221,	105,196,	108,225,	6,69,	
109,226,	26,110,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
110,227,	112,111,	65,178,	56,90,	
129,253,	130,196,	133,255,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	134,256,	137,258,	138,259,	
138,260,	139,261,	141,262,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	6,69,	6,69,	6,69,	
6,69,	7,70,	82,198,	140,258,	
82,199,	143,258,	72,0,	131,131,	
131,131,	7,70,	7,70,	56,162,	
56,163,	72,185,	72,185,	82,200,	
131,131,	148,258,	56,163,	150,270,	
140,195,	143,202,	72,185,	72,186,	
91,208,	91,208,	91,208,	91,208,	
91,208,	91,208,	91,208,	91,208,	
7,70,	151,271,	7,70,	7,70,	
152,272,	7,70,	153,273,	7,70,	
7,71,	7,0,	154,273,	7,70,	
155,274,	7,70,	7,70,	7,70,	
7,72,	7,72,	156,275,	157,276,	
158,261,	161,279,	162,280,	163,281,	
166,258,	7,72,	7,70,	172,258,	
177,298,	178,261,	180,300,	181,301,	
182,302,	7,70,	7,70,	7,70,	
7,70,	7,70,	7,70,	7,70,	
190,309,	191,310,	192,311,	7,70,	
7,70,	7,70,	7,70,	7,70,	
7,70,	193,312,	7,70,	7,70,	
194,313,	195,313,	198,314,	7,70,	
7,70,	199,315,	11,81,	11,81,	
200,316,	7,70,	201,317,	202,317,	
204,320,	7,70,	7,70,	7,70,	
7,70,	7,70,	7,70,	7,70,	
7,70,	7,70,	205,321,	206,322,	
90,204,	207,323,	90,205,	7,70,	
216,333,	11,82,	217,334,	7,70,	
7,70,	90,206,	218,335,	221,339,	
222,340,	224,341,	90,207,	225,342,	
226,343,	7,70,	11,83,	11,81,	
11,84,	11,85,	11,85,	11,85,	
11,85,	11,85,	11,85,	11,85,	
11,85,	11,85,	11,85,	11,86,	
90,204,	179,299,	90,205,	235,232,	
179,131,	179,131,	236,351,	11,87,	
242,241,	90,206,	185,301,	243,358,	
253,364,	179,131,	90,207,	220,338,	
11,87,	185,185,	185,185,	11,87,	
11,87,	11,87,	11,87,	11,87,	
12,81,	12,81,	185,185,	185,186,	
256,366,	220,338,	220,338,	259,372,	
23,92,	203,318,	256,367,	256,368,	
260,313,	262,317,	11,87,	11,87,	
11,87,	11,87,	11,87,	11,87,	
11,87,	11,87,	203,319,	12,81,	
11,87,	23,95,	267,258,	11,87,	
11,87,	11,87,	11,87,	11,87,	
219,336,	270,380,	271,381,	203,319,	
272,382,	12,81,	275,385,	12,85,	
12,85,	12,85,	12,85,	12,85,	
12,85,	12,85,	12,85,	12,85,	
12,85,	92,209,	92,209,	92,209,	
92,209,	92,209,	92,209,	92,209,	
92,209,	12,87,	23,106,	23,106,	
23,106,	23,106,	23,106,	23,106,	
23,106,	23,106,	12,87,	219,337,	
276,386,	12,87,	12,87,	12,87,	
12,87,	12,87,	278,387,	13,88,	
255,365,	255,365,	257,369,	279,388,	
280,389,	284,258,	274,384,	13,88,	
13,89,	255,365,	285,351,	257,370,	
12,87,	12,87,	12,87,	12,87,	
12,87,	12,87,	12,87,	12,87,	
274,384,	274,384,	12,87,	219,337,	
289,358,	12,87,	12,87,	12,87,	
12,87,	12,87,	13,88,	264,373,	
13,88,	13,88,	292,258,	13,88,	
298,397,	13,88,	13,88,	13,88,	
264,374,	13,88,	186,301,	13,88,	
13,88,	13,88,	13,88,	13,88,	
273,336,	186,306,	186,306,	300,399,	
303,0,	307,0,	306,301,	13,88,	
13,88,	308,0,	186,306,	312,196,	
313,401,	306,400,	306,400,	13,88,	
13,88,	13,88,	13,88,	13,88,	
13,88,	13,88,	306,400,	319,407,	
320,409,	13,88,	13,88,	13,88,	
13,88,	13,88,	13,88,	317,403,	
13,88,	13,88,	321,410,	273,383,	
322,411,	13,88,	13,88,	323,412,	
319,408,	333,416,	334,417,	13,88,	
340,196,	341,425,	342,426,	13,88,	
13,88,	13,88,	13,88,	13,88,	
13,88,	13,88,	13,88,	13,88,	
335,418,	343,416,	336,420,	14,90,	
337,421,	13,88,	345,0,	114,229,	
114,229,	13,88,	13,88,	273,383,	
349,351,	354,358,	356,355,	357,436,	
14,91,	364,196,	14,92,	13,88,	
14,93,	14,93,	14,93,	14,93,	
14,93,	14,93,	14,93,	14,93,	
369,442,	14,94,	114,229,	370,443,	
114,230,	114,114,	336,420,	14,95,	
337,422,	372,261,	373,445,	313,402,	
18,91,	114,114,	18,92,	114,114,	
18,93,	18,93,	18,93,	18,93,	
18,93,	18,93,	18,93,	18,93,	
374,446,	18,94,	378,258,	380,448,	
381,449,	386,261,	317,404,	14,91,	
94,213,	94,213,	94,213,	94,213,	
94,213,	94,213,	94,213,	94,213,	
14,96,	14,96,	14,96,	14,96,	
14,96,	14,96,	14,96,	14,96,	
387,455,	299,398,	335,419,	14,97,	
299,131,	299,131,	388,456,	18,91,	
383,451,	389,448,	382,418,	393,436,	
367,76,	299,131,	397,261,	14,91,	
18,96,	18,96,	18,96,	18,96,	
18,96,	18,96,	18,96,	18,96,	
21,91,	367,439,	21,92,	367,78,	
21,93,	21,93,	21,93,	21,93,	
21,93,	21,93,	21,93,	21,93,	
399,460,	21,94,	367,80,	18,91,	
383,452,	400,461,	407,408,	21,95,	
409,470,	318,405,	371,444,	410,471,	
411,472,	24,91,	318,319,	24,92,	
412,473,	24,93,	24,93,	24,93,	
24,93,	24,93,	24,93,	24,93,	
24,93,	416,90,	24,94,	318,319,	
365,438,	365,438,	417,478,	21,91,	
24,95,	371,444,	408,468,	368,440,	
419,418,	365,438,	421,484,	422,485,	
21,96,	21,96,	21,96,	21,96,	
21,96,	21,96,	21,96,	21,96,	
368,441,	408,469,	368,84,	27,111,	
382,450,	424,0,	420,482,	425,486,	
24,91,	426,487,	433,432,	27,112,	
27,112,	368,86,	417,478,	21,91,	
434,491,	24,96,	24,96,	24,96,	
24,96,	24,107,	24,96,	24,96,	
24,96,	95,214,	95,214,	95,214,	
95,214,	95,214,	95,214,	95,214,	
95,214,	435,436,	27,112,	442,493,	
27,111,	27,111,	420,483,	27,111,	
24,91,	27,111,	27,111,	27,111,	
318,406,	27,111,	443,494,	27,113,	
27,111,	27,111,	27,114,	27,114,	
398,459,	445,496,	446,497,	398,131,	
398,131,	448,90,	450,418,	27,114,	
27,111,	440,198,	449,499,	440,199,	
398,131,	451,500,	452,501,	27,114,	
27,114,	27,114,	27,114,	27,114,	
27,114,	27,114,	440,200,	430,430,	
430,430,	27,114,	27,114,	27,114,	
27,114,	27,114,	27,114,	455,503,	
27,114,	27,114,	456,504,	458,491,	
460,506,	27,114,	27,114,	462,0,	
463,0,	464,0,	449,499,	27,115,	
424,424,	460,507,	430,430,	27,114,	
27,114,	27,114,	27,114,	27,114,	
27,114,	27,114,	27,114,	27,114,	
465,0,	466,0,	424,424,	424,424,	
467,0,	27,114,	468,508,	28,116,	
469,509,	27,114,	27,114,	28,117,	
28,117,	28,117,	28,117,	28,117,	
28,117,	28,117,	28,117,	27,111,	
28,118,	29,90,	106,223,	106,223,	
106,223,	106,223,	106,223,	106,223,	
106,223,	106,223,	470,510,	471,511,	
472,512,	473,514,	29,122,	476,475,	
29,92,	477,516,	29,123,	29,123,	
29,123,	29,123,	29,123,	29,123,	
29,123,	29,123,	472,513,	29,124,	
478,103,	480,518,	28,119,	430,489,	
481,519,	29,95,	482,520,	483,521,	
484,522,	485,523,	487,526,	28,120,	
28,121,	28,120,	28,120,	28,120,	
28,120,	28,120,	28,120,	116,231,	
116,231,	116,231,	116,231,	116,231,	
116,231,	116,231,	116,231,	490,491,	
493,527,	29,125,	494,528,	496,529,	
497,530,	486,524,	28,119,	498,516,	
499,156,	500,531,	29,126,	29,127,	
29,126,	29,127,	29,127,	29,127,	
29,127,	29,127,	30,116,	486,525,	
501,532,	29,97,	30,117,	30,117,	
30,117,	30,117,	30,117,	30,117,	
30,117,	30,117,	503,533,	30,118,	
504,535,	29,125,	118,239,	118,239,	
118,239,	118,239,	118,239,	118,239,	
118,239,	118,239,	31,116,	507,537,	
503,534,	508,538,	31,117,	31,117,	
31,117,	31,117,	31,117,	31,117,	
31,117,	31,117,	509,539,	31,118,	
510,540,	511,541,	512,513,	514,542,	
515,516,	30,119,	119,121,	119,121,	
119,121,	119,121,	119,121,	119,121,	
119,121,	119,121,	30,120,	30,121,	
30,120,	30,121,	30,120,	30,120,	
30,120,	30,128,	438,131,	438,131,	
459,505,	517,0,	518,543,	459,131,	
459,131,	31,119,	519,544,	438,131,	
520,545,	521,546,	522,547,	523,547,	
459,131,	30,119,	31,120,	31,120,	
31,121,	31,120,	31,121,	31,120,	
31,120,	31,120,	120,240,	120,240,	
120,240,	120,240,	120,240,	120,240,	
120,240,	120,240,	524,525,	31,99,	
526,548,	527,549,	32,116,	528,550,	
529,551,	31,119,	32,117,	32,117,	
32,117,	32,117,	32,117,	32,117,	
32,117,	32,117,	530,552,	32,118,	
122,244,	122,244,	122,244,	122,244,	
122,244,	122,244,	122,244,	122,244,	
531,553,	532,553,	33,116,	533,534,	
535,554,	537,556,	33,117,	33,117,	
33,117,	33,117,	33,117,	33,117,	
33,117,	33,117,	505,536,	33,118,	
540,557,	505,131,	505,131,	438,492,	
541,542,	32,119,	543,560,	545,561,	
546,561,	539,405,	505,131,	548,563,	
549,564,	53,92,	32,120,	32,120,	
32,120,	32,121,	32,120,	32,121,	
32,120,	32,120,	536,555,	550,565,	
551,566,	536,131,	536,131,	552,567,	
544,480,	33,119,	53,95,	554,570,	
556,506,	418,479,	536,131,	542,558,	
557,572,	32,119,	33,120,	33,120,	
33,120,	33,120,	33,121,	33,120,	
33,121,	33,120,	34,116,	558,559,	
560,573,	542,559,	34,117,	34,117,	
34,117,	34,117,	34,117,	34,117,	
34,117,	34,117,	564,577,	34,118,	
544,480,	33,119,	565,578,	53,159,	
53,159,	53,159,	53,159,	53,159,	
53,159,	53,159,	53,159,	562,0,	
566,579,	567,580,	572,585,	418,480,	
573,586,	35,116,	577,591,	34,100,	
578,592,	35,117,	35,117,	35,117,	
35,117,	35,117,	35,117,	35,117,	
35,117,	34,119,	35,118,	418,481,	
539,406,	575,0,	576,0,	579,593,	
580,594,	585,599,	34,120,	34,120,	
34,120,	34,120,	34,120,	34,121,	
34,120,	34,121,	586,600,	418,480,	
590,0,	37,131,	555,571,	34,101,	
571,584,	555,131,	555,131,	571,131,	
571,131,	37,131,	37,132,	591,604,	
35,119,	34,119,	555,131,	592,605,	
571,131,	593,606,	562,575,	594,607,	
600,614,	35,120,	35,120,	35,120,	
35,120,	35,120,	35,120,	35,121,	
35,120,	603,0,	605,617,	607,619,	
37,131,	612,613,	37,131,	37,131,	
614,623,	37,131,	617,624,	37,131,	
37,131,	37,131,	599,612,	37,131,	
35,119,	37,131,	37,131,	37,131,	
37,133,	37,133,	562,576,	584,598,	
575,589,	619,625,	584,131,	584,131,	
599,613,	37,133,	37,131,	623,506,	
609,581,	624,628,	625,629,	584,131,	
629,606,	37,131,	37,131,	37,131,	
37,131,	37,131,	37,131,	37,131,	
632,633,	633,634,	630,631,	37,131,	
37,131,	37,131,	37,131,	37,131,	
37,131,	634,635,	37,131,	37,131,	
575,547,	576,590,	635,636,	37,131,	
37,131,	636,637,	637,638,	590,603,	
609,621,	37,131,	638,639,	639,640,	
640,641,	37,131,	37,131,	37,131,	
37,131,	37,131,	37,131,	37,131,	
37,131,	37,131,	598,611,	641,642,	
642,643,	598,131,	598,131,	37,131,	
630,131,	630,131,	643,644,	37,131,	
37,131,	39,69,	598,131,	644,645,	
645,646,	630,131,	646,647,	39,136,	
647,648,	37,134,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,137,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	39,136,	39,136,	39,136,	
39,136,	41,81,	41,81,	124,249,	
124,249,	124,249,	124,249,	124,249,	
124,249,	124,249,	124,249,	125,250,	
125,250,	125,250,	125,250,	125,250,	
125,250,	125,250,	125,250,	0,0,	
0,0,	0,0,	0,0,	0,0,	
41,82,	128,240,	128,240,	128,240,	
128,240,	128,240,	128,240,	128,240,	
128,240,	0,0,	0,0,	0,0,	
0,0,	41,141,	41,81,	41,84,	
41,142,	41,142,	41,142,	41,142,	
41,142,	41,142,	41,142,	41,142,	
41,142,	41,142,	41,143,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	41,144,	146,265,	
146,265,	146,265,	146,265,	146,265,	
146,265,	146,265,	146,265,	41,144,	
0,0,	0,0,	41,144,	41,144,	
41,144,	41,144,	41,144,	42,81,	
42,81,	128,217,	159,277,	159,277,	
159,277,	159,277,	159,277,	159,277,	
159,277,	159,277,	0,0,	0,0,	
0,0,	41,144,	41,144,	41,144,	
41,144,	41,144,	41,144,	41,144,	
41,144,	93,210,	42,81,	41,144,	
0,0,	0,0,	41,144,	41,144,	
41,144,	41,144,	41,144,	0,0,	
0,0,	0,0,	93,211,	0,0,	
42,81,	0,0,	42,142,	42,142,	
42,142,	42,142,	42,142,	42,142,	
42,142,	42,142,	42,142,	42,142,	
164,282,	164,282,	164,282,	164,282,	
164,282,	164,282,	164,282,	164,282,	
42,144,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
93,210,	42,144,	0,0,	0,0,	
42,144,	42,144,	42,144,	42,144,	
42,144,	93,212,	93,212,	93,212,	
93,212,	93,212,	93,212,	93,212,	
93,212,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	42,144,	
42,144,	42,144,	42,144,	42,144,	
42,144,	42,144,	42,144,	44,90,	
93,210,	42,144,	0,0,	0,0,	
42,144,	42,144,	42,144,	42,144,	
42,144,	0,0,	0,0,	0,0,	
44,146,	0,0,	44,92,	0,0,	
44,147,	44,147,	44,147,	44,147,	
44,147,	44,147,	44,147,	44,147,	
0,0,	44,148,	0,0,	0,0,	
0,0,	0,0,	0,0,	44,95,	
0,0,	0,0,	0,0,	0,0,	
48,146,	0,0,	48,92,	0,0,	
48,147,	48,147,	48,147,	48,147,	
48,147,	48,147,	48,147,	48,147,	
0,0,	48,148,	0,0,	0,0,	
0,0,	0,0,	0,0,	44,146,	
167,169,	167,169,	167,169,	167,169,	
167,169,	167,169,	167,169,	167,169,	
44,149,	44,149,	44,149,	44,149,	
44,149,	44,149,	44,149,	44,149,	
0,0,	611,622,	0,0,	44,150,	
611,131,	611,131,	0,0,	48,146,	
0,0,	0,0,	0,0,	0,0,	
0,0,	611,131,	0,0,	44,146,	
48,149,	48,149,	48,149,	48,149,	
48,149,	48,149,	48,149,	48,149,	
51,146,	0,0,	51,92,	0,0,	
51,147,	51,147,	51,147,	51,147,	
51,147,	51,147,	51,147,	51,147,	
0,0,	51,148,	622,627,	48,146,	
0,0,	622,131,	622,131,	51,95,	
0,0,	0,0,	0,0,	0,0,	
0,0,	54,146,	622,131,	54,92,	
0,0,	54,147,	54,147,	54,147,	
54,147,	54,147,	54,147,	54,147,	
54,147,	627,630,	54,148,	0,0,	
627,131,	627,131,	0,0,	51,146,	
54,95,	0,0,	0,0,	0,0,	
0,0,	627,131,	0,0,	0,0,	
51,149,	51,149,	51,149,	51,149,	
51,149,	51,149,	51,149,	51,149,	
168,288,	168,288,	168,288,	168,288,	
168,288,	168,288,	168,288,	168,288,	
54,146,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	51,146,	
0,0,	54,149,	54,149,	54,149,	
54,149,	54,160,	54,149,	54,149,	
54,149,	57,164,	0,0,	0,0,	
0,0,	57,165,	57,165,	57,165,	
57,165,	57,165,	57,165,	57,165,	
57,165,	58,90,	57,166,	0,0,	
54,146,	170,290,	170,290,	170,290,	
170,290,	170,290,	170,290,	170,290,	
170,290,	0,0,	58,170,	0,0,	
58,92,	0,0,	58,171,	58,171,	
58,171,	58,171,	58,171,	58,171,	
58,171,	58,171,	0,0,	58,172,	
0,0,	0,0,	0,0,	0,0,	
57,167,	58,95,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	57,168,	57,169,	57,168,	
57,168,	57,168,	57,168,	57,168,	
57,168,	173,295,	173,295,	173,295,	
173,295,	173,295,	173,295,	173,295,	
173,295,	58,173,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
57,167,	0,0,	58,174,	58,175,	
58,174,	58,175,	58,175,	58,175,	
58,175,	58,175,	59,164,	0,0,	
0,0,	58,150,	59,165,	59,165,	
59,165,	59,165,	59,165,	59,165,	
59,165,	59,165,	0,0,	59,166,	
0,0,	58,173,	176,288,	176,288,	
176,288,	176,288,	176,288,	176,288,	
176,288,	176,288,	60,164,	0,0,	
0,0,	0,0,	60,165,	60,165,	
60,165,	60,165,	60,165,	60,165,	
60,165,	60,165,	0,0,	60,166,	
0,0,	0,0,	0,0,	0,0,	
0,0,	59,167,	208,324,	208,324,	
208,324,	208,324,	208,324,	208,324,	
208,324,	208,324,	59,168,	59,169,	
59,168,	59,169,	59,168,	59,168,	
59,168,	59,176,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	60,167,	176,271,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	59,167,	60,168,	60,168,	
60,169,	60,168,	60,169,	60,168,	
60,168,	60,168,	209,325,	209,325,	
209,325,	209,325,	209,325,	209,325,	
209,325,	209,325,	0,0,	60,152,	
0,0,	0,0,	61,164,	0,0,	
0,0,	60,167,	61,165,	61,165,	
61,165,	61,165,	61,165,	61,165,	
61,165,	61,165,	0,0,	61,166,	
210,212,	210,212,	210,212,	210,212,	
210,212,	210,212,	210,212,	210,212,	
0,0,	0,0,	62,164,	0,0,	
0,0,	0,0,	62,165,	62,165,	
62,165,	62,165,	62,165,	62,165,	
62,165,	62,165,	0,0,	62,166,	
0,0,	0,0,	0,0,	0,0,	
0,0,	61,167,	211,326,	211,326,	
211,326,	211,326,	211,326,	211,326,	
211,326,	211,326,	61,168,	61,168,	
61,168,	61,169,	61,168,	61,169,	
61,168,	61,168,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	62,167,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	61,167,	62,168,	62,168,	
62,168,	62,168,	62,169,	62,168,	
62,169,	62,168,	63,164,	0,0,	
0,0,	0,0,	63,165,	63,165,	
63,165,	63,165,	63,165,	63,165,	
63,165,	63,165,	0,0,	63,166,	
0,0,	62,167,	212,327,	212,327,	
212,327,	212,327,	212,327,	212,327,	
212,327,	212,327,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	64,164,	0,0,	63,153,	
0,0,	64,165,	64,165,	64,165,	
64,165,	64,165,	64,165,	64,165,	
64,165,	63,167,	64,166,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	63,168,	63,168,	
63,168,	63,168,	63,168,	63,169,	
63,168,	63,169,	0,0,	0,0,	
0,0,	70,181,	0,0,	63,154,	
0,0,	0,0,	0,0,	0,0,	
0,0,	70,181,	70,181,	0,0,	
64,167,	63,167,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	64,168,	64,168,	64,168,	
64,168,	64,168,	64,168,	64,169,	
64,168,	0,0,	0,0,	0,0,	
70,181,	0,0,	70,181,	70,181,	
0,0,	70,181,	0,0,	70,181,	
70,182,	70,0,	0,0,	70,181,	
64,167,	70,181,	70,181,	70,181,	
70,181,	70,181,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	70,181,	70,181,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	70,181,	70,181,	70,181,	
70,181,	70,181,	70,181,	70,181,	
0,0,	0,0,	0,0,	70,181,	
70,181,	70,181,	70,181,	70,181,	
70,181,	0,0,	70,181,	70,181,	
0,0,	0,0,	0,0,	70,181,	
70,181,	0,0,	0,0,	0,0,	
0,0,	70,181,	0,0,	0,0,	
0,0,	70,181,	70,181,	70,181,	
70,181,	70,181,	70,181,	70,181,	
70,181,	70,181,	0,0,	0,0,	
0,0,	71,182,	0,0,	70,181,	
0,0,	0,0,	0,0,	70,181,	
70,181,	71,182,	71,182,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	70,181,	213,328,	213,328,	
213,328,	213,328,	213,328,	213,328,	
213,328,	213,328,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
71,182,	0,0,	71,182,	71,182,	
0,0,	71,182,	0,0,	71,182,	
71,183,	71,184,	0,0,	71,182,	
0,0,	71,182,	71,182,	71,182,	
71,182,	71,182,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	71,182,	71,182,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	71,182,	71,182,	71,182,	
71,182,	71,182,	71,182,	71,182,	
81,81,	81,81,	0,0,	71,182,	
71,182,	71,182,	71,182,	71,182,	
71,182,	0,0,	71,182,	71,182,	
0,0,	0,0,	0,0,	71,182,	
71,182,	0,0,	0,0,	0,0,	
0,0,	71,182,	0,0,	81,81,	
0,0,	71,182,	71,182,	71,182,	
71,182,	71,182,	71,182,	71,182,	
71,182,	71,182,	0,0,	0,0,	
0,0,	81,81,	0,0,	71,182,	
0,0,	0,0,	0,0,	71,182,	
71,182,	214,329,	214,329,	214,329,	
214,329,	214,329,	214,329,	214,329,	
214,329,	71,182,	0,0,	0,0,	
0,0,	81,197,	233,237,	233,237,	
233,237,	233,237,	233,237,	233,237,	
233,237,	233,237,	81,197,	0,0,	
0,0,	81,197,	81,197,	81,197,	
81,197,	81,197,	85,81,	85,81,	
234,350,	234,350,	234,350,	234,350,	
234,350,	234,350,	234,350,	234,350,	
0,0,	0,0,	0,0,	0,0,	
81,197,	81,197,	81,197,	81,197,	
81,197,	81,197,	81,197,	81,197,	
0,0,	85,81,	81,197,	147,266,	
0,0,	81,197,	81,197,	81,197,	
81,197,	81,197,	0,0,	0,0,	
0,0,	0,0,	0,0,	85,81,	
147,267,	85,85,	85,85,	85,85,	
85,85,	85,85,	85,85,	85,85,	
85,85,	85,85,	85,85,	0,0,	
0,0,	0,0,	0,0,	0,0,	
96,210,	0,0,	0,0,	85,87,	
96,215,	96,215,	96,215,	96,215,	
96,215,	96,215,	96,215,	96,215,	
85,87,	96,211,	147,266,	85,87,	
85,87,	85,87,	85,87,	85,87,	
0,0,	0,0,	0,0,	147,268,	
147,268,	147,268,	147,268,	147,268,	
147,268,	147,268,	147,268,	0,0,	
0,0,	0,0,	85,87,	85,87,	
85,87,	85,87,	85,87,	85,87,	
85,87,	85,87,	0,0,	96,210,	
85,87,	0,0,	147,266,	85,87,	
85,87,	85,87,	85,87,	85,87,	
96,212,	96,212,	96,212,	96,212,	
96,212,	96,212,	96,212,	96,212,	
107,210,	0,0,	0,0,	0,0,	
107,215,	107,215,	107,215,	107,215,	
107,215,	107,215,	107,215,	107,215,	
0,0,	107,211,	0,0,	96,210,	
237,352,	237,352,	237,352,	237,352,	
237,352,	237,352,	237,352,	237,352,	
111,111,	111,111,	0,0,	0,0,	
0,0,	0,0,	232,349,	245,247,	
245,247,	245,247,	245,247,	245,247,	
245,247,	245,247,	245,247,	232,349,	
0,0,	0,0,	232,349,	107,210,	
0,0,	232,349,	232,349,	111,111,	
0,0,	0,0,	0,0,	0,0,	
107,212,	107,212,	107,212,	107,212,	
107,212,	107,212,	107,212,	107,212,	
111,111,	0,0,	232,349,	111,111,	
111,111,	0,0,	0,0,	0,0,	
0,0,	0,0,	107,224,	232,349,	
111,111,	0,0,	232,349,	107,210,	
0,0,	232,349,	232,349,	0,0,	
111,111,	111,111,	111,111,	111,111,	
111,111,	111,111,	111,111,	0,0,	
113,111,	113,111,	111,111,	111,111,	
111,111,	111,111,	111,111,	111,111,	
0,0,	111,111,	111,111,	0,0,	
0,0,	0,0,	111,111,	111,111,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	113,111,	
111,111,	111,111,	111,111,	111,111,	
111,111,	111,111,	111,111,	111,111,	
111,111,	0,0,	0,0,	0,0,	
113,228,	0,0,	111,111,	113,111,	
113,111,	0,0,	111,111,	111,111,	
0,0,	0,0,	0,0,	0,0,	
113,111,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
113,111,	113,111,	113,111,	113,111,	
113,111,	113,111,	113,111,	0,0,	
0,0,	0,0,	113,111,	113,111,	
113,111,	113,111,	113,111,	113,111,	
0,0,	113,111,	113,111,	0,0,	
0,0,	0,0,	113,111,	113,111,	
0,0,	0,0,	117,232,	0,0,	
0,0,	0,0,	0,0,	117,233,	
113,111,	113,111,	113,111,	113,111,	
113,111,	113,111,	113,111,	113,111,	
113,111,	0,0,	0,0,	0,0,	
117,234,	238,351,	113,111,	117,235,	
0,0,	0,0,	113,111,	113,111,	
117,236,	238,352,	238,352,	238,352,	
238,352,	238,352,	238,352,	238,352,	
238,352,	117,236,	0,0,	0,0,	
117,236,	0,0,	0,0,	117,236,	
117,236,	0,0,	0,0,	0,0,	
0,0,	0,0,	117,233,	246,359,	
246,359,	246,359,	246,359,	246,359,	
246,359,	246,359,	246,359,	117,237,	
117,238,	117,237,	117,237,	117,237,	
117,237,	117,237,	117,237,	0,0,	
0,0,	117,236,	0,0,	0,0,	
117,236,	0,0,	121,241,	117,236,	
117,236,	0,0,	0,0,	0,0,	
0,0,	0,0,	117,233,	121,240,	
121,240,	121,240,	121,240,	121,240,	
121,240,	121,240,	121,240,	0,0,	
123,232,	0,0,	0,0,	121,242,	
0,0,	123,245,	0,0,	0,0,	
121,243,	247,360,	247,360,	247,360,	
247,360,	247,360,	247,360,	247,360,	
247,360,	121,243,	123,246,	248,351,	
121,243,	123,235,	0,0,	121,243,	
121,243,	0,0,	123,236,	248,360,	
248,360,	248,360,	248,360,	248,360,	
248,360,	248,360,	248,360,	123,236,	
0,0,	0,0,	123,236,	0,0,	
121,243,	123,236,	123,236,	0,0,	
0,0,	0,0,	0,0,	0,0,	
123,245,	121,243,	0,0,	0,0,	
121,243,	0,0,	0,0,	121,243,	
121,243,	123,247,	123,248,	123,247,	
123,247,	123,247,	123,247,	123,247,	
123,247,	0,0,	0,0,	123,236,	
0,0,	0,0,	123,236,	0,0,	
126,241,	123,236,	123,236,	0,0,	
0,0,	126,210,	0,0,	0,0,	
123,245,	126,251,	126,251,	126,251,	
126,251,	126,251,	126,251,	126,251,	
126,251,	0,0,	126,211,	0,0,	
0,0,	126,242,	0,0,	0,0,	
241,354,	0,0,	126,243,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	241,354,	0,0,	126,243,	
241,354,	0,0,	126,243,	241,354,	
241,354,	126,243,	126,243,	0,0,	
0,0,	0,0,	0,0,	0,0,	
126,210,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
241,354,	126,212,	126,252,	126,212,	
126,212,	126,212,	126,212,	126,212,	
126,212,	241,354,	0,0,	126,243,	
241,354,	0,0,	126,243,	241,354,	
241,354,	126,243,	126,243,	0,0,	
0,0,	127,210,	0,0,	0,0,	
126,210,	127,251,	127,251,	127,251,	
127,251,	127,251,	127,251,	127,251,	
127,251,	0,0,	127,211,	249,361,	
249,361,	249,361,	249,361,	249,361,	
249,361,	249,361,	249,361,	265,375,	
265,375,	265,375,	265,375,	265,375,	
265,375,	265,375,	265,375,	0,0,	
0,0,	132,132,	0,0,	0,0,	
0,0,	252,358,	0,0,	0,0,	
0,0,	132,132,	0,0,	0,0,	
127,210,	252,327,	252,327,	252,327,	
252,327,	252,327,	252,327,	252,327,	
252,327,	127,212,	127,212,	127,212,	
127,212,	127,212,	127,212,	127,212,	
127,212,	0,0,	0,0,	0,0,	
132,132,	0,0,	132,132,	132,132,	
0,0,	132,132,	0,0,	132,132,	
132,132,	132,132,	0,0,	132,132,	
127,210,	132,132,	132,132,	132,132,	
132,132,	132,132,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	132,132,	132,132,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	132,132,	132,132,	132,132,	
132,132,	132,132,	132,132,	132,132,	
0,0,	0,0,	0,0,	132,132,	
132,132,	132,132,	132,132,	132,132,	
132,132,	0,0,	132,132,	132,132,	
0,0,	0,0,	0,0,	132,132,	
132,132,	0,0,	0,0,	0,0,	
0,0,	132,132,	0,0,	0,0,	
0,0,	132,132,	132,132,	132,132,	
132,132,	132,132,	132,132,	132,132,	
132,132,	132,132,	0,0,	0,0,	
0,0,	135,135,	0,0,	132,132,	
0,0,	0,0,	0,0,	132,132,	
132,132,	135,135,	135,135,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	132,254,	266,268,	266,268,	
266,268,	266,268,	266,268,	266,268,	
266,268,	266,268,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
135,257,	0,0,	135,135,	135,135,	
0,0,	135,135,	0,0,	135,135,	
135,135,	135,135,	0,0,	135,135,	
0,0,	135,135,	135,135,	135,135,	
135,135,	135,135,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	135,135,	135,135,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	135,135,	135,135,	135,135,	
135,135,	135,135,	135,135,	135,135,	
0,0,	0,0,	0,0,	135,135,	
135,135,	135,135,	135,135,	135,135,	
135,135,	0,0,	135,135,	135,135,	
0,0,	0,0,	0,0,	135,135,	
135,135,	142,81,	142,81,	0,0,	
0,0,	135,135,	0,0,	215,330,	
0,0,	135,135,	135,135,	135,135,	
135,135,	135,135,	135,135,	135,135,	
135,135,	135,135,	0,0,	0,0,	
215,331,	0,0,	0,0,	135,135,	
142,81,	0,0,	0,0,	135,135,	
135,135,	268,376,	268,376,	268,376,	
268,376,	268,376,	268,376,	268,376,	
268,376,	135,135,	142,81,	0,0,	
142,142,	142,142,	142,142,	142,142,	
142,142,	142,142,	142,142,	142,142,	
142,142,	142,142,	215,330,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	142,144,	215,332,	
215,332,	215,332,	215,332,	215,332,	
215,332,	215,332,	215,332,	142,144,	
0,0,	0,0,	142,144,	142,144,	
142,144,	142,144,	142,144,	0,0,	
145,145,	0,0,	0,0,	0,0,	
0,0,	0,0,	215,330,	0,0,	
145,145,	145,263,	0,0,	0,0,	
0,0,	142,144,	142,144,	142,144,	
142,144,	142,144,	142,144,	142,144,	
142,144,	0,0,	0,0,	142,144,	
0,0,	0,0,	142,144,	142,144,	
142,144,	142,144,	142,144,	145,264,	
0,0,	145,145,	145,145,	0,0,	
145,145,	0,0,	145,145,	145,145,	
145,145,	0,0,	145,145,	0,0,	
145,145,	145,145,	145,145,	145,145,	
145,145,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
145,145,	145,145,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
145,145,	145,145,	145,145,	145,145,	
145,145,	145,145,	145,145,	0,0,	
0,0,	0,0,	145,145,	145,145,	
145,145,	145,145,	145,145,	145,145,	
0,0,	145,145,	145,145,	0,0,	
0,0,	0,0,	145,145,	145,145,	
0,0,	0,0,	0,0,	0,0,	
145,145,	0,0,	0,0,	0,0,	
145,145,	145,145,	145,145,	145,145,	
145,145,	145,145,	145,145,	145,145,	
145,145,	0,0,	0,0,	0,0,	
0,0,	0,0,	145,145,	0,0,	
149,266,	0,0,	145,145,	145,145,	
149,269,	149,269,	149,269,	149,269,	
149,269,	149,269,	149,269,	149,269,	
145,145,	149,267,	283,286,	283,286,	
283,286,	283,286,	283,286,	283,286,	
283,286,	283,286,	0,0,	0,0,	
160,266,	0,0,	0,0,	0,0,	
160,269,	160,269,	160,269,	160,269,	
160,269,	160,269,	160,269,	160,269,	
0,0,	160,267,	0,0,	0,0,	
0,0,	0,0,	0,0,	149,266,	
286,392,	286,392,	286,392,	286,392,	
286,392,	286,392,	286,392,	286,392,	
149,268,	149,268,	149,268,	149,268,	
149,268,	149,268,	149,268,	149,268,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	165,232,	160,266,	
0,0,	0,0,	0,0,	165,283,	
0,0,	0,0,	0,0,	149,266,	
160,268,	160,268,	160,268,	160,268,	
160,268,	160,268,	160,268,	160,268,	
165,284,	0,0,	0,0,	165,235,	
0,0,	0,0,	0,0,	0,0,	
165,285,	0,0,	160,278,	0,0,	
0,0,	0,0,	0,0,	160,266,	
0,0,	165,285,	0,0,	0,0,	
165,285,	0,0,	0,0,	165,285,	
165,285,	0,0,	0,0,	0,0,	
0,0,	0,0,	165,283,	291,293,	
291,293,	291,293,	291,293,	291,293,	
291,293,	291,293,	291,293,	165,286,	
165,287,	165,286,	165,286,	165,286,	
165,286,	165,286,	165,286,	0,0,	
0,0,	165,285,	0,0,	0,0,	
165,285,	0,0,	169,241,	165,285,	
165,285,	0,0,	0,0,	0,0,	
0,0,	0,0,	165,283,	169,288,	
169,288,	169,288,	169,288,	169,288,	
169,288,	169,288,	169,288,	0,0,	
171,232,	287,351,	0,0,	169,242,	
0,0,	171,291,	0,0,	0,0,	
169,289,	287,392,	287,392,	287,392,	
287,392,	287,392,	287,392,	287,392,	
287,392,	169,289,	171,292,	0,0,	
169,289,	171,235,	0,0,	169,289,	
169,289,	0,0,	171,285,	293,394,	
293,394,	293,394,	293,394,	293,394,	
293,394,	293,394,	293,394,	171,285,	
0,0,	0,0,	171,285,	0,0,	
169,289,	171,285,	171,285,	0,0,	
0,0,	0,0,	0,0,	0,0,	
171,291,	169,289,	0,0,	0,0,	
169,289,	0,0,	0,0,	169,289,	
169,289,	171,293,	171,294,	171,293,	
171,293,	171,293,	171,293,	171,293,	
171,293,	0,0,	0,0,	171,285,	
0,0,	0,0,	171,285,	0,0,	
174,241,	171,285,	171,285,	0,0,	
0,0,	174,266,	0,0,	0,0,	
171,291,	174,296,	174,296,	174,296,	
174,296,	174,296,	174,296,	174,296,	
174,296,	0,0,	174,267,	294,351,	
0,0,	174,242,	0,0,	0,0,	
0,0,	0,0,	174,289,	294,394,	
294,394,	294,394,	294,394,	294,394,	
294,394,	294,394,	294,394,	174,289,	
0,0,	0,0,	174,289,	0,0,	
0,0,	174,289,	174,289,	0,0,	
0,0,	0,0,	0,0,	0,0,	
174,266,	326,414,	326,414,	326,414,	
326,414,	326,414,	326,414,	326,414,	
326,414,	174,268,	174,297,	174,268,	
174,268,	174,268,	174,268,	174,268,	
174,268,	0,0,	0,0,	174,289,	
0,0,	0,0,	174,289,	0,0,	
0,0,	174,289,	174,289,	0,0,	
0,0,	175,266,	0,0,	0,0,	
174,266,	175,296,	175,296,	175,296,	
175,296,	175,296,	175,296,	175,296,	
175,296,	297,358,	175,267,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	297,376,	297,376,	297,376,	
297,376,	297,376,	297,376,	297,376,	
297,376,	0,0,	0,0,	0,0,	
0,0,	183,183,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	183,183,	183,183,	0,0,	
175,266,	330,332,	330,332,	330,332,	
330,332,	330,332,	330,332,	330,332,	
330,332,	175,268,	175,268,	175,268,	
175,268,	175,268,	175,268,	175,268,	
175,268,	0,0,	0,0,	0,0,	
183,183,	0,0,	183,183,	183,183,	
0,0,	183,183,	0,0,	183,183,	
0,0,	183,301,	0,0,	183,183,	
175,266,	183,183,	183,183,	183,183,	
183,183,	183,183,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	183,183,	183,183,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	183,183,	183,183,	183,183,	
183,183,	183,183,	183,183,	183,183,	
0,0,	0,0,	0,0,	183,183,	
183,183,	183,183,	183,183,	183,183,	
183,183,	0,0,	183,183,	183,183,	
0,0,	0,0,	0,0,	183,183,	
183,183,	0,0,	0,0,	0,0,	
0,0,	183,183,	0,0,	0,0,	
0,0,	183,183,	183,183,	183,183,	
183,183,	183,183,	183,183,	183,183,	
183,183,	183,183,	0,0,	0,0,	
0,0,	184,303,	0,0,	183,183,	
0,0,	0,0,	0,0,	183,183,	
183,183,	184,303,	184,303,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	183,183,	331,413,	331,413,	
331,413,	331,413,	331,413,	331,413,	
331,413,	331,413,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
184,303,	0,0,	184,303,	184,303,	
0,0,	184,303,	0,0,	184,303,	
184,304,	184,305,	0,0,	184,303,	
0,0,	184,303,	184,303,	184,303,	
184,303,	184,303,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	184,303,	184,303,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	184,303,	184,303,	184,303,	
184,303,	184,303,	184,303,	184,303,	
0,0,	0,0,	0,0,	184,303,	
184,303,	184,303,	184,303,	184,303,	
184,303,	0,0,	184,303,	184,303,	
0,0,	0,0,	0,0,	184,303,	
184,303,	0,0,	0,0,	0,0,	
0,0,	184,303,	0,0,	0,0,	
0,0,	184,303,	184,303,	184,303,	
184,303,	184,303,	184,303,	184,303,	
184,303,	184,303,	0,0,	0,0,	
0,0,	187,187,	0,0,	184,303,	
0,0,	0,0,	0,0,	184,303,	
184,303,	187,187,	187,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	184,303,	332,415,	332,415,	
332,415,	332,415,	332,415,	332,415,	
332,415,	332,415,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
187,187,	0,0,	187,187,	187,187,	
0,0,	187,187,	0,0,	187,187,	
187,187,	187,307,	0,0,	187,187,	
0,0,	187,187,	187,187,	187,187,	
187,187,	187,187,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	187,187,	187,187,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	187,187,	187,187,	187,187,	
187,187,	187,187,	187,187,	187,187,	
0,0,	0,0,	0,0,	187,187,	
187,187,	187,187,	187,187,	187,187,	
187,187,	0,0,	187,187,	187,187,	
0,0,	0,0,	0,0,	187,187,	
187,187,	0,0,	0,0,	0,0,	
0,0,	187,187,	0,0,	0,0,	
0,0,	187,187,	187,187,	187,187,	
187,187,	187,187,	187,187,	187,187,	
187,187,	187,187,	0,0,	0,0,	
0,0,	188,188,	0,0,	187,187,	
0,0,	0,0,	0,0,	187,187,	
187,187,	188,188,	188,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	187,187,	350,431,	350,431,	
350,431,	350,431,	350,431,	350,431,	
350,431,	350,431,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
188,188,	0,0,	188,188,	188,188,	
0,0,	188,188,	0,0,	188,188,	
188,188,	188,188,	0,0,	188,188,	
0,0,	188,188,	188,188,	188,188,	
188,188,	188,188,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	188,188,	188,188,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	188,188,	188,188,	188,188,	
188,188,	188,188,	188,188,	188,188,	
0,0,	0,0,	0,0,	188,188,	
188,188,	188,188,	188,188,	188,188,	
188,188,	223,330,	188,188,	188,188,	
0,0,	0,0,	0,0,	188,188,	
188,188,	0,0,	0,0,	0,0,	
0,0,	188,188,	223,331,	0,0,	
0,0,	188,188,	188,188,	188,188,	
188,188,	188,188,	188,188,	188,188,	
188,188,	188,188,	0,0,	0,0,	
0,0,	0,0,	0,0,	188,188,	
0,0,	227,344,	0,0,	188,188,	
188,188,	0,0,	0,0,	0,0,	
0,0,	227,344,	227,0,	0,0,	
223,330,	188,308,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	223,332,	223,332,	223,332,	
223,332,	223,332,	223,332,	223,332,	
223,332,	0,0,	0,0,	0,0,	
227,344,	0,0,	227,344,	227,344,	
0,0,	227,344,	0,0,	227,345,	
227,344,	227,344,	0,0,	227,344,	
223,330,	227,345,	227,344,	227,344,	
227,345,	227,345,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	227,345,	227,344,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	227,345,	227,345,	227,345,	
227,345,	227,345,	227,345,	227,345,	
0,0,	0,0,	0,0,	227,345,	
227,345,	227,345,	227,345,	227,345,	
227,345,	0,0,	227,345,	227,345,	
0,0,	0,0,	0,0,	227,345,	
227,345,	0,0,	0,0,	0,0,	
0,0,	227,344,	0,0,	0,0,	
0,0,	227,345,	227,345,	227,345,	
227,345,	227,345,	227,345,	227,345,	
227,345,	227,345,	0,0,	0,0,	
0,0,	228,228,	0,0,	227,345,	
0,0,	0,0,	0,0,	227,345,	
227,345,	228,228,	228,228,	0,0,	
355,435,	0,0,	0,0,	0,0,	
0,0,	227,344,	0,0,	0,0,	
0,0,	355,435,	0,0,	0,0,	
355,435,	0,0,	0,0,	355,435,	
355,435,	0,0,	0,0,	0,0,	
228,228,	0,0,	228,228,	228,228,	
0,0,	228,228,	0,0,	228,228,	
228,228,	228,228,	0,0,	228,228,	
355,435,	228,346,	228,228,	228,228,	
228,228,	228,228,	0,0,	0,0,	
0,0,	355,435,	0,0,	0,0,	
355,435,	228,228,	228,228,	355,435,	
355,435,	0,0,	0,0,	0,0,	
0,0,	228,228,	228,228,	228,228,	
228,228,	228,228,	228,228,	228,228,	
0,0,	0,0,	0,0,	228,228,	
228,228,	228,228,	228,228,	228,228,	
228,228,	0,0,	228,228,	228,228,	
229,229,	229,229,	0,0,	228,228,	
228,228,	359,437,	359,437,	359,437,	
359,437,	359,437,	359,437,	359,437,	
359,437,	228,228,	228,228,	228,228,	
228,228,	228,228,	228,228,	228,228,	
228,228,	228,228,	0,0,	229,229,	
0,0,	229,230,	0,0,	228,228,	
0,0,	0,0,	0,0,	228,228,	
228,228,	0,0,	0,0,	0,0,	
229,111,	0,0,	0,0,	229,111,	
229,111,	228,228,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
229,111,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
229,111,	229,111,	229,111,	229,111,	
229,111,	229,111,	229,111,	0,0,	
0,0,	0,0,	229,111,	229,111,	
229,111,	229,111,	229,111,	229,111,	
0,0,	229,111,	229,111,	0,0,	
0,0,	230,230,	229,111,	229,111,	
0,0,	0,0,	0,0,	0,0,	
0,0,	230,230,	230,230,	0,0,	
229,111,	229,111,	229,111,	229,111,	
229,111,	229,111,	229,111,	229,111,	
229,111,	0,0,	0,0,	0,0,	
0,0,	0,0,	229,111,	0,0,	
0,0,	0,0,	229,111,	229,111,	
230,230,	0,0,	230,347,	230,230,	
0,0,	230,230,	0,0,	230,230,	
230,230,	230,230,	0,0,	230,230,	
0,0,	230,230,	230,230,	230,230,	
230,230,	230,230,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	230,230,	230,230,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	230,230,	230,230,	230,230,	
230,230,	230,230,	230,230,	230,230,	
0,0,	0,0,	0,0,	230,230,	
230,230,	230,230,	230,230,	230,230,	
230,230,	0,0,	230,230,	230,230,	
0,0,	0,0,	231,241,	230,230,	
230,230,	0,0,	0,0,	0,0,	
0,0,	230,348,	0,0,	0,0,	
0,0,	230,230,	230,230,	230,230,	
230,230,	230,230,	230,230,	230,230,	
230,230,	230,230,	0,0,	231,242,	
0,0,	0,0,	0,0,	230,230,	
231,243,	0,0,	0,0,	230,230,	
230,230,	0,0,	0,0,	0,0,	
239,241,	231,243,	0,0,	0,0,	
231,243,	230,230,	0,0,	231,243,	
231,243,	239,353,	239,353,	239,353,	
239,353,	239,353,	239,353,	239,353,	
239,353,	0,0,	0,0,	0,0,	
0,0,	239,242,	240,355,	0,0,	
231,243,	0,0,	239,354,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	231,243,	0,0,	239,354,	
231,243,	0,0,	239,354,	231,243,	
231,243,	239,354,	239,354,	240,356,	
0,0,	0,0,	0,0,	0,0,	
240,357,	377,379,	377,379,	377,379,	
377,379,	377,379,	377,379,	377,379,	
377,379,	240,357,	239,354,	0,0,	
240,357,	0,0,	0,0,	240,357,	
240,357,	0,0,	0,0,	239,354,	
0,0,	0,0,	239,354,	0,0,	
244,241,	239,354,	239,354,	0,0,	
0,0,	0,0,	0,0,	0,0,	
240,357,	244,324,	244,324,	244,324,	
244,324,	244,324,	244,324,	244,324,	
244,324,	240,357,	250,241,	0,0,	
240,357,	244,242,	0,0,	240,357,	
240,357,	0,0,	244,243,	250,362,	
250,362,	250,362,	250,362,	250,362,	
250,362,	250,362,	250,362,	244,243,	
0,0,	0,0,	244,243,	250,242,	
0,0,	244,243,	244,243,	0,0,	
250,243,	251,355,	0,0,	0,0,	
0,0,	0,0,	251,330,	0,0,	
0,0,	250,243,	0,0,	0,0,	
250,243,	0,0,	244,243,	250,243,	
250,243,	0,0,	0,0,	251,331,	
0,0,	0,0,	251,356,	244,243,	
0,0,	0,0,	244,243,	251,357,	
0,0,	244,243,	244,243,	282,241,	
250,243,	0,0,	0,0,	0,0,	
251,357,	0,0,	0,0,	251,357,	
0,0,	250,243,	251,357,	251,357,	
250,243,	0,0,	258,258,	250,243,	
250,243,	251,330,	0,0,	0,0,	
282,242,	0,0,	258,258,	258,371,	
0,0,	282,289,	251,332,	251,363,	
251,332,	251,332,	251,332,	251,332,	
251,332,	251,332,	282,289,	0,0,	
251,357,	282,289,	0,0,	251,357,	
282,289,	282,289,	251,357,	251,357,	
0,0,	258,258,	0,0,	258,258,	
258,258,	251,330,	258,258,	0,0,	
258,258,	258,258,	258,258,	0,0,	
258,258,	282,289,	258,258,	258,258,	
258,258,	258,258,	258,258,	0,0,	
0,0,	0,0,	282,289,	0,0,	
0,0,	282,289,	258,258,	258,258,	
282,289,	282,289,	0,0,	0,0,	
0,0,	0,0,	258,258,	258,258,	
258,258,	258,258,	258,258,	258,258,	
258,258,	0,0,	0,0,	0,0,	
258,258,	258,258,	258,258,	258,258,	
258,258,	258,258,	269,377,	258,258,	
258,258,	0,0,	0,0,	0,0,	
258,258,	258,258,	0,0,	0,0,	
0,0,	0,0,	258,258,	269,378,	
0,0,	0,0,	258,258,	258,258,	
258,258,	258,258,	258,258,	258,258,	
258,258,	258,258,	258,258,	277,377,	
0,0,	0,0,	0,0,	0,0,	
258,258,	0,0,	0,0,	0,0,	
258,258,	258,258,	0,0,	0,0,	
277,378,	0,0,	0,0,	0,0,	
0,0,	269,377,	258,258,	0,0,	
0,0,	0,0,	0,0,	0,0,	
281,0,	0,0,	269,379,	269,379,	
269,379,	269,379,	269,379,	269,379,	
269,379,	269,379,	379,447,	379,447,	
379,447,	379,447,	379,447,	379,447,	
379,447,	379,447,	277,377,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	269,377,	0,0,	277,379,	
277,379,	277,379,	277,379,	277,379,	
277,379,	277,379,	277,379,	281,390,	
0,0,	0,0,	281,390,	281,390,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	281,390,	
281,391,	0,0,	277,377,	0,0,	
0,0,	0,0,	0,0,	281,390,	
281,390,	281,390,	281,390,	281,390,	
281,390,	281,390,	0,0,	0,0,	
0,0,	281,390,	281,390,	281,390,	
281,390,	281,390,	281,390,	363,436,	
281,390,	281,390,	0,0,	0,0,	
288,355,	281,390,	281,390,	363,415,	
363,415,	363,415,	363,415,	363,415,	
363,415,	363,415,	363,415,	281,390,	
281,390,	281,390,	281,390,	281,390,	
281,390,	281,390,	281,390,	281,390,	
0,0,	288,356,	0,0,	0,0,	
0,0,	281,390,	288,393,	0,0,	
0,0,	281,390,	281,390,	0,0,	
0,0,	0,0,	290,241,	288,393,	
0,0,	0,0,	288,393,	0,0,	
0,0,	288,393,	288,393,	290,375,	
290,375,	290,375,	290,375,	290,375,	
290,375,	290,375,	290,375,	0,0,	
0,0,	0,0,	0,0,	290,242,	
0,0,	0,0,	288,393,	0,0,	
290,289,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	288,393,	
295,241,	290,289,	288,393,	0,0,	
290,289,	288,393,	288,393,	290,289,	
290,289,	295,395,	295,395,	295,395,	
295,395,	295,395,	295,395,	295,395,	
295,395,	0,0,	0,0,	0,0,	
0,0,	295,242,	0,0,	0,0,	
290,289,	0,0,	295,289,	296,355,	
0,0,	0,0,	0,0,	0,0,	
296,377,	290,289,	0,0,	295,289,	
290,289,	0,0,	295,289,	290,289,	
290,289,	295,289,	295,289,	0,0,	
0,0,	296,378,	0,0,	0,0,	
296,356,	0,0,	0,0,	0,0,	
0,0,	296,393,	0,0,	0,0,	
0,0,	352,432,	295,289,	0,0,	
0,0,	0,0,	296,393,	0,0,	
0,0,	296,393,	0,0,	295,289,	
296,393,	296,393,	295,289,	0,0,	
304,304,	295,289,	295,289,	296,377,	
0,0,	0,0,	352,433,	0,0,	
304,304,	304,304,	0,0,	352,434,	
296,379,	296,396,	296,379,	296,379,	
296,379,	296,379,	296,379,	296,379,	
352,434,	0,0,	296,393,	352,434,	
0,0,	296,393,	352,434,	352,434,	
296,393,	296,393,	0,0,	304,304,	
0,0,	304,304,	304,304,	296,377,	
304,304,	0,0,	304,304,	304,0,	
0,0,	0,0,	304,304,	352,434,	
304,304,	304,304,	304,304,	304,304,	
304,304,	0,0,	0,0,	0,0,	
352,434,	0,0,	0,0,	352,434,	
304,304,	304,304,	352,434,	352,434,	
0,0,	0,0,	0,0,	0,0,	
304,304,	304,304,	304,304,	304,304,	
304,304,	304,304,	304,304,	0,0,	
0,0,	0,0,	304,304,	304,304,	
304,304,	304,304,	304,304,	304,304,	
325,331,	304,304,	304,304,	0,0,	
0,0,	0,0,	304,304,	304,304,	
0,0,	0,0,	0,0,	0,0,	
304,304,	325,331,	0,0,	0,0,	
304,304,	304,304,	304,304,	304,304,	
304,304,	304,304,	304,304,	304,304,	
304,304,	0,0,	0,0,	0,0,	
0,0,	0,0,	304,304,	0,0,	
338,423,	0,0,	304,304,	304,304,	
0,0,	0,0,	0,0,	0,0,	
338,423,	338,0,	0,0,	325,331,	
304,304,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
325,413,	325,413,	325,413,	325,413,	
325,413,	325,413,	325,413,	325,413,	
0,0,	0,0,	0,0,	338,423,	
0,0,	338,423,	338,423,	0,0,	
338,423,	0,0,	338,424,	338,423,	
338,423,	0,0,	338,423,	325,331,	
338,424,	338,423,	338,423,	338,424,	
338,424,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
338,424,	338,423,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
338,424,	338,424,	338,424,	338,424,	
338,424,	338,424,	338,424,	0,0,	
0,0,	0,0,	338,424,	338,424,	
338,424,	338,424,	338,424,	338,424,	
0,0,	338,424,	338,424,	344,0,	
0,0,	0,0,	338,424,	338,424,	
0,0,	0,0,	0,0,	0,0,	
338,423,	0,0,	0,0,	0,0,	
338,424,	338,424,	338,424,	338,424,	
338,338,	338,424,	338,424,	338,424,	
338,424,	0,0,	0,0,	0,0,	
0,0,	0,0,	338,424,	0,0,	
344,344,	0,0,	338,338,	338,338,	
0,0,	0,0,	344,344,	0,0,	
0,0,	344,344,	344,344,	0,0,	
338,423,	0,0,	0,0,	0,0,	
0,0,	0,0,	344,344,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	344,344,	344,344,	
344,344,	344,344,	344,344,	344,344,	
344,344,	0,0,	0,0,	0,0,	
344,344,	344,344,	344,344,	344,344,	
344,344,	344,344,	0,0,	344,344,	
344,344,	0,0,	0,0,	346,228,	
344,344,	344,344,	0,0,	0,0,	
0,0,	0,0,	0,0,	346,228,	
346,228,	0,0,	344,344,	344,344,	
344,344,	344,344,	344,344,	344,344,	
344,344,	344,344,	344,344,	0,0,	
0,0,	0,0,	0,0,	0,0,	
344,344,	0,0,	0,0,	0,0,	
344,344,	344,344,	346,228,	0,0,	
346,228,	346,228,	0,0,	346,228,	
0,0,	346,228,	346,228,	346,228,	
0,0,	346,228,	0,0,	346,427,	
346,228,	346,228,	346,228,	346,228,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	346,228,	
346,228,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	346,228,	
346,228,	346,228,	346,228,	346,228,	
346,228,	346,228,	0,0,	347,347,	
347,347,	346,228,	346,228,	346,228,	
346,228,	346,228,	346,228,	0,0,	
346,228,	346,228,	0,0,	0,0,	
0,0,	346,228,	346,228,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	347,347,	346,228,	
346,228,	346,228,	346,228,	346,228,	
346,228,	346,228,	346,228,	346,228,	
0,0,	0,0,	0,0,	347,111,	
0,0,	346,228,	347,111,	347,111,	
0,0,	346,228,	346,228,	0,0,	
0,0,	0,0,	0,0,	347,111,	
0,0,	0,0,	0,0,	346,228,	
0,0,	0,0,	0,0,	347,111,	
347,111,	347,111,	347,111,	347,111,	
347,111,	347,111,	0,0,	0,0,	
0,0,	347,111,	347,111,	347,111,	
347,111,	347,111,	347,111,	0,0,	
347,111,	347,111,	0,0,	0,0,	
348,429,	347,111,	347,111,	0,0,	
0,0,	0,0,	0,0,	347,428,	
348,429,	348,429,	0,0,	347,111,	
347,111,	347,111,	347,111,	347,111,	
347,111,	347,111,	347,111,	347,111,	
0,0,	0,0,	0,0,	0,0,	
0,0,	347,111,	0,0,	0,0,	
0,0,	347,111,	347,111,	348,429,	
0,0,	348,430,	348,429,	0,0,	
348,429,	0,0,	348,429,	348,429,	
348,429,	0,0,	348,429,	0,0,	
348,429,	348,429,	348,429,	348,429,	
348,429,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
348,429,	348,429,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
348,429,	348,429,	348,429,	348,429,	
348,429,	348,429,	348,429,	0,0,	
0,0,	0,0,	348,429,	348,429,	
348,429,	348,429,	348,429,	348,429,	
0,0,	348,429,	348,429,	0,0,	
0,0,	353,355,	348,429,	348,429,	
0,0,	0,0,	0,0,	0,0,	
348,429,	0,0,	0,0,	360,432,	
348,429,	348,429,	348,429,	348,429,	
348,429,	348,429,	348,429,	348,429,	
348,429,	0,0,	353,356,	0,0,	
0,0,	0,0,	348,429,	353,435,	
0,0,	0,0,	348,429,	348,429,	
360,433,	0,0,	0,0,	362,355,	
353,435,	360,434,	0,0,	353,435,	
348,429,	0,0,	353,435,	353,435,	
0,0,	0,0,	360,434,	0,0,	
432,490,	360,434,	0,0,	0,0,	
360,434,	360,434,	0,0,	0,0,	
362,356,	432,490,	0,0,	353,435,	
432,490,	362,357,	0,0,	432,490,	
432,490,	384,0,	0,0,	0,0,	
353,435,	360,434,	362,357,	353,435,	
0,0,	362,357,	353,435,	353,435,	
362,357,	362,357,	360,434,	0,0,	
432,490,	360,434,	0,0,	0,0,	
360,434,	360,434,	0,0,	0,0,	
0,0,	432,490,	0,0,	0,0,	
432,490,	362,357,	0,0,	432,490,	
432,490,	0,0,	0,0,	0,0,	
384,453,	0,0,	362,357,	384,453,	
384,453,	362,357,	0,0,	0,0,	
362,357,	362,357,	0,0,	0,0,	
384,453,	384,454,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
384,453,	384,453,	384,453,	384,453,	
384,453,	384,453,	384,453,	0,0,	
0,0,	390,0,	384,453,	384,453,	
384,453,	384,453,	384,453,	384,453,	
396,436,	384,453,	384,453,	0,0,	
0,0,	0,0,	384,453,	384,453,	
396,447,	396,447,	396,447,	396,447,	
396,447,	396,447,	396,447,	396,447,	
384,453,	384,453,	384,453,	384,453,	
384,384,	384,453,	384,453,	384,453,	
384,453,	0,0,	0,0,	0,0,	
390,390,	0,0,	384,453,	390,390,	
390,390,	0,0,	384,384,	384,384,	
0,0,	0,0,	0,0,	0,0,	
390,390,	390,391,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
390,390,	390,390,	390,390,	390,390,	
390,390,	390,390,	390,390,	0,0,	
0,0,	0,0,	390,390,	390,390,	
390,390,	390,390,	390,390,	390,390,	
0,0,	390,390,	390,390,	391,0,	
0,0,	0,0,	390,390,	390,390,	
413,474,	413,474,	413,474,	413,474,	
413,474,	413,474,	413,474,	413,474,	
390,390,	390,390,	390,390,	390,390,	
390,390,	390,390,	390,390,	390,390,	
390,390,	391,457,	0,0,	0,0,	
0,0,	0,0,	390,390,	0,0,	
391,344,	0,0,	390,390,	390,390,	
0,0,	0,0,	391,344,	0,0,	
0,0,	391,344,	391,344,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	391,344,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	391,344,	391,344,	
391,344,	391,344,	391,344,	391,344,	
391,344,	0,0,	0,0,	0,0,	
391,344,	391,344,	391,344,	391,344,	
391,344,	391,344,	0,0,	391,344,	
391,344,	0,0,	0,0,	392,432,	
391,344,	391,344,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	394,432,	391,344,	391,344,	
391,344,	391,344,	391,344,	391,344,	
391,344,	391,344,	391,344,	0,0,	
392,433,	0,0,	0,0,	0,0,	
391,344,	392,458,	0,0,	0,0,	
391,344,	391,344,	394,433,	0,0,	
0,0,	395,355,	392,458,	394,458,	
0,0,	392,458,	0,0,	0,0,	
392,458,	392,458,	0,0,	0,0,	
394,458,	0,0,	475,515,	394,458,	
0,0,	0,0,	394,458,	394,458,	
0,0,	0,0,	395,356,	475,515,	
0,0,	392,458,	475,515,	395,393,	
0,0,	475,515,	475,515,	0,0,	
0,0,	0,0,	392,458,	394,458,	
395,393,	392,458,	0,0,	395,393,	
392,458,	392,458,	395,393,	395,393,	
394,458,	401,401,	475,515,	394,458,	
0,0,	0,0,	394,458,	394,458,	
0,0,	401,401,	401,0,	475,515,	
0,0,	0,0,	475,515,	395,393,	
0,0,	475,515,	475,515,	0,0,	
0,0,	0,0,	0,0,	0,0,	
395,393,	0,0,	0,0,	395,393,	
0,0,	0,0,	395,393,	395,393,	
401,401,	0,0,	401,401,	401,401,	
0,0,	401,401,	0,0,	401,401,	
401,401,	401,462,	0,0,	401,401,	
0,0,	401,401,	401,401,	401,401,	
401,401,	401,401,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	401,401,	401,401,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	401,401,	401,401,	401,401,	
401,401,	401,401,	401,401,	401,401,	
0,0,	0,0,	0,0,	401,401,	
401,401,	401,401,	401,401,	401,401,	
401,401,	0,0,	401,401,	401,401,	
0,0,	0,0,	0,0,	401,401,	
401,401,	0,0,	0,0,	0,0,	
0,0,	401,401,	0,0,	0,0,	
0,0,	401,401,	401,401,	401,401,	
401,401,	401,401,	401,401,	401,401,	
401,401,	401,401,	0,0,	0,0,	
0,0,	402,402,	0,0,	401,401,	
0,0,	0,0,	0,0,	401,401,	
401,401,	402,402,	402,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	401,401,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
402,402,	0,0,	402,402,	402,402,	
0,0,	402,402,	0,0,	402,402,	
402,402,	402,402,	0,0,	402,402,	
0,0,	402,402,	402,402,	402,402,	
402,402,	402,402,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	402,402,	402,402,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	402,402,	402,402,	402,402,	
402,402,	402,402,	402,402,	402,402,	
0,0,	0,0,	0,0,	402,402,	
402,402,	402,402,	402,402,	402,402,	
402,402,	0,0,	402,402,	402,402,	
0,0,	0,0,	0,0,	402,402,	
402,402,	0,0,	0,0,	0,0,	
0,0,	402,402,	0,0,	0,0,	
0,0,	402,402,	402,402,	402,402,	
402,402,	402,402,	402,402,	402,402,	
402,402,	402,402,	0,0,	0,0,	
0,0,	403,403,	0,0,	402,402,	
0,0,	0,0,	0,0,	402,402,	
402,402,	403,403,	403,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	402,463,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
403,403,	0,0,	403,403,	403,403,	
0,0,	403,403,	0,0,	403,403,	
403,403,	403,464,	0,0,	403,403,	
0,0,	403,403,	403,403,	403,403,	
403,403,	403,403,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	403,403,	403,403,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	403,403,	403,403,	403,403,	
403,403,	403,403,	403,403,	403,403,	
0,0,	0,0,	0,0,	403,403,	
403,403,	403,403,	403,403,	403,403,	
403,403,	0,0,	403,403,	403,403,	
0,0,	0,0,	0,0,	403,403,	
403,403,	0,0,	0,0,	0,0,	
0,0,	403,403,	0,0,	0,0,	
0,0,	403,403,	403,403,	403,403,	
403,403,	403,403,	403,403,	403,403,	
403,403,	403,403,	0,0,	0,0,	
0,0,	404,404,	0,0,	403,403,	
0,0,	0,0,	0,0,	403,403,	
403,403,	404,404,	404,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	403,403,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
404,404,	0,0,	404,404,	404,404,	
0,0,	404,404,	0,0,	404,404,	
404,404,	404,404,	0,0,	404,404,	
0,0,	404,404,	404,404,	404,404,	
404,404,	404,404,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	404,404,	404,404,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	404,404,	404,404,	404,404,	
404,404,	404,404,	404,404,	404,404,	
0,0,	0,0,	0,0,	404,404,	
404,404,	404,404,	404,404,	404,404,	
404,404,	0,0,	404,404,	404,404,	
0,0,	0,0,	0,0,	404,404,	
404,404,	0,0,	0,0,	0,0,	
0,0,	404,404,	0,0,	0,0,	
0,0,	404,404,	404,404,	404,404,	
404,404,	404,404,	404,404,	404,404,	
404,404,	404,404,	0,0,	0,0,	
0,0,	405,405,	0,0,	404,404,	
0,0,	0,0,	0,0,	404,404,	
404,404,	405,405,	405,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	404,465,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
405,405,	0,0,	405,405,	405,405,	
0,0,	405,405,	0,0,	405,405,	
405,405,	405,466,	0,0,	405,405,	
0,0,	405,405,	405,405,	405,405,	
405,405,	405,405,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	405,405,	405,405,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	405,405,	405,405,	405,405,	
405,405,	405,405,	405,405,	405,405,	
0,0,	0,0,	0,0,	405,405,	
405,405,	405,405,	405,405,	405,405,	
405,405,	0,0,	405,405,	405,405,	
0,0,	0,0,	0,0,	405,405,	
405,405,	0,0,	0,0,	0,0,	
0,0,	405,405,	0,0,	0,0,	
0,0,	405,405,	405,405,	405,405,	
405,405,	405,405,	405,405,	405,405,	
405,405,	405,405,	0,0,	0,0,	
0,0,	406,406,	0,0,	405,405,	
0,0,	0,0,	0,0,	405,405,	
405,405,	406,406,	406,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	405,405,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
406,406,	0,0,	406,406,	406,406,	
0,0,	406,406,	0,0,	406,406,	
406,406,	406,406,	0,0,	406,406,	
0,0,	406,406,	406,406,	406,406,	
406,406,	406,406,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	406,406,	406,406,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	406,406,	406,406,	406,406,	
406,406,	406,406,	406,406,	406,406,	
0,0,	0,0,	0,0,	406,406,	
406,406,	406,406,	406,406,	406,406,	
406,406,	0,0,	406,406,	406,406,	
0,0,	0,0,	415,475,	406,406,	
406,406,	0,0,	0,0,	0,0,	
0,0,	406,406,	0,0,	0,0,	
0,0,	406,406,	406,406,	406,406,	
406,406,	406,406,	406,406,	406,406,	
406,406,	406,406,	0,0,	415,476,	
423,0,	0,0,	0,0,	406,406,	
415,477,	0,0,	0,0,	406,406,	
406,406,	0,0,	0,0,	0,0,	
0,0,	415,477,	0,0,	0,0,	
415,477,	406,467,	0,0,	415,477,	
415,477,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	423,423,	0,0,	0,0,	
0,0,	0,0,	0,0,	423,423,	
415,477,	0,0,	423,423,	423,423,	
0,0,	0,0,	0,0,	0,0,	
0,0,	415,477,	0,0,	423,423,	
415,477,	0,0,	0,0,	415,477,	
415,477,	0,0,	0,0,	423,423,	
423,423,	423,423,	423,423,	423,423,	
423,423,	423,423,	0,0,	0,0,	
0,0,	423,423,	423,423,	423,423,	
423,423,	423,423,	423,423,	0,0,	
423,423,	423,423,	0,0,	0,0,	
427,228,	423,423,	423,423,	0,0,	
0,0,	0,0,	0,0,	0,0,	
427,228,	427,228,	0,0,	423,423,	
423,423,	423,423,	423,423,	423,423,	
423,423,	423,423,	423,423,	423,423,	
0,0,	0,0,	0,0,	0,0,	
0,0,	423,423,	0,0,	0,0,	
0,0,	423,423,	423,423,	427,228,	
0,0,	427,228,	427,228,	0,0,	
427,228,	0,0,	427,228,	427,228,	
427,228,	0,0,	427,228,	0,0,	
427,427,	427,228,	427,228,	427,228,	
427,228,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
427,228,	427,228,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
427,228,	427,228,	427,228,	427,228,	
427,228,	427,228,	427,228,	0,0,	
0,0,	0,0,	427,228,	427,228,	
427,228,	427,228,	427,228,	427,228,	
0,0,	427,228,	427,228,	0,0,	
0,0,	431,432,	427,228,	427,228,	
0,0,	0,0,	0,0,	0,0,	
427,488,	0,0,	0,0,	0,0,	
427,228,	427,228,	427,228,	427,228,	
427,228,	427,228,	427,228,	427,228,	
427,228,	0,0,	431,433,	0,0,	
0,0,	0,0,	427,228,	431,490,	
0,0,	0,0,	427,228,	427,228,	
0,0,	0,0,	0,0,	0,0,	
431,490,	0,0,	0,0,	431,490,	
427,228,	0,0,	431,490,	431,490,	
0,0,	444,495,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	444,444,	0,0,	0,0,	
0,0,	0,0,	0,0,	431,490,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
431,490,	0,0,	0,0,	431,490,	
0,0,	0,0,	431,490,	431,490,	
444,444,	0,0,	444,495,	444,495,	
0,0,	444,495,	0,0,	444,495,	
444,495,	444,495,	0,0,	444,495,	
0,0,	444,495,	444,495,	444,495,	
444,495,	444,495,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	444,495,	444,495,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	444,495,	444,495,	444,495,	
444,495,	444,495,	444,495,	444,495,	
0,0,	0,0,	0,0,	444,495,	
444,495,	444,495,	444,495,	444,495,	
444,495,	0,0,	444,495,	444,495,	
0,0,	0,0,	447,475,	444,495,	
444,495,	0,0,	0,0,	0,0,	
0,0,	444,495,	0,0,	0,0,	
0,0,	444,495,	444,495,	444,495,	
444,495,	444,495,	444,495,	444,495,	
444,495,	444,495,	0,0,	447,476,	
0,0,	0,0,	453,0,	444,495,	
447,498,	0,0,	0,0,	444,495,	
444,495,	0,0,	0,0,	0,0,	
0,0,	447,498,	0,0,	0,0,	
447,498,	444,495,	0,0,	447,498,	
447,498,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
447,498,	453,453,	0,0,	0,0,	
453,453,	453,453,	0,0,	0,0,	
0,0,	447,498,	0,0,	0,0,	
447,498,	453,453,	453,454,	447,498,	
447,498,	0,0,	0,0,	0,0,	
0,0,	453,453,	453,453,	453,453,	
453,453,	453,453,	453,453,	453,453,	
0,0,	0,0,	0,0,	453,453,	
453,453,	453,453,	453,453,	453,453,	
453,453,	0,0,	453,453,	453,453,	
454,0,	0,0,	0,0,	453,453,	
453,453,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	453,453,	453,453,	453,453,	
453,453,	453,453,	453,453,	453,453,	
453,453,	453,453,	454,502,	0,0,	
0,0,	0,0,	0,0,	453,453,	
0,0,	454,423,	0,0,	453,453,	
453,453,	0,0,	0,0,	454,423,	
0,0,	0,0,	454,423,	454,423,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	454,423,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	454,423,	
454,423,	454,423,	454,423,	454,423,	
454,423,	454,423,	0,0,	0,0,	
0,0,	454,423,	454,423,	454,423,	
454,423,	454,423,	454,423,	0,0,	
454,423,	454,423,	0,0,	0,0,	
457,457,	454,423,	454,423,	0,0,	
0,0,	0,0,	0,0,	0,0,	
457,457,	0,0,	0,0,	454,423,	
454,423,	454,423,	454,423,	454,423,	
454,423,	454,423,	454,423,	454,423,	
0,0,	0,0,	0,0,	0,0,	
0,0,	454,423,	0,0,	0,0,	
0,0,	454,423,	454,423,	457,457,	
0,0,	457,457,	457,457,	0,0,	
457,457,	0,0,	457,457,	457,457,	
457,457,	0,0,	457,457,	0,0,	
457,457,	457,457,	457,457,	457,457,	
457,457,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
457,457,	457,457,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
457,457,	457,457,	457,457,	457,457,	
457,457,	457,457,	457,457,	0,0,	
0,0,	0,0,	457,457,	457,457,	
457,457,	457,457,	457,457,	457,457,	
0,0,	457,457,	457,457,	0,0,	
0,0,	474,475,	457,457,	457,457,	
0,0,	0,0,	0,0,	0,0,	
457,457,	0,0,	0,0,	0,0,	
457,457,	457,457,	457,457,	457,457,	
457,457,	457,457,	457,457,	457,457,	
457,457,	0,0,	474,476,	0,0,	
0,0,	0,0,	457,457,	474,515,	
0,0,	0,0,	457,457,	457,457,	
0,0,	0,0,	0,0,	0,0,	
474,515,	0,0,	0,0,	474,515,	
457,457,	0,0,	474,515,	474,515,	
0,0,	479,479,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	479,479,	479,0,	0,0,	
0,0,	0,0,	0,0,	474,515,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
474,515,	0,0,	0,0,	474,515,	
0,0,	0,0,	474,515,	474,515,	
479,479,	0,0,	479,479,	479,479,	
0,0,	479,479,	0,0,	479,479,	
479,479,	479,517,	0,0,	479,479,	
0,0,	479,479,	479,479,	479,479,	
479,479,	479,479,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	479,479,	479,479,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	479,479,	479,479,	479,479,	
479,479,	479,479,	479,479,	479,479,	
0,0,	0,0,	0,0,	479,479,	
479,479,	479,479,	479,479,	479,479,	
479,479,	0,0,	479,479,	479,479,	
0,0,	0,0,	0,0,	479,479,	
479,479,	0,0,	0,0,	0,0,	
0,0,	479,479,	0,0,	0,0,	
0,0,	479,479,	479,479,	479,479,	
479,479,	479,479,	479,479,	479,479,	
479,479,	479,479,	495,495,	0,0,	
0,0,	0,0,	0,0,	479,479,	
0,0,	0,0,	495,495,	479,479,	
479,479,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	479,479,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	495,495,	0,0,	495,495,	
495,495,	0,0,	495,495,	0,0,	
495,495,	495,495,	495,495,	0,0,	
495,495,	0,0,	495,495,	495,495,	
495,495,	495,495,	495,495,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	495,495,	495,495,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	495,495,	495,495,	
495,495,	495,495,	495,495,	495,495,	
495,495,	0,0,	0,0,	0,0,	
495,495,	495,495,	495,495,	495,495,	
495,495,	495,495,	0,0,	495,495,	
495,495,	0,0,	0,0,	0,0,	
495,495,	495,495,	0,0,	0,0,	
0,0,	0,0,	495,495,	0,0,	
0,0,	0,0,	495,495,	495,495,	
495,495,	495,495,	495,495,	495,495,	
495,495,	495,495,	495,495,	502,502,	
0,0,	0,0,	0,0,	0,0,	
495,495,	0,0,	0,0,	502,502,	
495,495,	495,495,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	495,495,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	502,502,	0,0,	
502,502,	502,502,	0,0,	502,502,	
0,0,	502,502,	502,502,	502,502,	
0,0,	502,502,	0,0,	502,502,	
502,502,	502,502,	502,502,	502,502,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	502,502,	
502,502,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	502,502,	
502,502,	502,502,	502,502,	502,502,	
502,502,	502,502,	0,0,	0,0,	
0,0,	502,502,	502,502,	502,502,	
502,502,	502,502,	502,502,	0,0,	
502,502,	502,502,	0,0,	0,0,	
0,0,	502,502,	502,502,	0,0,	
0,0,	0,0,	0,0,	502,502,	
0,0,	0,0,	0,0,	502,502,	
502,502,	502,502,	502,502,	502,502,	
502,502,	502,502,	502,502,	502,502,	
0,0,	0,0,	0,0,	547,561,	
0,0,	502,502,	0,0,	0,0,	
0,0,	502,502,	502,502,	547,561,	
547,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	502,502,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	547,561,	0,0,	
547,561,	547,561,	0,0,	547,561,	
0,0,	547,547,	547,561,	547,561,	
0,0,	547,561,	0,0,	547,547,	
547,561,	547,561,	547,547,	547,547,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	547,547,	
547,561,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	547,547,	
547,547,	547,547,	547,547,	547,547,	
547,547,	547,562,	0,0,	0,0,	
553,0,	547,547,	547,547,	547,547,	
547,547,	547,547,	547,547,	0,0,	
547,547,	547,547,	0,0,	0,0,	
0,0,	547,547,	547,547,	0,0,	
0,0,	0,0,	0,0,	547,561,	
0,0,	0,0,	0,0,	547,547,	
547,547,	547,547,	547,547,	547,547,	
547,547,	547,562,	547,547,	547,547,	
0,0,	0,0,	0,0,	553,553,	
0,0,	547,547,	553,553,	553,553,	
0,0,	547,547,	547,547,	0,0,	
0,0,	0,0,	0,0,	553,553,	
553,568,	0,0,	0,0,	547,561,	
0,0,	0,0,	0,0,	553,553,	
553,553,	553,553,	553,553,	553,553,	
553,553,	553,569,	0,0,	0,0,	
0,0,	553,553,	553,553,	553,553,	
553,553,	553,553,	553,553,	0,0,	
553,553,	553,553,	561,0,	0,0,	
0,0,	553,553,	553,553,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	553,553,	
553,553,	553,553,	553,553,	553,553,	
553,553,	553,569,	553,553,	553,553,	
0,0,	0,0,	0,0,	0,0,	
0,0,	553,553,	0,0,	561,561,	
0,0,	553,553,	553,553,	0,0,	
0,0,	561,561,	0,0,	0,0,	
561,561,	561,561,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	561,561,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	561,561,	561,561,	561,561,	
561,561,	561,561,	561,561,	561,574,	
0,0,	0,0,	0,0,	561,561,	
561,561,	561,561,	561,561,	561,561,	
561,561,	0,0,	561,561,	561,561,	
568,0,	0,0,	0,0,	561,561,	
561,561,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	561,561,	561,561,	561,561,	
561,561,	561,561,	561,561,	561,574,	
561,561,	561,561,	568,581,	0,0,	
0,0,	0,0,	0,0,	561,561,	
0,0,	568,561,	0,0,	561,561,	
561,561,	0,0,	0,0,	568,561,	
0,0,	0,0,	568,561,	568,561,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	568,561,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	568,561,	
568,561,	568,561,	568,561,	568,561,	
568,561,	568,574,	0,0,	0,0,	
569,0,	568,561,	568,561,	568,561,	
568,561,	568,561,	568,561,	0,0,	
568,561,	568,561,	0,0,	0,0,	
0,0,	568,561,	568,561,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	568,561,	
568,561,	568,561,	568,561,	568,561,	
568,561,	568,574,	568,561,	568,561,	
0,0,	0,0,	0,0,	569,553,	
0,0,	568,561,	569,553,	569,553,	
0,0,	568,561,	568,561,	0,0,	
0,0,	0,0,	0,0,	569,553,	
569,568,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	569,582,	
569,553,	569,553,	569,553,	569,553,	
569,553,	569,569,	0,0,	0,0,	
0,0,	569,553,	569,553,	569,553,	
569,553,	569,553,	569,553,	0,0,	
569,553,	569,553,	574,0,	0,0,	
0,0,	569,553,	569,553,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	569,583,	
569,553,	569,553,	569,553,	569,553,	
569,553,	569,569,	569,553,	569,553,	
0,0,	0,0,	0,0,	0,0,	
0,0,	569,553,	0,0,	574,561,	
0,0,	569,553,	569,553,	0,0,	
0,0,	574,561,	0,0,	0,0,	
574,561,	574,561,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	574,561,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	574,587,	574,561,	574,561,	
574,561,	574,561,	574,561,	574,574,	
0,0,	0,0,	0,0,	574,561,	
574,561,	574,561,	574,561,	574,561,	
574,561,	0,0,	574,561,	574,561,	
0,0,	0,0,	581,581,	574,561,	
574,561,	0,0,	0,0,	0,0,	
0,0,	0,0,	581,581,	0,0,	
0,0,	574,588,	574,561,	574,561,	
574,561,	574,561,	574,561,	574,574,	
574,561,	574,561,	0,0,	0,0,	
0,0,	0,0,	0,0,	574,561,	
0,0,	0,0,	0,0,	574,561,	
574,561,	581,581,	0,0,	581,581,	
581,581,	0,0,	581,581,	0,0,	
581,581,	581,581,	581,581,	0,0,	
581,581,	0,0,	581,581,	581,581,	
581,581,	581,581,	581,581,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	581,581,	581,581,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	581,581,	581,581,	
581,581,	581,581,	581,581,	581,581,	
581,595,	0,0,	0,0,	582,0,	
581,581,	581,581,	581,581,	581,581,	
581,581,	581,581,	0,0,	581,581,	
581,581,	0,0,	0,0,	0,0,	
581,581,	581,581,	0,0,	0,0,	
0,0,	0,0,	581,581,	0,0,	
0,0,	0,0,	581,581,	581,581,	
581,581,	581,581,	581,581,	581,581,	
581,595,	581,581,	581,581,	0,0,	
0,0,	0,0,	582,553,	0,0,	
581,581,	582,553,	582,553,	0,0,	
581,581,	581,581,	0,0,	0,0,	
0,0,	0,0,	582,553,	582,568,	
0,0,	0,0,	581,581,	0,0,	
0,0,	0,0,	582,553,	582,553,	
582,553,	582,553,	582,553,	582,553,	
582,569,	0,0,	0,0,	0,0,	
582,553,	582,553,	582,596,	582,553,	
582,553,	582,553,	0,0,	582,553,	
582,553,	583,0,	0,0,	0,0,	
582,553,	582,553,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	582,553,	582,553,	
582,553,	582,553,	582,553,	582,553,	
582,569,	582,553,	582,553,	0,0,	
0,0,	0,0,	582,553,	0,0,	
582,553,	0,0,	0,0,	0,0,	
582,553,	582,553,	0,0,	0,0,	
583,553,	0,0,	0,0,	583,553,	
583,553,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
583,553,	583,568,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
583,553,	583,553,	583,553,	583,553,	
583,553,	583,553,	583,569,	0,0,	
0,0,	0,0,	583,553,	583,553,	
583,553,	583,553,	583,553,	583,553,	
0,0,	583,553,	583,553,	587,0,	
0,0,	0,0,	583,553,	583,553,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
583,553,	583,553,	583,553,	583,553,	
583,553,	583,553,	583,569,	583,553,	
583,553,	0,0,	0,0,	0,0,	
583,597,	0,0,	583,553,	0,0,	
587,561,	0,0,	583,553,	583,553,	
0,0,	0,0,	587,561,	0,0,	
0,0,	587,561,	587,561,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	587,561,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	587,561,	587,561,	
587,561,	587,561,	587,561,	587,561,	
587,574,	0,0,	0,0,	0,0,	
587,561,	587,561,	587,601,	587,561,	
587,561,	587,561,	0,0,	587,561,	
587,561,	588,0,	0,0,	0,0,	
587,561,	587,561,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	587,561,	587,561,	
587,561,	587,561,	587,561,	587,561,	
587,574,	587,561,	587,561,	0,0,	
0,0,	0,0,	587,561,	0,0,	
587,561,	0,0,	588,561,	0,0,	
587,561,	587,561,	0,0,	0,0,	
588,561,	0,0,	0,0,	588,561,	
588,561,	0,0,	0,0,	0,0,	
0,0,	0,0,	589,0,	0,0,	
588,561,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
588,561,	588,561,	588,561,	588,561,	
588,561,	588,561,	588,574,	0,0,	
0,0,	0,0,	588,561,	588,561,	
588,561,	588,561,	588,561,	588,561,	
0,0,	588,561,	588,561,	0,0,	
0,0,	0,0,	588,561,	588,561,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
588,561,	588,561,	588,561,	588,561,	
588,561,	588,561,	588,574,	588,561,	
588,561,	0,0,	0,0,	0,0,	
588,602,	0,0,	588,561,	0,0,	
0,0,	589,603,	588,561,	588,561,	
589,547,	589,547,	589,547,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
589,547,	589,547,	589,547,	0,0,	
0,0,	589,547,	589,547,	0,0,	
595,581,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
595,581,	0,0,	0,0,	0,0,	
0,0,	0,0,	589,547,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	589,547,	589,547,	0,0,	
0,0,	589,547,	589,547,	595,581,	
0,0,	595,581,	595,581,	0,0,	
595,581,	0,0,	595,581,	595,581,	
595,581,	0,0,	595,581,	0,0,	
595,581,	595,581,	595,581,	595,581,	
595,581,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
595,581,	595,581,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
595,608,	595,581,	595,581,	595,581,	
595,581,	595,581,	595,595,	0,0,	
0,0,	596,0,	595,581,	595,581,	
595,581,	595,581,	595,581,	595,581,	
0,0,	595,581,	595,581,	0,0,	
0,0,	0,0,	595,581,	595,581,	
0,0,	0,0,	0,0,	0,0,	
595,581,	0,0,	0,0,	0,0,	
595,609,	595,581,	595,581,	595,581,	
595,581,	595,581,	595,595,	595,581,	
595,581,	0,0,	0,0,	0,0,	
596,553,	0,0,	595,581,	596,553,	
596,553,	0,0,	595,581,	595,581,	
0,0,	0,0,	0,0,	0,0,	
596,553,	596,568,	0,0,	0,0,	
595,581,	0,0,	0,0,	0,0,	
596,553,	596,553,	596,553,	596,553,	
596,610,	596,553,	596,569,	596,553,	
596,553,	596,553,	596,553,	596,553,	
596,553,	596,553,	596,553,	596,553,	
0,0,	596,553,	596,553,	596,553,	
596,553,	596,553,	596,553,	596,553,	
596,553,	596,553,	597,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
596,553,	596,553,	596,553,	596,553,	
596,553,	596,553,	596,569,	596,553,	
596,553,	596,553,	0,0,	0,0,	
0,0,	0,0,	596,553,	0,0,	
0,0,	0,0,	596,553,	596,553,	
596,553,	596,553,	0,0,	0,0,	
596,553,	596,553,	0,0,	0,0,	
0,0,	597,553,	0,0,	0,0,	
597,553,	597,553,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	597,553,	597,568,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	597,553,	597,553,	597,553,	
597,553,	597,553,	597,553,	597,569,	
0,0,	0,0,	0,0,	597,553,	
597,553,	597,553,	597,553,	597,553,	
597,553,	0,0,	597,553,	597,553,	
601,0,	0,0,	0,0,	597,553,	
597,553,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	597,553,	597,553,	597,553,	
597,553,	597,610,	597,553,	597,569,	
597,553,	597,553,	0,0,	0,0,	
0,0,	0,0,	0,0,	597,553,	
0,0,	601,561,	0,0,	597,553,	
597,553,	0,0,	0,0,	601,561,	
0,0,	0,0,	601,561,	601,561,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	601,561,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	601,561,	
601,561,	601,561,	601,561,	601,615,	
601,561,	601,574,	601,561,	601,561,	
601,561,	601,561,	601,561,	601,561,	
601,561,	601,561,	601,561,	0,0,	
601,561,	601,561,	601,561,	601,561,	
601,561,	601,561,	601,561,	601,561,	
601,561,	602,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	601,561,	
601,561,	601,561,	601,561,	601,561,	
601,561,	601,574,	601,561,	601,561,	
601,561,	0,0,	0,0,	0,0,	
0,0,	601,561,	0,0,	0,0,	
0,0,	601,561,	601,561,	601,561,	
601,561,	0,0,	602,561,	601,561,	
601,561,	0,0,	0,0,	0,0,	
602,561,	0,0,	0,0,	602,561,	
602,561,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
602,561,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
602,561,	602,561,	602,561,	602,561,	
602,561,	602,561,	602,574,	0,0,	
0,0,	0,0,	602,561,	602,561,	
602,561,	602,561,	602,561,	602,561,	
0,0,	602,561,	602,561,	0,0,	
0,0,	604,604,	602,561,	602,561,	
0,0,	0,0,	0,0,	0,0,	
0,0,	604,604,	604,616,	0,0,	
602,561,	602,561,	602,561,	602,561,	
602,615,	602,561,	602,574,	602,561,	
602,561,	0,0,	0,0,	0,0,	
0,0,	0,0,	602,561,	0,0,	
0,0,	0,0,	602,561,	602,561,	
604,604,	0,0,	604,604,	604,604,	
0,0,	604,604,	0,0,	604,604,	
604,604,	604,604,	0,0,	604,604,	
0,0,	604,604,	604,604,	604,604,	
604,604,	604,604,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	604,604,	604,604,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	604,604,	604,604,	604,604,	
604,604,	604,604,	604,604,	604,604,	
0,0,	0,0,	0,0,	604,604,	
604,604,	604,604,	604,604,	604,604,	
604,604,	0,0,	604,604,	604,604,	
0,0,	0,0,	0,0,	604,604,	
604,604,	0,0,	0,0,	0,0,	
0,0,	604,604,	0,0,	0,0,	
0,0,	604,604,	604,604,	604,604,	
604,604,	604,604,	604,604,	604,604,	
604,604,	604,604,	0,0,	0,0,	
0,0,	606,606,	0,0,	604,604,	
0,0,	0,0,	0,0,	604,604,	
604,604,	606,606,	606,618,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	604,604,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
606,606,	0,0,	606,606,	606,606,	
0,0,	606,606,	0,0,	606,606,	
606,606,	606,606,	0,0,	606,606,	
0,0,	606,606,	606,606,	606,606,	
606,606,	606,606,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	606,606,	606,606,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	606,606,	606,606,	606,606,	
606,606,	606,606,	606,606,	606,606,	
0,0,	0,0,	0,0,	606,606,	
606,606,	606,606,	606,606,	606,606,	
606,606,	0,0,	606,606,	606,606,	
0,0,	0,0,	0,0,	606,606,	
606,606,	0,0,	0,0,	0,0,	
0,0,	606,606,	0,0,	0,0,	
0,0,	606,606,	606,606,	606,606,	
606,606,	606,606,	606,606,	606,606,	
606,606,	606,606,	0,0,	0,0,	
0,0,	608,581,	0,0,	606,606,	
0,0,	0,0,	0,0,	606,606,	
606,606,	608,581,	608,371,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	606,606,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
608,581,	0,0,	608,581,	608,581,	
0,0,	608,581,	0,0,	608,581,	
608,581,	608,581,	0,0,	608,581,	
0,0,	608,581,	608,581,	608,581,	
608,581,	608,581,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	608,581,	608,581,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	608,581,	608,581,	608,581,	
608,581,	608,581,	608,581,	608,595,	
0,0,	0,0,	0,0,	608,581,	
608,581,	608,620,	608,581,	608,581,	
608,581,	0,0,	608,581,	608,581,	
610,0,	0,0,	0,0,	608,581,	
608,581,	0,0,	0,0,	0,0,	
0,0,	608,581,	0,0,	0,0,	
0,0,	608,581,	608,581,	608,581,	
608,581,	608,581,	608,581,	608,595,	
608,581,	608,581,	0,0,	0,0,	
0,0,	608,581,	0,0,	608,581,	
0,0,	0,0,	0,0,	608,581,	
608,581,	0,0,	0,0,	610,553,	
0,0,	0,0,	610,553,	610,553,	
0,0,	608,581,	0,0,	0,0,	
0,0,	0,0,	0,0,	610,553,	
610,568,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	610,553,	
610,553,	610,553,	610,553,	610,553,	
610,553,	610,569,	0,0,	0,0,	
0,0,	610,553,	610,553,	610,553,	
610,553,	610,553,	610,553,	0,0,	
610,553,	610,553,	615,0,	0,0,	
0,0,	610,553,	610,553,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	610,553,	
610,553,	610,553,	610,553,	610,553,	
610,553,	610,569,	610,553,	610,553,	
0,0,	0,0,	0,0,	0,0,	
0,0,	610,553,	0,0,	615,561,	
0,0,	610,553,	610,553,	0,0,	
0,0,	615,561,	0,0,	0,0,	
615,561,	615,561,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	615,561,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	615,561,	615,561,	615,561,	
615,561,	615,561,	615,561,	615,574,	
0,0,	0,0,	0,0,	615,561,	
615,561,	615,561,	615,561,	615,561,	
615,561,	0,0,	615,561,	615,561,	
0,0,	0,0,	620,581,	615,561,	
615,561,	0,0,	0,0,	0,0,	
0,0,	0,0,	620,581,	620,371,	
0,0,	615,561,	615,561,	615,561,	
615,561,	615,561,	615,561,	615,574,	
615,561,	615,561,	0,0,	0,0,	
0,0,	0,0,	0,0,	615,561,	
0,0,	0,0,	0,0,	615,561,	
615,561,	620,581,	0,0,	620,581,	
620,581,	0,0,	620,581,	0,0,	
620,581,	620,581,	620,581,	0,0,	
620,581,	0,0,	620,581,	620,581,	
620,581,	620,581,	620,581,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	620,581,	620,581,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	620,581,	620,581,	
620,581,	620,581,	620,626,	620,581,	
620,595,	620,581,	620,581,	620,581,	
620,581,	620,581,	620,581,	620,581,	
620,581,	620,581,	0,0,	620,581,	
620,581,	620,581,	620,581,	620,581,	
620,581,	620,581,	620,581,	620,581,	
0,0,	0,0,	620,581,	0,0,	
0,0,	0,0,	620,581,	620,581,	
620,581,	620,581,	620,581,	620,581,	
620,595,	620,581,	620,581,	620,581,	
0,0,	0,0,	0,0,	0,0,	
620,581,	621,581,	0,0,	0,0,	
620,581,	620,581,	620,581,	620,581,	
0,0,	621,581,	620,581,	620,581,	
0,0,	0,0,	620,581,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
621,581,	0,0,	621,581,	621,581,	
0,0,	621,581,	0,0,	621,581,	
621,581,	621,581,	0,0,	621,581,	
0,0,	621,581,	621,581,	621,581,	
621,581,	621,581,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	621,581,	621,581,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	621,581,	621,581,	621,581,	
621,581,	621,581,	621,581,	621,595,	
0,0,	0,0,	0,0,	621,581,	
621,581,	621,581,	621,581,	621,581,	
621,581,	0,0,	621,581,	621,581,	
0,0,	0,0,	0,0,	621,581,	
621,581,	0,0,	0,0,	0,0,	
0,0,	621,581,	0,0,	0,0,	
0,0,	621,581,	621,581,	621,581,	
621,581,	621,626,	621,581,	621,595,	
621,581,	621,581,	626,581,	0,0,	
0,0,	0,0,	0,0,	621,581,	
0,0,	0,0,	626,581,	621,581,	
621,581,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	621,581,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	626,581,	0,0,	626,581,	
626,581,	0,0,	626,581,	0,0,	
626,581,	626,581,	626,581,	0,0,	
626,581,	0,0,	626,581,	626,581,	
626,581,	626,581,	626,581,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	626,581,	626,581,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	626,581,	626,581,	
626,581,	626,581,	626,581,	626,581,	
626,595,	0,0,	0,0,	0,0,	
626,581,	626,581,	626,581,	626,581,	
626,581,	626,581,	0,0,	626,581,	
626,581,	0,0,	0,0,	0,0,	
626,581,	626,581,	0,0,	0,0,	
0,0,	0,0,	626,581,	0,0,	
0,0,	0,0,	626,581,	626,581,	
626,581,	626,581,	626,581,	626,581,	
626,595,	626,581,	626,581,	0,0,	
0,0,	0,0,	631,631,	0,0,	
626,581,	0,0,	0,0,	0,0,	
626,581,	626,581,	631,631,	631,632,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	626,581,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	631,631,	0,0,	631,631,	
631,631,	0,0,	631,631,	0,0,	
631,631,	631,631,	631,631,	0,0,	
631,631,	0,0,	631,631,	631,631,	
631,631,	631,631,	631,631,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	631,631,	631,631,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	631,631,	631,631,	
631,631,	631,631,	631,631,	631,631,	
631,631,	0,0,	0,0,	0,0,	
631,631,	631,631,	631,631,	631,631,	
631,631,	631,631,	0,0,	631,631,	
631,631,	0,0,	0,0,	0,0,	
631,631,	631,631,	0,0,	0,0,	
0,0,	0,0,	631,631,	0,0,	
0,0,	0,0,	631,631,	631,631,	
631,631,	631,631,	631,631,	631,631,	
631,631,	631,631,	631,631,	0,0,	
0,0,	0,0,	0,0,	0,0,	
631,631,	0,0,	0,0,	0,0,	
631,631,	631,631,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	631,254,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-83,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+10,	0,		yyvstop+3,
yycrank+159,	0,		yyvstop+5,
yycrank+178,	0,		yyvstop+7,
yycrank+-300,	0,		yyvstop+10,
yycrank+29,	0,		yyvstop+12,
yycrank+20,	0,		yyvstop+15,
yycrank+63,	yysvec+6,	yyvstop+17,
yycrank+381,	yysvec+6,	yyvstop+20,
yycrank+455,	yysvec+6,	yyvstop+24,
yycrank+-538,	0,		yyvstop+28,
yycrank+615,	yysvec+6,	yyvstop+31,
yycrank+18,	yysvec+6,	yyvstop+34,
yycrank+15,	yysvec+6,	yyvstop+37,
yycrank+31,	yysvec+6,	yyvstop+40,
yycrank+639,	yysvec+6,	yyvstop+43,
yycrank+16,	yysvec+6,	yyvstop+46,
yycrank+16,	yysvec+6,	yyvstop+49,
yycrank+699,	yysvec+6,	yyvstop+52,
yycrank+78,	yysvec+6,	yyvstop+55,
yycrank+425,	yysvec+6,	yyvstop+58,
yycrank+724,	yysvec+6,	yyvstop+61,
yycrank+14,	yysvec+6,	yyvstop+64,
yycrank+114,	yysvec+6,	yyvstop+67,
yycrank+-806,	0,		yyvstop+70,
yycrank+874,	yysvec+6,	yyvstop+72,
yycrank+901,	yysvec+6,	yyvstop+75,
yycrank+961,	yysvec+6,	yyvstop+78,
yycrank+985,	yysvec+6,	yyvstop+81,
yycrank+1057,	yysvec+6,	yyvstop+84,
yycrank+1081,	yysvec+6,	yyvstop+87,
yycrank+1141,	yysvec+6,	yyvstop+90,
yycrank+1172,	yysvec+6,	yyvstop+93,
yycrank+45,	yysvec+6,	yyvstop+96,
yycrank+-1248,	0,		yyvstop+99,
yycrank+32,	0,		yyvstop+101,
yycrank+1326,	0,		yyvstop+103,
yycrank+144,	yysvec+39,	yyvstop+106,
yycrank+1440,	yysvec+39,	yyvstop+109,
yycrank+1514,	yysvec+39,	yyvstop+113,
yycrank+-41,	yysvec+13,	yyvstop+117,
yycrank+1587,	yysvec+39,	yyvstop+120,
yycrank+39,	yysvec+39,	yyvstop+123,
yycrank+31,	yysvec+39,	yyvstop+126,
yycrank+37,	yysvec+39,	yyvstop+129,
yycrank+1611,	yysvec+39,	yyvstop+132,
yycrank+44,	yysvec+39,	yyvstop+135,
yycrank+17,	yysvec+39,	yyvstop+138,
yycrank+1671,	yysvec+39,	yyvstop+141,
yycrank+122,	yysvec+39,	yyvstop+144,
yycrank+1106,	yysvec+39,	yyvstop+147,
yycrank+1696,	yysvec+39,	yyvstop+150,
yycrank+48,	yysvec+39,	yyvstop+153,
yycrank+207,	yysvec+39,	yyvstop+156,
yycrank+1756,	yysvec+39,	yyvstop+159,
yycrank+1781,	yysvec+39,	yyvstop+162,
yycrank+1841,	yysvec+39,	yyvstop+165,
yycrank+1865,	yysvec+39,	yyvstop+168,
yycrank+1937,	yysvec+39,	yyvstop+171,
yycrank+1961,	yysvec+39,	yyvstop+174,
yycrank+2021,	yysvec+39,	yyvstop+177,
yycrank+2052,	yysvec+39,	yyvstop+180,
yycrank+127,	yysvec+39,	yyvstop+183,
yycrank+-29,	yysvec+37,	yyvstop+186,
yycrank+65,	0,		0,	
yycrank+0,	yysvec+5,	yyvstop+188,
yycrank+0,	yysvec+6,	yyvstop+190,
yycrank+-2128,	0,		0,	
yycrank+-2236,	0,		0,	
yycrank+-265,	yysvec+70,	0,	
yycrank+46,	0,		0,	
yycrank+0,	0,		yyvstop+192,
yycrank+39,	0,		0,	
yycrank+132,	0,		0,	
yycrank+147,	yysvec+6,	yyvstop+194,
yycrank+36,	0,		0,	
yycrank+39,	yysvec+6,	yyvstop+196,
yycrank+0,	yysvec+78,	0,	
yycrank+2299,	0,		0,	
yycrank+257,	yysvec+81,	0,	
yycrank+43,	yysvec+6,	yyvstop+199,
yycrank+125,	0,		0,	
yycrank+2373,	yysvec+6,	yyvstop+201,
yycrank+45,	0,		0,	
yycrank+0,	yysvec+6,	yyvstop+204,
yycrank+0,	yysvec+13,	yyvstop+207,
yycrank+0,	0,		yyvstop+209,
yycrank+340,	0,		0,	
yycrank+227,	yysvec+6,	yyvstop+211,
yycrank+416,	0,		0,	
yycrank+1500,	yysvec+6,	yyvstop+213,
yycrank+607,	0,		0,	
yycrank+732,	0,		0,	
yycrank+2391,	yysvec+6,	yyvstop+215,
yycrank+96,	yysvec+6,	yyvstop+217,
yycrank+96,	yysvec+6,	yyvstop+219,
yycrank+103,	yysvec+6,	yyvstop+221,
yycrank+118,	yysvec+6,	yyvstop+223,
yycrank+87,	yysvec+6,	yyvstop+225,
yycrank+90,	yysvec+6,	yyvstop+227,
yycrank+104,	yysvec+6,	yyvstop+229,
yycrank+18,	yysvec+6,	yyvstop+231,
yycrank+142,	yysvec+6,	yyvstop+233,
yycrank+885,	yysvec+6,	yyvstop+236,
yycrank+2451,	yysvec+6,	yyvstop+238,
yycrank+125,	yysvec+6,	yyvstop+240,
yycrank+119,	yysvec+6,	yyvstop+242,
yycrank+126,	yysvec+6,	yyvstop+244,
yycrank+-2511,	yysvec+27,	0,	
yycrank+-192,	yysvec+27,	0,	
yycrank+-2575,	yysvec+27,	0,	
yycrank+-642,	yysvec+27,	0,	
yycrank+0,	0,		yyvstop+246,
yycrank+882,	yysvec+6,	yyvstop+248,
yycrank+2626,	yysvec+6,	yyvstop+250,
yycrank+925,	0,		0,	
yycrank+953,	yysvec+6,	yyvstop+253,
yycrank+1041,	yysvec+6,	yyvstop+255,
yycrank+2698,	yysvec+6,	yyvstop+257,
yycrank+1019,	yysvec+6,	yyvstop+260,
yycrank+2716,	yysvec+6,	yyvstop+262,
yycrank+1354,	0,		0,	
yycrank+1362,	yysvec+6,	yyvstop+265,
yycrank+2788,	yysvec+6,	yyvstop+267,
yycrank+2860,	yysvec+6,	yyvstop+270,
yycrank+1424,	yysvec+6,	yyvstop+272,
yycrank+129,	yysvec+6,	yyvstop+274,
yycrank+130,	yysvec+6,	yyvstop+276,
yycrank+-259,	yysvec+37,	0,	
yycrank+-2936,	yysvec+37,	0,	
yycrank+-184,	yysvec+37,	0,	
yycrank+237,	0,		yyvstop+279,
yycrank+-3044,	0,		0,	
yycrank+0,	yysvec+39,	yyvstop+281,
yycrank+238,	0,		0,	
yycrank+223,	yysvec+39,	yyvstop+283,
yycrank+225,	yysvec+39,	yyvstop+285,
yycrank+271,	0,		0,	
yycrank+226,	yysvec+39,	yyvstop+288,
yycrank+3124,	yysvec+39,	yyvstop+290,
yycrank+273,	0,		0,	
yycrank+0,	yysvec+39,	yyvstop+293,
yycrank+-3207,	0,		yyvstop+296,
yycrank+1410,	yysvec+39,	yyvstop+298,
yycrank+2362,	yysvec+39,	yyvstop+300,
yycrank+285,	yysvec+94,	0,	
yycrank+3275,	yysvec+39,	yyvstop+302,
yycrank+222,	yysvec+39,	yyvstop+304,
yycrank+232,	yysvec+39,	yyvstop+306,
yycrank+239,	yysvec+39,	yyvstop+308,
yycrank+253,	yysvec+39,	yyvstop+310,
yycrank+225,	yysvec+39,	yyvstop+312,
yycrank+229,	yysvec+39,	yyvstop+314,
yycrank+234,	yysvec+39,	yyvstop+316,
yycrank+272,	yysvec+39,	yyvstop+318,
yycrank+273,	yysvec+39,	yyvstop+320,
yycrank+1477,	yysvec+39,	yyvstop+323,
yycrank+3299,	yysvec+39,	yyvstop+325,
yycrank+256,	yysvec+39,	yyvstop+327,
yycrank+249,	yysvec+39,	yyvstop+329,
yycrank+245,	yysvec+39,	yyvstop+331,
yycrank+1475,	yysvec+39,	yyvstop+333,
yycrank+3346,	yysvec+39,	yyvstop+335,
yycrank+324,	yysvec+118,	0,	
yycrank+1579,	yysvec+39,	yyvstop+338,
yycrank+1727,	yysvec+39,	yyvstop+340,
yycrank+3418,	yysvec+39,	yyvstop+342,
yycrank+1720,	yysvec+39,	yyvstop+345,
yycrank+3436,	yysvec+39,	yyvstop+347,
yycrank+327,	yysvec+124,	0,	
yycrank+1764,	yysvec+39,	yyvstop+350,
yycrank+3508,	yysvec+39,	yyvstop+352,
yycrank+3580,	yysvec+39,	yyvstop+355,
yycrank+1853,	yysvec+39,	yyvstop+357,
yycrank+249,	yysvec+39,	yyvstop+359,
yycrank+250,	yysvec+39,	yyvstop+361,
yycrank+-396,	yysvec+37,	0,	
yycrank+248,	0,		0,	
yycrank+-322,	yysvec+70,	0,	
yycrank+-323,	yysvec+71,	0,	
yycrank+-3656,	yysvec+71,	0,	
yycrank+-3764,	0,		0,	
yycrank+-409,	yysvec+70,	0,	
yycrank+-541,	yysvec+70,	0,	
yycrank+-3872,	0,		0,	
yycrank+-3980,	0,		0,	
yycrank+0,	0,		yyvstop+364,
yycrank+340,	0,		0,	
yycrank+341,	0,		0,	
yycrank+342,	0,		0,	
yycrank+336,	yysvec+6,	yyvstop+366,
yycrank+352,	yysvec+6,	yyvstop+369,
yycrank+353,	0,		yyvstop+372,
yycrank+0,	yysvec+6,	yyvstop+374,
yycrank+0,	0,		yyvstop+377,
yycrank+354,	0,		0,	
yycrank+357,	0,		0,	
yycrank+360,	0,		0,	
yycrank+362,	yysvec+6,	yyvstop+379,
yycrank+363,	0,		yyvstop+382,
yycrank+441,	0,		yyvstop+384,
yycrank+291,	0,		0,	
yycrank+295,	0,		0,	
yycrank+310,	0,		0,	
yycrank+308,	0,		0,	
yycrank+1881,	yysvec+6,	yyvstop+386,
yycrank+1921,	0,		0,	
yycrank+1899,	yysvec+6,	yyvstop+388,
yycrank+1929,	0,		0,	
yycrank+2033,	yysvec+6,	yyvstop+390,
yycrank+2205,	0,		0,	
yycrank+2304,	0,		0,	
yycrank+3094,	yysvec+6,	yyvstop+392,
yycrank+313,	yysvec+6,	yyvstop+395,
yycrank+315,	yysvec+6,	yyvstop+397,
yycrank+299,	yysvec+6,	yyvstop+399,
yycrank+464,	yysvec+6,	yyvstop+401,
yycrank+354,	yysvec+6,	yyvstop+403,
yycrank+318,	yysvec+6,	yyvstop+405,
yycrank+375,	yysvec+6,	yyvstop+407,
yycrank+4016,	yysvec+6,	yyvstop+410,
yycrank+316,	yysvec+6,	yyvstop+412,
yycrank+315,	yysvec+6,	yyvstop+414,
yycrank+308,	yysvec+6,	yyvstop+416,
yycrank+-4092,	0,		yyvstop+418,
yycrank+-4200,	yysvec+27,	0,	
yycrank+-4275,	yysvec+27,	0,	
yycrank+-4360,	0,		0,	
yycrank+4406,	yysvec+6,	yyvstop+421,
yycrank+2460,	0,		0,	
yycrank+2269,	yysvec+6,	yyvstop+424,
yycrank+2287,	0,		0,	
yycrank+403,	yysvec+232,	0,	
yycrank+405,	yysvec+6,	yyvstop+426,
yycrank+2463,	yysvec+6,	yyvstop+429,
yycrank+2644,	yysvec+6,	yyvstop+431,
yycrank+4440,	0,		yyvstop+434,
yycrank+4462,	yysvec+6,	yyvstop+436,
yycrank+2786,	0,		0,	
yycrank+408,	yysvec+241,	0,	
yycrank+410,	yysvec+6,	yyvstop+439,
yycrank+4512,	yysvec+6,	yyvstop+442,
yycrank+2430,	yysvec+6,	yyvstop+445,
yycrank+2618,	0,		0,	
yycrank+2716,	yysvec+6,	yyvstop+447,
yycrank+2734,	yysvec+6,	yyvstop+449,
yycrank+2870,	yysvec+239,	yyvstop+452,
yycrank+4530,	yysvec+6,	yyvstop+454,
yycrank+4557,	yysvec+6,	yyvstop+457,
yycrank+2900,	yysvec+6,	yyvstop+461,
yycrank+407,	yysvec+6,	yyvstop+464,
yycrank+0,	0,		yyvstop+467,
yycrank+-492,	yysvec+37,	0,	
yycrank+426,	0,		0,	
yycrank+439,	0,		0,	
yycrank+-4641,	0,		yyvstop+469,
yycrank+426,	yysvec+39,	yyvstop+471,
yycrank+444,	yysvec+39,	yyvstop+474,
yycrank+0,	yysvec+39,	yyvstop+477,
yycrank+445,	yysvec+39,	yyvstop+480,
yycrank+0,	yysvec+135,	yyvstop+483,
yycrank+-468,	yysvec+13,	yyvstop+485,
yycrank+2878,	yysvec+39,	yyvstop+487,
yycrank+2965,	yysvec+39,	yyvstop+489,
yycrank+458,	yysvec+211,	0,	
yycrank+3112,	yysvec+39,	yyvstop+491,
yycrank+4677,	yysvec+39,	yyvstop+493,
yycrank+398,	yysvec+39,	yyvstop+496,
yycrank+399,	yysvec+39,	yyvstop+498,
yycrank+381,	yysvec+39,	yyvstop+500,
yycrank+556,	yysvec+39,	yyvstop+502,
yycrank+445,	yysvec+39,	yyvstop+504,
yycrank+401,	yysvec+39,	yyvstop+506,
yycrank+487,	yysvec+39,	yyvstop+508,
yycrank+4702,	yysvec+39,	yyvstop+511,
yycrank+433,	yysvec+39,	yyvstop+513,
yycrank+435,	yysvec+39,	yyvstop+515,
yycrank+428,	yysvec+39,	yyvstop+517,
yycrank+-4762,	yysvec+227,	yyvstop+519,
yycrank+4587,	yysvec+39,	yyvstop+522,
yycrank+3237,	yysvec+39,	yyvstop+525,
yycrank+513,	yysvec+234,	0,	
yycrank+509,	yysvec+39,	yyvstop+527,
yycrank+3315,	yysvec+39,	yyvstop+530,
yycrank+3436,	yysvec+39,	yyvstop+532,
yycrank+4808,	yysvec+39,	yyvstop+535,
yycrank+523,	yysvec+39,	yyvstop+538,
yycrank+4842,	yysvec+39,	yyvstop+541,
yycrank+3338,	yysvec+39,	yyvstop+544,
yycrank+542,	yysvec+246,	0,	
yycrank+3454,	yysvec+39,	yyvstop+546,
yycrank+3526,	yysvec+39,	yyvstop+548,
yycrank+4876,	yysvec+39,	yyvstop+551,
yycrank+4903,	yysvec+39,	yyvstop+554,
yycrank+3596,	yysvec+39,	yyvstop+558,
yycrank+531,	yysvec+39,	yyvstop+561,
yycrank+-676,	yysvec+37,	0,	
yycrank+490,	0,		0,	
yycrank+0,	0,		yyvstop+564,
yycrank+0,	yysvec+184,	yyvstop+566,
yycrank+-552,	yysvec+184,	0,	
yycrank+-4987,	yysvec+71,	0,	
yycrank+0,	0,		yyvstop+568,
yycrank+-553,	yysvec+70,	0,	
yycrank+-583,	yysvec+187,	yyvstop+570,
yycrank+-587,	yysvec+188,	yyvstop+572,
yycrank+0,	yysvec+78,	0,	
yycrank+0,	yysvec+78,	0,	
yycrank+0,	yysvec+78,	0,	
yycrank+551,	yysvec+6,	yyvstop+574,
yycrank+560,	0,		0,	
yycrank+0,	yysvec+86,	0,	
yycrank+0,	yysvec+84,	0,	
yycrank+0,	yysvec+86,	0,	
yycrank+579,	0,		0,	
yycrank+725,	0,		0,	
yycrank+579,	0,		0,	
yycrank+497,	0,		0,	
yycrank+508,	0,		0,	
yycrank+508,	0,		0,	
yycrank+512,	0,		0,	
yycrank+0,	yysvec+6,	yyvstop+576,
yycrank+5023,	0,		0,	
yycrank+3548,	0,		0,	
yycrank+0,	yysvec+6,	yyvstop+579,
yycrank+0,	0,		yyvstop+582,
yycrank+0,	0,		yyvstop+584,
yycrank+3572,	yysvec+6,	yyvstop+586,
yycrank+3685,	0,		0,	
yycrank+3841,	yysvec+6,	yyvstop+588,
yycrank+522,	yysvec+6,	yyvstop+590,
yycrank+523,	yysvec+6,	yyvstop+592,
yycrank+612,	yysvec+6,	yyvstop+594,
yycrank+579,	0,		0,	
yycrank+576,	yysvec+6,	yyvstop+597,
yycrank+-5099,	0,		yyvstop+599,
yycrank+0,	yysvec+6,	yyvstop+602,
yycrank+553,	yysvec+6,	yyvstop+605,
yycrank+530,	yysvec+6,	yyvstop+607,
yycrank+533,	yysvec+6,	yyvstop+609,
yycrank+544,	yysvec+6,	yyvstop+611,
yycrank+-5173,	yysvec+227,	yyvstop+613,
yycrank+-640,	yysvec+227,	yyvstop+615,
yycrank+-5258,	yysvec+27,	0,	
yycrank+-5322,	yysvec+27,	0,	
yycrank+-5407,	0,		yyvstop+618,
yycrank+615,	0,		yyvstop+620,
yycrank+3949,	0,		0,	
yycrank+0,	0,		yyvstop+622,
yycrank+4933,	yysvec+6,	yyvstop+624,
yycrank+5453,	0,		yyvstop+627,
yycrank+616,	0,		yyvstop+629,
yycrank+4146,	0,		0,	
yycrank+618,	yysvec+355,	0,	
yycrank+618,	yysvec+6,	yyvstop+631,
yycrank+0,	0,		yyvstop+634,
yycrank+4240,	0,		0,	
yycrank+5463,	yysvec+6,	yyvstop+636,
yycrank+0,	yysvec+353,	yyvstop+640,
yycrank+5487,	yysvec+6,	yyvstop+643,
yycrank+4802,	yysvec+6,	yyvstop+647,
yycrank+550,	yysvec+6,	yyvstop+650,
yycrank+-736,	yysvec+37,	0,	
yycrank+0,	yysvec+8,	yyvstop+652,
yycrank+700,	0,		0,	
yycrank+759,	0,		0,	
yycrank+575,	0,		0,	
yycrank+564,	0,		0,	
yycrank+757,	0,		0,	
yycrank+633,	yysvec+39,	yyvstop+654,
yycrank+-585,	yysvec+13,	yyvstop+656,
yycrank+-585,	yysvec+13,	yyvstop+658,
yycrank+0,	yysvec+39,	yyvstop+660,
yycrank+0,	yysvec+39,	yyvstop+663,
yycrank+4432,	yysvec+39,	yyvstop+666,
yycrank+666,	yysvec+331,	0,	
yycrank+4733,	yysvec+39,	yyvstop+668,
yycrank+592,	yysvec+39,	yyvstop+670,
yycrank+593,	yysvec+39,	yyvstop+672,
yycrank+698,	yysvec+39,	yyvstop+674,
yycrank+656,	yysvec+39,	yyvstop+677,
yycrank+-5547,	yysvec+338,	yyvstop+679,
yycrank+0,	yysvec+39,	yyvstop+682,
yycrank+622,	yysvec+39,	yyvstop+685,
yycrank+617,	yysvec+39,	yyvstop+687,
yycrank+625,	yysvec+39,	yyvstop+689,
yycrank+628,	yysvec+39,	yyvstop+691,
yycrank+-5611,	yysvec+227,	yyvstop+693,
yycrank+-5685,	yysvec+227,	yyvstop+696,
yycrank+5731,	yysvec+39,	yyvstop+698,
yycrank+690,	yysvec+39,	yyvstop+701,
yycrank+5741,	yysvec+39,	yyvstop+704,
yycrank+5765,	yysvec+39,	yyvstop+708,
yycrank+5587,	yysvec+39,	yyvstop+712,
yycrank+623,	yysvec+39,	yyvstop+715,
yycrank+-811,	yysvec+37,	0,	
yycrank+655,	0,		0,	
yycrank+-720,	yysvec+70,	0,	
yycrank+-5848,	0,		0,	
yycrank+-5956,	0,		0,	
yycrank+-6064,	0,		0,	
yycrank+-6172,	0,		0,	
yycrank+-6280,	0,		0,	
yycrank+-6388,	0,		0,	
yycrank+713,	0,		0,	
yycrank+758,	0,		0,	
yycrank+665,	0,		0,	
yycrank+665,	0,		0,	
yycrank+667,	0,		0,	
yycrank+667,	0,		0,	
yycrank+5651,	0,		0,	
yycrank+0,	0,		yyvstop+717,
yycrank+6434,	yysvec+6,	yyvstop+719,
yycrank+749,	yysvec+6,	yyvstop+722,
yycrank+709,	yysvec+6,	yyvstop+724,
yycrank+1133,	0,		0,	
yycrank+760,	yysvec+6,	yyvstop+726,
yycrank+738,	0,		0,	
yycrank+725,	yysvec+6,	yyvstop+729,
yycrank+694,	yysvec+6,	yyvstop+731,
yycrank+-6486,	yysvec+338,	yyvstop+733,
yycrank+-799,	yysvec+338,	yyvstop+735,
yycrank+701,	yysvec+6,	yyvstop+738,
yycrank+704,	yysvec+6,	yyvstop+740,
yycrank+-6571,	0,		0,	
yycrank+0,	0,		yyvstop+742,
yycrank+0,	yysvec+348,	0,	
yycrank+870,	0,		0,	
yycrank+6617,	0,		yyvstop+745,
yycrank+5474,	0,		0,	
yycrank+774,	yysvec+432,	0,	
yycrank+779,	yysvec+6,	yyvstop+747,
yycrank+796,	0,		yyvstop+750,
yycrank+0,	0,		yyvstop+752,
yycrank+0,	yysvec+431,	yyvstop+754,
yycrank+-1018,	yysvec+37,	0,	
yycrank+0,	yysvec+78,	0,	
yycrank+820,	0,		0,	
yycrank+0,	yysvec+86,	0,	
yycrank+730,	0,		0,	
yycrank+735,	0,		0,	
yycrank+-6700,	yysvec+258,	yyvstop+757,
yycrank+-748,	yysvec+13,	yyvstop+759,
yycrank+-743,	yysvec+13,	yyvstop+761,
yycrank+6746,	yysvec+39,	yyvstop+763,
yycrank+829,	yysvec+39,	yyvstop+766,
yycrank+789,	yysvec+39,	yyvstop+768,
yycrank+830,	yysvec+39,	yyvstop+770,
yycrank+800,	yysvec+39,	yyvstop+773,
yycrank+769,	yysvec+39,	yyvstop+775,
yycrank+-6800,	yysvec+338,	yyvstop+777,
yycrank+-6874,	yysvec+338,	yyvstop+780,
yycrank+777,	yysvec+39,	yyvstop+782,
yycrank+781,	yysvec+39,	yyvstop+784,
yycrank+-6959,	yysvec+258,	yyvstop+786,
yycrank+850,	yysvec+39,	yyvstop+789,
yycrank+-1023,	yysvec+37,	0,	
yycrank+792,	0,		0,	
yycrank+0,	0,		yyvstop+792,
yycrank+-885,	yysvec+401,	yyvstop+795,
yycrank+-886,	yysvec+402,	yyvstop+797,
yycrank+-887,	yysvec+403,	yyvstop+799,
yycrank+-902,	yysvec+404,	yyvstop+801,
yycrank+-903,	yysvec+405,	yyvstop+803,
yycrank+-906,	yysvec+406,	yyvstop+805,
yycrank+871,	0,		0,	
yycrank+870,	0,		0,	
yycrank+831,	0,		0,	
yycrank+842,	0,		0,	
yycrank+843,	0,		yyvstop+807,
yycrank+842,	0,		0,	
yycrank+7005,	0,		yyvstop+810,
yycrank+5752,	0,		0,	
yycrank+907,	yysvec+475,	0,	
yycrank+908,	yysvec+6,	yyvstop+812,
yycrank+863,	yysvec+6,	yyvstop+815,
yycrank+-7088,	0,		0,	
yycrank+860,	0,		0,	
yycrank+843,	0,		0,	
yycrank+897,	0,		0,	
yycrank+866,	0,		0,	
yycrank+885,	yysvec+6,	yyvstop+817,
yycrank+854,	yysvec+6,	yyvstop+819,
yycrank+892,	yysvec+6,	yyvstop+821,
yycrank+873,	yysvec+6,	yyvstop+824,
yycrank+0,	0,		yyvstop+826,
yycrank+0,	0,		yyvstop+829,
yycrank+946,	0,		yyvstop+831,
yycrank+0,	0,		yyvstop+833,
yycrank+0,	yysvec+134,	yyvstop+835,
yycrank+887,	0,		0,	
yycrank+885,	0,		0,	
yycrank+-7193,	yysvec+258,	yyvstop+838,
yycrank+-890,	yysvec+13,	yyvstop+840,
yycrank+-887,	yysvec+13,	yyvstop+842,
yycrank+954,	yysvec+39,	yyvstop+844,
yycrank+899,	yysvec+39,	yyvstop+847,
yycrank+914,	yysvec+39,	yyvstop+849,
yycrank+893,	yysvec+39,	yyvstop+851,
yycrank+-7298,	yysvec+258,	yyvstop+853,
yycrank+917,	yysvec+39,	yyvstop+856,
yycrank+923,	yysvec+39,	yyvstop+859,
yycrank+-1093,	yysvec+37,	0,	
yycrank+0,	0,		yyvstop+861,
yycrank+930,	0,		0,	
yycrank+1001,	0,		0,	
yycrank+1010,	0,		yyvstop+863,
yycrank+934,	0,		0,	
yycrank+940,	0,		0,	
yycrank+946,	0,		0,	
yycrank+0,	0,		yyvstop+865,
yycrank+937,	0,		0,	
yycrank+1007,	0,		yyvstop+868,
yycrank+0,	0,		yyvstop+870,
yycrank+-1059,	yysvec+479,	yyvstop+872,
yycrank+958,	0,		0,	
yycrank+1042,	0,		0,	
yycrank+993,	0,		0,	
yycrank+962,	0,		0,	
yycrank+995,	yysvec+6,	yyvstop+874,
yycrank+964,	yysvec+6,	yyvstop+876,
yycrank+998,	yysvec+6,	yyvstop+878,
yycrank+0,	yysvec+6,	yyvstop+880,
yycrank+984,	yysvec+6,	yyvstop+883,
yycrank+1069,	0,		0,	
yycrank+987,	0,		0,	
yycrank+-1072,	yysvec+13,	yyvstop+885,
yycrank+-998,	yysvec+13,	yyvstop+887,
yycrank+1041,	yysvec+39,	yyvstop+889,
yycrank+1010,	yysvec+39,	yyvstop+891,
yycrank+1027,	yysvec+39,	yyvstop+893,
yycrank+0,	yysvec+39,	yyvstop+895,
yycrank+1012,	yysvec+39,	yyvstop+898,
yycrank+-1117,	yysvec+37,	0,	
yycrank+1019,	0,		0,	
yycrank+0,	yysvec+469,	0,	
yycrank+1109,	0,		0,	
yycrank+1030,	0,		0,	
yycrank+1028,	0,		0,	
yycrank+1074,	0,		yyvstop+900,
yycrank+1045,	0,		0,	
yycrank+1086,	0,		0,	
yycrank+1064,	0,		0,	
yycrank+1033,	0,		0,	
yycrank+-7406,	0,		yyvstop+902,
yycrank+1050,	yysvec+6,	yyvstop+904,
yycrank+1050,	0,		0,	
yycrank+1058,	0,		0,	
yycrank+-1062,	yysvec+13,	yyvstop+906,
yycrank+-1062,	yysvec+13,	yyvstop+908,
yycrank+-7470,	yysvec+547,	yyvstop+910,
yycrank+1070,	yysvec+39,	yyvstop+912,
yycrank+-1205,	yysvec+37,	0,	
yycrank+1056,	0,		0,	
yycrank+1075,	0,		0,	
yycrank+1087,	0,		0,	
yycrank+0,	0,		yyvstop+914,
yycrank+1072,	0,		0,	
yycrank+-7544,	yysvec+547,	0,	
yycrank+-1201,	yysvec+547,	yyvstop+916,
yycrank+0,	yysvec+6,	yyvstop+918,
yycrank+1093,	0,		0,	
yycrank+1091,	0,		0,	
yycrank+-1107,	yysvec+13,	yyvstop+921,
yycrank+-1102,	yysvec+13,	yyvstop+923,
yycrank+-7618,	yysvec+547,	0,	
yycrank+-7682,	yysvec+547,	yyvstop+925,
yycrank+0,	yysvec+39,	yyvstop+927,
yycrank+-1207,	yysvec+37,	0,	
yycrank+1115,	0,		0,	
yycrank+1111,	0,		0,	
yycrank+-7756,	yysvec+547,	0,	
yycrank+-1223,	yysvec+547,	yyvstop+930,
yycrank+-1224,	yysvec+547,	yyvstop+932,
yycrank+1110,	0,		0,	
yycrank+1110,	0,		0,	
yycrank+-1127,	yysvec+13,	yyvstop+934,
yycrank+-1126,	yysvec+13,	yyvstop+936,
yycrank+-7841,	yysvec+258,	yyvstop+938,
yycrank+-7905,	yysvec+547,	yyvstop+940,
yycrank+-7979,	yysvec+547,	yyvstop+942,
yycrank+-1254,	yysvec+37,	0,	
yycrank+1121,	0,		0,	
yycrank+1130,	0,		0,	
yycrank+-8053,	yysvec+547,	0,	
yycrank+-8127,	yysvec+547,	0,	
yycrank+-8172,	yysvec+547,	yyvstop+944,
yycrank+-1238,	yysvec+547,	yyvstop+946,
yycrank+1158,	0,		0,	
yycrank+1231,	0,		0,	
yycrank+-1164,	yysvec+13,	yyvstop+948,
yycrank+-1235,	yysvec+13,	yyvstop+950,
yycrank+-8263,	yysvec+258,	yyvstop+952,
yycrank+-8327,	yysvec+547,	yyvstop+954,
yycrank+-8408,	yysvec+547,	yyvstop+956,
yycrank+-1309,	yysvec+37,	0,	
yycrank+1189,	0,		0,	
yycrank+1163,	0,		0,	
yycrank+-8482,	yysvec+547,	0,	
yycrank+-8563,	yysvec+547,	0,	
yycrank+-1267,	yysvec+547,	yyvstop+958,
yycrank+-8648,	0,		yyvstop+961,
yycrank+1176,	0,		0,	
yycrank+-8756,	0,		yyvstop+963,
yycrank+-1177,	yysvec+13,	yyvstop+966,
yycrank+-8864,	0,		yyvstop+968,
yycrank+-1231,	yysvec+608,	yyvstop+970,
yycrank+-8938,	yysvec+547,	yyvstop+972,
yycrank+-1648,	yysvec+37,	0,	
yycrank+1181,	0,		0,	
yycrank+0,	0,		yyvstop+975,
yycrank+1173,	0,		0,	
yycrank+-9012,	yysvec+547,	yyvstop+977,
yycrank+0,	0,		yyvstop+979,
yycrank+1181,	0,		0,	
yycrank+0,	0,		yyvstop+981,
yycrank+-1196,	yysvec+13,	yyvstop+984,
yycrank+-9097,	0,		yyvstop+986,
yycrank+-9208,	yysvec+258,	yyvstop+988,
yycrank+-1685,	yysvec+37,	0,	
yycrank+1197,	0,		0,	
yycrank+1201,	0,		0,	
yycrank+-1202,	yysvec+13,	yyvstop+990,
yycrank+-9313,	yysvec+258,	yyvstop+992,
yycrank+-1708,	yysvec+37,	0,	
yycrank+0,	yysvec+591,	0,	
yycrank+-1211,	yysvec+13,	yyvstop+995,
yycrank+-1312,	yysvec+37,	0,	
yycrank+-9421,	0,		0,	
yycrank+-1275,	yysvec+631,	0,	
yycrank+-1276,	yysvec+631,	0,	
yycrank+-1284,	yysvec+631,	0,	
yycrank+-1289,	yysvec+631,	0,	
yycrank+-1292,	yysvec+631,	0,	
yycrank+-1293,	yysvec+631,	0,	
yycrank+-1297,	yysvec+631,	0,	
yycrank+-1298,	yysvec+631,	0,	
yycrank+-1299,	yysvec+631,	0,	
yycrank+-1310,	yysvec+631,	0,	
yycrank+-1311,	yysvec+631,	0,	
yycrank+-1317,	yysvec+631,	0,	
yycrank+-1322,	yysvec+631,	0,	
yycrank+-1323,	yysvec+631,	0,	
yycrank+-1245,	yysvec+631,	0,	
yycrank+1362,	0,		yyvstop+997,
yycrank+0,	0,		yyvstop+1000,
0,	0,	0};
struct yywork *yytop = yycrank+9546;
struct yysvf *yybgin = yysvec+1;
unsigned char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
' ' ,01  ,'"' ,'#' ,01  ,'%' ,01  ,047 ,
'(' ,')' ,01  ,'+' ,01  ,'-' ,'.' ,'/' ,
'0' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,
'1' ,'9' ,':' ,'%' ,01  ,'+' ,01  ,01  ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,
'E' ,'E' ,'E' ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'N' ,'R' ,'S' ,'E' ,'E' ,'E' ,'W' ,
'X' ,'E' ,'E' ,01  ,01  ,']' ,01  ,'+' ,
01  ,'a' ,'b' ,'c' ,'d' ,'e' ,'f' ,'g' ,
'h' ,'i' ,'E' ,'K' ,'L' ,'M' ,'N' ,'o' ,
'P' ,'N' ,'R' ,'s' ,'t' ,'E' ,'E' ,'W' ,
'X' ,'E' ,'E' ,01  ,01  ,'}' ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
unsigned char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,1,0,0,1,0,0,
1,0,0,1,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
*/
/*
#
# IBM CONFIDENTIAL
# Copyright International Business Machines Corp. 1989
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of IBM
#
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
# 
*/
/* @(#)ncform	1.3  com/lib/l,3.1,8951 9/7/89 18:48:47 */
int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
unsigned char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
unsigned char yysbuf[YYLMAX];
unsigned char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	unsigned char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
            if (yylastch >= yytext + YYLMAX) {
                fprintf(yyout, "Maximum token length exceeded\n");
                yytext[YYLMAX] = 0;
                return 0;
            }
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( yyt > yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if(yyt < yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
                if (yyleng >= YYLMAX) {
                    fprintf(yyout, "Maximum token length exceeded\n");
                    yytext[YYLMAX] = 0;
                    return 0;
                }
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
