/*
    SABRE Fighter Plane Simulator 
    Copyright (c) 1997 Dan Hammer
    Portions Donated By Antti Barck

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/*************************************************
 *           SABRE Fighter Plane Simulator              *
 * Version: 0.1                                  *
 * File   : vga_13.h                             *
 * Date   : March, 1997                          *
 * Author : Dan Hammer                           *
 * Low level graphics routines header.           *
 *************************************************/
#ifndef __vga_13_h
#define __vga_13_h

#include "grafix.h"

class SimFont;

extern unsigned char *xbuffer;
extern unsigned char *buffer_ptr;
extern unsigned char *screen_ptr;
extern float aspect_ratio;
extern int   VGAMODE;
extern int   SCREEN_WIDTH;
extern int   SCREEN_HEIGHT;
extern int   MXSCREEN_WIDTH;
extern int   MXSCREEN_HEIGHT;
extern int   MAX_X;
extern int   MAX_Y;
extern int   N_COLORS;
extern int   PALETTE_SIZE;

extern SimFont      *g_font;
extern Rect         cliprect;

#define VIDEO 0x10

typedef int ( p_callback)(int);

void init_vga_13(void);
void restorecrtmode(void);
void putpixel(int x, int y, int color);
void read_palette(int start, int number, char * palette);
void clr_palette(int start, int number);
float calc_aspect_ratio(float h, float w);
void set_rgb_value(int color, char red, char green, char blue);
void get_rgb_value(int color, char *red, char *green, char *blue);
void set_palette(int startcolor, int endcolor, char *palette);
void get_palette(int startcolor, int endcolor, char *palette);
void fade_palette_out(int startcolor, int endcolor, p_callback *pb);

void clear_scr(char color, int row);
void clear_scr(char color);
void blit_buff();
void h_line(int x, int y, int len, int color);
void v_line(int x, int y, int len, int color);
void fill_rect(Rect &r, int color);

#ifndef __grafix_h
struct Rect;
#endif

void b_linedraw(int x1, int y1, int x2, int y2, int color, Rect *bounds);

#endif

