/*-------------------------------------------------------------------------*/
/* rcfile.c --- Load initialization variables from the .xcircuitrc file	   */
/* Copyright (c) 1998  Tim Edwards, Johns Hopkins University        	   */
/*-------------------------------------------------------------------------*/
   
/*-------------------------------------------------------------------------*/
/*      written by Tim Edwards, 9/9/96                                     */
/*-------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include "Xw/Xw.h"

#define Loaded 2

/*-------------------------------------------------------------------------*/
/* Local includes                                                          */
/*-------------------------------------------------------------------------*/

#include "xcircuit.h"

/*-------------------------------------------------------------------------*/
/* Global Variable definitions						   */
/*-------------------------------------------------------------------------*/

extern char _STR2[250], _STR[150];
extern char **fonts;
extern short fontcount;
extern Clientdata areastruct;
extern short beeper;

extern void setdefaultfontmarks();

/*-------------------------------------------------------------------------*/

loadrcfile()
{
   char *userdir = getenv((const char *)"HOME");
   FILE *fd;
   char temp[250], commandstr[30], type[50], value[50];
   char *cmdptr;
   short liboverride = False, coloroverride = False;

   sprintf(_STR2, "%s", USER_RC_FILE);     /* Name imported from Makefile */

   /* try first in current directory, then look in user's home directory */

   if ((fd = fopen(_STR2, "r")) == NULL) {
      sprintf(_STR2, "%s/%s", userdir, USER_RC_FILE);
      if ((fd = fopen(_STR2, "r")) == NULL) goto end;
   }

   while (fgets(temp, 249, fd) != NULL) {
      sscanf(temp, "%s", commandstr);
      for(cmdptr = commandstr; isspace(*cmdptr); cmdptr++);

      /* very liberal about comment line characters */

      if (*cmdptr == '#' || *cmdptr == '%' || *cmdptr == ';');

      else if (!strcmp(cmdptr, "override")) {
	 sscanf(temp, "%*s %s", _STR);
	 if (!strcmp(_STR, "default")) {
	    sscanf(temp, "%*s %*s %s", value);
	    if (!strcmp(value, "library") || !strcmp(value, "libraries")) {
	       liboverride = True;
	    }
	    else if (!strcmp(value, "color") || !strcmp(value, "colors")) {
	       coloroverride = True;
	    }
         }
      }

      /* load builtin libraries */

      else if (!strcmp(cmdptr, "library")) {

	 /* if loading of default libraries is not overridden, load them first */

	 if (liboverride == False) {
	    strcpy(_STR, BUILTINS_FILE);
	    loadlibrary(LIBRARY);
	    liboverride = Loaded;
	 }

	 sscanf(temp, "%*s %s", _STR);
	 loadlibrary(LIBRARY);
	 liboverride = Loaded;
      }

      /* load extra fonts */

      else if (!strcmp(cmdptr, "font")) {
	 sscanf(temp, "%*s %s", _STR2);
	 fonts = (char **) realloc (fonts, (fontcount + 1) * sizeof(char *));
         fonts[fontcount] = (char *) malloc (sizeof(char));
         setnewfont(NULL, fonts[fontcount]);
      }

      /* load extra colors */

      else if (!strcmp(cmdptr, "color")) {
	 sscanf(temp, "%*s %s", _STR2);
	 addnewcolorentry(xc_alloccolor(_STR2));
      }

      /* set variables */
 
      else if (!strcmp(cmdptr, "set")) {
	 sscanf(temp, "%*s %s", _STR);
	 if (!strcmp(_STR, "default")) {
	    sscanf(temp, "%*s %*s %s %s", type, value);
	    if (!strcmp(type, "font")) {
	       short i;
	       for (i = 0; i < fontcount; i++)
		  if (!strcmp(fonts[i], value)) break;

	       if (i == fontcount) {
		  strcpy(_STR2, value);
	 	  fonts = (char **) realloc (fonts, (fontcount + 1) * sizeof(char *));
         	  fonts[fontcount] = (char *) malloc (sizeof(char));
         	  setnewfont(NULL, fonts[fontcount]);
	       }
   	       areastruct.psfont = i;
	       setdefaultfontmarks();
	    }
         }
	 else if (!strcmp(_STR, "boxedit")) {
	    sscanf(temp, "%*s %*s %s", value);
	    if (!strcmp(value, "rhomboid-x")) boxedit(NULL, RHOMBOIDX, NULL);
	    else if (!strcmp(value, "rhomboid-y")) boxedit(NULL, RHOMBOIDY, NULL);
	    else if (!strcmp(value, "rhomboid-a")) boxedit(NULL, RHOMBOIDA, NULL);
	    else if (!strcmp(value, "manhattan")) boxedit(NULL, MANHATTAN, NULL);
	    else if (!strcmp(value, "normal")) boxedit(NULL, NORMAL, NULL);

         }
	 else if (!strcmp(_STR, "linewidth")) {
	    sscanf(temp, "%*s %*s %*s %f", &areastruct.wirewidth[0]);
	 }
         else if (!strcmp(_STR, "beep")) {
	    sscanf(temp, "%*s %*s %s %s", type, value);
	    if (!strcmp(type, "off")) beeper = 0;
	 }
         else if (!strcmp(_STR, "colorscheme")) {
	    sscanf(temp, "%*s %*s %s", value);
	    if (!strcmp(value, "inverse") || !strcmp(value, "2")) {
	       areastruct.invert = False;
	       inversecolor(NULL, &areastruct.invert, NULL);
	    }
 	 }
         else if (!strcmp(_STR, "coordstyle")) {
	    sscanf(temp, "%*s %*s %s", value);
	    if (!strcmp(value, "cm") || !strcmp(value, "centimeters")) {
	       areastruct.coordstyle[0] = CM;
	       areastruct.pagesize[0].x = 595;  /* A4 size */
	       areastruct.pagesize[0].y = 842;
	       togglegrid((unsigned short)areastruct.coordstyle[0]);
            }
         }
      }
   }

   /* arrange the loaded libraries */

end:
   if (liboverride == False) {
      strcpy(_STR, BUILTINS_FILE);
      loadlibrary(LIBRARY);
   }
   composelib(LIBRARY);

   /* Add the default colors */

   if (coloroverride == False) {
      addnewcolorentry(xc_alloccolor("Gray40"));
      addnewcolorentry(xc_alloccolor("Gray60"));
      addnewcolorentry(xc_alloccolor("Gray80"));
      addnewcolorentry(xc_alloccolor("Gray90"));
      addnewcolorentry(xc_alloccolor("Red"));
      addnewcolorentry(xc_alloccolor("Blue"));
      addnewcolorentry(xc_alloccolor("Green"));
      addnewcolorentry(xc_alloccolor("Yellow"));
      addnewcolorentry(xc_alloccolor("Purple"));
      addnewcolorentry(xc_alloccolor("Cyan"));
      addnewcolorentry(xc_alloccolor("Magenta"));
      addnewcolorentry(xc_alloccolor("Orange"));
      addnewcolorentry(xc_alloccolor("Tan"));
      addnewcolorentry(xc_alloccolor("Brown"));
   }
}

#undef Loaded
