
/*
 * Definitions common to data-file readers.
 * At the moment this is somewhat specific to analog data.
 *
 * $Log: reader.h,v $
 * Revision 1.2  1998/09/17 18:22:39  tell
 * split typedef and struct decls to allow forward references.
 * added user-data pointer to DVar
 * Added binary HSPICE format and tracking of variable types
 *
 * Revision 1.1  1998/08/31 21:00:41  tell
 * Initial revision
 *
 */

#define DS_DBLKSIZE	8192
#define DS_INBLKS	1024
#define ds_blockno(n) ((n) / DS_DBLKSIZE)
#define ds_offset(n) ((n) % DS_DBLKSIZE)

typedef enum {
	UNKNOWN = 0,
	TIME = 1,
	VOLTAGE = 2,
	CURRENT = 3,
	FREQUENCY = 4,
} VarType;

typedef struct _DVar DVar;
typedef struct _DataFile DataFile;
typedef struct _IVar IVar;
typedef struct _DataSet DataSet;

/*
 * an array of values, the common part at the start of both DVar and IVar.
 */ 
struct _DataSet {
	char *name;
	DataFile *dfile;  /* backpointer to file */
	VarType type;
	int nvalues;
	double min;
	double max;
	
	/* remaining stuff is an array storage structure 
	 * that could be abstracted out and/or replaced with somthing else */
	/* pointer to array of pointers to blocks of doubles */
	double **bptr;
	int bpsize; /* size of array of pointers */
	int bpused; /* number of blocks actually allocated */
};

/* independent variable, for example time
 * values are expected to be monotonicly increasing. 
 * (or at least nondecreasing)
 */
struct _IVar {
	DataSet d;
	/* possible enhancement if needed for speed: add tree-structure 
	 * for fast access to particular value or ranges of values
	 */
};

/* dependent variable, for example voltage */
struct _DVar {
	DataSet d;
	IVar *iv;
	void *udata;
};

struct _DataFile {
	char *filename;
	IVar *iv;
	int ndv;
	DVar **dv;
};

/* defined in rd_cazm.c */
extern DataFile *cz_read_file(char *name, FILE *fp);

/* defined in rd_hspice.c */
extern DataFile *hs_read_file_ascii(char *name, FILE *fp);
extern DataFile *hs_read_file_bin(char *name, FILE *fp);

/* defined in reader.c */
extern DataFile *analog_read_file(char *name, char *format);
extern double an_interp_value(DVar *dv, double ival);
extern int an_find_point(IVar *iv, double ival);
extern double an_get_point(DataSet *ds, int n);

extern int fread_line(FILE *fp, char **bufp, int *bufsize);
extern void an_free_datafile(DataFile *df);
extern void an_init_dataset(DataSet *ds, DataFile *df, 
			    char *name, VarType type);
extern void an_free_dataset(DataSet *ds);
extern void an_set_point(DataSet *ds, int n, double val);
extern void an_expand_dset(DataSet *ds);
extern char *vartype_name_str(VarType type);

extern int analog_read_debug;
