/***********************************************************************/
/* LINKED.C - Linked list routines.                                    */
/***********************************************************************/
/*
 * THE - The Hessling Editor. A text editor similar to VM/CMS xedit.
 * Copyright (C) 1991-1997 Mark Hessling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to:
 *
 *    The Free Software Foundation, Inc.
 *    675 Mass Ave,
 *    Cambridge, MA 02139 USA.
 *
 *
 * If you make modifications to this software that you feel increases
 * it usefulness for the rest of the community, please email the
 * changes, enhancements, bug fixes as well as any and all ideas to me.
 * This software is going to be maintained and enhanced as deemed
 * necessary by the community.
 *
 * Mark Hessling                 Email:             M.Hessling@qut.edu.au
 * PO Box 203                    Phone:                    +617 3802 0800
 * Bellara                       http://www.gu.edu.au/gext/the/markh.html
 * QLD 4507                      **** Maintainer PDCurses & REXX/SQL ****
 * Australia                     ************* Author of THE ************
 */

/*
$Id: linked.c 2.1 1995/06/24 16:30:19 MH Rel MH $
*/

#include <the.h>
#include <proto.h>

/*-------------------------- external data ----------------------------*/

/***********************************************************************/
#ifdef HAVE_PROTO
LINE *lll_add(LINE *first,LINE *curr,unsigned short size)
#else
LINE *lll_add(first,curr,size)
LINE *first;
LINE *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a LINE to the current linked list after the current member.    */
/* PARAMETERS:                                                         */
/* first      - pointer to first LINE in linked list                   */
/* curr       - pointer to current LINE in linked list                 */
/* size       - size of a LINE item                                    */
/* RETURN:    - pointer to next LINE item                              */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *next=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    lll_add");
#endif

 if ((next=(LINE *)(*the_malloc)(size)) != (LINE *)NULL)
   {
    if (curr == NULL)
      {
       if (first == NULL)
         {
          /*
           * First entry in LL 
           */
/*          first = next; */
          next->next = NULL;
          next->prev = NULL;
         }
       else
         {
          /* 
           * Insert this entry before first. Calling routine
           * must reset first to returned pointer.
           */
          next->next = first;
          next->prev = NULL;
          first->prev = next;
         }
      }
    else
      {
       if (curr->next != NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
       next->prev = curr;
      }
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
 next->line = NULL;
 next->name = NULL;
 next->pre = NULL;
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef HAVE_PROTO
LINE *lll_del(LINE **first,LINE **last,LINE *curr,short direction)
#else
LINE *lll_del(first,last,curr,direction)
LINE **first;
LINE **last;
LINE *curr;
short direction;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    lll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
    *first = NULL;
    if (last != NULL)
       *last = NULL;
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
    new_curr = curr->next;
 else
    new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef HAVE_PROTO
LINE *lll_free(LINE *first)
#else
LINE *lll_free(first)
LINE *first;
#endif
/***********************************************************************/
/* Free up all allocated memory until the last item in the linked-list */
/* PARAMETERS:                                                         */
/* first      - pointer to first line for the file                     */
/* RETURN:    - NULL                                                   */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *curr=NULL;
 LINE *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    lll_free");
#endif
 curr = first;
 while (curr != NULL)
   {
    if (curr->line) (*the_free)(curr->line);
    if (curr->name) (*the_free)(curr->name);
    new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
   }
#ifdef TRACE
 trace_return();
#endif
 return((LINE *)NULL);
}
/***********************************************************************/
#ifdef HAVE_PROTO
LINE *lll_find(LINE *first,LINE *last,LINETYPE line_number,LINETYPE max_lines)
#else
LINE *lll_find(first,last,line_number,max_lines)
LINE *first,*last;
LINETYPE line_number,max_lines;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *curr=NULL;
 LINETYPE i=0L;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    lll_find");
#endif
 if (line_number < (max_lines/2))
   {
    curr = first;
    if (curr != NULL)
       for(i=0L;i<line_number && curr->next != NULL; i++, curr=curr->next);
   }
 else
   {
    curr = last;
    if (curr != NULL)
       for(i=max_lines+1L;i>line_number && curr->prev != NULL; i--, curr=curr->prev);
   }
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef HAVE_PROTO
LINE *lll_locate(LINE *first,CHARTYPE *value)
#else
LINE *lll_locate(first,value)
LINE *first;
CHARTYPE *value;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 LINE *curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    lll_locate");
#endif
 curr = first;
 while (curr)
   {
    if (curr->name
    &&  strcmp((DEFCHAR*)curr->name,(DEFCHAR*)value) == 0)
       break;
    curr = curr->next;
   }
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef HAVE_PROTO
VIEW_DETAILS *vll_add(VIEW_DETAILS *first,VIEW_DETAILS *curr,unsigned short size)
#else
VIEW_DETAILS *vll_add(first,curr,size)
VIEW_DETAILS *first;
VIEW_DETAILS *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a VIEW_DETAILS to the current linked list after the current member.    */
/* PARAMETERS:                                                         */
/* first      - pointer to first VIEW_DETAILS in linked list                   */
/* curr       - pointer to current VIEW_DETAILS in linked list                 */
/* size       - size of a VIEW_DETAILS item                                    */
/* RETURN:    - pointer to next VIEW_DETAILS item                              */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 VIEW_DETAILS *next=(VIEW_DETAILS *)NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    vll_add");
#endif

 if ((next=(VIEW_DETAILS *)(*the_malloc)(size)) != (VIEW_DETAILS *)NULL)
   {
    if (curr == (VIEW_DETAILS *)NULL)
      {
       first = next;
       next->next = (VIEW_DETAILS *)NULL;
      }
    else
      {
       if (curr->next != (VIEW_DETAILS *)NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
      }
    next->prev = curr;
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
 next->file_for_view = (FILE_DETAILS *)NULL;
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef HAVE_PROTO
VIEW_DETAILS *vll_del(VIEW_DETAILS **first,VIEW_DETAILS **last,VIEW_DETAILS *curr,short direction)
#else
VIEW_DETAILS *vll_del(first,last,curr,direction)
VIEW_DETAILS **first;
VIEW_DETAILS **last;
VIEW_DETAILS *curr;
short direction;
#endif
/***********************************************************************/
/* This ll_del() function is different to others!!!!!!!!               */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 VIEW_DETAILS *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    vll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
    *first = NULL;
    if (last != NULL)
       *last = NULL;
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/* If DIRECTION_FORWARD, curr becomes first, otherwise curr becomes prev*/
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    if (direction == DIRECTION_FORWARD)
       new_curr = *first;
    else
       new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
   new_curr = curr->next;
 else
   new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef HAVE_PROTO
DEFINE *dll_add(DEFINE *first,DEFINE *curr,unsigned short size)
#else
DEFINE *dll_add(first,curr,size)
DEFINE *first;
DEFINE *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a DEFINE to the current linked list after the current member.  */
/* PARAMETERS:                                                         */
/* first      - pointer to first DEFINE in linked list                 */
/* curr       - pointer to current DEFINE in linked list               */
/* size       - size of a DEFINE item                                  */
/* RETURN:    - pointer to next DEFINE item                            */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 DEFINE *next=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    dll_add");
#endif
 if ((next=(DEFINE *)(*the_malloc)(size)) != (DEFINE *)NULL)
   {
    if (curr == NULL)
      {
       first = next;
       next->next = NULL;
      }
    else
      {
       if (curr->next != NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
      }
    next->prev = curr;
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
 next->def_params = NULL;
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef HAVE_PROTO
DEFINE *dll_del(DEFINE **first,DEFINE **last,DEFINE *curr,short direction)
#else
DEFINE *dll_del(first,last,curr,direction)
DEFINE **first;
DEFINE **last;
DEFINE *curr;
short direction;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 DEFINE *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    dll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
    *first = NULL;
    if (last != NULL)
       *last = NULL;
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
   new_curr = curr->next;
 else
   new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef HAVE_PROTO
DEFINE *dll_free(DEFINE *first)
#else
DEFINE *dll_free(first)
DEFINE *first;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 DEFINE *curr=NULL;
 DEFINE *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    dll_free");
#endif
 curr = first;
 while (curr != (DEFINE *)NULL)
   {
    if (curr->def_params != NULL)
       (*the_free)(curr->def_params);
    new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
   }
#ifdef TRACE
 trace_return();
#endif
 return((DEFINE *)NULL);
}
/***********************************************************************/
#ifdef HAVE_PROTO
PPC *pll_add(PPC *first,PPC *curr,unsigned short size)
#else
PPC *pll_add(first,curr,size)
PPC *first;
PPC *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a PPC to the current linked list after the current member.     */
/* PARAMETERS:                                                         */
/* first      - pointer to first PPC in linked list                    */
/* curr       - pointer to current PPC in linked list                  */
/* size       - size of a PPC item                                     */
/* RETURN:    - pointer to next PPC item                               */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 PPC *next=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    pll_add");
#endif

 if ((next=(PPC *)(*the_malloc)(size)) != (PPC *)NULL)
   {
    if (curr == NULL)
      {
       first = next;
       next->next = NULL;
      }
    else
      {
       if (curr->next != NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
      }
    next->prev = curr;
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef HAVE_PROTO
PPC *pll_del(PPC **first,PPC **last,PPC *curr,short direction)
#else
PPC *pll_del(first,last,curr,direction)
PPC **first;
PPC **last;
PPC *curr;
short direction;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 PPC *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    pll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
    *first = NULL;
    if (last != NULL)
       *last = NULL;
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
   new_curr = curr->next;
 else
   new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef HAVE_PROTO
PPC *pll_free(PPC *first)
#else
PPC *pll_free(first)
PPC *first;
#endif
/***********************************************************************/
/* Free up all allocated memory until the last item in the linked-list */
/* PARAMETERS:                                                         */
/* first      - pointer to first line for the file                     */
/* RETURN:    - NULL                                                   */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 PPC *curr=NULL;
 PPC *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    pll_free");
#endif
 curr = first;
 while (curr != NULL)
   {
    new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
   }
#ifdef TRACE
 trace_return();
#endif
 return((PPC *)NULL);
}
/***********************************************************************/
#ifdef HAVE_PROTO
PPC *pll_find(PPC *first,LINETYPE line_number)
#else
PPC *pll_find(first,line_number)
PPC *first;
LINETYPE line_number;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 PPC *curr_ppc=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    pll_find");
#endif
 curr_ppc = first;
 while (curr_ppc != NULL)
   {
    if (curr_ppc->ppc_line_number == line_number)
      {
#ifdef TRACE
       trace_return();
#endif
       return(curr_ppc);
      }
    curr_ppc = curr_ppc->next;
   }
#ifdef TRACE
 trace_return();
#endif
 return(NULL);
}
/***********************************************************************/
#ifdef HAVE_PROTO
RESERVED *rll_add(RESERVED *first,RESERVED *curr,unsigned short size)
#else
RESERVED *rll_add(first,curr,size)
RESERVED *first;
RESERVED *curr;
unsigned short size;
#endif
/***********************************************************************/
/* Adds a RESERVED to the current linked list after the current member.    */
/* PARAMETERS:                                                         */
/* first      - pointer to first RESERVED in linked list                   */
/* curr       - pointer to current RESERVED in linked list                 */
/* size       - size of a RESERVED item                                    */
/* RETURN:    - pointer to next RESERVED item                              */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 RESERVED *next=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    rll_add");
#endif

 if ((next=(RESERVED *)(*the_malloc)(size)) != (RESERVED *)NULL)
   {
    if (curr == NULL)
      {
       first = next;
       next->next = NULL;
      }
    else
      {
       if (curr->next != NULL)
          curr->next->prev = next;
       next->next = curr->next;
       curr->next = next;
      }
    next->prev = curr;
   }
/*---------------------------------------------------------------------*/
/* Ensure all pointers in the structure are set to NULL                */
/*---------------------------------------------------------------------*/
 next->line = NULL;
 next->spec = NULL;
#ifdef TRACE
 trace_return();
#endif
 return(next);
}
/***********************************************************************/
#ifdef HAVE_PROTO
RESERVED *rll_del(RESERVED **first,RESERVED **last,RESERVED *curr,short direction)
#else
RESERVED *rll_del(first,last,curr,direction)
RESERVED **first;
RESERVED **last;
RESERVED *curr;
short direction;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 RESERVED *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    rll_del");
#endif
/*---------------------------------------------------------------------*/
/* Delete the only record                                              */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL && curr->next == NULL)
   {
    (*the_free)(curr);
    *first = NULL;
    if (last != NULL)
       *last = NULL;
#ifdef TRACE
    trace_return();
#endif
    return(NULL);
   }
/*---------------------------------------------------------------------*/
/* Delete the first record                                             */
/*---------------------------------------------------------------------*/
 if (curr->prev == NULL)
   {
    curr->next->prev = NULL;
    *first = new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* Delete the last  record                                             */
/*---------------------------------------------------------------------*/
 if (curr->next == NULL)
   {
    curr->prev->next = NULL;
    new_curr = curr->prev;
    if (last != NULL)
       *last = curr->prev;
    (*the_free)(curr);
    curr = new_curr;
#ifdef TRACE
    trace_return();
#endif
    return(curr);
   }
/*---------------------------------------------------------------------*/
/* All others                                                          */
/*---------------------------------------------------------------------*/
 curr->prev->next = curr->next;
 curr->next->prev = curr->prev;
 if (direction == DIRECTION_FORWARD)
   new_curr = curr->next;
 else
   new_curr = curr->prev;

 (*the_free)(curr);
 curr = new_curr;
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
/***********************************************************************/
#ifdef HAVE_PROTO
RESERVED *rll_free(RESERVED *first)
#else
RESERVED *rll_free(first)
RESERVED *first;
#endif
/***********************************************************************/
/* Free up all allocated memory until the last item in the linked-list */
/* PARAMETERS:                                                         */
/* first      - pointer to first line for the file                     */
/* RETURN:    - NULL                                                   */
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 RESERVED *curr=NULL;
 RESERVED *new_curr=NULL;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    rll_free");
#endif
 curr = first;
 while (curr != NULL)
   {
    if (curr->line != (CHARTYPE *)NULL)
       (*the_free)(curr->line);
    if (curr->spec != (CHARTYPE *)NULL)
       (*the_free)(curr->spec);
    if (curr->attr != (COLOUR_ATTR *)NULL)
       (*the_free)(curr->attr);
    new_curr = curr->next;
    (*the_free)(curr);
    curr = new_curr;
   }
#ifdef TRACE
 trace_return();
#endif
 return((RESERVED *)NULL);
}
/***********************************************************************/
#ifdef HAVE_PROTO
RESERVED *rll_find(RESERVED *first,short row)
#else
RESERVED *rll_find(first,row)
RESERVED *first;
short row;
#endif
/***********************************************************************/
{
/*--------------------------- local data ------------------------------*/
 RESERVED *curr=NULL;
 short i=0;
/*--------------------------- processing ------------------------------*/
#ifdef TRACE
 trace_function("linked.c:    rll_find");
#endif
 curr = first;
 if (curr != NULL)
    for(i=0;i<row && curr->next != NULL; i++, curr=curr->next);
#ifdef TRACE
 trace_return();
#endif
 return(curr);
}
